<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       http://echopointer.com
 * @since      1.0.0
 *
 * @package    Kas_Dvf
 * @subpackage Kas_Dvf/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Kas_Dvf
 * @subpackage Kas_Dvf/public
 * @author     Syed Muhammad Shafiq <shafiq_shaheen@hotmail.com>
 */
class Kas_Dvf_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;
		$this->load_dependencies();

	}

	/**
	 * Load the required dependencies for this class.
	 *
	 * Include the following files :
	 *
	 * - Kas_Dokan_Vendor_Filter_DokanData. Collect and get all required Dokan saller information.
	 *
	 *
	 * @since    1.0.6
	 * @access   private
	 */
	private function load_dependencies() {
	    /**
	     * The class responsible for getting dokan data to menupulate fields
	     */
	    require_once plugin_dir_path( dirname( __FILE__ ) ) . 'classes/class-kas-dvf-dokandata.php';
	    /**
	     * The class responsible for widget form
	     */
	    require_once plugin_dir_path( dirname( __FILE__ ) ) . 'classes/class-kas-dvf-widget.php';
	    
	}	

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Kas_Dvf_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Kas_Dvf_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
	    $s_options = get_option($this->plugin_name . '-scripts');
	    wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/kas-dvf-public.css', array(), $this->version, 'all' );
	    
	    if ($s_options['enable-select2'] > 0){
	        wp_enqueue_style( 'select2', plugin_dir_url( __FILE__ ) . 'assets/select2/css/select2.min.css', array(), $this->version, 'all' );
	        wp_enqueue_style( 'select2-bootstrap', plugin_dir_url( __FILE__ ) . 'assets/select2/css/select2-bootstrap.css', array(), $this->version, 'all' );
	        wp_enqueue_style( 'select2-custom', plugin_dir_url( __FILE__ ) . 'css/kas-dvf-select2-custom.css', array(), $this->version, 'all' );
	    }else {
	        //doSomething...
	    }

	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Kas_Dvf_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Kas_Dvf_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
	    $s_options = get_option($this->plugin_name . '-scripts');
	    
	    if ($s_options['show-mapview'] > 0){
	        
	        if( isset($_SERVER['HTTPS'] ) ) {
	            wp_enqueue_script( 'google-map', 'https://maps.googleapis.com/maps/api/js?key='.dokan_get_option('gmap_api_key','dokan_general','store').'&sensor=false&callback=&libraries=geometry', array( 'jquery' ), $this->version, false );
	        }else {
	            wp_enqueue_script( 'google-map', 'http://maps.google.com/maps/api/js?key='.dokan_get_option('gmap_api_key','dokan_general','store').'&sensor=false&callback=&libraries=geometry', array( 'jquery' ), $this->version, false );
	        }
	   }
	   if ($s_options['enable-select2'] > 0){
	       wp_enqueue_script( 'select2', plugin_dir_url( __FILE__ ) . 'assets/select2/js/select2.min.js', array( 'jquery' ), $this->version, false );
	   }
		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/kas-dvf-public.js', array( 'jquery' ), $this->version, false );
		wp_localize_script( $this->plugin_name, 'kas_dvf_ajax_object', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
	}
	
	/**
	 * start session
	 *
	 * @since    1.0.0
	 */
	public function start_session(){
	    if( !session_id() ){
	        session_start();
	    }
	}
	
	/**
	 * destroy session
	 *
	 * @since    1.0.0
	 */
	public function end_session(){
	    session_destroy();
	    session_unset();
	}
	
	
	/**
	 * Add ShortCode Functions for Dokan Vendor Filter Form.
	 *
	 * @since    1.0.0
	 */
	public function form() {
	    
	    // get vendors
	    $sellers = $this->get_vendors('');
	    
	    $countries = array();
	    $states = array();
	    $cities = array();
	    $zips = array();
	    $stores = array();
	    foreach ($sellers['users'] as $seller){
	        $store_info = dokan_get_store_info($seller->data->ID);
	        $store_url  = dokan_get_store_url($seller->data->ID);
	        
	        if (!in_array_r($store_info['address']['country'], $countries)) {
	            array_push($countries,array($store_info['address']['country'] , WC()->countries->countries[ $store_info['address']['country'] ]));
	        }
	        if (!in_array_r($store_info['address']['state'], $states)) {
	            array_push($states,array($store_info['address']['state'] , WC()->countries->get_states( $store_info['address']['country'] )[$store_info['address']['state']] ));
	        }
	        if (!in_array($store_info['address']['city'], $cities)) {
	            array_push($cities,$store_info['address']['city']);
	        }
	        if (!in_array($store_info['address']['zip'], $zips)) {
	            array_push($zips,$store_info['address']['zip']);
	        }
	        if (!in_array($store_info['store_name'], $stores)) {
	            array_push($stores, array('name' => $store_info['store_name'], 'link' => $store_url));
	        }
  
	    }
	    
	    $args = array(
	        'text_domain' => $this->plugin_name,
	        'countries' => $countries,
	        'states' => $states,
	        'cities' => $cities,
	        'zips'	=> $zips,
	        'stores' => $stores,
	    );
	    kas_dvf_get_template('form.php', $args);
	}
	
	/**
	 * dokan vendor filter single field form.
	 *
	 * @since    1.3.0
	 */
	public function form_aio() { 
		$options = get_option($this->plugin_name . '-general');
		$result_action = $options['results'];
		$query_string = (isset($_GET['kas_query']) ? $_GET['kas_query'] : '');
		$args = array();
		$args['text_domain'] = $this->plugin_name;
		$args['result_action'] = $result_action;
		$args['query_string'] = $query_string;
		kas_dvf_get_template('form-aio.php', $args);
	}
	
	/**
	 * dokan vendor filter results .
	 *
	 * @since    1.3.0
	 */
	public function filter_results() { 
		$args = array();
		$query = array();
		$search = '';
		$search_key = '';
		$query['kas_country'] = (isset($_GET['kas_country']) ? $_GET['kas_country'] : '');
		$query['kas_state'] = (isset($_GET['kas_state']) ? $_GET['kas_state'] : '');
		$query['kas_city'] = (isset($_GET['kas_city']) ? $_GET['kas_city'] : '');
		$query['kas_zip'] = (isset($_GET['kas_zip']) ? $_GET['kas_zip'] : '');
		$kas_category = (isset($_GET['kas_category']) ? $_GET['kas_category'] : '');
		$query['query_string'] = (isset($_GET['kas_query']) ? $_GET['kas_query'] : '');
		$options = get_option($this->plugin_name . '-general');	    
		$s_options = get_option($this->plugin_name . '-scripts');
		$products_pp = isset($options['products-perpage']) ? $options['products-perpage'] : 10;
		$google_api = dokan_get_option('gmap_api_key','dokan_general','store'); 

    	foreach ($query as $key => $q){
    	    if(!empty($q)){
    	        $search = $q;
    	        $search_key = $key;
    	    }
    	}

    	// get vendors 
    	$sellers = $this->verify_seller($search, $search_key, $this->get_vendors($search));

 		if(empty($sellers)){
		    
 		    if(!empty($_SESSION['current_latitude']) && !empty($_SESSION['current_longitude']) && $s_options['get-location'] <= 0){
    	        $google_data =  $this->request_mapAPI( "geocode/json?latlng=".$_SESSION['current_latitude'].",".$_SESSION['current_longitude']."&sensor=false&key=".$google_api,"GET" );
		        $google_arr = json_decode($google_data);
		    }else{
		        $sellers = !empty($search) ? $this->get_vendors($search) : $this->get_vendors('');
		    }

    		if ($google_arr->status=='OK') {
    		  // Get the elements as array
    		    if(in_array("postal_code",$google_arr->results[0]->address_components[7]->types)){
    		        $elements = $google_arr->results[0]->address_components[7];
    		    }else{
    		        $elements = !empty($elements) ? $elements : $google_arr->results[2]->address_components[3];
    		    }
    		    $search = $elements->short_name;
    		    // get vendors
    		    $sellers = $this->get_vendors($search);
    		 }
		}
    	
    	// get products
    	$paged = ( get_query_var('paged1') ) ? get_query_var('paged1') : 1;
    	$author_ids = array();
    	
    	foreach ($sellers['users'] as $seller) {
    	    
    		array_push($author_ids,$seller->ID);
    	}    		
    
        $p_args = array(
                'author__in' => $author_ids,
    		    'post_type'  => array('product'),
                'post_status' => 'publish',
                'posts_per_page' => $products_pp,
          		'paged' => $paged,
        		'orderby' => 'date',
    	        'order' => 'DESC',      
        );
        
        if(!empty($kas_category)){
            $p_args['product_cat'] = $kas_category;
            $sellers = $this->get_vendors_by_category($search, $kas_category, $sellers);
            $search_key = $search_key ? $search_key : 'kas_category';
            $sellers = $this->verify_seller($search, $search_key, $sellers);
            $search = $kas_category;
        }
        
        $args['show_products'] = ($options['show-products'] > 0) ? $options['show-products'] : 0;
        $args['image_size'] = 'kas_vendor_image';
        $args['data'] = $sellers;           
		$loop = new WP_Query( $p_args );		
		$args['loop'] = $loop;
		$args['query'] = $search;
		$args['text_domain'] = $this->plugin_name;
		kas_dvf_get_template('results.php', $args);
	}
	
	/**
	 * add miles away in vendors loop .
	 *
	 * @since    1.3.0
	 */
	public function distance_away($seller) { 
	    $args = array();
	    $args['text_domain'] = $this->plugin_name;
	    $options = get_option($this->plugin_name . '-general');
	    $distance_type = $options['distance-type'];
	    $google_api = dokan_get_option('gmap_api_key','dokan_general','store');

	    $vendor = dokan()->vendor->get( $seller->ID );
	    $current_latitude = ($_SESSION['current_latitude']) ? $_SESSION['current_latitude'] : '';
	    $current_longitude = ($_SESSION['current_longitude']) ? $_SESSION['current_longitude'] : '';
	    
	    if(!empty($current_latitude) && !empty($current_longitude) && !empty($vendor->get_location())){
	        $vendor_locaiton = explode(',', $vendor->get_location());
	        $args['get_direction'] = 'http://maps.google.com/maps?saddr='.$current_latitude.','.$current_longitude.'&daddr='.$vendor->get_location();
	        $distance_data =  $this->request_mapAPI( "distancematrix/json?&units=$distance_type&origins=$current_latitude,$current_longitude&destinations=$vendor_locaiton[0], $vendor_locaiton[1]&key=$google_api","GET" );
	        $distance_arr = json_decode($distance_data);
	        
	        if ($distance_arr->status=='OK') {
	            // Get the elements as array
	            $elements = $distance_arr->rows[0]->elements;
	            $distance = $elements[0]->distance->text;
	            $duration = $elements[0]->duration->text;
	            $args['distance'] = $distance;
	            $args['duration'] = $duration;
	        }
	        
	    }else{
	        $args['get_direction'] = '';
	        $args['distance'] = '';
	        $args['duration'] = '';
	    }

	    kas_dvf_get_template('distance_details.php', $args);
	}
	
	/**
	 * store user current location.
	 *
	 * @since    2.0.0
	 */
	public function current_location() { 
	    $current_latitude = ($_POST['current_latitude']) ? $_POST['current_latitude'] : '';
	    $current_longitude = ($_POST['current_longitude']) ? $_POST['current_longitude'] : '';
	    
	    if(!empty($current_latitude) && !empty($current_longitude)){
	        $_SESSION['current_latitude'] = $current_latitude;
	        $_SESSION['current_longitude'] = $current_longitude;
	        echo 'success!';
	    }else {
	        echo 'Permission denied!';
	    }

	    wp_die();
	    
	}
	
	/**
	 * request to google.
	 *
	 * @since    2.0.0
	 */
	public function request_mapAPI($pram,$method){
	    
	    $request_url = 'https://maps.googleapis.com/maps/api/'.$pram;
	    
	    $request = array();
	    $request['method'] = $method;
	    
	    $response = wp_remote_request($request_url,$request);
	    return wp_remote_retrieve_body($response);
	    
	}
	
	/**
	 * get seller users.
	 *
	 * @since    2.0.0
	 */
	private function get_vendors($search, $authors = array()){
	    
	    //Grab all options
	    $s_options = get_option($this->plugin_name . '-scripts');
	    $google_api = dokan_get_option('gmap_api_key','dokan_general','store'); 

	    if($s_options['get-location'] > 0 && !empty($search)){
	        $google_data =  $this->request_mapAPI( "geocode/json?address=$search&sensor=false&key=$google_api","GET" );
	        $google_arr = json_decode($google_data);
	        if ($google_arr->status=='OK') {
	            // Get the elements as array
	            $elements = $google_arr->results[0]->geometry;
	            $_SESSION['current_latitude'] = $elements->location->lat;
	            $_SESSION['current_longitude'] = $elements->location->lng;

	        }else{
	            $_SESSION['current_latitude'] = 0.00;
	            $_SESSION['current_longitude'] = 0.00;
	        }
	          
	    }
	    
	    $args = array();
	    
	    if(!empty($search)){
    	    $args['meta_query'][] = array(
    	        'key' => 'dokan_profile_settings',
    	        'value' => $search,
    	        'compare' => 'LIKE'
    	    );
	    }
	    
	    if(!empty($authors)){
	        $args['include'] = $authors;
	    }
	     
	    $sellers = dokan_get_sellers( apply_filters( 'dvf_seller_listing_args', $args) );
	    
	    return $sellers;  
	}
	
	/**
	 * get seller by category.
	 *
	 * @since    2.0.0
	 */
	private function get_vendors_by_category($search, $kas_category, $sellers){
	
    	// sort vendor ids
    	$vendor_ids = array();
    	foreach ($sellers['users'] as $seller){
    	    // get vendor products
    	    $vendor_args = array(
    	        'author'     =>  $seller->ID,
    	        'post_type'  => 'product',
    	        'post_status' => 'publish',
    	    );
    	    
    	    $author_posts = get_posts( $vendor_args );
    	    
    	    
    	    foreach ( $author_posts as $post ) {
    	        
    	        $terms = get_the_terms( $post->ID, 'product_cat' );
    	        if(is_array($terms) || is_object($terms)){
    	            foreach ($terms as $term){
    	                if (!empty($term->name) && $term->name === $kas_category) {
    	                    if (!in_array($seller->ID, $vendor_ids)) {
    	                        array_push($vendor_ids, $seller->ID);
    	                    }
    	                }
    	            }
    	        }
    	    }
    	}
    	
    	$sellers = $this->get_vendors($search, $vendor_ids);
    	return $sellers;
	}
	
	/**
	 * update search form.
	 *
	 * @since    2.0.0
	 */
 	public function update_search_form(){

 	    
 	    $locations = array();
 	    $countries = array();
 	    $states = array();
 	    $cities = array();
 	    $zips = array();
 	    $stores = array();

 	    $sellers = $this->verify_seller(
 	        $_POST['selected'],
 	        $_POST['key'],
 	        $this->get_vendors( $_POST['selected'] 
 	    ));
	    
	    foreach ( $sellers['users'] as $seller ) {
	        $store_info = dokan_get_store_info( $seller->ID );
	        $store_url  = dokan_get_store_url($seller->ID);
	        if (!in_array($store_info['address']['country'], $countries)) {
	            array_push($countries,$store_info['address']['country']);
	        }
	        if (!in_array($store_info['address']['state'], $states)) {
	            array_push($states,$store_info['address']['state']);
	        }
	        if (!in_array($store_info['address']['city'], $cities)) {
	            array_push($cities,$store_info['address']['city']);
	        }
	        if (!in_array($store_info['address']['zip'], $zips)) {
	            array_push($zips,$store_info['address']['zip']);
	        }
	        if (!in_array($store_info['store_name'], $stores)) {
	            array_push($stores,array('store_link' => $store_url, 'store_name' => $store_info['store_name']));
	        }

	    }
	    $locations['countries'] = $countries;
	    $locations['states'] = $states;
	    $locations['cities'] = $cities;
	    $locations['zips'] = $zips;
	    $locations['stores'] = $stores;
	    echo json_encode($locations);
	   wp_die(); 
 	}
 	
 	/**
 	 * set new dokan image size
 	 *
 	 * @since    2.0.0
 	 */
	public function dokan_register_image_size($args){
	    
	    add_image_size('kas_vendor_image', 335, 250, true);
	    $args['image_size'] = 'kas_vendor_image';
	    
	    return $args;
	}
	
	/**
	 * Save dokan locations on update vendors setting
	 *
	 * @since    2.0.0
	 */
	public function save_dokan_location_fields( $store_id ) {
	    //dokan_geo_latitude
	    
	    $dokan_settings = dokan_get_store_info( $store_id );
	    if ( isset( $dokan_settings['location'] ) && isset( $dokan_settings['find_address'] ) ) {
	        $location = explode( ',', $dokan_settings['location'] );
	        
	        if ( 2 !== count( $location ) ) {
	            return;
	        }
	    }
	    
	    update_user_meta( $store_id, 'dokan_geo_latitude', $location[0] );
	    update_user_meta( $store_id, 'dokan_geo_longitude', $location[1] );
	    
	    update_user_meta( $store_id, 'dokan_geo_address', $dokan_settings['find_address'] );
	}
	
	/**
	 * Verify sellers
	 *
	 * @since    2.0.0
	 */
	private function get_vendors_by_ids($vendors = array()){
	    return $this->get_vendors('',$vendors);
	}
	
	/**
	 * Verify sellers
	 *
	 * @since    2.0.0
	 */
	private function verify_seller($search, $search_key, $sellers){
	    
	    $vendors = array();
	    
        foreach ( $sellers['users'] as $seller ) {
            if(strlen($search) <= 3 && strlen($search) > 0 && !empty($search)){
                $store_info = dokan_get_store_info( $seller->ID );
                //echo var_export($seller);
                if ($store_info['address']['country'] === $search || $store_info['address']['state'] === $search) {
                    array_push($vendors, $seller->ID);
                }
            }else{
                switch ($search_key) {
                    case 'kas_city':
                        array_push($vendors, $seller->ID);
                        break;
                    case 'kas_zip':
                        array_push($vendors, $seller->ID);
                        break;
                    case 'kas_category':
                        array_push($vendors, $seller->ID);
                        break;
                    default:
                        return;
                }
            }
        }
        return $this->get_vendors_by_ids($vendors);
	}
	
	/**
	 * Generate vendor locations
	 *
	 * @since    2.0.0
	 */
	public function generate_location(){
	    
	    //setup vendor coordinates if empty
	    $vendors = dokan_get_sellers();
	    $google_api = dokan_get_option('gmap_api_key','dokan_general','store');
	    
	    foreach ($vendors['users'] as $vendor){
	        
	        $store_info = dokan_get_store_info($vendor->ID);
	        
	        if ( empty( $store_info['location'] ) || !isset($store_info['location']) && !empty($google_api)) {
	            
	            if ($store_info['address']['city']) {
	                $search = $store_info['address']['city'];
	            }else{
	                continue;
	            }
	            
	            $google_data =  Kas_Dvf_Public::request_mapAPI( "geocode/json?address=$search&sensor=false&key=$google_api","GET" );
	            $google_arr = json_decode($google_data);
	            if ($google_arr->status=='OK') {
	                
	                $dokan_settings = dokan_get_store_info($vendor->ID);
	                // Get the elements as array
	                $elements = $google_arr->results[0]->geometry;
	                $dokan_settings['location'] = $elements->location->lat . ',' . $elements->location->lng;
	                $dokan_settings['find_address'] = $store_info['address']['street_1'] . ', ' . $store_info['address']['street_1'] . ', ' . $store_info['address']['city'];
	                
	                update_user_meta( $vendor->ID, 'dokan_geo_latitude', $elements->location->lat );
	                update_user_meta( $vendor->ID, 'dokan_geo_longitude', $elements->location->lng);
	                update_user_meta( $vendor->ID, 'dokan_geo_address', $store_info['address']['street_1'] . ', ' . $store_info['address']['street_1'] . ', ' . $store_info['address']['city'] );
	                update_user_meta( $vendor->ID, 'dokan_profile_settings', $dokan_settings );
	                    
	            }
	        }
	    }
	}
	
}
