/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       http://echopointer.com
 * @since      1.0.0
 *
 * @package    Kas_Dvf
 * @subpackage Kas_Dvf/public/js
 */
(function( $ ) {
	'use strict';

	/**
	 * All of the code for your public-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note that this assume you're going to use jQuery, so it prepares
	 * the $ function reference to be used within the scope of this
	 * function.
	 *
	 * From here, you're able to define handlers for when the DOM is
	 * ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * Or when the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and so on.
	 *
	 * Remember that ideally, we should not attach any more than a single DOM-ready or window-load handler
	 * for any particular page. Though other scripts in WordPress core, other plugins, and other themes may
	 * be doing this, we should try to minimize doing that in our own work.
	 */
	/*jQuery( document ).ready(function() {

	});*/

	window.onload = function() {
		console.log('location triggered');
		  var startPos;
		  var geoSuccess = function(position) {
		    startPos = position;

			var location_data = {
					'current_latitude': startPos.coords.latitude,
					'current_longitude': startPos.coords.longitude,
					'action' : 	'current_location'
			};		
			console.log(startPos);
			jQuery('.kas-ripple').css('display', 'inline-block');
			jQuery.post(kas_dvf_ajax_object.ajax_url, location_data, function(response) {
				
				if(response){
					console.log(response);
					jQuery('.kas-ripple').css('display', 'none');
				}
				
			});
		    
		  };
		  var geoError = function(error) {
		    console.log('Error occurred. Error code: ' + error.code);
		    // error.code can be:
		    //   0: unknown error
		    //   1: permission denied
		    //   2: position unavailable (error response from location provider)
		    //   3: timed out
		  };
		  navigator.geolocation.getCurrentPosition(geoSuccess, geoError);
		};

		jQuery( document ).ready(function() {

			// make select 2 
			if(jQuery(".kas-search").length){
				jQuery.fn.select2.defaults.set( "theme", 'bootstrap' );
				jQuery(".kas-search select").select2();
			}
			
			//onChange store name redirect
			jQuery('.kas_store').on('change', function (){
				var kas_store_str = jQuery( ".kas_store" ).val();
				kas_store_str = kas_store_str.replace(/\s+/g, '-').toLowerCase();
				// alert(kas_store_str);
				// redirect
				window.location = kas_store_str;
				jQuery('.kas-ripple').css('display', 'inline-block');
			});	
			
			//onLoad fields sorting	
			if(jQuery(".kas-search select").length){	
				var kas_load;
				jQuery(".kas-search select").each(function(){
					var selected = jQuery(this); // This is the jquery object of the input, do what you will
					if(selected.val() && selected.attr("name") != 'kas_store'){
						kas_load = selected;
					}
				});	
				
				if(kas_load){
					var data = {
						'action': 'update_search_form',
						'selected': kas_load.val(),
						'key': kas_load.attr("id")
					};	
					kas_load.id = kas_load.attr("id");
					kas_call_sorting(data, kas_load);
				}
			}		
			  // onChange fields sorting
			jQuery( ".kas-search" ).on( "change" ,function(e) {
				jQuery('.kas-ripple').css('display', 'inline-block');
				var selected = e.target;
				var data = {
					'action': 'update_search_form',
					'selected': selected.value,
					'key': selected.id
				};
				kas_call_sorting(data, selected);
			});	

		});			
		
})( jQuery );

/**
 * create select options.
 * 
 * @since 1.0.0
 */
function kas_option_generator(str, key = '', val = '', myArray, str_explod = 0){

	var string = '';
	string += '<option value="">' + str + '</option>';
	if ( myArray.length != 0 ) {
		for (var x = 0; x < myArray.length; x++) {
			if(key.length && val.length){
				string += '<option value="' + myArray[x][key] + '">' + myArray[x][val] + '</option>';
			}else if(key.length){
				string += '<option value="' + myArray[x][key] + '">' + myArray[x][key] + '</option>';
			}else if(str_explod > 0){
			var array = myArray[x].split(',');
				for (var y = 0; y < array.length; y++) {
					if(array[y] !== null){
						string += '<option value="' + array[y] + '">' + array[y] + '</option>';
					}
				}
			}else{
				if(myArray[x] !== null){
					string += '<option value="' + myArray[x] + '">' + myArray[x] + '</option>';
				}
			}
		}
	}
	return string;
}
/**
 * load select options.
 * 
 * @since 2.0.0
 */
function kas_call_sorting(data, selected){
	jQuery.post(kas_dvf_ajax_object.ajax_url, data, function(response) {
		if(response){
			jQuery('.kas-ripple').css('display', 'none');
			var data = JSON.parse(response);
			switch (selected.id) {
			  case 'kas_country':
				  var state = kas_option_generator('State..','','', data['states']);	
				  jQuery('#kas_state').html(state);
				  var city = kas_option_generator('City..','','', data['cities']);	
				  jQuery('#kas_city').html(city);
				  var zip = kas_option_generator('Zip..','','', data['zips']);	
				  jQuery('#kas_zip').html(zip);
				  var store = kas_option_generator('Store Name..','store_link','store_name',data['stores']);	
				  jQuery('#kas_store').html(store);
			    break;
			  case 'kas_state':
				  var city = kas_option_generator('City..','','', data['cities']);	
				  jQuery('#kas_city').html(city);
				  var zip = kas_option_generator('Zip..','','', data['zips']);	
				  jQuery('#kas_zip').html(zip);
				  var store = kas_option_generator('Store Name..','store_link','store_name',data['stores']);
				  jQuery('#kas_store').html(store);

			    break;
			  case 'kas_city':
				  var zip = kas_option_generator('Zip..','','', data['zips']);	
				  jQuery('#kas_zip').html(zip);
				  var store = kas_option_generator('Store Name..','store_link','store_name',data['stores']);	
				  jQuery('#kas_store').html(store);
			     
			    break;
			  case 'kas_zip':
				  var store = kas_option_generator('Store Name..','store_link','store_name',data['stores']);			
				  jQuery('#kas_store').html(store);
			    
			    break;
			}
		}
		
	});	
}