<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       http://echopointer.com
 * @since      1.3.0
 *
 * @package    Kas_Dvf
 * @subpackage Kas_Dvf/templates
 */

/**
 *
 * @package Kas_Dvf
 * @subpackage Kas_Dvf/templates
 * @author Syed Muhammad Shafiq <shafiq_shaheen@hotmail.com>
 */
?>
<!-- This file should primarily consist of HTML with a little bit of PHP. -->
<?php
// Grab all options

$g_options = get_option($text_domain . '-general');
$f_options = get_option($text_domain . '-forms');
$s_options = get_option($text_domain . '-scripts');
if ($data['users']) {
    $kas_map_info = '';
    // Generate json for map markers....
    $user_count = 0;
    foreach ($data['users'] as $seller) {

        $vendor = dokan()->vendor->get($seller->ID);
        $store_banner_id = $vendor->get_banner_id();
        $store_name = $vendor->get_shop_name();
        $store_url = $vendor->get_shop_url();
        //$store_rating = $vendor->get_rating();
        //$is_store_featured = $vendor->is_featured();
        $store_phone = !empty($vendor->get_phone()) ? $vendor->get_phone() : 'Not Available';
        $store_info = dokan_get_store_info($seller->ID);
        //$store_address = dokan_get_seller_short_address($seller->ID);
        $store_banner_url = $store_banner_id ? wp_get_attachment_image_src($store_banner_id, 'kas_vendor_image') : DOKAN_PLUGIN_ASSEST . '/images/default-store-banner.png';
        $store_avatar = $vendor->get_avatar();

        if (! empty($store_info['location'])) {
            $locations = explode(',', $store_info['location']);
            $def_lat = $locations[0];
            $def_long = $locations[1];

            $store_m_address = $store_info['address']['street_1'] . ' ' . $store_info['address']['street_2'] . ',';

            // create html
           
            $store_popup = '<div class="kas-infowindow" style="background-position: center; background-repeat: no-repeat; background-size: cover;background-image: url('.$store_banner_url[0].');"/>
                              <div class="kas-banner-shadow">
                                <div class="kas-infowindow-content">    
                                    <span class="kas-infowindow-content-heading"><a href="' . $store_url . '">' . $store_name . '</a></span>
                                    <span class="kas-infowindow-content-address">'.$store_m_address.' 
                                    <br><br>
                                    <b>'.  $store_info['address']['zip'] . ', ' . $store_info['address']['city'] . '
                                    <br>' . $store_info['address']['state'] . ', '.$store_info['address']['country'] . '</b>
                                    </span>
                                    <span class="kas-infowindow-contact">
                                        <i class="fa fa-phone" aria-hidden="true"></i>
                                        '.$store_phone.'
                                    </span>    
                                </div>
                                <img class="kas-infowindow-avatar" src='.$store_avatar.'
                                alt='.$store_name.'
                                size="150">
                              </div>  
                            </div>';


            // create marker ..
            //$kas_map_info .= "['<a href=\"" . $store_url . "\">" . $store_popup . "<\a>',";
            $kas_map_info .= "['" . preg_replace( "/\r|\n/", "", $store_popup ) . "',";
            $kas_map_info .= "'" . $store_name . "',";
            $kas_map_info .= "'" . $def_lat . "',";
            $kas_map_info .= "'" . $def_long . "',";
            $kas_map_info .= "'" . $user_count . "'],";
            $user_count ++;
        }
    }

    $kas_map_info = substr($kas_map_info, 0, - 1);
    $kas_map_info = '<script type="text/javascript">  var locations = [' . $kas_map_info . '];</script>';

    // json for map markers
    echo $kas_map_info;

    ?>

<script type="text/javascript">

	var map;
	var Markers = {};
	var infowindow;
	
	if(locations[0][2]){
		var origin = new google.maps.LatLng(locations[0][2], locations[0][3]);
	}else {
		var origin = new google.maps.LatLng(location_data[0], location_data[1]);
	}
	function initialize() {
		var mapOptions = {
			zoom: <?php echo $s_options['map-zoom']; ?>,
			center: origin
		};

		map = new google.maps.Map(document.getElementById('map-canvas'), mapOptions);

		infowindow = new google.maps.InfoWindow();

		for (i = 0; i < locations.length; i++) {
			createMarker(locations[i][2], locations[i][3], locations[i][0], locations[i][1], i);
		}
		
		//open first found location
		locate(0);
		
		//close infoWindow when map click
        google.maps.event.addListener(map, 'click', function() {
            infowindow.close();
        });
	}
	
	//auto open marker on load
	function locate(marker_id) {
		var myMarker = Markers[marker_id];
		var markerPosition = myMarker.getPosition();
		map.setCenter(markerPosition);
		google.maps.event.trigger(myMarker, 'click');
	}
	
	
	//create infoWindow 
	function createMarker(lat, lon, html, title, i) {
        var newmarker = new google.maps.Marker({
            position: new google.maps.LatLng(lat, lon),
            map: map,
            title: title
        });
    
        newmarker['infowindow'] = new google.maps.InfoWindow({
                content: html,
                // maxWidth: 00,
                // minWidth: 200
            });
    
        google.maps.event.addListener(newmarker, 'click', function() {
        	infowindow.close();
            this['infowindow'].open(map, this);
            infowindow = this['infowindow'];
        });
        Markers[locations[i][4]] = newmarker;
	}
	
	//onLoad show map
	google.maps.event.addDomListener(window, 'load', initialize);

</script>

<div id="map-canvas" style="width:100%; height:<?php echo esc_attr($s_options['map-height']); ?>px;"></div>


<br>
<?php } else { ?>
<p class="dokan-error"><?php esc_html_e('No seller found for map!', $text_domain); ?></p>
<?php } ?>