<?php

/**
 * Plugin Settings
 */

defined( "ABSPATH" ) || exit;

$tutorlms_cvs_settings    = get_option( '__tutorlms_cvs_plugin_global_settings', array() );

// Enable logs and systems information
$tutorlms_cvs_wp_log = isset( $tutorlms_cvs_settings['tutorlms_cvs_wp_log'] ) ? $tutorlms_cvs_settings['tutorlms_cvs_wp_log'] : '';

?>
<div class="wn_wrap tutorlms_cvs-setting">
    <form method="post">
        <table class="form-table">
        <!-- tutor_cvs nonce field -->
        <?php wp_nonce_field( "tutorlms_certificate_verify_and_share_nonce", "tutorlms_certificate_verify_and_share_nonce" ); ?>

            <!-- tutor_cvs enable logs and systems information -->
            <tr>
                <th scope="row" class="qst-mrk-tbl-tutor_cvs">
                    <label for="tutorlms_cvs_wp_log">
                        <?php echo __( 'Enable Debug Logs', 'tutorlms-certificate-verify-and-share' ); ?>
                   <i class="fas fa-question"></i>
                    </label>
 
                    <p class="description">
                        <?php echo __( 'Enable this option to generate import debug logs and send to our support team.','tutorlms-certificate-verify-and-share'); ?>
                    </p>
                </th>
                <td class="ldscvs-flex-row">
                    <label for="tutorlms_cvs_wp_log">
                        <input name="tutorlms_cvs_wp_log" type="checkbox" value="1" <?php checked( true, $tutorlms_cvs_wp_log ); ?> >
                    </label>
                    

                </td>
            </tr>

            <!-- tutor_cvs certificate verification -->
            <tr>
                <th scope="row" class="qst-mrk-tbl-tutor_cvs">
                    <label for="tutorlms_cvs_shortcode">
                        <?php echo __( 'Certificate Verification Shortcode', 'tutorlms-certificate-verify-and-share' ); ?>
                   <i class="fas fa-question"></i>
                    </label>
 
                    <p class="description">
                        <?php echo __( 'Utilize the shortcode to display the certificate verification functionality.','tutorlms-certificate-verify-and-share'); ?>
                    </p>
                </th>
                <td class="ldscvs-flex-row">
                    
                    <div class="wooninjas_shortcode_tlm_cvs">
                        <code>[certificate_verification]</code>
                        <button type="button">
                            <span class="dashicons dashicons-admin-page"></span>
                        </button>
                    </div>

                </td>
            </tr>

        </table>
        <div class="submit">
            <input type="submit" name="tutor_cvs_save_settings_options" class="button-primary" value="<?php esc_attr_e( 'Update Settings', 'tutorlms-certificate-verify-and-share' ); ?>">
        </div>
    </form>
</div>
