<?php
if ( ! defined( 'ABSPATH' ) ) exit;

if( !class_exists('Tutorlms_Certificate_Verify_And_Share_Cron') ) {

	/**
	 * Class Tutorlms_Certificate_Verify_And_Share_Cron
	 */
	class Tutorlms_Certificate_Verify_And_Share_Cron {
		/**
		 * tutorlms_Course_Import_Export_Cron constructor.
		 */
		public function __construct() {
			global $wp_version;

			if( version_compare($wp_version, '5.4', '<') ) {
				add_filter( 'cron_schedules', [ $this, 'add_weekly_schedule' ] ); //Add weekly schedule if WP version is less than 5.4
			}

			//Uncomment following line to add minute schedule, for testing purpose only.
			//add_filter( 'cron_schedules', [$this, 'add_one_min_schedule'] );

			add_action( 'wp', [$this, 'wp_cb'] );
		}

		public function add_one_min_schedule( $schedules ) {
			$schedules['minute'] = array(
				'interval' => MINUTE_IN_SECONDS,
				'display' => __('Every Minute'),
			);

			return $schedules;
		}

		public function add_weekly_schedule( $schedules ) {
			$schedules['weekly'] = array(
				'interval' => WEEK_IN_SECONDS,
				'display'  => __( 'Once Weekly' ),
			);

			return $schedules;
		}

		public function wp_cb() {
			$this->weekly_events();
		}

		private function weekly_events() {

			if ( ! wp_next_scheduled( 'tutorlms_certificate_verify_and_share_weekly_scheduled_events' ) ) {
				//Change weekly to minute for testing purpose only.
				wp_schedule_event( current_time( 'timestamp', true ), 'weekly', 'tutorlms_certificate_verify_and_share_weekly_scheduled_events' );
			}

			// Delete logs
			if ( ! wp_next_scheduled( 'tutorlms_cvs_wp_logging_prune_routine' ) ) {
		        wp_schedule_event( time(), 'weekly', 'tutorlms_cvs_wp_logging_prune_routine' );
		    }
		}
	}

	new Tutorlms_Certificate_Verify_And_Share_Cron;
}