<?php

defined( "ABSPATH" ) || exit;

?>

<div class="hero">
    
    <div class="social-links">

        <a class="fb" href="<?php echo esc_url( $this->get_social_share_url( 'facebook' ) ); ?>" onclick="window.open( this.href, 'facebook','left=20,top=20,width=700,height=500,toolbar=0,resizable=1'); return false;">
            <i class="fab fa-facebook-f"></i>
        </a>
        
        <a class="tw" href="<?php echo esc_url( $this->get_social_share_url( 'twitter' ) ); ?>" onclick="window.open( this.href, 'twitter','left=20,top=20,width=700,height=500,toolbar=0,resizable=1'); return false;">
            <i class="fab fa-twitter"></i>
        </a>

        <a class="ln" href="#ex1" rel="modal:open">
            <i class="fab fa-linkedin-in"></i>
        </a>
        
        <a class="pi" href="<?php echo esc_url( $this->get_social_share_url( 'pinterest' ) ); ?>" onclick="window.open( this.href, 'pinterest','left=20,top=20,width=700,height=500,toolbar=0,resizable=1'); return false;">
            <i class="fab fa-pinterest"></i>
        </a>
    </div>

</div>

<!-- Modal HTML embedded directly into document -->
<div id="ex1" class="modal" style="width: 300px;text-align:center; z-index: 9999;">
    <h5 style="font-weight:bold"><?php echo esc_html( 'Share on LinkedIn', 'tutorlms-certificate-verify-and-share' ); ?></h5> 
    <?php echo esc_html( 'Showcase your knowledge, experience and skills and be found for new opportunities.', 'tutorlms-certificate-verify-and-share' ); ?>
    
    <a href="<?php echo esc_url( $this->get_social_share_url( 'linkedin' ) ); ?>" onclick="window.open( this.href, 'linkedin','left=20,top=20,width=700,height=500,toolbar=0,resizable=1'); return false;" class="btn btn-linkedin btn-lg" >
        <i class="fab fa-linkedin-in"></i> 
        Share
    </a>
    
    <a href="#ex2" rel="modal:open" class="btn btn-linkedin btn-lg">
        <i class="fab fa-linkedin-in"></i> 
        Add to profile
    </a>

</div>
<div id="ex2" class="modal" style="max-width: 700px;width: 700px; z-index: 9999;">
    <p>
        <?php 
            esc_html_e( 'Use the copy icon to quickly fill in the information in the "Add Certification" area of your LinkedIn profile.', 'tutorlms-certificate-verify-and-share' ); ?>
    </p>
    <table cellspacing="0" cellpadding="10">
        <tbody>
            <tr>
                <td><?php echo esc_html( 'Certificate Name', 'tutorlms-certificate-verify-and-share' ); ?></td>
                <td>
                    <span class="content"> <?php echo esc_html( get_the_title( absint( $certificate_data[0]->course_id ) ) ); ?></span>
                    <span class="copy_content"> <i class="fas fa-copy"></i> </span>
                </td>
            </tr>
            <tr>
                <td><?php echo esc_html( 'Issuing Organization', 'tutorlms-certificate-verify-and-share' ); ?></td>
                <td>
                    <span class="content"> <?php echo esc_html( get_bloginfo( 'name' ) ); ?> </span>
                    <span class="copy_content"> <i class="fas fa-copy"></i> </span>
                </td>
            </tr>
            <tr>
                <td><?php echo esc_html( 'Credential ID', 'tutorlms-certificate-verify-and-share' ); ?></td>
                <td>
                    <span class="content"> <?php echo esc_html( $_GET['cert_hash'] ); ?> </span>
                    <span class="copy_content"> <i class="fas fa-copy"></i> </span>
                </td>
            </tr>
            <tr>
                <td><?php echo esc_html( 'Credential URL', 'tutorlms-certificate-verify-and-share' ); ?></td>
                <td>
                    <span class="content"> <?php echo urldecode( $this->certificate_url() ); ?> </span>
                    <span class="copy_content"> <i class="fas fa-copy"></i> </span>
                </td>
            </tr>
            <tr>
                <td><?php echo esc_html( 'Issue Date', 'tutorlms-certificate-verify-and-share' ); ?></td>
                <td><?php echo esc_html( date('l jS \of F Y', strtotime( $certificate_data[0]->completion_date ) ) ); ?></td>
            </tr>
            
            <?php 
                $course_id = $certificate_data[0]->course_id;
                $expiration     = get_post_meta( $course_id, '_tutor_enable_certificate_expiration', true );
                $duration       = get_post_meta( $course_id, '_tutor_certificate_expiration_duration', true );
                $duration_type  = get_post_meta( $course_id, '_tutor_certificate_expiration_duration_type', true );
                if( 'on' === $expiration ) {
                    $expire_date = date( 'l jS \of F Y', strtotime( '+'. $duration .' '. $duration_type, strtotime( $certificate_data[0]->completion_date ) ) );
                ?>
                <tr>
                    <td><?php echo esc_html( 'Expire Date', 'tutorlms-certificate-verify-and-share' ); ?></td>
                    <td><?php echo esc_html( $expire_date ); ?></td>
                </tr>
                <?php } ?>

        </tbody>
    </table>
    <a href="https://www.linkedin.com/profile/add?startTask=CERTIFICATION_NAME" onclick="window.open( this.href, 'linkedin','left=20,top=20,width=700,height=500,toolbar=0,resizable=1'); return false;" class="btn btn-linkedin btn-lg">
        <i class="fab fa-linkedin-in"></i> 
        <?php echo esc_html( 'Add to profile', 'tutorlms-certificate-verify-and-share' ); ?>
    </a>
</div>

<script type="text/javascript">
jQuery(document).ready(function($) {
  // Append the code to the "tutor-certificate-info" class
  
});

</script>