<?php

/**
 * @link              https://wooninjas.com/
 * @since             1.0.0
 * @package           Tutorlms_Certificate_Verify_And_Share
 *
 * @wordpress-plugin
 * Plugin Name:       تایید به و اشتراک گذاری گواهینامه تیوتر ال ام اس
 * Plugin URI:        https://wpnovin.com
 * Description:       این افزونه یک ویژگی تأیید گواهی را فراهم می کند که به دانش آموزان اجازه می دهد گواهینامه های خود را تأیید کنند و یک ویژگی اشتراک گواهی که به آنها امکان می دهد آن را در سیستم عامل های رسانه های اجتماعی به اشتراک بگذارند.
 * Version:           1.0.6
 * Author:            نوین وردپرس
 * Author URI:        https://wpnovin.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       tutorlms-certificate-verify-and-share
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'TUTORLMS_CERTIFICATE_VERIFY_AND_SHARE_VERSION', '1.0.6' );

define( 'TUTORLMS_CERTIFICATE_VERIFY_AND_SHARE_FILE', __FILE__ );
define( 'TUTORLMS_CERTIFICATE_VERIFY_AND_SHARE_URL', plugin_dir_url( __FILE__ )) ;
define( 'TUTORLMS_CERTIFICATE_VERIFY_AND_SHARE_PLUGIN_NAME', 'TutorLMS Certificate Verify And Share' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-tutorlms-certificate-verify-and-share-activator.php
 */
function activate_tutorlms_certificate_verify_and_share() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-tutorlms-certificate-verify-and-share-activator.php';
	Tutorlms_Certificate_Verify_And_Share_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-tutorlms-certificate-verify-and-share-deactivator.php
 */
function deactivate_tutorlms_certificate_verify_and_share() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-tutorlms-certificate-verify-and-share-deactivator.php';
	Tutorlms_Certificate_Verify_And_Share_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_tutorlms_certificate_verify_and_share' );
register_deactivation_hook( __FILE__, 'deactivate_tutorlms_certificate_verify_and_share' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-tutorlms-certificate-verify-and-share.php';

/**
 * Begins execution of the plugin.
 *
 * @since    1.0.0
 */
function run_tutorlms_certificate_verify_and_share() {
    $plugin = new Tutorlms_Certificate_Verify_And_Share();
    $plugin->run();
}

function tutorlms_certificate_verify_and_share_missing_plugin_notice() {
    unset( $_GET['activate'] );  
    $plugin_data = get_plugin_data( __FILE__ );

    $class = 'notice notice-error is-dismissible';
    $message = sprintf( __( '%s requires <a href="https://www.themeum.com/product/tutor-lms/">TutorLMS</a> plugin to be activated.', 'tutorlms-certificate-verify-and-share' ), $plugin_data['Name'] );
    printf ( "<div id='message' class='%s'> <p>%s</p></div>", $class, $message );
}

function tutorlms_certificate_verify_and_share_plugins_loaded_cb() {
    if ( current_user_can( 'activate_plugins' ) && ! function_exists( 'tutor' ) ) {
        if ( ! function_exists( 'is_plugin_active_for_network' ) ) {
            include_once( ABSPATH . '/wp-admin/includes/plugin.php' );
        }
        deactivate_plugins ( plugin_basename ( __FILE__ ), true );
        add_action( "admin_notices", 'tutorlms_certificate_verify_and_share_missing_plugin_notice' );
    } else {
        run_tutorlms_certificate_verify_and_share();
    }
}
add_action( 'plugins_loaded', 'tutorlms_certificate_verify_and_share_plugins_loaded_cb' );