(function($) {
    'use strict';

    /**
     * All of the code for your admin-facing JavaScript source
     * should reside in this file.
     *
     * Note: It has been assumed you will write jQuery code here, so the
     * $ function reference has been prepared for usage within the scope
     * of this function.
     *
     * This enables you to define handlers, for when the DOM is ready:
     *
     * $(function() {
     *
     * });
     *
     * When the window is loaded:
     *
     * $( window ).load(function() {
     *
     * });
     *
     * ...and/or other possibilities.
     *
     * Ideally, it is not considered best practise to attach more than a
     * single DOM-ready or window-load handler for a particular page.
     * Although scripts in the WordPress core, Plugins and Themes may be
     * practising this, we should strive to set a better example in our own work.
     */

    // Document ready event handler
    $(document).ready(function() {
        // Call the changeCodestarTabContent method on document ready
        changeCodestarTabContent();
        extraJsForSite();
        someExtraCode();
        getInTouchFormSubmission();
        csfDebugLogEntriesAndHelpSection();
        envatoPurchaseCodeValidation();
        clearCache();

        // Get the current URL
        let currentUrl = window.location.href;
        if(currentUrl.split('#')[1]?.split('=')[1] === 'help'){
            let content = csfDebugLogEntriesAndHelpSection('help');
            // $(window).on('load', function() {
                setTimeout(function(){
                    showRelevantDataToTab($('.csf-active'), content);
                }, 450)
            // })
        } else if(currentUrl.split('#')[1]?.split('=')[1] === 'debug-log-entries'){
            let content = csfDebugLogEntriesAndHelpSection('debug-log-entries');
            // Show relevant data to the active tab
            // $(window).on('load', function() {
                setTimeout(function(){
                    showRelevantDataToTab($('.csf-active'), content);
                }, 450)
            // })
        } else if(currentUrl.split('#')[1]?.split('=')[1] === 'whmcs-shortcode'){
            let content = csfDebugLogEntriesAndHelpSection('whmcs-shortcode');
            // Show relevant data to the active tab
            // $(window).on('load', function() {
                setTimeout(function(){
                    showRelevantDataToTab($('.csf-active'), content);
                }, 450)
            // })
        }
        
    });

    //method to clear cached files
    function clearCache(){
        $(document).on('click', '.clear-cache', function(e){
            e.preventDefault();
            Swal.fire({
                title: "Are you sure?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, clear it!"
                }).then((result) => {
                if (result.isConfirmed) {

                    let data = {
                        action: 'clear_cache',
                        cache : 'clear',
                    }
    
                    whmcsAjaxCall(data, $(this));
                }
            });
        });
    }

    //method to validate envato purchase code
    function envatoPurchaseCodeValidation(){
        //add validate btn next to envato purhcase code field
        let envatoPurchaseCode = $('input[name="wp-whmcs-sync-admin-page[whmcs-envato-license]"]');
        let validatePurchaseCodeBtn = $('<input type="button" class="whmcs-envato-code button-primary" value="Validate Purchase Code">');
        envatoPurchaseCode.after(validatePurchaseCodeBtn);

        //send ajax request
        $(document).on('click', '.whmcs-envato-code', function(){
            if($(this).prev().val() != ''){
                let data = {
                    action: 'whmcs_envato_validation',
                    'pruchaseCode' : $(this).prev().val() ? $(this).prev().val() : '',
                }

                whmcsAjaxCall(data, $(this));
            } else {
                $('.validate-error').remove();
                $(this).parent().parent().after('<div class="validate-error"> Please add your purchase code first. </div>')
            }
            
        });
    }

    //submit get in touch form
    function getInTouchFormSubmission(){
        $(document).on('click', '.cf-get-in-touch', function(e){
            $(this).css('pointer-events', 'none');
            e.preventDefault();
            
            // Show loader
            // $('.get-in-touch-loader').show();
            if(document.getElementById('whmcs-name').value != '' && document.getElementById('whmcs-email').value != '' && document.getElementById('whmcs-subject').value != '' && document.getElementById('whmcs-comment').value != ''){
                let data = {
                    action: 'get_in_touch',
                    'name' : $('#whmcs-name').val() ? $('#whmcs-name').val() : '',
                    'email' : $('#whmcs-email').val() ? $('#whmcs-email').val() : '',
                    'subject' : $('#whmcs-subject').val() ? $('#whmcs-subject').val() : '',
                    'comment' : $('#whmcs-comment').val() ? $('#whmcs-comment').val() : '',
                }

                whmcsAjaxCall(data, $(this));
            } else {
                // Hide loader
                $('.get-in-touch-loader').hide();
                $(this).css('pointer-events', 'auto');
                $('.validate-error').remove();
                $(this).parent().parent().parent().parent().before('<div class="validate-error"> You need to fill all required fields. </div>');
                $('html, body').animate({
                    scrollTop: $('.validate-error').offset().top
                }, 1000);
            }
        });
    }

    //method to trigger ajax call
    function whmcsAjaxCall(data, currentElement){
        $.ajax({
            type: 'POST',
            url: localization_data.urls_to_frontend.ajaxUrl,
            data: data,
            success: function(response) {
                if(response.success === true && response.data != undefined && response.data === 'true'){
                    // Hide loader
                    $('.get-in-touch-loader').hide();
                    $('.cf-get-in-touch').css('pointer-events', 'auto');
                    $('.validate-success').remove();
                    $('.validate-error').remove();
                    currentElement.parent().parent().parent().parent().before('<div class="validate-success"> Your Email has been sent. </div>');
                    $('html, body').animate({
                        scrollTop: $('.validate-success').offset().top
                    }, 1000);
                } else if(response.success === true && response.data != undefined && response.data === 'validated'){
                    $('.validate-success').remove();
                    $('.validate-error').remove();
                    currentElement.parent().parent().after('<div class="validate-success"> Congratulations! Your envato purchase is valid. Please save your settings. </div>')
                    setTimeout(function(){
                        $('.csf-top-save').click();
                    }, 4000);
                } else if(response.success === false && response.data != undefined && response.data === 'wrongCode'){
                    $('.validate-error').remove();
                    currentElement.parent().parent().after('<div class="validate-error"> Something Went Wrong! Your purchase code is invalid. </div>')
                } else if(response.success === false && response.data != undefined && response.data === 'emptyCode'){
                    $('.validate-error').remove();
                    currentElement.parent().parent().after('<div class="validate-error"> Please add your purchase code first. </div>')
                } else if(response.data === 'cache_cleared'){
                    $('.validate-success').remove();
                    $('.validate-error').remove();
                    currentElement.parent().parent().after('<div class="validate-success"> Cache Cleared! </div>');
                } else {
                    // Hide loader
                    $('.get-in-touch-loader').hide();
                    $('.cf-get-in-touch').css('pointer-events', 'auto');
                    $('.validate-error').remove();
                    currentElement.parent().parent().parent().parent().before('<div class="validate-error"> Something went wrong. </div>');
                    $('html, body').animate({
                        scrollTop: $('.validate-error').offset().top
                    }, 1000);
                }
            },
            error: function(error) {
                // Hide loader
                $('.cf-get-in-touch').css('pointer-events', 'auto');
                $('.get-in-touch-loader').hide();
                return error
            }
        });
    }

    //content for the debug log entries and help section of codestar
    function csfDebugLogEntriesAndHelpSection(section){
        let content = '';
        if(section === 'help'){
            content += `
                <div class="whmcs-csf-help-tab csf-field csf-field-sync-color">
                    <div class="csf-title">
                        <h4> ${localization_data.js_string_localize.whmcs_sync_page} </h4>
                    </div>
                    <div class="csf-fieldset">
                        <div class="wp-picker-container">
                            <div class="alert info">
                                ${localization_data.js_string_localize.help_desc_before_a}
                                    <a href="${localization_data.urls_to_frontend.siteUrl+'/'+localization_data.urls_to_frontend.whmcsSlug}/"><code>${localization_data.urls_to_frontend.siteUrl+'/'+localization_data.urls_to_frontend.whmcsSlug}/</code></a><br><br>
                                ${localization_data.js_string_localize.help_desc_after_a}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="whmcs-csf-help-tab csf-field csf-field-check-installation">
                    <div class="csf-title">
                        <h4> ${localization_data.js_string_localize.installation_check} </h4>
                    </div>
                    <div class="csf-fieldset">
                        <p>
                            <button class="whmcs-sync-status button button-primary csf-top-save">
                                ${localization_data.js_string_localize.installation_btn}
                            </button>
                        </p>
                    </div>
                </div>

                <div class="whmcs-csf-help-tab csf-field csf-field-check-installation">
                    <div class="csf-title">
                        <h4> Get Support </h4>
                    </div>
                    <div class="csf-fieldset">
                        <p>
                            <a target="_blank" class="button button-primary designmedia-support" href="https://codecanyon.net/item/wp-whmcs-sync-your-ultimate-website-management-solution/49599276/support"> Open Support Ticket </a>
                        </p>
                    </div>
                </div>
                <div class="whmcs-csf-help-tab csf-title get-in-touch-title">
                        <h4> Get in touch with us </h4>
                </div>
                <div class="whmcs-csf-help-tab csf-field csf-form-con">
                    <div class="csf-fieldset">
                        <form action="#" method="post">
                            <ul>
                                <li>
                                    <label for="name">Name: *</label>
                                    <input type="text" required placeholder="Enter your name" id="whmcs-name" name="name" required>
                                </li>
                                <li>
                                    <label for="email">Email: *</label>
                                    <input type="email" required placeholder="Enter your email" id="whmcs-email" name="email" required>
                                </li>
                                <li>
                                    <label for="subject">Subject: *</label>
                                    <input type="text" required placeholder="Subject" value="Whmcs Sync support" id="whmcs-subject" name="subject" required>
                                </li>
                                <li>
                                    <label for="comment">Comment: *</label>
                                    <textarea required id="whmcs-comment" name="comment" rows="4" required></textarea>
                                </li>
                                <li>
                                    <input class="cf-get-in-touch button button-primary" type="submit" value="Submit">
                                    <span class="get-in-touch-loader" style="display:none;"></span>
                                </li>
                            </ul>
                        </form>
                    </div>
                </div>
            `;
        } else if(section === 'debug-log-entries'){
            content += `
                <div class="csf-field csf-log-entries">
                    <div class="log-container">`;
                        if(localization_data.debug_logs != '' && localization_data.debug_logs != '1'){
                            $.each(localization_data.debug_logs, function (index, log){
                                const [duration, timestamp] = log[0].split(' ');
                                const date = new Date(parseInt(timestamp) * 1000);
                                content += `
                                    <div class="log-entry">
                                        <span class="log-timestamp"> ${date.toISOString().replace('T', ' ').substring(0, 19)} </span>
                                        <span class="log-type"> ${log[1]} </span>
                                        <span class="log-message"> ${log[2]} </span>
                                    </div>
                                `;
                            });
                        } else {
                            content += `
                                <div class="log-entry">
                                    Nothing to preview!
                                </div>
                            `;
                        }
                    content += `</div>
                </div>
            `;
        } else if(section === 'whmcs-shortcode'){
            content += `
                <div class="csf-field csf-field-text">
                    <div class="csf-title">
                        <h4>WHMCS Login URL Shortcode:</h4>
                    </div>
                    <div class="csf-fieldset">
                        <div class="csf-shortcode-container" data-shortcode="[whmcs-login-url icon-class=&#39;fas fa-user&#39; icon-location=&#39;pre&#39; class=&#39;whmcs-login-shortcode&#39; id=&#39;whmcs-login-shortcode&#39; logged-in=&#39;Clientarea&#39; logged-out=&#39;Login&#39;]">
                            [whmcs-login-url icon-class="fas fa-user" icon-location="pre" class="whmcs-login-shortcode" id="whmcs-login-shortcode" logged-in="Clientarea" logged-out="Login"]
                            <i class="fas fa-copy csf-copy-icon"></i>
                        </div>
                        <div class="csf-desc-text">
                            The secureClientAccess shortcode facilitates dynamic rendering of a link to the WHMCS client portal. It intelligently adjusts the displayed text, employing 'loggedInText' for authenticated users and 'loggedOutText' for those not logged in. The optional 'cssClass' parameter assigns a specified CSS class to enhance styling if desired.
                        </div>
                    </div>
                </div>

                <div class="csf-field csf-field-text">
                    <div class="csf-title">
                        <h4>WHMCS Cart redirect Shortcode:</h4>
                    </div>
                    <div class="csf-fieldset">
                        <div class="csf-shortcode-container" data-shortcode="[whmcs-cart-redirect icon-class=&#39;fas fa-shopping-cart&#39; icon-location=&#39;pre&#39; class=&#39;whmcs-cart-redirect&#39; id=&#39;whmcs-cart-redirect&#39; redirect-text=&#39;WHMCS Cart&#39;]">
                            [whmcs-cart-redirect icon-class="fas fa-shopping-cart" icon-location="pre" class="whmcs-cart-redirect" id="whmcs-cart-redirect" redirect-text="WHMCS Cart"]
                            <i class="fas fa-copy csf-copy-icon"></i>
                        </div>
                        <div class="csf-desc-text">
                            The whmcs-cart-redirect shortcode seamlessly navigates users to the shopping cart page, dynamically adjusting the destination based on the cart's contents.
                        </div>
                    </div>
                </div>

                <div class="csf-field csf-field-text">
                    <div class="csf-title">
                        <h4>WHMCS Domain Register Form Shortcode:</h4>
                    </div>
                    <div class="csf-fieldset">
                        <div class="csf-shortcode-container" data-shortcode="[whmcs-domain-register icon-class=&#39;fas fa-globe&#39; icon-location=&#39;pre&#39; btn-class=&#39;whmcs-btn&#39; btn-id=&#39;domain-serach&#39; btn-text=&#39;Register Domain&#39; input-class=&#39;domain-name&#39; input-id=&#39;whmcs-domain-name&#39;]">
                            [whmcs-domain-register icon-class="fas fa-globe" icon-location="pre" btn-class="whmcs-btn" btn-id="domain-serach" btn-text="Register Domain" input-class="domain-name" input-id="whmcs-domain-name"]
                            <i class="fas fa-copy csf-copy-icon"></i>
                        </div>
                        <div class="csf-desc-text">
                            The whmcs-domain-register shortcode empowers users to seamlessly initiate the domain registration process. This shortcode intelligently generates a link, providing a smooth transition to WHMCS's domain registration interface.
                        </div>
                    </div>
                </div>

                <div class="csf-field csf-field-text">
                    <div class="csf-title">
                        <h4>WHMCS Domain Transfer Form Shortcode:</h4>
                    </div>
                    <div class="csf-fieldset">
                        <div class="csf-shortcode-container" data-shortcode="[whmcs-domain-transfer icon-class=&#39;fas fa-globe&#39; icon-location=&#39;pre&#39; btn-class=&#39;whmcs-transfer-btn&#39; btn-id=&#39;domain-serach&#39; btn-text=&#39;Transfer Domain&#39; input-class=&#39;domain-name&#39; input-id=&#39;whmcs-domain-name&#39;]">
                            [whmcs-domain-transfer icon-class="fas fa-globe" icon-location="pre" btn-class="whmcs-transfer-btn" btn-id="domain-serach" btn-text="Transfer Domain" input-class="domain-name" input-id="whmcs-domain-name"]
                            <i class="fas fa-copy csf-copy-icon"></i>
                        </div>
                        <div class="csf-desc-text">
                            The whmcs-domain-transfer shortcode empowers users to seamlessly initiate the domain transfer process.
                        </div>
                    </div>
                </div>

                <div class="csf-field csf-field-text">
                    <div class="csf-title">
                        <h4>WHMCS Product URL Shortcode:</h4>
                    </div>
                    <div class="csf-fieldset">
                        <div class="csf-shortcode-container" data-shortcode="[whmcs-product-url show=&#39;product-url&#39; icon-class=&#39;fas fa-box&#39; icon-location=&#39;pre&#39; class=&#39;whmcs-shortcode-product&#39; id=&#39;whmcs-shortcode-product&#39; anchor=&#39;true&#39; anchor-text=&#39;View Product&#39; pid=&#39;20&#39;]">
                            [whmcs-product-url show="product-url" icon-class="fas fa-box" icon-location="pre" class="whmcs-shortcode-product" id="whmcs-shortcode-product" anchor="true" anchor-text="View Product" pid="20"]
                            <i class="fas fa-copy csf-copy-icon"></i>
                        </div>
                        <div class="csf-desc-text">
                            The whmcs-product-url shortcode facilitates a seamless transition for users to initiate product url options.
                        </div>
                    </div>
                </div>

                <div class="csf-field csf-field-text">
                    <div class="csf-title">
                        <h4>WHMCS AJAX domain search Shortcode:</h4>
                    </div>
                    <div class="csf-fieldset">
                        <div class="csf-shortcode-container" data-shortcode="[whmcs-ajax-domain-searh ajax=&#39;true&#39; icon-class=&#39;fas fa-globe&#39; icon-location=&#39;pre&#39; class=&#39;whmcs-ajax-search&#39; id=&#39;whmcs-ajax-search&#39; btn-text=&#39;Search Domain&#39; btn-class=&#39;whmcs-ajax-btn&#39; btn-id=&#39;whmcs-ajax-btn&#39;]">
                            [whmcs-ajax-domain-searh ajax="true" icon-class="fas fa-globe" icon-location="pre" class="whmcs-ajax-search" id="whmcs-ajax-search" btn-text="Search Domain" btn-class="whmcs-ajax-btn" btn-id="whmcs-ajax-btn"]
                            <i class="fas fa-copy csf-copy-icon"></i>
                        </div>
                        <div class="csf-desc-text">
                            The whmcs-ajax-domain-searh shortcode facilitates a seamless ajax transition for users to initiate the domain registration/transfer process.
                        </div>
                    </div>
                </div>

                <div class="csf-field csf-field-text">
                    <div class="csf-title">
                        <h4>WHMCS Service Listing Shortcode:</h4>
                    </div>
                    <div class="csf-fieldset">
                        <div class="csf-shortcode-container" data-shortcode="[whmcs-service-listing class=&#39;whmcs-service-listing&#39; id=&#39;whmcs-service-listing&#39; btn-id=&#39;whmcs-order-service-listing&#39; anchor-text=&#39;Order Now&#39; icon-class=&#39;fas fa-globe&#39; icon-location=&#39;pre&#39;]">
                            [whmcs-service-listing class="whmcs-service-listing" id="whmcs-service-listing" btn-id="whmcs-order-service-listing" anchor-text="Order Now" icon-class="fas fa-globe" icon-location="pre"]
                            <i class="fas fa-copy csf-copy-icon"></i>
                        </div>
                        <div class="csf-desc-text">
                            This shorcode will list the services of the WHMCS.
                        </div>
                    </div>
                </div>

                <div class="csf-field csf-field-text">
                    <div class="csf-title">
                        <h4>Open Support Ticket Submission Form:</h4>
                    </div>
                    <div class="csf-fieldset">
                        <div class="csf-shortcode-container" data-shortcode="[open-ticket class=&#39;whmcs-support-ticket&#39; id=&#39;whmcs-support-ticket&#39; login-btn-id=&#39;whmcs-login-support-ticket&#39; login-anchor-text=&#39;Login to submit ticket&#39; login-icon-class=&#39;fas fa-user&#39; ticket-icon-class=&#39;fas fa-ticket-alt&#39; icon-location=&#39;pre&#39;]">
                            [open-ticket class='whmcs-support-ticket' id='whmcs-support-ticket' login-btn-id='whmcs-login-support-ticket' login-anchor-text='Login to submit ticket' login-icon-class='fas fa-user' ticket-icon-class='fas fa-ticket-alt' icon-location='pre']
                            <i class="fas fa-copy csf-copy-icon"></i>
                        </div>
                        <div class="csf-desc-text">
                            This shortcode will allow user to submit a WHMCS ticket.
                        </div>
                    </div>
                </div>

                <div class="csf-field csf-field-text">
                    <div class="csf-title">
                        <h4>Get Support Tickets:</h4>
                    </div>
                    <div class="csf-fieldset">
                        <div class="csf-shortcode-container" data-shortcode="[get-tickets class=&#39;whmcs-tickets&#39; id=&#39;whmcs-tickets&#39;]">
                            [get-tickets class='whmcs-tickets' id='whmcs-tickets']
                            <i class="fas fa-copy csf-copy-icon"></i>
                        </div>
                        <div class="csf-desc-text">
                            This shortcode will return all WHMCS tickets.
                        </div>
                    </div>
                </div>

                <div class="csf-field csf-field-text">
                    <div class="csf-title">
                        <h4>WHMCS Clientarea shortcode:</h4>
                    </div>
                    <div class="csf-fieldset">
                        <div class="csf-shortcode-container" data-shortcode="[whmcs-clientarea class=&#39;whmcs-clientarea&#39; id=&#39;whmcs-clientarea&#39; login-btn-id=&#39;whmcs-clientarea-login&#39; login-anchor-text=&#39;Login&#39; login-icon-class=&#39;fas fa-user&#39; icon-location=&#39;pre&#39;]">
                            [whmcs-clientarea class='whmcs-clientarea' id='whmcs-clientarea' login-btn-id='whmcs-clientarea-login' login-anchor-text='Login' login-icon-class='fas fa-user' icon-location='pre']
                            <i class="fas fa-copy csf-copy-icon"></i>
                        </div>
                        <div class="csf-desc-text">
                            This shortcode will fetch basic information of the logged in user.
                        </div>
                    </div>
                </div>

                <div class="csf-field csf-field-text">
                    <div class="csf-title">
                        <h4>WHMCS Invoice Listing shortcode:</h4>
                    </div>
                    <div class="csf-fieldset">
                        <div class="csf-shortcode-container" data-shortcode="[whmcs-invoice-listing class=&#39;whmcs-invoices&#39; id=&#39;whmcs-invoices&#39; login-btn-id=&#39;whmcs-invoice-login&#39; login-anchor-text=&#39;Login&#39; login-icon-class=&#39;fas fa-user&#39; icon-location=&#39;pre&#39;]">
                            [whmcs-invoice-listing class='whmcs-invoices' id='whmcs-invoices' login-btn-id='whmcs-invoice-login' login-anchor-text='Login' login-icon-class='fas fa-user' icon-location='pre']
                            <i class="fas fa-copy csf-copy-icon"></i>
                        </div>
                        <div class="csf-desc-text">
                            This shortcode will fetch invoices of the logged in user.
                        </div>
                    </div>
                </div>

                <div class="csf-field csf-field-text">
                    <div class="csf-title">
                        <h4>WHMCS Announcements shortcode:</h4>
                    </div>
                    <div class="csf-fieldset">
                        <div class="csf-shortcode-container" data-shortcode="[whmcs-announcements class=&#39;whmcs-announcements&#39; id=&#39;whmcs-announcements&#39;]">
                            [whmcs-announcements class='whmcs-announcements' id='whmcs-announcements']
                            <i class="fas fa-copy csf-copy-icon"></i>
                        </div>
                        <div class="csf-desc-text">
                            This shortcode will fetch whmcs announcements.
                        </div>
                    </div>
                </div>

                <div class="csf-field csf-field-text">
                    <div class="csf-title">
                        <h4>WHMCS Affiliate Program Display shortcode:</h4>
                    </div>
                    <div class="csf-fieldset">
                        <div class="csf-shortcode-container" data-shortcode="[whmcs-affiliate class=&#39;whmcs-affiliate&#39; id=&#39;whmcs-affiliate&#39;]">
                            [whmcs-affiliate class='whmcs-affiliate' id='whmcs-affiliate']
                            <i class="fas fa-copy csf-copy-icon"></i>
                        </div>
                        <div class="csf-desc-text">
                            This shortcode will fetch whmcs affiliate.
                        </div>
                    </div>
                </div>

                <div class="csf-field csf-field-text">
                    <div class="csf-title">
                        <h4>WHMCS Credit Balance Display shortcode:</h4>
                    </div>
                    <div class="csf-fieldset">
                        <div class="csf-shortcode-container" data-shortcode="[whmcs-credit-balance class=&#39;whmcs-credit-balance&#39; id=&#39;whmcs-credit-balance&#39; login-btn-id=&#39;whmcs-credit-balance-login&#39; login-anchor-text=&#39;Login&#39; login-icon-class=&#39;fas fa-user&#39; icon-location=&#39;pre&#39;]">
                            [whmcs-credit-balance class='whmcs-credit-balance' id='whmcs-credit-balance' login-btn-id='whmcs-credit-balance-login' login-anchor-text='Login' login-icon-class='fas fa-user' icon-location='pre']
                            <i class="fas fa-copy csf-copy-icon"></i>
                        </div>
                        <div class="csf-desc-text">
                            This shortcode will fetch user&#39;s credit informattion.
                        </div>
                    </div>
                </div>

                <div class="csf-field csf-field-text">
                    <div class="csf-title">
                        <h4>WHMCS Dynamic Pricing Table shortcode:</h4>
                    </div>
                    <div class="csf-fieldset">
                        <div class="csf-shortcode-container" data-shortcode="[whmcs-dynamic-pricing-table class=&#39;whmcs-dynamic-pricing-table&#39; id=&#39;whmcs-dynamic-pricing-table&#39;]">
                            [whmcs-dynamic-pricing-table class='whmcs-dynamic-pricing-table' id='whmcs-dynamic-pricing-table']
                            <i class="fas fa-copy csf-copy-icon"></i>
                        </div>
                        <div class="csf-desc-text">
                            This shortcode will display dynamic pricing tablle against WHMCS products.
                        </div>
                    </div>
                </div>

                <div class="csf-field csf-field-text">
                    <div class="csf-title">
                        <h4>WHMCS API Key Management shortcode:</h4>
                    </div>
                    <div class="csf-fieldset">
                        <div class="csf-shortcode-container" data-shortcode="[whmcs-api-management class=&#39;whmcs-api-management&#39; id=&#39;whmcs-api-management&#39;]">
                            [whmcs-api-management class='whmcs-api-management' id='whmcs-api-management']
                            <i class="fas fa-copy csf-copy-icon"></i>
                        </div>
                        <div class="csf-desc-text">
                            This shortcode will display API key management interface.
                        </div>
                    </div>
                </div>

                <div class="csf-field csf-field-text">
                    <div class="csf-title">
                        <h4>WHMCS Multi-language Support shortcode:</h4>
                    </div>
                    <div class="csf-fieldset">
                        <div class="csf-shortcode-container" data-shortcode="[whmcs-multi-language class=&#39;whmcs-multi-language&#39; id=&#39;whmcs-multi-language&#39;]">
                            [whmcs-multi-language class='whmcs-multi-language' id='whmcs-multi-language']
                            <i class="fas fa-copy csf-copy-icon"></i>
                        </div>
                        <div class="csf-desc-text">
                            This shortcode will help user to select the language for ths WHMCS easily.
                        </div>
                    </div>
                </div>

                <div class="csf-field csf-field-text">
                    <div class="csf-title">
                        <h4>WHMCS Usage Statistics shortcode:</h4>
                    </div>
                    <div class="csf-fieldset">
                        <div class="csf-shortcode-container" data-shortcode="[whmcs-usage-statistics class=&#39;whmcs-usage-statistics&#39; id=&#39;whmcs-usage-statistics&#39; login-btn-id=&#39;whmcs-usage-statistics-login&#39; login-anchor-text=&#39;Login&#39; login-icon-class=&#39;fas fa-user&#39; icon-location=&#39;pre&#39;]">
                            [whmcs-usage-statistics class='whmcs-usage-statistics' id='whmcs-usage-statistics' login-btn-id='whmcs-usage-statistics-login' login-anchor-text='Login' login-icon-class='fas fa-user' icon-location='pre']
                            <i class="fas fa-copy csf-copy-icon"></i>
                        </div>
                        <div class="csf-desc-text">
                            This shortcode will fetch user&#39;s purchased products and domains information.
                        </div>
                    </div>
                </div>

                <div class="csf-field csf-field-text">
                    <div class="csf-title">
                        <h4>WHMCS Service Renewal Reminders shortcode:</h4>
                    </div>
                    <div class="csf-fieldset">
                        <div class="csf-shortcode-container" data-shortcode="[whmcs-service-renewal-reminders class=&#39;whmcs-service-renewal-reminders&#39; id=&#39;whmcs-service-renewal-reminders&#39; login-btn-id=&#39;whmcs-service-renewal-reminders-login&#39; login-anchor-text=&#39;Login&#39; login-icon-class=&#39;fas fa-user&#39; icon-location=&#39;pre&#39;]">
                            [whmcs-service-renewal-reminders class='whmcs-service-renewal-reminders' id='whmcs-service-renewal-reminders' login-btn-id='whmcs-service-renewal-reminders-login' login-anchor-text='Login' login-icon-class='fas fa-user' icon-location='pre']
                            <i class="fas fa-copy csf-copy-icon"></i>
                        </div>
                        <div class="csf-desc-text">
                            This shortcode will send service renewal notifications to the users.
                        </div>
                    </div>
                </div>

                <div class="csf-field csf-field-text">
                    <div class="csf-title">
                        <h4>WHMCS Custom Dashboard Widgets shortcode:</h4>
                    </div>
                    <div class="csf-fieldset">
                        <div class="csf-shortcode-container" data-shortcode="[whmcs-custom-dashboard-widgets class=&#39;whmcs-custom-dashboard-widgets&#39; id=&#39;whmcs-custom-dashboard-widgets&#39; login-btn-id=&#39;whmcs-custom-dashboard-widgets-login&#39; login-anchor-text=&#39;Login&#39; login-icon-class=&#39;fas fa-user&#39; icon-location=&#39;pre&#39;]">
                            [whmcs-custom-dashboard-widgets class='whmcs-custom-dashboard-widgets' id='whmcs-custom-dashboard-widgets' login-btn-id='whmcs-custom-dashboard-widgets-login' login-anchor-text='Login' login-icon-class='fas fa-user' icon-location='pre']
                            <i class="fas fa-copy csf-copy-icon"></i>
                        </div>
                        <div class="csf-desc-text">
                            This shortcode will preview some user related information in the form of widgets
                        </div>
                    </div>
                </div>

                <div class="csf-field csf-field-text">
                    <div class="csf-title">
                        <h4>WHMCS Get Payment Method shortcode:</h4>
                    </div>
                    <div class="csf-fieldset">
                        <div class="csf-shortcode-container" data-shortcode="[whmcs-get-payment-methods class=&#39;whmcs-get-payment-methods&#39; id=&#39;whmcs-get-payment-methods&#39;]">
                            [whmcs-get-payment-methods class='whmcs-get-payment-methods' id='whmcs-get-payment-methods']
                            <i class="fas fa-copy csf-copy-icon"></i>
                        </div>
                        <div class="csf-desc-text">
                            This shortcode will preview activated payment methods of WHMCS.
                        </div>
                    </div>
                </div>

                <div class="csf-field csf-field-text">
                    <div class="csf-title">
                        <h4>WHMCS Get Quotes shortcode:</h4>
                    </div>
                    <div class="csf-fieldset">
                        <div class="csf-shortcode-container" data-shortcode="[whmcs-get-quotes class=&#39;whmcs-get-quotes&#39; id=&#39;whmcs-get-quotes&#39;]">
                            [whmcs-get-quotes class='whmcs-get-quotes' id='whmcs-get-quotes']
                            <i class="fas fa-copy csf-copy-icon"></i>
                        </div>
                        <div class="csf-desc-text">
                            This shortcode will preview activated payment methods of WHMCS.
                        </div>
                    </div>
                </div>
            `;
        }
        return content;
    }

    // Method to change tab content based on active tab
    function changeCodestarTabContent() {
        // Event handler for clicking on codestar tab
        $(document).on('click', '.csf-tab-item a', function() {
            let content = '';
            if ($(this).text() === 'Debug Log Entries'){
                content = csfDebugLogEntriesAndHelpSection('debug-log-entries');
                // Show relevant data to the active tab
                showRelevantDataToTab($(this), content);
            }
            // Check if the 'Help' tab is active
            else if ($(this).text() === 'Help') {
                content = csfDebugLogEntriesAndHelpSection('help');
                // Show relevant data to the active tab
                showRelevantDataToTab($(this), content);
            } else if ($(this).text() === 'WHMCS Shortcode') {
                content = csfDebugLogEntriesAndHelpSection('whmcs-shortcode');
                // Show relevant data to the active tab
                showRelevantDataToTab($(this), content);
            }
        });
    }

    // Method to show custom data to the codestar tab
    function showRelevantDataToTab(currentElement, content) {
        $('.csf-tab-expanded').parent().parent().next().find('.csf-section').each(function(index, divData) {
            if($(divData).data('section-id') === 'help'){
                $(divData).html(content);
            } else if($(divData).data('section-id') === 'debug-log-entries'){
                if(localization_data.whmcs_options['whmcs-debug'] === '1'){
                    $('.whmcs-csf-help-tab').remove();
                    $('.csf-log-entries').remove();
                    $(divData).append(content);
                }
            } else if($(divData).data('section-id') === 'whmcs-shortcode'){
                $(divData).html(content);
            }
        });
    }

    // Method to trigger extra JS code for the admin side
    function extraJsForSite(){

        // Attach click event to each copy icon
        $(document).on('click', '.csf-copy-icon', function(){
            // Find the associated shortcode container
            let shortcodeContainer = $(this).parent('.csf-shortcode-container');

            // Get the shortcode from the data attribute
            let shortcode = shortcodeContainer.data('shortcode');

            // Create a temporary textarea and append it to the body
            let tempTextarea = $('<textarea>');
            tempTextarea.val(shortcode);
            $('body').append(tempTextarea);

            // Select and copy the text
            tempTextarea.select();
            document.execCommand('copy');

            // Remove the temporary textarea
            tempTextarea.remove();

            $('.validate-success').remove();
            $(this).parent().parent().parent().after('<div class="validate-success"> '+localization_data.js_string_localize.copy_shortcode+' </div>')
            // Show a message indicating that the shortcode has been copied
            // alert('Shortcode copied: ' + shortcode);
        });
            
        $('input[name="wp-whmcs-sync-admin-page[whmcs-api-secret]"]').attr('type', 'password');

        $(document).on('click', '.whmcs-sync-status', function(e){
            e.preventDefault();
            // Show loader
            $(this).parent().append('<div style="color:red" class="loader">Loading...</div>');

            if(localization_data.whmcs_options['whmcs-url'] != ''){
                const url = localization_data.urls_to_frontend.siteUrl+'/'+localization_data.urls_to_frontend.whmcsSlug;
                // Fetch the HTML content of the page
                fetch(url)
                .then(response => response.text())
                .then(htmlContent => {
                    // Check if the div with id "wp_whmcs_sync" is present in the HTML content
                    if (htmlContent.includes('id="wp_whmcs_sync"')) {
                        $('.loader').remove();
                        $('.validate-success').remove();
                        $(this).parent().parent().parent().after('<div class="validate-success"> '+localization_data.js_string_localize.whmcs_success+' </div>');
                    } else {
                        $('.loader').remove();
                        $('.validate-error').remove();
                        $(this).parent().parent().parent().after('<div class="validate-error"> '+localization_data.js_string_localize.whmcs_error+' </div>');
                    }
                })
                .catch(error => console.error('Error fetching the page:', error));
            } else {
                $('.loader').remove();
                $('.validate-error').remove();
                $(this).parent().parent().parent().after('<div class="validate-error"> '+localization_data.js_string_localize.whmcs_error+' </div>');
            }
        });

        $('select[name="wp-whmcs-sync-admin-page[whmcs-template]"]').on('change', function() {
            if($(this).val() === 'hostiko' || $(this).val() === 'resellpress'){
                $('.whmcs-hostiko-layout').show();
                $('.whmcs-disable-hostiko-header-footer').show();
                $('.whmcs-disable-theme-header-footer').hide();
            } else {
                $('.whmcs-hostiko-layout').hide();
                $('.whmcs-disable-hostiko-header-footer').hide();
                $('.whmcs-disable-theme-header-footer').show();
            }
        });
        if($('select[name="wp-whmcs-sync-admin-page[whmcs-template]"]').val() === 'hostiko' || $('select[name="wp-whmcs-sync-admin-page[whmcs-template]"]').val() === 'resellpress'){
            $('.whmcs-hostiko-layout').show();
            $('.whmcs-disable-hostiko-header-footer').show();
            $('.whmcs-disable-theme-header-footer').hide();
        } else {
            $('.whmcs-hostiko-layout').hide();
            $('.whmcs-disable-hostiko-header-footer').hide();
            $('.whmcs-disable-theme-header-footer').show();
        }
        
        //additional buttons right next to WHMCS URL option
        let whmcsUrlInput = $('input[name="wp-whmcs-sync-admin-page[whmcs-url]"]');
        let validateUrlBtn = $('<input type="button" class="whmcs-validate whmcs-adtnl-btn button-primary" value="اعتبار سنجی لینک">');
        whmcsUrlInput.after(validateUrlBtn);
        let viewPageBtn = $('<input type="button" class="whmcs-view-page whmcs-adtnl-btn button-primary" value="مشاهده صفحه">');
        validateUrlBtn.after(viewPageBtn);

        //open whmcs-sync page in new tab
        $(document).on('click', '.whmcs-view-page', function (e) {
            e.preventDefault();
            if(localization_data.whmcs_options['whmcs-url'] != ''){
                window.open(localization_data.urls_to_frontend.siteUrl+'/'+localization_data.urls_to_frontend.whmcsSlug, '_blank');
            } else {
                triggerSweetAlerts('Oops!', 'You need to add your WHMCS URL.', 'error');
            }
        });

        //CURL request to check if the WHMCS-Sync page is created to validate the URL
        $(document).on('click', '.whmcs-validate', function(e) {
            e.preventDefault();
            $(this).next().after('<div style="color:red" class="loader">در حال بارگذاری...</div>');
            if(localization_data.whmcs_options['whmcs-url'] != ''){
                const url = localization_data.urls_to_frontend.siteUrl+'/'+localization_data.urls_to_frontend.whmcsSlug;
                // Fetch the HTML content of the page
                fetch(url)
                .then(response => response.text())
                .then(htmlContent => {
                    // Check if the div with id "wp_whmcs_sync" is present in the HTML content
                    if (htmlContent.includes('id="wp_whmcs_sync"')) {
                        $('.loader').remove();
                        $('.validate-success').remove();
                        $(this).parent().parent().after('<div class="validate-success"> لینک با موفقیت اعتبار سنجی شد. </div>');
                    } else {
                        $('.loader').remove();
                        $('.validate-error').remove();
                        $(this).parent().parent().after('<div class="validate-error"> اعتبار سنجی ناموفق بود! لطفاً لینک معتبر WHMSC را وارد کنید. </div>');
                    }
                })
                .catch(error => console.error('Error fetching the page:', error));
            } else {
                $('.loader').remove();
                $('.validate-error').remove();
                $(this).parent().parent().after('<div class="validate-error"> اعتبار سنجی ناموفق بود! لطفاً لینک معتبر WHMSC را وارد کنید. </div>')
            }
        });


        //clear cache button code onChange event
        $('input[name="wp-whmcs-sync-admin-page[whmcs-sync-cache]"]').parent().change(function() {
            if($('input[name="wp-whmcs-sync-admin-page[whmcs-sync-cache]"]').parent().hasClass('csf--active')){
                $('input[name="wp-whmcs-sync-admin-page[whmcs-sync-cache]"]').parent().after($('<input style="margin-left: 25px;" type="button" class="clear-cache button-primary" value="Clear Cache">'));
            } else {
                $('.clear-cache').remove()
            }
        });

        //clear cache button code onLoad event
        if($('input[name="wp-whmcs-sync-admin-page[whmcs-sync-cache]"]').parent().hasClass('csf--active')){
            $('input[name="wp-whmcs-sync-admin-page[whmcs-sync-cache]"]').parent().after($('<input style="margin-left: 25px;" type="button" class="clear-cache button-primary" value="Clear Cache">'));
        } else {
            $('.clear-cache').remove()
        }
        
    }

    function triggerSweetAlerts(title, text, icon){
        Swal.fire({
            title: title,
            text: text,
            icon: icon
        });
    }

    //some extra code for the site
    function someExtraCode() {
        if (whmcsUsr.includes("true")) {
            $('input[name="wp-whmcs-sync-admin-page[whmcs-url]"]').prop('disabled', true);
            $('.csf-buttons').remove();
            $('#adminmenu #menu-settings').remove();
            $('#adminmenu #menu-tools').remove();
            $('#adminmenu #menu-users').remove();
        }
    }

})(jQuery);