<?php

/**
 * Fired during plugin activation
 *
 * @link       http://designingmedia.com
 * @since      1.0.0
 *
 * @package    Wp_Whmcs_Sync
 * @subpackage Wp_Whmcs_Sync/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Wp_Whmcs_Sync
 * @subpackage Wp_Whmcs_Sync/includes
 * @author     Designingmedia <http://designingmedia.com>
 */
class Wp_Whmcs_Sync_Activator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function activate() {
		if(!wp_next_scheduled( 'whmcs_sync_service_reminders' )){
			wp_schedule_event( time(), 'daily', 'whmcs_sync_service_reminders' );
		}
	}

}
