<?php
namespace AIOSEO\Plugin\Extend\NewsSitemap;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Handles our sitemaps.
 *
 * @since 1.0.0
 */
class Sitemap {
	/**
	 * Class constructor.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
		add_action( 'wp_loaded', function() {
			if ( ! isset( aioseo()->sitemap ) ) {
				return;
			}

			aioseo()->sitemap->addAddon( 'news', [
				'sitemap' => $this,
				'content' => aioseoNewsSitemap()->content,
				'output'  => aioseoNewsSitemap()->output,
				'rewrite' => aioseoNewsSitemap()->rewrite,
				'helpers' => aioseoNewsSitemap()->helpers,
			]);
		} );
	}

	/**
	 * Adds our sitemap params to the query vars whitelist.
	 *
	 * @since 1.0.0
	 *
	 * @param  array $params The array of whitelisted query variable names.
	 * @return array $params The filtered array of whitelisted query variable names.
	 */
	public function addWhitelistParams( $params ) {
		return $params;
	}

	/**
	 * Checks if static file should be served and generates it if it doesn't exist.
	 *
	 * This essentially acts as a safety net in case a file doesn't exist yet or has been deleted.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function doesFileExist() {
		return;
	}

	/**
	 * Determines the current sitemap context.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function determineContext() {
		$indexName = apply_filters( 'aioseo_news_sitemap_index_name', 'news' );
		if ( aioseo()->sitemap->indexName === $indexName ) {
			aioseo()->sitemap->indexName = 'news';
			aioseo()->sitemap->type      = 'news';
			return;
		}
	}

	/**
	 * Returns the sitemap stylesheet.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function xsl() {
		$requestUrl  = ! empty( $_SERVER['REQUEST_URI'] ) ? $_SERVER['REQUEST_URI'] : '';
		$requestPath = wp_parse_url( $requestUrl, PHP_URL_PATH );

		if ( ! empty( $requestPath ) && preg_match( '#(/news\.xsl)$#i', $requestPath ) ) {
			aioseo()->sitemap->headers();
			$charset     = get_option( 'blog_charset' );
			$sitemapUrl  = wp_get_referer();
			$sitemapPath = trim( wp_parse_url( $sitemapUrl, PHP_URL_PATH ), '/' );

			// phpcs:disable VariableAnalysis.CodeAnalysis.VariableAnalysis.UnusedVariable
			$parameters    = aioseo()->helpers->getParametersFromUrl( $sitemapUrl );
			$linksPerIndex = aioseo()->options->sitemap->general->linksPerIndex;
			$xslParams     = aioseo()->cache->get( 'aioseo_sitemap_' . $sitemapPath );
			// phpcs:enable VariableAnalysis.CodeAnalysis.VariableAnalysis.UnusedVariable

			echo '<?xml version="1.0" encoding="' . esc_attr( $charset ) . '"?>';
			include_once( AIOSEO_NEWS_SITEMAP_DIR . '/app/Views/xsl/news.php' );
			exit();
		}
	}
}