<?php

/*=======================================================
*    Register Post type
* =======================================================*/

if ( ! function_exists('htslider_register_custom_post') ) {
    
    function htslider_register_custom_post() {
    
        // Register Header Post type
        $labels = array(
            'name'                  => _x( 'اسلایدر', 'Post Type General Name'),
            'singular_name'         => _x( 'اسلایدر', 'Post Type Singular Name'),
            'menu_name'             => esc_html__( 'اسلایدر'),
            'name_admin_bar'        => esc_html__( 'اسلایدر'),
            'archives'              => esc_html__( 'آرشیو'),
            'parent_item_colon'     => esc_html__( 'اصلی'),
            'all_items'             => esc_html__( 'همه اسلایدر ها'),
            'add_new_item'          => esc_html__( 'افزودن اسلایدر'),
            'add_new'               => esc_html__( ' افزونه اسلایدر'),
            'new_item'              => esc_html__( 'افزودن جدید'),
            'edit_item'             => esc_html__( 'ویرایش'),
            'update_item'           => esc_html__( 'بروزرسانی'),
            'view_item'             => esc_html__( 'مشاهده'),
            'search_items'          => esc_html__( 'جستجو'),
            'not_found'             => esc_html__( 'یافت نشد.'),
            'not_found_in_trash'    => esc_html__( 'چیزی یافت نشد.'),
            'featured_image'        => esc_html__( 'تصویر شاخص'),
            'set_featured_image'    => esc_html__( 'انتخاب شاخص'),
            'remove_featured_image' => esc_html__( 'حذف تصویر'),
            'use_featured_image'    => esc_html__( 'استفاده از تصویر'),
            'insert_into_item'      => esc_html__( 'اضافه کردن'),
            'uploaded_to_this_item' => esc_html__( 'بروزرسانی'),
            'items_list'            => esc_html__( 'لیست آیتم ها'),
            'items_list_navigation' => esc_html__( 'ناوبری'),
            'filter_items_list'     => esc_html__( 'فیلتر'),
        );

        $args = array(
            'label'                 => esc_html__( 'Slider'),
            'labels'                => $labels,
            'supports'              => array( 'title', 'editor', 'elementor' ),
            'hierarchical'          => false,
            'public'                => false,
            'show_ui'               => true,
            'show_in_menu'          => 'htslider_page',
            'menu_position'         => 5,
            'menu_icon'             => 'dashicons-welcome-view-site',
            'show_in_admin_bar'     => true,
            'show_in_nav_menus'     => true,
            'can_export'            => true,
            'has_archive'           => false,       
            'exclude_from_search'   => false,
            'publicly_queryable'    => true,
            'rewrite'               => false,
            'capability_type'       => 'page',
        );

        register_post_type( 'htslider_slider', $args );    

    }
    add_action( 'init', 'htslider_register_custom_post', 0 );

}

/*=======================================================
*    Register Custom Taxonomy
* =======================================================*/

if(! function_exists('htslider_custom_taxonomy')){

    function htslider_custom_taxonomy(){
        $labels = array(
            'name'                       => _x( 'دسته بندی ', 'Taxonomy General Name'),
            'singular_name'              => _x( 'دسته بندی', 'Taxonomy Singular Name'),
            'menu_name'                  => esc_html__( 'دسته بندی اسلایدر'),
            'all_items'                  => esc_html__( 'همه دسته بندی ها'),
            'parent_item'                => esc_html__( 'آیتم اصلی'),
            'parent_item_colon'          => esc_html__( 'آیتم اصلی:'),
            'new_item_name'              => esc_html__( 'دسته بندی جدید'),
            'add_new_item'               => esc_html__( 'افزودن آیتم جدید'),
            'edit_item'                  => esc_html__( 'ویرایش'),
            'update_item'                => esc_html__( 'بروزرسانی'),
            'view_item'                  => esc_html__( 'مشاهده'),
            'separate_items_with_commas' => esc_html__( 'با کاما جدا کنید.'),
            'add_or_remove_items'        => esc_html__( 'افزودن یا حرف'),
            'choose_from_most_used'      => esc_html__( 'انتخاب از موارد استفاده شده'),
            'popular_items'              => esc_html__( 'آیتم های محبوب'),
            'search_items'               => esc_html__( 'جستجو'),
            'not_found'                  => esc_html__( 'یافت نشد.'),
            'no_terms'                   => esc_html__( 'یافت نشد'),
            'items_list'                 => esc_html__( 'لیست اسلاید'),
            'items_list_navigation'      => esc_html__( 'ناوبری لیست اسلاید'),
        );
        $args = array(
            'labels'                     => $labels,
            'hierarchical'               => true,
            'public'                     => true,
            'show_ui'                    => true,
            'show_admin_column'          => true,
            'show_in_nav_menus'          => true,
            'show_tagcloud'              => true,
        );
        register_taxonomy( 'htslider_category', array( 'htslider_slider' ), $args );

    }

    add_action( 'init', 'htslider_custom_taxonomy', 0 );

}