<?php

namespace WPBULKY\Includes;

defined( 'ABSPATH' ) || exit;

class Support {

	protected static $instance = null;

	public function __construct() {
		add_action( 'plugins_loaded', [ $this, 'admin_init' ] );
	}

	public static function instance() {
		return self::$instance == null ? self::$instance = new self : self::$instance;
	}

	public function admin_init() {
		$this->check_update();
		$this->support();
	}

	public function support() {
		if ( ! class_exists( 'VillaTheme_Support_Pro' ) ) {
			include_once WPBULKY_CONST['plugin_dir'] . 'support/support.php';
		}
		new \VillaTheme_Support_Pro(
			array(
				'support'   => 'https://villatheme.com/supports/forum/plugins/wpbulky-wordpress-bulk-edit-post-types',
				'docs'      => 'http://docs.villatheme.com/?item=wpbulky-wordpress-bulk-edit-post-types',
				'review'    => 'https://codecanyon.net/downloads',
				'css'       => WPBULKY_CONST['dist_url'],
				'image'     => WPBULKY_CONST['img_url'],
				'slug'      => WPBULKY_CONST['slug'],
				'menu_slug' => 'vi_wpbulky_settings',
				'version'   => WPBULKY_CONST['version']
			)
		);
	}

	public function check_update() {
		if ( ! class_exists( 'VillaTheme_Plugin_Check_Update' ) ) {
			include_once WPBULKY_CONST['plugin_dir'] . 'support/check_update.php';
		}

		if ( ! class_exists( 'VillaTheme_Plugin_Updater' ) ) {
			include_once WPBULKY_CONST['plugin_dir'] . 'support/update.php';
		}

		$setting_url = admin_url( 'admin.php?page=vi_wpbulky_settings#/update' );
		$key         = get_option( 'vi_wpbulky_auto_update_key' );

		new \VillaTheme_Plugin_Check_Update (
			WPBULKY_CONST['version'],                    // current version
			'https://villatheme.com/wp-json/downloads/v3',  // update path
			WPBULKY_CONST['basename'],                  // plugin file slug
			WPBULKY_CONST['full_slug'],
			WPBULKY_CONST['auto_update_id'],
			$key,
			$setting_url
		);

		new \VillaTheme_Plugin_Updater( WPBULKY_CONST['basename'], 'woocommerce-bulk-edit', $setting_url );
	}
}