<?php
/**
 * Plugin Name: WPBulky - WordPress Bulk Edit Post Types Premium
 * Plugin URI: https://villatheme.com/extensions/wpbulky-wordpress-bulk-edit-post-types/
 * Description: WPBulky-WordPress Bulk Edit Post Types is a helpful tool that allows you to work with post types in bulk. The plugin supports sufficient tools to edit post types like posts, pages, media ….
 * Version: 1.1.6
 * Author: نوین وردپرس
 * Author URI: wpnovin.com
 * Text Domain: wpbulky
 * Domain Path: /languages
 * Copyright 2021 VillaTheme.com. All rights reserved.
 * Requires at least: 5.0
 * Tested up to: 5.8
 * Requires PHP: 7.0
 **/

use WPBULKY\Admin\Admin;
use WPBULKY\Admin\Ajax;
use WPBULKY\Admin\Editor;
use WPBULKY\Admin\History;
use WPBULKY\Includes\Data;
use WPBULKY\Includes\Enqueue;
use WPBULKY\Includes\Support;

defined( 'ABSPATH' ) || exit;

if ( is_file( plugin_dir_path( __FILE__ ) . 'autoload.php' ) ) {
	require_once plugin_dir_path( __FILE__ ) . 'autoload.php';
}

class WPBulky_Edit_Post_Types {
	public $plugin_name = 'WPBulky';

	public $version = '1.1.6';

	public $conditional = '';

	protected static $instance = null;

	public function __construct() {
		$this->define();

		if ( ! ( $this->conditional = $this->check_conditional() ) ) {
			$this->load_class();
			add_filter( 'plugin_action_links_' . WPBULKY_CONST['basename'], [ $this, 'setting_link' ] );
			add_action( 'init', [ $this, 'load_text_domain' ] );
		}

		add_action( 'admin_notices', [ $this, 'admin_notices' ] );

		register_activation_hook( __FILE__, [ $this, 'active' ] );
	}

	public static function instance() {
		return self::$instance == null ? self::$instance = new self : self::$instance;
	}

	public function define() {
		if ( ! defined( 'WPBULKY_CONST' ) ) {
			define( 'WPBULKY_CONST', [
				'version'        => $this->version,
				'slug'           => 'wpbulky',
				'full_slug'      => 'wpbulky-wordpress-bulk-edit-post-types',
				'assets_slug'    => 'wpbulky-wordpress-bulk-edit-post-types-',
				'file'           => __FILE__,
				'basename'       => plugin_basename( __FILE__ ),
				'plugin_dir'     => plugin_dir_path( __FILE__ ),
				'includes_dir'   => plugin_dir_path( __FILE__ ) . 'includes' . DIRECTORY_SEPARATOR,
				'admin_dir'      => plugin_dir_path( __FILE__ ) . 'admin' . DIRECTORY_SEPARATOR,
				'dist_dir'       => plugin_dir_path( __FILE__ ) . 'assets' . DIRECTORY_SEPARATOR . 'dist' . DIRECTORY_SEPARATOR,
				'dist_url'       => plugins_url( 'assets/dist/', __FILE__ ),
				'libs_url'       => plugins_url( 'assets/libs/', __FILE__ ),
				'img_url'        => plugins_url( 'assets/img/', __FILE__ ),
				'capability'     => 'edit_posts',
				'codecanyon_id'  => 34105857,
				'auto_update_id' => 102858,
			] );
		}
	}

	public function admin_notices() {
		if ( ! $this->conditional ) {
			return;
		}
		foreach ( $this->conditional as $message ) {
			echo sprintf( "<div id='message' class='error'><p>%s</p></div>", esc_html( $message ) );
		}
	}

	public function setting_link( $links ) {
		$settings_link = [ sprintf( "<a href='%1s' >%2s</a>", esc_url( admin_url( 'admin.php?page=vi_wpbulky_settings' ) ), esc_html__( 'Settings', 'wpbulky' ) ) ];

		return array_merge( $settings_link, $links );
	}

	public function check_conditional() {
		$message = [];
		if ( ! version_compare( phpversion(), '7.0', '>=' ) ) {
			$message[] = $this->plugin_name . ' ' . esc_html__( 'require PHP version at least 7.0', 'wpbulky' );
		}

		global $wp_version;
		if ( ! version_compare( $wp_version, '5.0', '>=' ) ) {
			$message[] = $this->plugin_name . ' ' . esc_html__( 'require WordPress version at least 5.0', 'wpbulky' );
		}

		return $message;
	}

	public function load_class() {

		if ( ! function_exists( 'WPBulky_Data' ) ) {
			function WPBulky_Data() {
				return Data::instance();
			}
		}

		if ( is_admin() ) {
			Enqueue::instance();
			Admin::instance();
			Editor::instance();
			Support::instance();
			Ajax::instance();
		}
	}

	public function load_text_domain() {
		$locale = determine_locale();
		$locale = apply_filters( 'plugin_locale', $locale, 'wpbulky' );

		unload_textdomain( 'wpbulky' );
		load_textdomain( 'wpbulky', WP_LANG_DIR . '/wpbulky-wordpress-bulk-edit-post-types/wpbulky-wordpress-bulk-edit-post-types-' . $locale . '.mo' );
		load_plugin_textdomain( 'wpbulky', false, plugin_basename( dirname( WPBULKY_CONST['file'] ) ) . '/languages' );
	}

	public function active( $network_wide ) {
		global $wpdb;
		$history = History::instance();
		if ( function_exists( 'is_multisite' ) && is_multisite() && $network_wide ) {
			$current_blog = $wpdb->blogid;
			$blogs        = $wpdb->get_col( "SELECT blog_id FROM {$wpdb->blogs}" );
			foreach ( $blogs as $blog ) {
				switch_to_blog( $blog );
				$history->create_database_table();
			}
			switch_to_blog( $current_blog );
		} else {
			$history->create_database_table();
		}

		if ( ! get_option( 'wpbulky_params_setting' ) ) {
			$default_data = [ 'post_types' => [ 'post', 'page', 'attachment' ] ];
			update_option( 'wpbulky_params_setting', $default_data );
		}
	}

}

require 'novin-update/wpnovin-atuo-update.php';
$myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
	'http://dl3.wpnovin.com/Source/Plugins/wpbulky-wordpress-bulk-edit-post-types/SD4F45A5S6554.json',
	__FILE__,
	'wpbulky-wordpress-bulk-edit-post-types'
);


WPBulky_Edit_Post_Types::instance();

