/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-09-29 07:54:01 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=25894 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4797 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1016 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=149 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=107 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=149 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=307 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("1", "2", "comments_reactions", "wow");
INSERT INTO `wp_commentmeta` VALUES("2", "2", "_comments_reactions", "field_58bf3358a6b78");
INSERT INTO `wp_commentmeta` VALUES("3", "3", "_wxr_import_user", "2");
INSERT INTO `wp_commentmeta` VALUES("4", "4", "_wxr_import_user", "2");
INSERT INTO `wp_commentmeta` VALUES("5", "5", "comments_reactions", "love");
INSERT INTO `wp_commentmeta` VALUES("6", "5", "_comments_reactions", "field_58bf3358a6b78");
INSERT INTO `wp_commentmeta` VALUES("7", "6", "comments_reactions", "like");
INSERT INTO `wp_commentmeta` VALUES("8", "6", "_comments_reactions", "field_58bf3358a6b78");
INSERT INTO `wp_commentmeta` VALUES("9", "7", "comments_reactions", "like");
INSERT INTO `wp_commentmeta` VALUES("10", "7", "_comments_reactions", "field_58bf3358a6b78");
INSERT INTO `wp_commentmeta` VALUES("11", "7", "_wxr_import_user", "2");
INSERT INTO `wp_commentmeta` VALUES("12", "8", "comments_reactions", "love");
INSERT INTO `wp_commentmeta` VALUES("13", "8", "_comments_reactions", "field_58bf3358a6b78");
INSERT INTO `wp_commentmeta` VALUES("14", "9", "comments_reactions", "love");
INSERT INTO `wp_commentmeta` VALUES("15", "9", "_comments_reactions", "field_58bf3358a6b78");
INSERT INTO `wp_commentmeta` VALUES("16", "10", "comments_reactions", "like");
INSERT INTO `wp_commentmeta` VALUES("17", "10", "_comments_reactions", "field_58bf3358a6b78");
INSERT INTO `wp_commentmeta` VALUES("18", "11", "comments_reactions", "love");
INSERT INTO `wp_commentmeta` VALUES("19", "11", "_comments_reactions", "field_58bf3358a6b78");
INSERT INTO `wp_commentmeta` VALUES("20", "12", "comments_reactions", "love");
INSERT INTO `wp_commentmeta` VALUES("21", "12", "_comments_reactions", "field_58bf3358a6b78");
INSERT INTO `wp_commentmeta` VALUES("22", "13", "comments_reactions", "wow");
INSERT INTO `wp_commentmeta` VALUES("23", "13", "_comments_reactions", "field_58bf3358a6b78");
INSERT INTO `wp_commentmeta` VALUES("24", "14", "comments_reactions", "haha");
INSERT INTO `wp_commentmeta` VALUES("25", "14", "_comments_reactions", "field_58bf3358a6b78");
INSERT INTO `wp_commentmeta` VALUES("26", "15", "comments_reactions", "wow");
INSERT INTO `wp_commentmeta` VALUES("27", "15", "_comments_reactions", "field_58bf3358a6b78");
INSERT INTO `wp_commentmeta` VALUES("28", "16", "comments_reactions", "haha");
INSERT INTO `wp_commentmeta` VALUES("29", "16", "_comments_reactions", "field_58bf3358a6b78");
INSERT INTO `wp_commentmeta` VALUES("30", "16", "_wxr_import_user", "2");
INSERT INTO `wp_commentmeta` VALUES("31", "17", "comments_reactions", "love");
INSERT INTO `wp_commentmeta` VALUES("32", "17", "_comments_reactions", "field_58bf3358a6b78");
INSERT INTO `wp_commentmeta` VALUES("33", "18", "_wxr_import_user", "2");
INSERT INTO `wp_commentmeta` VALUES("34", "19", "comments_reactions", "sad");
INSERT INTO `wp_commentmeta` VALUES("35", "19", "_comments_reactions", "field_5c9bee01a519a");
INSERT INTO `wp_commentmeta` VALUES("36", "19", "_wp_trash_meta_status", "0");
INSERT INTO `wp_commentmeta` VALUES("37", "19", "_wp_trash_meta_time", "1727596199");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("2", "20", "داراب", "drea@aol.com", "", "46.99.23.167", "2017-04-18 15:41:35", "2017-04-18 12:11:35", "عالی بود", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("3", "37", "سینا", "support@kingthemes.net", "", "85.102.26.148", "2017-01-19 12:54:27", "2017-01-19 09:24:27", "آهنگ جذابی بود", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("4", "37", "شادی", "support@kingthemes.net", "", "85.102.26.148", "2017-01-19 12:55:27", "2017-01-19 09:25:27", "امتیاز زیادی نمیدم بهش", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("5", "74", "رضوانه", "rezzentertainment@gmail.com", "", "108.56.213.160", "2017-04-14 02:54:15", "2017-04-13 23:24:15", "خیلی دوسش دارم", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("6", "74", "پناهنده", "creativeshah2003@gmail.com", "", "59.94.204.83", "2017-04-15 15:43:41", "2017-04-15 12:13:41", "کیف کردم", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("7", "75", "شازده کوچولو", "support@kingthemes.net", "", "212.253.57.172", "2017-03-17 22:33:46", "2017-03-17 19:03:46", "واقعاً دمتون گرم", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("8", "75", "لئون", "leo00@hotmail.com", "", "85.97.216.227", "2017-03-18 17:50:04", "2017-03-18 14:20:04", "طراحیشو خیلی دوس داشتم", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("9", "75", "کامران", "itreview@ymail.com", "", "14.1.100.26", "2017-04-13 22:23:33", "2017-04-13 18:53:33", "خیلی خوب بود", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("10", "75", "کیومرث", "itreview@ymail.com", "", "14.1.100.26", "2017-04-13 22:30:00", "2017-04-13 19:00:00", "لایک داشت", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("11", "75", "تارا", "tester@gmail.com", "", "109.12.179.187", "2017-04-15 09:24:24", "2017-04-15 05:54:24", "عاشقشم", "0", "1", "", "comment", "10", "0");
INSERT INTO `wp_comments` VALUES("12", "75", "پرویز", "pait@msn.com", "", "82.114.76.253", "2017-04-15 14:54:28", "2017-04-15 11:24:28", "یه دونه ای به مولا", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("13", "75", "شاه فرهاد", "hgjhgjhjj@gmail.com", "http://howtrick.com", "119.30.32.143", "2017-04-15 17:32:36", "2017-04-15 14:02:36", "خیلی خوب بود", "0", "1", "", "comment", "10", "0");
INSERT INTO `wp_comments` VALUES("14", "75", "محمود خان", "mufc_devils_1878@yahoo.com", "", "104.218.173.192", "2017-04-15 19:51:45", "2017-04-15 16:21:45", "خیلی خنده دار بود", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("15", "75", "ایمان", "1234@ukr.net", "https://erom.pro", "31.193.87.154", "2017-04-22 13:59:11", "2017-04-22 10:29:11", "وای چه خفن", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("16", "82", "سلطان اکبرآباد", "support@kingthemes.net", "", "85.97.216.227", "2017-03-18 17:52:49", "2017-03-18 14:22:49", "هاهاها", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("17", "88", "زیبا", "test@mailer.com", "", "142.234.73.88", "2017-04-14 17:54:57", "2017-04-14 14:24:57", "من عاشق این انیمیشن هستم", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("18", "643", "دیبا زاهدی", "support@kingthemes.net", "", "88.228.198.117", "2017-01-17 14:47:48", "2017-01-17 11:17:48", "ای وای مث سرژیک بود", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("19", "807", "Tes688t", "test@gmail.com", "", "151.246.227.127", "2023-11-06 02:21:03", "2023-11-05 22:51:03", "Yes", "0", "spam", "Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Mobile Safari/537.36", "comment", "0", "5");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("7", "20220214_d982d8a7d984d8a8d988d8b1d8afd9", "bc003d560c0a429c1534_20240929075350", "22", "2024-09-29 07:54:01", "King", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-09-29 07:53:50\";s:7:\"Version\";s:6:\"1.5.11\";s:9:\"VersionWP\";s:5:\"6.6.2\";s:9:\"VersionDB\";s:7:\"10.11.9\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:7;s:4:\"Name\";s:39:\"20220214_d982d8a7d984d8a8d988d8b1d8afd9\";s:4:\"Hash\";s:35:\"bc003d560c0a429c1534_20240929075350\";s:8:\"NameHash\";s:75:\"20220214_d982d8a7d984d8a8d988d8b1d8afd9_bc003d560c0a429c1534_20240929075350\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"20220214_d982d8a7d984d8a8d988d8b1d8afd9_bc003d560c0a429c1534_20240929075350_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.5\";s:6:\"WPUser\";s:4:\"King\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:87:\"20220214_d982d8a7d984d8a8d988d8b1d8afd9_bc003d560c0a429c1534_20240929075350_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:37:\"/home/themeswpn/public_html/King/Main\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:698;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:5222;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-09-29 07:53:50\";s:7:\"Version\";s:6:\"1.5.11\";s:9:\"VersionWP\";s:5:\"6.6.2\";s:9:\"VersionDB\";s:7:\"10.11.9\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20220214_d982d8a7d984d8a8d988d8b1d8afd9\";s:4:\"Hash\";s:35:\"bc003d560c0a429c1534_20240929075350\";s:8:\"NameHash\";s:75:\"20220214_d982d8a7d984d8a8d988d8b1d8afd9_bc003d560c0a429c1534_20240929075350\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:93:\"20220214_d982d8a7d984d8a8d988d8b1d8afd9_bc003d560c0a429c1534_20240929075350_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:51:\"/home/themeswpn/public_html/King/Main/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:88:\"20220214_d982d8a7d984d8a8d988d8b1d8afd9_bc003d560c0a429c1534_20240929075350_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:158:\"/home/themeswpn/public_html/King/Main/wp-content/backups-dup-lite/tmp/20220214_d982d8a7d984d8a8d988d8b1d8afd9_bc003d560c0a429c1534_20240929075350_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:46:\"/home/themeswpn/public_html/King/Main/wp-admin\";i:1;s:49:\"/home/themeswpn/public_html/King/Main/wp-includes\";i:2;s:58:\"/home/themeswpn/public_html/King/Main/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:37:\"/home/themeswpn/public_html/King/Main\";i:1;s:37:\"/home/themeswpn/public_html/King/Main\";i:2;s:48:\"/home/themeswpn/public_html/King/Main/wp-content\";i:3;s:56:\"/home/themeswpn/public_html/King/Main/wp-content/uploads\";i:4;s:56:\"/home/themeswpn/public_html/King/Main/wp-content/plugins\";i:5;s:59:\"/home/themeswpn/public_html/King/Main/wp-content/mu-plugins\";i:6;s:55:\"/home/themeswpn/public_html/King/Main/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:69:\"/home/themeswpn/public_html/King/Main/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://themes.wpnovin.com/King/Main", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://themes.wpnovin.com/King/Main", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "قالب وردپرس خبری کینگ | دموی اصلی", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "یک سایت دیگر با وردپرس فارسی", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "1", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "wpnovin.ir@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:209:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:7:\"list/?$\";s:24:\"index.php?post_type=list\";s:37:\"list/feed/(feed|rdf|rss|rss2|atom)/?$\";s:41:\"index.php?post_type=list&feed=$matches[1]\";s:32:\"list/(feed|rdf|rss|rss2|atom)/?$\";s:41:\"index.php?post_type=list&feed=$matches[1]\";s:24:\"list/page/([0-9]{1,})/?$\";s:42:\"index.php?post_type=list&paged=$matches[1]\";s:7:\"poll/?$\";s:24:\"index.php?post_type=poll\";s:37:\"poll/feed/(feed|rdf|rss|rss2|atom)/?$\";s:41:\"index.php?post_type=poll&feed=$matches[1]\";s:32:\"poll/(feed|rdf|rss|rss2|atom)/?$\";s:41:\"index.php?post_type=poll&feed=$matches[1]\";s:24:\"poll/page/([0-9]{1,})/?$\";s:42:\"index.php?post_type=poll&paged=$matches[1]\";s:9:\"trivia/?$\";s:26:\"index.php?post_type=trivia\";s:39:\"trivia/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=trivia&feed=$matches[1]\";s:34:\"trivia/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=trivia&feed=$matches[1]\";s:26:\"trivia/page/([0-9]{1,})/?$\";s:44:\"index.php?post_type=trivia&paged=$matches[1]\";s:10:\"stories/?$\";s:27:\"index.php?post_type=stories\";s:40:\"stories/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=stories&feed=$matches[1]\";s:35:\"stories/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=stories&feed=$matches[1]\";s:27:\"stories/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=stories&paged=$matches[1]\";s:18:\"^profile/settings?\";s:22:\"index.php?bpsettings=1\";s:18:\"^profile/([^/]*)/?\";s:44:\"index.php?bpaccount=1&profile_id=$matches[1]\";s:10:\"^profile/?\";s:21:\"index.php?bpaccount=1\";s:16:\"^likes/([^/]*)/?\";s:41:\"index.php?bplike=1&profile_id=$matches[1]\";s:8:\"^likes/?\";s:18:\"index.php?bplike=1\";s:20:\"^followers/([^/]*)/?\";s:45:\"index.php?bpfollower=1&profile_id=$matches[1]\";s:12:\"^followers/?\";s:22:\"index.php?bpfollower=1\";s:20:\"^following/([^/]*)/?\";s:46:\"index.php?bpfollowing=1&profile_id=$matches[1]\";s:12:\"^following/?\";s:23:\"index.php?bpfollowing=1\";s:12:\"^dashboard/?\";s:23:\"index.php?bpdashboard=1\";s:18:\"^prvtmsg/([^/]*)/?\";s:44:\"index.php?bpprvtmsg=1&profile_id=$matches[1]\";s:10:\"^prvtmsg/?\";s:21:\"index.php?bpprvtmsg=1\";s:8:\"^login/?\";s:19:\"index.php?bplogin=1\";s:11:\"^register/?\";s:22:\"index.php?bpregister=1\";s:8:\"^reset/?\";s:19:\"index.php?bpreset=1\";s:22:\"^submit-post/([^/]*)/?\";s:40:\"index.php?bpsnews=1&template=$matches[1]\";s:14:\"^submit-post/?\";s:19:\"index.php?bpsnews=1\";s:15:\"^submit-video/?\";s:20:\"index.php?bpsvideo=1\";s:15:\"^submit-audio/?\";s:20:\"index.php?bpsaudio=1\";s:15:\"^submit-image/?\";s:20:\"index.php?bpsimage=1\";s:8:\"^updte/?\";s:19:\"index.php?bpupdte=1\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:32:\"list/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"list/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"list/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"list/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"list/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"list/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"list/([^/]+)/embed/?$\";s:37:\"index.php?list=$matches[1]&embed=true\";s:25:\"list/([^/]+)/trackback/?$\";s:31:\"index.php?list=$matches[1]&tb=1\";s:45:\"list/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?list=$matches[1]&feed=$matches[2]\";s:40:\"list/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?list=$matches[1]&feed=$matches[2]\";s:33:\"list/([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?list=$matches[1]&paged=$matches[2]\";s:40:\"list/([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?list=$matches[1]&cpage=$matches[2]\";s:27:\"list/([^/]+)/amp(/(.*))?/?$\";s:42:\"index.php?list=$matches[1]&amp=$matches[3]\";s:29:\"list/([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?list=$matches[1]&page=$matches[2]\";s:21:\"list/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:31:\"list/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:51:\"list/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"list/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"list/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:27:\"list/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"poll/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"poll/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"poll/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"poll/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"poll/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"poll/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"poll/([^/]+)/embed/?$\";s:37:\"index.php?poll=$matches[1]&embed=true\";s:25:\"poll/([^/]+)/trackback/?$\";s:31:\"index.php?poll=$matches[1]&tb=1\";s:45:\"poll/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?poll=$matches[1]&feed=$matches[2]\";s:40:\"poll/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?poll=$matches[1]&feed=$matches[2]\";s:33:\"poll/([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?poll=$matches[1]&paged=$matches[2]\";s:40:\"poll/([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?poll=$matches[1]&cpage=$matches[2]\";s:27:\"poll/([^/]+)/amp(/(.*))?/?$\";s:42:\"index.php?poll=$matches[1]&amp=$matches[3]\";s:29:\"poll/([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?poll=$matches[1]&page=$matches[2]\";s:21:\"poll/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:31:\"poll/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:51:\"poll/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"poll/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"poll/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:27:\"poll/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"trivia/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"trivia/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"trivia/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"trivia/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"trivia/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"trivia/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"trivia/([^/]+)/embed/?$\";s:39:\"index.php?trivia=$matches[1]&embed=true\";s:27:\"trivia/([^/]+)/trackback/?$\";s:33:\"index.php?trivia=$matches[1]&tb=1\";s:47:\"trivia/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?trivia=$matches[1]&feed=$matches[2]\";s:42:\"trivia/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?trivia=$matches[1]&feed=$matches[2]\";s:35:\"trivia/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?trivia=$matches[1]&paged=$matches[2]\";s:42:\"trivia/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?trivia=$matches[1]&cpage=$matches[2]\";s:29:\"trivia/([^/]+)/amp(/(.*))?/?$\";s:44:\"index.php?trivia=$matches[1]&amp=$matches[3]\";s:31:\"trivia/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?trivia=$matches[1]&page=$matches[2]\";s:23:\"trivia/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"trivia/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"trivia/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"trivia/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"trivia/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"trivia/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"stories/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"stories/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"stories/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"stories/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"stories/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"stories/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"stories/([^/]+)/embed/?$\";s:40:\"index.php?stories=$matches[1]&embed=true\";s:28:\"stories/([^/]+)/trackback/?$\";s:34:\"index.php?stories=$matches[1]&tb=1\";s:48:\"stories/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?stories=$matches[1]&feed=$matches[2]\";s:43:\"stories/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?stories=$matches[1]&feed=$matches[2]\";s:36:\"stories/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?stories=$matches[1]&paged=$matches[2]\";s:43:\"stories/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?stories=$matches[1]&cpage=$matches[2]\";s:30:\"stories/([^/]+)/amp(/(.*))?/?$\";s:45:\"index.php?stories=$matches[1]&amp=$matches[3]\";s:32:\"stories/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?stories=$matches[1]&page=$matches[2]\";s:24:\"stories/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"stories/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"stories/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"stories/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"stories/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"stories/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:22:\"([^/]+)/amp(/(.*))?/?$\";s:42:\"index.php?name=$matches[1]&amp=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:10:{i:0;s:29:\"Novin-Fonts/font-uploader.php\";i:1;s:34:\"advanced-custom-fields-pro/acf.php\";i:2;s:33:\"classic-editor/classic-editor.php\";i:3;s:35:\"classic-widgets/classic-widgets.php\";i:4;s:25:\"duplicator/duplicator.php\";i:5;s:31:\"envato-market/envato-market.php\";i:6;s:47:\"one-click-demo-import/one-click-demo-import.php\";i:7;s:45:\"upload-max-file-size/upload-max-file-size.php\";i:8;s:53:\"widget-importer-exporter/widget-importer-exporter.php\";i:9;s:29:\"wp-parsidate/wp-parsidate.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wp_options` VALUES("40", "template", "king", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "king", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "57155", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "0", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "posts", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "Asia/Tehran", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "0", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1657753089", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("99", "initial_db_version", "49752", "yes");
INSERT INTO `wp_options` VALUES("100", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:62:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:19:\"download_subscribes\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("101", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("102", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_block", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "sidebars_widgets", "a:8:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:1:{i:0;s:11:\"hot-posts-5\";}s:9:\"sidebar-2\";a:1:{i:0;s:11:\"hot-posts-4\";}s:24:\"first-footer-widget-area\";a:1:{i:0;s:17:\"commented-posts-2\";}s:25:\"second-footer-widget-area\";a:1:{i:0;s:14:\"recent-posts-2\";}s:24:\"third-footer-widget-area\";a:1:{i:0;s:16:\"trending-posts-2\";}s:25:\"fourth-footer-widget-area\";a:1:{i:0;s:10:\"nav_menu-2\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("105", "cron", "a:13:{i:1727596689;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1727607489;a:2:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1727608092;a:1:{s:33:\"puc_cron_check_updates_theme-king\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1727630542;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1727650689;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1727650694;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1727650695;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1727692200;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1727755822;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1727851926;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1728153134;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1728169089;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("116", "widget_nav_menu", "a:2:{i:2;a:2:{s:5:\"title\";s:21:\"دسترسی سریع\";s:8:\"nav_menu\";i:145;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("117", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("119", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("120", "theme_mods_twentytwentyone", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1644756589;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "no");
INSERT INTO `wp_options` VALUES("121", "https_detection_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("148", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("154", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("159", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:20:\"wpnovin.ir@gmail.com\";s:7:\"version\";s:3:\"6.6\";s:9:\"timestamp\";i:1721152646;}", "no");
INSERT INTO `wp_options` VALUES("164", "_transient_health-check-site-status-result", "{\"good\":18,\"recommended\":4,\"critical\":1}", "yes");
INSERT INTO `wp_options` VALUES("184", "current_theme", "King", "yes");
INSERT INTO `wp_options` VALUES("185", "theme_mods_twentytwentytwo", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1644756591;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "no");
INSERT INTO `wp_options` VALUES("186", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("188", "theme_mods_king", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:3:{s:7:\"primary\";i:141;s:11:\"header-menu\";i:138;s:10:\"header-nav\";i:138;}s:18:\"custom_css_post_id\";i:865;}", "yes");
INSERT INTO `wp_options` VALUES("190", "envato_market", "a:2:{s:16:\"is_plugin_active\";s:1:\"1\";s:17:\"installed_version\";s:5:\"2.0.6\";}", "yes");
INSERT INTO `wp_options` VALUES("191", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("192", "envato_market_state", "activated", "yes");
INSERT INTO `wp_options` VALUES("193", "acf_version", "6.3.6", "yes");
INSERT INTO `wp_options` VALUES("196", "wp_calendar_block_has_published_posts", "1", "yes");
INSERT INTO `wp_options` VALUES("199", "_options_1st_reaction", "field_58cb0048d7754", "no");
INSERT INTO `wp_options` VALUES("200", "_options_1st_reaction_text", "field_58cb01a1d809a", "no");
INSERT INTO `wp_options` VALUES("201", "_options_2nd_reaction", "field_58cb038c97f33", "no");
INSERT INTO `wp_options` VALUES("202", "_options_2nd_reaction_text", "field_58cb03ef97f38", "no");
INSERT INTO `wp_options` VALUES("203", "_options_3rd_reaction", "field_58cb03a897f34", "no");
INSERT INTO `wp_options` VALUES("204", "_options_3rd_reaction_text", "field_58cb040e97f39", "no");
INSERT INTO `wp_options` VALUES("205", "_options_4th_reaction", "field_58cb03b597f35", "no");
INSERT INTO `wp_options` VALUES("206", "_options_4th_reaction_text", "field_58cb042397f3a", "no");
INSERT INTO `wp_options` VALUES("207", "_options_5th_reaction", "field_58cb03c897f36", "no");
INSERT INTO `wp_options` VALUES("208", "_options_5th_reaction_text", "field_58cb043e97f3b", "no");
INSERT INTO `wp_options` VALUES("209", "_options_6th_reaction", "field_58cb03d597f37", "no");
INSERT INTO `wp_options` VALUES("210", "_options_6th_reaction_text", "field_58cb044b97f3c", "no");
INSERT INTO `wp_options` VALUES("211", "_options_ad_in_footer", "field_5807cf3989999", "no");
INSERT INTO `wp_options` VALUES("212", "_options_ad_main_area_top", "field_5807cd1840d8e", "no");
INSERT INTO `wp_options` VALUES("213", "_options_add_new_links_to_header", "field_59921f85f694a", "no");
INSERT INTO `wp_options` VALUES("214", "_options_ads_above_content", "field_58811d947aac1", "no");
INSERT INTO `wp_options` VALUES("215", "_options_ads_below_content", "field_58811eb07aac2", "no");
INSERT INTO `wp_options` VALUES("216", "_options_alert_background_color", "field_5ea6ec9e0eb97", "no");
INSERT INTO `wp_options` VALUES("217", "_options_alert_text_color", "field_5ea6ecd50eb98", "no");
INSERT INTO `wp_options` VALUES("218", "_options_allow_users_to_delete_their_posts", "field_5a61000ecc234", "no");
INSERT INTO `wp_options` VALUES("219", "_options_allowed_emails", "field_5b4135b865288", "no");
INSERT INTO `wp_options` VALUES("220", "_options_allowed_emails_0_allowed_email", "field_5b41360b65289", "no");
INSERT INTO `wp_options` VALUES("221", "_options_allowed_emails_1_allowed_email", "field_5b41360b65289", "no");
INSERT INTO `wp_options` VALUES("222", "_options_allowed_emails_2_allowed_email", "field_5b41360b65289", "no");
INSERT INTO `wp_options` VALUES("223", "_options_allowed_emails_3_allowed_email", "field_5b41360b65289", "no");
INSERT INTO `wp_options` VALUES("224", "_options_archive_page_sidebar_template", "field_5e6ce648bd117", "no");
INSERT INTO `wp_options` VALUES("225", "_options_body_background", "field_57c895309a899", "no");
INSERT INTO `wp_options` VALUES("226", "_options_border_radius_of_grid_posts", "field_5ed7e4aa59193", "no");
INSERT INTO `wp_options` VALUES("227", "_options_button_colors", "field_58729141f3c04", "no");
INSERT INTO `wp_options` VALUES("228", "_options_button_text_color", "field_5872921c0b902", "no");
INSERT INTO `wp_options` VALUES("229", "_options_color_for_images", "field_57fc103b316d5", "no");
INSERT INTO `wp_options` VALUES("230", "_options_color_for_music", "field_5ef4eb809f545", "no");
INSERT INTO `wp_options` VALUES("231", "_options_color_for_news", "field_57fc0fe5cbf75", "no");
INSERT INTO `wp_options` VALUES("232", "_options_color_for_nsfw", "field_58890c43f6bdc", "no");
INSERT INTO `wp_options` VALUES("233", "_options_color_for_videos", "field_57fc1018316d4", "no");
INSERT INTO `wp_options` VALUES("234", "_options_comment_box_background", "field_587294b7dea0e", "no");
INSERT INTO `wp_options` VALUES("235", "_options_comment_box_text_color", "field_587294e3dea0f", "no");
INSERT INTO `wp_options` VALUES("236", "_options_comment_form_background", "field_5872984de6632", "no");
INSERT INTO `wp_options` VALUES("237", "_options_comment_form_text_color", "field_58729871e6633", "no");
INSERT INTO `wp_options` VALUES("238", "_options_comments_area_background_color", "field_58729467dea0d", "no");
INSERT INTO `wp_options` VALUES("239", "_options_comments_reply_button_background", "field_58729749cc217", "no");
INSERT INTO `wp_options` VALUES("240", "_options_comments_reply_button_value_color", "field_5872978acc218", "no");
INSERT INTO `wp_options` VALUES("241", "_options_cookie_button_text", "field_5f7744eea710f", "no");
INSERT INTO `wp_options` VALUES("242", "_options_cookie_popup_content", "field_5f7744a9a710e", "no");
INSERT INTO `wp_options` VALUES("243", "_options_custom_css", "field_584b14e35892f", "no");
INSERT INTO `wp_options` VALUES("244", "_options_custom_html_head", "field_5850544aeba32", "no");
INSERT INTO `wp_options` VALUES("245", "_options_custom_message_image", "field_585057d5c9b45", "no");
INSERT INTO `wp_options` VALUES("246", "_options_custom_message_login", "field_585057a5c9b42", "no");
INSERT INTO `wp_options` VALUES("247", "_options_custom_message_news", "field_585057afc9b43", "no");
INSERT INTO `wp_options` VALUES("248", "_options_custom_message_register", "field_58505770c9b41", "no");
INSERT INTO `wp_options` VALUES("249", "_options_custom_message_video", "field_585057c7c9b44", "no");
INSERT INTO `wp_options` VALUES("250", "_options_default_avatar", "field_5962a60ced4f8", "no");
INSERT INTO `wp_options` VALUES("251", "_options_default_cover", "field_5962a9f8d8a5c", "no");
INSERT INTO `wp_options` VALUES("252", "_options_disable_creating_playlist", "field_5eefcef17a29a", "no");
INSERT INTO `wp_options` VALUES("253", "_options_disable_custom_css", "field_584b139267219", "no");
INSERT INTO `wp_options` VALUES("254", "_options_disable_image", "field_585059b6c4ed6", "no");
INSERT INTO `wp_options` VALUES("255", "_options_disable_music", "field_5eef51b56ab0b", "no");
INSERT INTO `wp_options` VALUES("256", "_options_disable_news", "field_5850597dc4ed4", "no");
INSERT INTO `wp_options` VALUES("257", "_options_disable_post_moderation", "field_5cea9bea2aa64", "no");
INSERT INTO `wp_options` VALUES("258", "_options_disable_users_submit", "field_5850595bc4ed3", "no");
INSERT INTO `wp_options` VALUES("259", "_options_disable_video", "field_585059a0c4ed5", "no");
INSERT INTO `wp_options` VALUES("260", "_options_disable_video_and_mp3_upload", "field_590ba0bcfa337", "no");
INSERT INTO `wp_options` VALUES("261", "_options_display_editors_choice_note", "field_5c9bd5afa48b7", "no");
INSERT INTO `wp_options` VALUES("262", "_options_display_linkedin_share_button", "field_58867cab5820c", "no");
INSERT INTO `wp_options` VALUES("263", "_options_display_mini_slider", "field_5ec949ddf486d", "no");
INSERT INTO `wp_options` VALUES("264", "_options_display_pinterest_share_button", "field_58867cc25820d", "no");
INSERT INTO `wp_options` VALUES("265", "_options_display_reactions_block", "field_58caff85cd44e", "no");
INSERT INTO `wp_options` VALUES("266", "_options_display_related", "field_5863f1ac660a2", "no");
INSERT INTO `wp_options` VALUES("267", "_options_display_related_posts_by", "field_5866a29d8136d", "no");
INSERT INTO `wp_options` VALUES("268", "_options_display_slider", "field_5ec94b505a36d", "no");
INSERT INTO `wp_options` VALUES("269", "_options_display_thumblr_share_button", "field_58867c7f5820b", "no");
INSERT INTO `wp_options` VALUES("270", "_options_display_vk_share_button", "field_58867cd65820e", "no");
INSERT INTO `wp_options` VALUES("271", "_options_display_wapp_share_button", "field_59025c9640fcd", "no");
INSERT INTO `wp_options` VALUES("272", "_options_display_who_liked", "field_586ea39dd21ec", "no");
INSERT INTO `wp_options` VALUES("273", "_options_editors_choice_badge_background", "field_5c9bd76567287", "no");
INSERT INTO `wp_options` VALUES("274", "_options_editors_choice_badge_text", "field_5c9bd78567288", "no");
INSERT INTO `wp_options` VALUES("275", "_options_editors_choice_default_text", "field_5c9bd62ea48b9", "no");
INSERT INTO `wp_options` VALUES("276", "_options_editors_choice_title", "field_5c9bd5dfa48b8", "no");
INSERT INTO `wp_options` VALUES("277", "_options_enable_ad_video", "field_57f5713fa06c8", "no");
INSERT INTO `wp_options` VALUES("278", "_options_enable_age_verification", "field_5ceaa10ab26af", "no");
INSERT INTO `wp_options` VALUES("279", "_options_enable_allowed_emails", "field_5b41358c65287", "no");
INSERT INTO `wp_options` VALUES("280", "_options_enable_amp", "field_5a3c373608c03", "no");
INSERT INTO `wp_options` VALUES("281", "_options_enable_bookmarks", "field_5f6f4d0f08a11", "no");
INSERT INTO `wp_options` VALUES("282", "_options_enable_category_follow", "field_5cf15178e5bee", "no");
INSERT INTO `wp_options` VALUES("283", "_options_enable_embed_code_adding", "field_59c9862afac51", "no");
INSERT INTO `wp_options` VALUES("284", "_options_enable_floating_video", "field_59c6e73fb5032", "no");
INSERT INTO `wp_options` VALUES("285", "_options_enable_gdpr_cookie", "field_5f77448da710d", "no");
INSERT INTO `wp_options` VALUES("286", "_options_enable_grid_view", "field_5850552203a19", "no");
INSERT INTO `wp_options` VALUES("287", "_options_enable_headerstrip", "field_5f73250316b5b", "no");
INSERT INTO `wp_options` VALUES("288", "_options_enable_leaderboard_badges", "field_5a5682dbc9aa0", "no");
INSERT INTO `wp_options` VALUES("289", "_options_enable_lightbox_ad", "field_5eb5bbe5f6fd2", "no");
INSERT INTO `wp_options` VALUES("290", "_options_enable_lightbox_gallery", "field_5eb5a80b9380e", "no");
INSERT INTO `wp_options` VALUES("291", "_options_enable_live_search", "field_5e592cc9d2207", "no");
INSERT INTO `wp_options` VALUES("292", "_options_enable_live_user_search", "field_5e59312f8d5e7", "no");
INSERT INTO `wp_options` VALUES("293", "_options_enable_meta_tags", "field_58b04f09f9f53", "no");
INSERT INTO `wp_options` VALUES("294", "_options_enable_newsletter_popup", "field_5f88599405af7", "no");
INSERT INTO `wp_options` VALUES("295", "_options_enable_night_mode", "field_5c9ba55568bf6", "no");
INSERT INTO `wp_options` VALUES("296", "_options_enable_notification", "field_5ceac98602971", "no");
INSERT INTO `wp_options` VALUES("297", "_options_enable_nsfw_for_images", "field_58599193f287a", "no");
INSERT INTO `wp_options` VALUES("298", "_options_enable_nsfw_for_news", "field_58599151f2878", "no");
INSERT INTO `wp_options` VALUES("299", "_options_enable_nsfw_for_videos", "field_58599184f2879", "no");
INSERT INTO `wp_options` VALUES("300", "_options_enable_post_edit", "field_597901fe706fc", "no");
INSERT INTO `wp_options` VALUES("301", "_options_enable_private_messages", "field_591cc88deaabc", "no");
INSERT INTO `wp_options` VALUES("302", "_options_enable_reactions", "field_58caff4ccd44d", "no");
INSERT INTO `wp_options` VALUES("303", "_options_enable_reactions_without_comments", "field_5a5e5a964ea35", "no");
INSERT INTO `wp_options` VALUES("304", "_options_enable_rtl", "field_597bbe9f58b70", "no");
INSERT INTO `wp_options` VALUES("305", "_options_enable_save_posts", "field_5c9ba7100c467", "no");
INSERT INTO `wp_options` VALUES("306", "_options_enable_sticky_ad", "field_5807c89983906", "no");
INSERT INTO `wp_options` VALUES("307", "_options_enable_tag_follow", "field_5cf151e3e5bef", "no");
INSERT INTO `wp_options` VALUES("308", "_options_enable_terms_and_conditions", "field_58505c1d656ae", "no");
INSERT INTO `wp_options` VALUES("309", "_options_enable_text_translation", "field_5cf2b41025dfe", "no");
INSERT INTO `wp_options` VALUES("310", "_options_enable_user_badges", "field_5a53c0da450b0", "no");
INSERT INTO `wp_options` VALUES("311", "_options_enable_user_groups", "field_5e83b43e385ce", "no");
INSERT INTO `wp_options` VALUES("312", "_options_enable_user_points", "field_5a5e62c52c195", "no");
INSERT INTO `wp_options` VALUES("313", "_options_facebook_access_token", "field_5945ad8eec21b", "no");
INSERT INTO `wp_options` VALUES("314", "_options_facebook_share_app_id", "field_58866cb0459fe", "no");
INSERT INTO `wp_options` VALUES("315", "_options_facebook_share_description", "field_58617b1055b45", "no");
INSERT INTO `wp_options` VALUES("316", "_options_facebook_share_secret_key", "field_58866d8945a00", "no");
INSERT INTO `wp_options` VALUES("317", "_options_facebook_user_access_token", "field_5a27076c77513", "no");
INSERT INTO `wp_options` VALUES("318", "_options_fatfooter_background", "field_5805375a5b9a4", "no");
INSERT INTO `wp_options` VALUES("319", "_options_follow_button_background", "field_5c9bd6e067283", "no");
INSERT INTO `wp_options` VALUES("320", "_options_follow_button_text_color", "field_5c9bd71167285", "no");
INSERT INTO `wp_options` VALUES("321", "_options_footer_background", "field_5805368749bfe", "no");
INSERT INTO `wp_options` VALUES("322", "_options_footer_copyright", "field_5850565bd3af0", "no");
INSERT INTO `wp_options` VALUES("323", "_options_footer_custom_link", "field_585056e7d3af5", "no");
INSERT INTO `wp_options` VALUES("324", "_options_footer_facebook_link", "field_58505697d3af1", "no");
INSERT INTO `wp_options` VALUES("325", "_options_footer_google_link", "field_585056d6d3af4", "no");
INSERT INTO `wp_options` VALUES("326", "_options_footer_link_color", "field_580539b0b8510", "no");
INSERT INTO `wp_options` VALUES("327", "_options_footer_linkedin_link", "field_585056b0d3af2", "no");
INSERT INTO `wp_options` VALUES("328", "_options_footer_text_color", "field_580538640ac50", "no");
INSERT INTO `wp_options` VALUES("329", "_options_footer_twitter_link", "field_585056c3d3af3", "no");
INSERT INTO `wp_options` VALUES("330", "_options_footer_widgets_title_background", "field_58067be4a3470", "no");
INSERT INTO `wp_options` VALUES("331", "_options_footer_widgets_title_color", "field_58067c33c8cda", "no");
INSERT INTO `wp_options` VALUES("332", "_options_for_image_link", "field_5f7f403c31e59", "no");
INSERT INTO `wp_options` VALUES("333", "_options_for_image_link_for_image", "field_5f7f403c31e5a", "no");
INSERT INTO `wp_options` VALUES("334", "_options_for_music_link", "field_5f7f423737191", "no");
INSERT INTO `wp_options` VALUES("335", "_options_for_music_link_for_music", "field_5f7f423737192", "no");
INSERT INTO `wp_options` VALUES("336", "_options_for_news_link", "field_5f7f39ca32e76", "no");
INSERT INTO `wp_options` VALUES("337", "_options_for_news_link_for_news", "field_5f7f3ce893e52", "no");
INSERT INTO `wp_options` VALUES("338", "_options_for_news_link_links_in_mega_menu", "field_5f7f3e33d0bca", "no");
INSERT INTO `wp_options` VALUES("339", "_options_for_news_link_links_in_mega_menu_0_mega_menu_link_text", "field_5f7f3f6fd0bcb", "no");
INSERT INTO `wp_options` VALUES("340", "_options_for_news_link_links_in_mega_menu_0_mega_menu_link_url", "field_5f7f3f9cd0bcc", "no");
INSERT INTO `wp_options` VALUES("341", "_options_for_news_link_links_in_mega_menu_1_mega_menu_link_text", "field_5f7f3f6fd0bcb", "no");
INSERT INTO `wp_options` VALUES("342", "_options_for_news_link_links_in_mega_menu_1_mega_menu_link_url", "field_5f7f3f9cd0bcc", "no");
INSERT INTO `wp_options` VALUES("343", "_options_for_news_link_links_in_mega_menu_2_mega_menu_link_text", "field_5f7f3f6fd0bcb", "no");
INSERT INTO `wp_options` VALUES("344", "_options_for_news_link_links_in_mega_menu_2_mega_menu_link_url", "field_5f7f3f9cd0bcc", "no");
INSERT INTO `wp_options` VALUES("345", "_options_for_news_link_links_in_mega_menu_3_mega_menu_link_text", "field_5f7f3f6fd0bcb", "no");
INSERT INTO `wp_options` VALUES("346", "_options_for_news_link_links_in_mega_menu_3_mega_menu_link_url", "field_5f7f3f9cd0bcc", "no");
INSERT INTO `wp_options` VALUES("347", "_options_for_news_link_mpost_number", "field_5f82f74ba9456", "no");
INSERT INTO `wp_options` VALUES("348", "_options_for_news_link_show_in_mega_menu", "field_5f7f3d8180484", "no");
INSERT INTO `wp_options` VALUES("349", "_options_for_video_link", "field_5f7f4080e9145", "no");
INSERT INTO `wp_options` VALUES("350", "_options_for_video_link_for_video", "field_5f7f4080e9146", "no");
INSERT INTO `wp_options` VALUES("351", "_options_for_video_link_links_in_mega_menu", "field_5f7f4080e9148", "no");
INSERT INTO `wp_options` VALUES("352", "_options_for_video_link_links_in_mega_menu_0_mega_menu_link_text", "field_5f7f4080e9149", "no");
INSERT INTO `wp_options` VALUES("353", "_options_for_video_link_links_in_mega_menu_0_mega_menu_link_url", "field_5f7f4080e914a", "no");
INSERT INTO `wp_options` VALUES("354", "_options_for_video_link_links_in_mega_menu_1_mega_menu_link_text", "field_5f7f4080e9149", "no");
INSERT INTO `wp_options` VALUES("355", "_options_for_video_link_links_in_mega_menu_1_mega_menu_link_url", "field_5f7f4080e914a", "no");
INSERT INTO `wp_options` VALUES("356", "_options_for_video_link_links_in_mega_menu_2_mega_menu_link_text", "field_5f7f4080e9149", "no");
INSERT INTO `wp_options` VALUES("357", "_options_for_video_link_links_in_mega_menu_2_mega_menu_link_url", "field_5f7f4080e914a", "no");
INSERT INTO `wp_options` VALUES("358", "_options_for_video_link_links_in_mega_menu_3_mega_menu_link_text", "field_5f7f4080e9149", "no");
INSERT INTO `wp_options` VALUES("359", "_options_for_video_link_links_in_mega_menu_3_mega_menu_link_url", "field_5f7f4080e914a", "no");
INSERT INTO `wp_options` VALUES("360", "_options_for_video_link_mpost_number", "field_5f82f8695f624", "no");
INSERT INTO `wp_options` VALUES("361", "_options_for_video_link_show_in_mega_menu", "field_5f7f4080e9147", "no");
INSERT INTO `wp_options` VALUES("362", "_options_gallery_background", "field_5eb6dfac3b094", "no");
INSERT INTO `wp_options` VALUES("363", "_options_gallery_layout", "field_5eadb0f9e9e3c", "no");
INSERT INTO `wp_options` VALUES("364", "_options_gallery_text_color", "field_5eb6e037ec85a", "no");
INSERT INTO `wp_options` VALUES("365", "_options_get_a_follower", "field_5a5e631d2c197", "no");
INSERT INTO `wp_options` VALUES("366", "_options_google_fonts", "field_57f6b8674af4c", "no");
INSERT INTO `wp_options` VALUES("367", "_options_grid_height", "field_5ec94c68998ff", "no");
INSERT INTO `wp_options` VALUES("368", "_options_groups_create_posts", "field_5e83c6c67829c", "no");
INSERT INTO `wp_options` VALUES("369", "_options_groups_create_posts_without_approval", "field_5e84bcb207b30", "no");
INSERT INTO `wp_options` VALUES("370", "_options_groups_edit_their_own_posts", "field_5e84bec25347b", "no");
INSERT INTO `wp_options` VALUES("371", "_options_groups_view_posts", "field_5e8e0884d1346", "no");
INSERT INTO `wp_options` VALUES("372", "_options_groups_write_comments", "field_5e922736085be", "no");
INSERT INTO `wp_options` VALUES("373", "_options_header_08_options", "field_5ee1260bb71fa", "no");
INSERT INTO `wp_options` VALUES("374", "_options_header_08_options_bottom_icons", "field_5ee1260bb71fe", "no");
INSERT INTO `wp_options` VALUES("375", "_options_header_08_options_font_color", "field_5ee1260bb71fd", "no");
INSERT INTO `wp_options` VALUES("376", "_options_header_background", "field_57c88ed8fba47", "no");
INSERT INTO `wp_options` VALUES("377", "_options_header_link_color", "field_57fc093cc31f2", "no");
INSERT INTO `wp_options` VALUES("378", "_options_header_menu_background_color", "field_5c9bd7e05e57c", "no");
INSERT INTO `wp_options` VALUES("379", "_options_header_menu_columns", "field_5c9bd485e2c13", "no");
INSERT INTO `wp_options` VALUES("380", "_options_header_menu_layout", "field_5c9bd420e2c12", "no");
INSERT INTO `wp_options` VALUES("381", "_options_header_menu_link_colors", "field_5c9bd7f55e57d", "no");
INSERT INTO `wp_options` VALUES("382", "_options_header_menu_link_hover_colors", "field_5c9bd80b5e57e", "no");
INSERT INTO `wp_options` VALUES("383", "_options_header_search_background", "field_57fc0a2cc9b37", "no");
INSERT INTO `wp_options` VALUES("384", "_options_header_templates", "field_5e28626d0b645", "no");
INSERT INTO `wp_options` VALUES("385", "_options_headerstrip_background", "field_5f75fee9e1b1a", "no");
INSERT INTO `wp_options` VALUES("386", "_options_headerstrip_button_color", "field_5f75ff18e1b1c", "no");
INSERT INTO `wp_options` VALUES("387", "_options_headerstrip_button_text", "field_5f732669abb00", "no");
INSERT INTO `wp_options` VALUES("388", "_options_headerstrip_button_url", "field_5f7326b3abb01", "no");
INSERT INTO `wp_options` VALUES("389", "_options_headerstrip_text", "field_5f7325f5abaff", "no");
INSERT INTO `wp_options` VALUES("390", "_options_headerstrip_text_color", "field_5f75ff0ae1b1b", "no");
INSERT INTO `wp_options` VALUES("391", "_options_hide_author_about_text", "field_586eae6583078", "no");
INSERT INTO `wp_options` VALUES("392", "_options_hide_author_social_links", "field_5a132ee5ed76f", "no");
INSERT INTO `wp_options` VALUES("393", "_options_hide_categories", "field_60bf964f1bfd2", "no");
INSERT INTO `wp_options` VALUES("394", "_options_hide_image_Link", "field_58669857eaaaa", "no");
INSERT INTO `wp_options` VALUES("395", "_options_hide_music_Link", "field_5eef50b10e24a", "no");
INSERT INTO `wp_options` VALUES("396", "_options_hide_news_Link", "field_586697d3eaaa8", "no");
INSERT INTO `wp_options` VALUES("397", "_options_hide_post_author_box", "field_586eae2d83077", "no");
INSERT INTO `wp_options` VALUES("398", "_options_hide_video_Link", "field_58669823eaaa9", "no");
INSERT INTO `wp_options` VALUES("399", "_options_hs_expired_time", "field_5f7603c969a9a", "no");
INSERT INTO `wp_options` VALUES("400", "_options_image_posts_templates", "field_5d4ee1104a59a", "no");
INSERT INTO `wp_options` VALUES("401", "_options_items_length", "field_5ec94d74086c3", "no");
INSERT INTO `wp_options` VALUES("402", "_options_king_badges", "field_5a53c1327f005", "no");
INSERT INTO `wp_options` VALUES("403", "_options_king_badges_0_badge_description", "field_5a55de08a3581", "no");
INSERT INTO `wp_options` VALUES("404", "_options_king_badges_0_badge_icon", "field_5a55de08a357d", "no");
INSERT INTO `wp_options` VALUES("405", "_options_king_badges_0_badge_max_point", "field_5a55de08a357f", "no");
INSERT INTO `wp_options` VALUES("406", "_options_king_badges_0_badge_min_point", "field_5a55de08a357e", "no");
INSERT INTO `wp_options` VALUES("407", "_options_king_badges_0_badge_title", "field_5a55de08a3580", "no");
INSERT INTO `wp_options` VALUES("408", "_options_king_badges_1_badge_description", "field_5a5469ee905b9", "no");
INSERT INTO `wp_options` VALUES("409", "_options_king_badges_1_badge_icon", "field_5a53c2c77f008", "no");
INSERT INTO `wp_options` VALUES("410", "_options_king_badges_1_badge_max_point", "field_5a55dc50522c9", "no");
INSERT INTO `wp_options` VALUES("411", "_options_king_badges_1_badge_min_point", "field_5a53c26b7f007", "no");
INSERT INTO `wp_options` VALUES("412", "_options_king_badges_1_badge_title", "field_5a53c21c7f006", "no");
INSERT INTO `wp_options` VALUES("413", "_options_king_badges_10_badge_description", "field_5a55ddd9a3575", "no");
INSERT INTO `wp_options` VALUES("414", "_options_king_badges_10_badge_icon", "field_5a55ddd9a3571", "no");
INSERT INTO `wp_options` VALUES("415", "_options_king_badges_10_badge_max_point", "field_5a55ddd9a3573", "no");
INSERT INTO `wp_options` VALUES("416", "_options_king_badges_10_badge_min_point", "field_5a55ddd9a3572", "no");
INSERT INTO `wp_options` VALUES("417", "_options_king_badges_10_badge_title", "field_5a55ddd9a3574", "no");
INSERT INTO `wp_options` VALUES("418", "_options_king_badges_2_badge_description", "field_5a5469ee905b9", "no");
INSERT INTO `wp_options` VALUES("419", "_options_king_badges_2_badge_icon", "field_5a53c2c77f008", "no");
INSERT INTO `wp_options` VALUES("420", "_options_king_badges_2_badge_max_point", "field_5a55dc50522c9", "no");
INSERT INTO `wp_options` VALUES("421", "_options_king_badges_2_badge_min_point", "field_5a53c26b7f007", "no");
INSERT INTO `wp_options` VALUES("422", "_options_king_badges_2_badge_title", "field_5a53c21c7f006", "no");
INSERT INTO `wp_options` VALUES("423", "_options_king_badges_3_badge_description", "field_5a5469ee905b9", "no");
INSERT INTO `wp_options` VALUES("424", "_options_king_badges_3_badge_icon", "field_5a53c2c77f008", "no");
INSERT INTO `wp_options` VALUES("425", "_options_king_badges_3_badge_max_point", "field_5a55dc50522c9", "no");
INSERT INTO `wp_options` VALUES("426", "_options_king_badges_3_badge_min_point", "field_5a53c26b7f007", "no");
INSERT INTO `wp_options` VALUES("427", "_options_king_badges_3_badge_title", "field_5a53c21c7f006", "no");
INSERT INTO `wp_options` VALUES("428", "_options_king_badges_4_badge_description", "field_5a55ddc8a356f", "no");
INSERT INTO `wp_options` VALUES("429", "_options_king_badges_4_badge_icon", "field_5a55ddc8a356b", "no");
INSERT INTO `wp_options` VALUES("430", "_options_king_badges_4_badge_max_point", "field_5a55ddc8a356d", "no");
INSERT INTO `wp_options` VALUES("431", "_options_king_badges_4_badge_min_point", "field_5a55ddc8a356c", "no");
INSERT INTO `wp_options` VALUES("432", "_options_king_badges_4_badge_title", "field_5a55ddc8a356e", "no");
INSERT INTO `wp_options` VALUES("433", "_options_king_badges_5_badge_description", "field_5a55ddeca357b", "no");
INSERT INTO `wp_options` VALUES("434", "_options_king_badges_5_badge_icon", "field_5a55ddeca3577", "no");
INSERT INTO `wp_options` VALUES("435", "_options_king_badges_5_badge_max_point", "field_5a55ddeca3579", "no");
INSERT INTO `wp_options` VALUES("436", "_options_king_badges_5_badge_min_point", "field_5a55ddeca3578", "no");
INSERT INTO `wp_options` VALUES("437", "_options_king_badges_5_badge_title", "field_5a55ddeca357a", "no");
INSERT INTO `wp_options` VALUES("438", "_options_king_badges_6_badge_description", "field_5a55ddeca357b", "no");
INSERT INTO `wp_options` VALUES("439", "_options_king_badges_6_badge_icon", "field_5a55ddeca3577", "no");
INSERT INTO `wp_options` VALUES("440", "_options_king_badges_6_badge_max_point", "field_5a55ddeca3579", "no");
INSERT INTO `wp_options` VALUES("441", "_options_king_badges_6_badge_min_point", "field_5a55ddeca3578", "no");
INSERT INTO `wp_options` VALUES("442", "_options_king_badges_6_badge_title", "field_5a55ddeca357a", "no");
INSERT INTO `wp_options` VALUES("443", "_options_king_badges_7_badge_description", "field_5a55ddeca357b", "no");
INSERT INTO `wp_options` VALUES("444", "_options_king_badges_7_badge_icon", "field_5a55ddeca3577", "no");
INSERT INTO `wp_options` VALUES("445", "_options_king_badges_7_badge_max_point", "field_5a55ddeca3579", "no");
INSERT INTO `wp_options` VALUES("446", "_options_king_badges_7_badge_min_point", "field_5a55ddeca3578", "no");
INSERT INTO `wp_options` VALUES("447", "_options_king_badges_7_badge_title", "field_5a55ddeca357a", "no");
INSERT INTO `wp_options` VALUES("448", "_options_king_badges_8_badge_description", "field_5a55ddd9a3575", "no");
INSERT INTO `wp_options` VALUES("449", "_options_king_badges_8_badge_icon", "field_5a55ddd9a3571", "no");
INSERT INTO `wp_options` VALUES("450", "_options_king_badges_8_badge_max_point", "field_5a55ddd9a3573", "no");
INSERT INTO `wp_options` VALUES("451", "_options_king_badges_8_badge_min_point", "field_5a55ddd9a3572", "no");
INSERT INTO `wp_options` VALUES("452", "_options_king_badges_8_badge_title", "field_5a55ddd9a3574", "no");
INSERT INTO `wp_options` VALUES("453", "_options_king_badges_9_badge_description", "field_5a55ddd9a3575", "no");
INSERT INTO `wp_options` VALUES("454", "_options_king_badges_9_badge_icon", "field_5a55ddd9a3571", "no");
INSERT INTO `wp_options` VALUES("455", "_options_king_badges_9_badge_max_point", "field_5a55ddd9a3573", "no");
INSERT INTO `wp_options` VALUES("456", "_options_king_badges_9_badge_min_point", "field_5a55ddd9a3572", "no");
INSERT INTO `wp_options` VALUES("457", "_options_king_badges_9_badge_title", "field_5a55ddd9a3574", "no");
INSERT INTO `wp_options` VALUES("458", "_options_length_hot", "field_57daf9b9334ca", "no");
INSERT INTO `wp_options` VALUES("459", "_options_length_nsfw", "field_57dafc37a5570", "no");
INSERT INTO `wp_options` VALUES("460", "_options_length_of_followers", "field_5814fc5ee9ded", "no");
INSERT INTO `wp_options` VALUES("461", "_options_length_of_following", "field_5814fc80e9dee", "no");
INSERT INTO `wp_options` VALUES("462", "_options_length_of_posts_in_profile", "field_58150087dea82", "no");
INSERT INTO `wp_options` VALUES("463", "_options_length_of_users_dashboard", "field_5817b2fb6b637", "no");
INSERT INTO `wp_options` VALUES("464", "_options_length_of_users_liked_posts", "field_58150123c274f", "no");
INSERT INTO `wp_options` VALUES("465", "_options_length_reaction", "field_5903b3a8d050f", "no");
INSERT INTO `wp_options` VALUES("466", "_options_length_slider", "field_5ec94d3b086c2", "no");
INSERT INTO `wp_options` VALUES("467", "_options_length_trend", "field_57dafb25dd912", "no");
INSERT INTO `wp_options` VALUES("468", "_options_length_users", "field_57dafbcf93901", "no");
INSERT INTO `wp_options` VALUES("469", "_options_lightbox_gallery_ad_code", "field_5eb5bc46f6fd3", "no");
INSERT INTO `wp_options` VALUES("470", "_options_load_more_background", "field_586695b184cca", "no");
INSERT INTO `wp_options` VALUES("471", "_options_load_more_button_border", "field_5866963484ccc", "no");
INSERT INTO `wp_options` VALUES("472", "_options_load_more_button_show", "field_58dae233761cc", "no");
INSERT INTO `wp_options` VALUES("473", "_options_load_more_button_text_color", "field_5866961584ccb", "no");
INSERT INTO `wp_options` VALUES("474", "_options_login_and_register_buttons_background", "field_5a63b13792977", "no");
INSERT INTO `wp_options` VALUES("475", "_options_max_avatar_size", "field_58505a6fc4ed9", "no");
INSERT INTO `wp_options` VALUES("476", "_options_max_cover_size", "field_58505a95c4eda", "no");
INSERT INTO `wp_options` VALUES("477", "_options_max_file_u_size", "field_597bc29558c8a", "no");
INSERT INTO `wp_options` VALUES("478", "_options_maximum_content_length", "field_588fae418b17f", "no");
INSERT INTO `wp_options` VALUES("479", "_options_maximum_title_length", "field_588fa0d0c1508", "no");
INSERT INTO `wp_options` VALUES("480", "_options_mini_items_length", "field_5ec94adbb2b61", "no");
INSERT INTO `wp_options` VALUES("481", "_options_mini_slider_post_height", "field_5ec94a8808aa3", "no");
INSERT INTO `wp_options` VALUES("482", "_options_moderate_posts_edit", "field_597a5fb1fd83c", "no");
INSERT INTO `wp_options` VALUES("483", "_options_navigation_background", "field_57fc0857adad7", "no");
INSERT INTO `wp_options` VALUES("484", "_options_navigation_links", "field_5806928fde018", "no");
INSERT INTO `wp_options` VALUES("485", "_options_navigation_links_active", "field_59249bdd7dd76", "no");
INSERT INTO `wp_options` VALUES("486", "_options_newsletter_cover_image", "field_5f885da53139f", "no");
INSERT INTO `wp_options` VALUES("487", "_options_newsletter_delay_time", "field_5f885e49889da", "no");
INSERT INTO `wp_options` VALUES("488", "_options_newsletter_description", "field_5f885ccce1383", "no");
INSERT INTO `wp_options` VALUES("489", "_options_newsletter_expired", "field_5f885e08889d9", "no");
INSERT INTO `wp_options` VALUES("490", "_options_newsletter_submit_text", "field_5f8866ee8c9af", "no");
INSERT INTO `wp_options` VALUES("491", "_options_newsletter_title", "field_5f8859b805af8", "no");
INSERT INTO `wp_options` VALUES("492", "_options_night_mode_logo", "field_5c9ba5a868bf7", "no");
INSERT INTO `wp_options` VALUES("493", "_options_night_mode_mobile_logo", "field_5e4fba72e9cd5", "no");
INSERT INTO `wp_options` VALUES("494", "_options_notification_box_background", "field_5cfa38ae73f7c", "no");
INSERT INTO `wp_options` VALUES("495", "_options_notification_box_inside_background", "field_5cfa38d073f7d", "no");
INSERT INTO `wp_options` VALUES("496", "_options_notification_icon_background", "field_5cfa387973f7a", "no");
INSERT INTO `wp_options` VALUES("497", "_options_notification_icon_color", "field_5cfa389e73f7b", "no");
INSERT INTO `wp_options` VALUES("498", "_options_notifications_text_color", "field_5cfa391d73f7e", "no");
INSERT INTO `wp_options` VALUES("499", "_options_only_verified", "field_58505a0bc4ed7", "no");
INSERT INTO `wp_options` VALUES("500", "_options_padding_between_grid_posts", "field_5ed7e45c59192", "no");
INSERT INTO `wp_options` VALUES("501", "_options_page_header_background", "field_5887f35a63c63", "no");
INSERT INTO `wp_options` VALUES("502", "_options_page_header_text_color", "field_5887f44a63c64", "no");
INSERT INTO `wp_options` VALUES("503", "_options_page_link_color", "field_57fc0ca410dd7", "no");
INSERT INTO `wp_options` VALUES("504", "_options_page_link_hover_color", "field_57fc0ed8b5f65", "no");
INSERT INTO `wp_options` VALUES("505", "_options_pagination_type", "field_5e56a7618095d", "no");
INSERT INTO `wp_options` VALUES("506", "_options_post_author_box_background", "field_5815057b54404", "no");
INSERT INTO `wp_options` VALUES("507", "_options_post_author_box_text_color", "field_5815061995480", "no");
INSERT INTO `wp_options` VALUES("508", "_options_post_background", "field_5806785eb286e", "no");
INSERT INTO `wp_options` VALUES("509", "_options_post_column_numbers", "field_5ed91ec746105", "no");
INSERT INTO `wp_options` VALUES("510", "_options_post_content_background_color", "field_581502d4f0f0c", "no");
INSERT INTO `wp_options` VALUES("511", "_options_post_content_text_color", "field_581503a21d6cf", "no");
INSERT INTO `wp_options` VALUES("512", "_options_post_entry_content_color", "field_5887f64af5e57", "no");
INSERT INTO `wp_options` VALUES("513", "_options_post_like_button_background", "field_5872929b65c5d", "no");
INSERT INTO `wp_options` VALUES("514", "_options_post_like_button_icon_color", "field_587292da65c5e", "no");
INSERT INTO `wp_options` VALUES("515", "_options_post_meta_background", "field_58164a8408681", "no");
INSERT INTO `wp_options` VALUES("516", "_options_post_meta_text_color", "field_58164ab1495b7", "no");
INSERT INTO `wp_options` VALUES("517", "_options_post_page_boxes_background", "field_587bde52c5bfe", "no");
INSERT INTO `wp_options` VALUES("518", "_options_post_page_boxes_title_background", "field_587bde85c5bff", "no");
INSERT INTO `wp_options` VALUES("519", "_options_post_page_boxes_title_color", "field_58cc4e71fa23c", "no");
INSERT INTO `wp_options` VALUES("520", "_options_post_title_color", "field_5c9bd73367286", "no");
INSERT INTO `wp_options` VALUES("521", "_options_posting_a_comment", "field_5a5e632b2c198", "no");
INSERT INTO `wp_options` VALUES("522", "_options_posts_meta_background", "field_5863f58305007", "no");
INSERT INTO `wp_options` VALUES("523", "_options_posts_meta_color", "field_5863f5aa05008", "no");
INSERT INTO `wp_options` VALUES("524", "_options_privacy_text", "field_5f8863c48c9ae", "no");
INSERT INTO `wp_options` VALUES("525", "_options_reactions_title_in_comment_form", "field_58cb233146f1f", "no");
INSERT INTO `wp_options` VALUES("526", "_options_related_length", "field_5863f1d1660a3", "no");
INSERT INTO `wp_options` VALUES("527", "_options_related_posts_heading", "field_5866a171781a8", "no");
INSERT INTO `wp_options` VALUES("528", "_options_search_page_sidebar_template", "field_5e6ce738c1f60", "no");
INSERT INTO `wp_options` VALUES("529", "_options_search_v2_box_background", "field_5ecbc62dce687", "no");
INSERT INTO `wp_options` VALUES("530", "_options_search_v2_button_background", "field_5ecbc56daed99", "no");
INSERT INTO `wp_options` VALUES("531", "_options_search_v2_icon_color", "field_5ecbc591aed9a", "no");
INSERT INTO `wp_options` VALUES("532", "_options_search_v2_input_background", "field_5ecbc642ce688", "no");
INSERT INTO `wp_options` VALUES("533", "_options_select_default_display_option", "field_5e59662fbe87c", "no");
INSERT INTO `wp_options` VALUES("534", "_options_select_grid_template", "field_5ec94bf0e3e5c", "no");
INSERT INTO `wp_options` VALUES("535", "_options_share_bar_background", "field_581504dd3cb82", "no");
INSERT INTO `wp_options` VALUES("536", "_options_share_bar_buttons_background", "field_581648857a500", "no");
INSERT INTO `wp_options` VALUES("537", "_options_show_in_mini_slider", "field_5ec94a5f08aa2", "no");
INSERT INTO `wp_options` VALUES("538", "_options_show_only_logged_users", "field_5f75f3434aceb", "no");
INSERT INTO `wp_options` VALUES("539", "_options_show_slider", "field_5ec94b83e3e5a", "no");
INSERT INTO `wp_options` VALUES("540", "_options_show_user_results_in_search", "field_5e760eb00fbe2", "no");
INSERT INTO `wp_options` VALUES("541", "_options_sidebar_image_template", "field_5e6a7ffbdfd26", "no");
INSERT INTO `wp_options` VALUES("542", "_options_sidebar_links", "field_58067db0a81fc", "no");
INSERT INTO `wp_options` VALUES("543", "_options_sidebar_music_template", "field_5eef57821c57e", "no");
INSERT INTO `wp_options` VALUES("544", "_options_sidebar_news_template", "field_5e6a7db6977c0", "no");
INSERT INTO `wp_options` VALUES("545", "_options_sidebar_sticky_ad", "field_5807c8dd83907", "no");
INSERT INTO `wp_options` VALUES("546", "_options_sidebar_templates", "field_5e69104d459ec", "no");
INSERT INTO `wp_options` VALUES("547", "_options_sidebar_text_color", "field_58067de5a81fd", "no");
INSERT INTO `wp_options` VALUES("548", "_options_sidebar_video_template", "field_5e6a7f6f4b204", "no");
INSERT INTO `wp_options` VALUES("549", "_options_sidebar_widgets_post_meta_text_color", "field_5863f3a18f505", "no");
INSERT INTO `wp_options` VALUES("550", "_options_sidebar_widgets_title_background", "field_58067d4ca81fa", "no");
INSERT INTO `wp_options` VALUES("551", "_options_sidebar_widgets_title_color", "field_58067d92a81fb", "no");
INSERT INTO `wp_options` VALUES("552", "_options_single_post_templates", "field_5d4ee03c4a594", "no");
INSERT INTO `wp_options` VALUES("553", "_options_skip_ad_after", "field_57f576023b604", "no");
INSERT INTO `wp_options` VALUES("554", "_options_slider_height", "field_5ec94d0b086c1", "no");
INSERT INTO `wp_options` VALUES("555", "_options_slider_template", "field_5ec94e7246167", "no");
INSERT INTO `wp_options` VALUES("556", "_options_social_share_style", "field_5e8a0bcd4e8f8", "no");
INSERT INTO `wp_options` VALUES("557", "_options_submit_background", "field_58067a58ad696", "no");
INSERT INTO `wp_options` VALUES("558", "_options_submit_button_link_colors", "field_59249acf78b65", "no");
INSERT INTO `wp_options` VALUES("559", "_options_submiticon_color", "field_58067a95f2787", "no");
INSERT INTO `wp_options` VALUES("560", "_options_submitting_a_post", "field_5a5e62ef2c196", "no");
INSERT INTO `wp_options` VALUES("561", "_options_twitter_share_description", "field_58617f1602fc0", "no");
INSERT INTO `wp_options` VALUES("562", "_options_user_groups", "field_5e7376a3c9cad", "no");
INSERT INTO `wp_options` VALUES("563", "_options_user_groups_0_default_group_for_new_users", "field_5e7379b1cccd4", "no");
INSERT INTO `wp_options` VALUES("564", "_options_user_groups_0_group_color", "field_5e737766c9caf", "no");
INSERT INTO `wp_options` VALUES("565", "_options_user_groups_0_group_icon", "field_5e73778dc9cb0", "no");
INSERT INTO `wp_options` VALUES("566", "_options_user_groups_0_group_name", "field_5e73772dc9cae", "no");
INSERT INTO `wp_options` VALUES("567", "_options_user_groups_0_group_users", "field_5e865379a58e8", "no");
INSERT INTO `wp_options` VALUES("568", "_options_user_groups_1_default_group_for_new_users", "field_5e7379b1cccd4", "no");
INSERT INTO `wp_options` VALUES("569", "_options_user_groups_1_group_color", "field_5e737766c9caf", "no");
INSERT INTO `wp_options` VALUES("570", "_options_user_groups_1_group_icon", "field_5e73778dc9cb0", "no");
INSERT INTO `wp_options` VALUES("571", "_options_user_groups_1_group_name", "field_5e73772dc9cae", "no");
INSERT INTO `wp_options` VALUES("572", "_options_user_groups_1_group_users", "field_5e865379a58e8", "no");
INSERT INTO `wp_options` VALUES("573", "_options_user_groups_2_default_group_for_new_users", "field_5e7379b1cccd4", "no");
INSERT INTO `wp_options` VALUES("574", "_options_user_groups_2_group_color", "field_5e737766c9caf", "no");
INSERT INTO `wp_options` VALUES("575", "_options_user_groups_2_group_icon", "field_5e73778dc9cb0", "no");
INSERT INTO `wp_options` VALUES("576", "_options_user_groups_2_group_name", "field_5e73772dc9cae", "no");
INSERT INTO `wp_options` VALUES("577", "_options_user_groups_2_group_users", "field_5e865379a58e8", "no");
INSERT INTO `wp_options` VALUES("578", "_options_user_points_badge_background", "field_5945aa8244ab6", "no");
INSERT INTO `wp_options` VALUES("579", "_options_user_points_badge_color", "field_5945ab4244ab7", "no");
INSERT INTO `wp_options` VALUES("580", "_options_verified_edit_posts", "field_59790f60e1564", "no");
INSERT INTO `wp_options` VALUES("581", "_options_verified_posts", "field_58505a4ec4ed8", "no");
INSERT INTO `wp_options` VALUES("582", "_options_video_load_ad", "field_57f57171a06c9", "no");
INSERT INTO `wp_options` VALUES("583", "_options_video_posts_templates", "field_5d4ee0cf4a599", "no");
INSERT INTO `wp_options` VALUES("584", "options_1st_reaction", "", "no");
INSERT INTO `wp_options` VALUES("585", "options_1st_reaction_text", "عالی", "no");
INSERT INTO `wp_options` VALUES("586", "options_2nd_reaction", "", "no");
INSERT INTO `wp_options` VALUES("587", "options_2nd_reaction_text", "عشقه", "no");
INSERT INTO `wp_options` VALUES("588", "options_3rd_reaction", "", "no");
INSERT INTO `wp_options` VALUES("589", "options_3rd_reaction_text", "هاها", "no");
INSERT INTO `wp_options` VALUES("590", "options_4th_reaction", "", "no");
INSERT INTO `wp_options` VALUES("591", "options_4th_reaction_text", "چه با حال", "no");
INSERT INTO `wp_options` VALUES("592", "options_5th_reaction", "", "no");
INSERT INTO `wp_options` VALUES("593", "options_5th_reaction_text", "غمگین", "no");
INSERT INTO `wp_options` VALUES("594", "options_6th_reaction", "", "no");
INSERT INTO `wp_options` VALUES("595", "options_6th_reaction_text", "به درد نخور", "no");
INSERT INTO `wp_options` VALUES("596", "options_ad_in_footer", "<div class=\"ad-area\">محل تبلیغات شما</div>", "no");
INSERT INTO `wp_options` VALUES("597", "options_ad_main_area_top", "<div class=\"ad-area\">محل تبلیغات شما</div>", "no");
INSERT INTO `wp_options` VALUES("598", "options_add_new_links_to_header", "", "no");
INSERT INTO `wp_options` VALUES("599", "options_ads_above_content", "<div class=\"ad-area\">محل تبلیغات شما</div>", "no");
INSERT INTO `wp_options` VALUES("600", "options_ads_below_content", "<div class=\"ad-area\">محل تبلیغات شما</div>", "no");
INSERT INTO `wp_options` VALUES("601", "options_alert_background_color", "", "no");
INSERT INTO `wp_options` VALUES("602", "options_alert_text_color", "", "no");
INSERT INTO `wp_options` VALUES("603", "options_allow_users_to_delete_their_posts", "0", "no");
INSERT INTO `wp_options` VALUES("604", "options_allowed_emails", "4", "no");
INSERT INTO `wp_options` VALUES("605", "options_allowed_emails_0_allowed_email", "gmail.com", "no");
INSERT INTO `wp_options` VALUES("606", "options_allowed_emails_1_allowed_email", "hotmail.com", "no");
INSERT INTO `wp_options` VALUES("607", "options_allowed_emails_2_allowed_email", "yahoo.com", "no");
INSERT INTO `wp_options` VALUES("608", "options_allowed_emails_3_allowed_email", "outlook.com", "no");
INSERT INTO `wp_options` VALUES("609", "options_archive_page_sidebar_template", "king-sidebar-04", "no");
INSERT INTO `wp_options` VALUES("610", "options_body_background", "", "no");
INSERT INTO `wp_options` VALUES("611", "options_border_radius_of_grid_posts", "4", "no");
INSERT INTO `wp_options` VALUES("612", "options_button_colors", "", "no");
INSERT INTO `wp_options` VALUES("613", "options_button_text_color", "", "no");
INSERT INTO `wp_options` VALUES("614", "options_color_for_images", "", "no");
INSERT INTO `wp_options` VALUES("615", "options_color_for_music", "", "no");
INSERT INTO `wp_options` VALUES("616", "options_color_for_news", "", "no");
INSERT INTO `wp_options` VALUES("617", "options_color_for_nsfw", "", "no");
INSERT INTO `wp_options` VALUES("618", "options_color_for_videos", "", "no");
INSERT INTO `wp_options` VALUES("619", "options_comment_box_background", "", "no");
INSERT INTO `wp_options` VALUES("620", "options_comment_box_text_color", "", "no");
INSERT INTO `wp_options` VALUES("621", "options_comment_form_background", "", "no");
INSERT INTO `wp_options` VALUES("622", "options_comment_form_text_color", "", "no");
INSERT INTO `wp_options` VALUES("623", "options_comments_area_background_color", "", "no");
INSERT INTO `wp_options` VALUES("624", "options_comments_reply_button_background", "", "no");
INSERT INTO `wp_options` VALUES("625", "options_comments_reply_button_value_color", "", "no");
INSERT INTO `wp_options` VALUES("626", "options_cookie_button_text", "پذیرفتن", "no");
INSERT INTO `wp_options` VALUES("627", "options_cookie_popup_content", "این وبسایت از کوکی ها برای تجربه بهتر کاربر استفاده می کند: <a href=\"#\">قوانین کوکی ها</a>", "no");
INSERT INTO `wp_options` VALUES("628", "options_custom_css", ".ad-area {\r\n\r\nborder:2px dashed #ccd6dd;\r\nbackground-image: url(https://king.kingthemes.org/docs/imgs/headafter.png);\r\nbackground-repeat:repeat-y;\r\nbackground-position:15%;\r\npadding:30px;\r\nborder-radius:4px;\r\nfont-size:18px;\r\ntext-align:center;\r\n}\r\n.king-night .ad-area {\r\nborder-color:#303030;\r\n}\r\n.list-item-media .instagram-media {\r\n    height:700px !important;\r\n}", "no");
INSERT INTO `wp_options` VALUES("629", "options_custom_html_head", "", "no");
INSERT INTO `wp_options` VALUES("630", "options_custom_message_image", "", "no");
INSERT INTO `wp_options` VALUES("631", "options_custom_message_login", "<p>حساب تستی : </p>\r\n\r\nusername: kingtheme pass: kingtheme", "no");
INSERT INTO `wp_options` VALUES("632", "options_custom_message_news", "", "no");
INSERT INTO `wp_options` VALUES("633", "options_custom_message_register", "", "no");
INSERT INTO `wp_options` VALUES("634", "options_custom_message_video", "", "no");
INSERT INTO `wp_options` VALUES("635", "options_default_avatar", "", "no");
INSERT INTO `wp_options` VALUES("636", "options_default_cover", "", "no");
INSERT INTO `wp_options` VALUES("637", "options_disable_creating_playlist", "0", "no");
INSERT INTO `wp_options` VALUES("638", "options_disable_custom_css", "0", "no");
INSERT INTO `wp_options` VALUES("639", "options_disable_image", "0", "no");
INSERT INTO `wp_options` VALUES("640", "options_disable_music", "0", "no");
INSERT INTO `wp_options` VALUES("641", "options_disable_news", "0", "no");
INSERT INTO `wp_options` VALUES("642", "options_disable_post_moderation", "0", "no");
INSERT INTO `wp_options` VALUES("643", "options_disable_users_submit", "0", "no");
INSERT INTO `wp_options` VALUES("644", "options_disable_video", "0", "no");
INSERT INTO `wp_options` VALUES("645", "options_disable_video_and_mp3_upload", "0", "no");
INSERT INTO `wp_options` VALUES("646", "options_display_editors_choice_note", "1", "no");
INSERT INTO `wp_options` VALUES("647", "options_display_linkedin_share_button", "1", "no");
INSERT INTO `wp_options` VALUES("648", "options_display_mini_slider", "1", "no");
INSERT INTO `wp_options` VALUES("649", "options_display_pinterest_share_button", "1", "no");
INSERT INTO `wp_options` VALUES("650", "options_display_reactions_block", "1", "no");
INSERT INTO `wp_options` VALUES("651", "options_display_related", "1", "no");
INSERT INTO `wp_options` VALUES("652", "options_display_related_posts_by", "categories", "no");
INSERT INTO `wp_options` VALUES("653", "options_display_slider", "1", "no");
INSERT INTO `wp_options` VALUES("654", "options_display_thumblr_share_button", "1", "no");
INSERT INTO `wp_options` VALUES("655", "options_display_vk_share_button", "1", "no");
INSERT INTO `wp_options` VALUES("656", "options_display_wapp_share_button", "1", "no");
INSERT INTO `wp_options` VALUES("657", "options_display_who_liked", "0", "no");
INSERT INTO `wp_options` VALUES("658", "options_editors_choice_badge_background", "", "no");
INSERT INTO `wp_options` VALUES("659", "options_editors_choice_badge_text", "", "no");
INSERT INTO `wp_options` VALUES("660", "options_editors_choice_default_text", "", "no");
INSERT INTO `wp_options` VALUES("661", "options_editors_choice_title", "انتخاب نویسندگان", "no");
INSERT INTO `wp_options` VALUES("662", "options_enable_ad_video", "1", "no");
INSERT INTO `wp_options` VALUES("663", "options_enable_age_verification", "1", "no");
INSERT INTO `wp_options` VALUES("664", "options_enable_allowed_emails", "1", "no");
INSERT INTO `wp_options` VALUES("665", "options_enable_amp", "1", "no");
INSERT INTO `wp_options` VALUES("666", "options_enable_bookmarks", "1", "no");
INSERT INTO `wp_options` VALUES("667", "options_enable_category_follow", "1", "no");
INSERT INTO `wp_options` VALUES("668", "options_enable_embed_code_adding", "1", "no");
INSERT INTO `wp_options` VALUES("669", "options_enable_floating_video", "1", "no");
INSERT INTO `wp_options` VALUES("670", "options_enable_gdpr_cookie", "1", "no");
INSERT INTO `wp_options` VALUES("671", "options_enable_grid_view", "1", "no");
INSERT INTO `wp_options` VALUES("672", "options_enable_headerstrip", "1", "no");
INSERT INTO `wp_options` VALUES("673", "options_enable_leaderboard_badges", "0", "no");
INSERT INTO `wp_options` VALUES("674", "options_enable_lightbox_ad", "1", "no");
INSERT INTO `wp_options` VALUES("675", "options_enable_lightbox_gallery", "1", "no");
INSERT INTO `wp_options` VALUES("676", "options_enable_live_search", "1", "no");
INSERT INTO `wp_options` VALUES("677", "options_enable_live_user_search", "1", "no");
INSERT INTO `wp_options` VALUES("678", "options_enable_meta_tags", "1", "no");
INSERT INTO `wp_options` VALUES("679", "options_enable_newsletter_popup", "1", "no");
INSERT INTO `wp_options` VALUES("680", "options_enable_night_mode", "0", "no");
INSERT INTO `wp_options` VALUES("681", "options_enable_notification", "1", "no");
INSERT INTO `wp_options` VALUES("682", "options_enable_nsfw_for_images", "1", "no");
INSERT INTO `wp_options` VALUES("683", "options_enable_nsfw_for_news", "1", "no");
INSERT INTO `wp_options` VALUES("684", "options_enable_nsfw_for_videos", "1", "no");
INSERT INTO `wp_options` VALUES("685", "options_enable_post_edit", "1", "no");
INSERT INTO `wp_options` VALUES("686", "options_enable_private_messages", "1", "no");
INSERT INTO `wp_options` VALUES("687", "options_enable_reactions", "1", "no");
INSERT INTO `wp_options` VALUES("688", "options_enable_reactions_without_comments", "1", "no");
INSERT INTO `wp_options` VALUES("689", "options_enable_rtl", "1", "no");
INSERT INTO `wp_options` VALUES("690", "options_enable_save_posts", "1", "no");
INSERT INTO `wp_options` VALUES("691", "options_enable_sticky_ad", "1", "no");
INSERT INTO `wp_options` VALUES("692", "options_enable_tag_follow", "1", "no");
INSERT INTO `wp_options` VALUES("693", "options_enable_terms_and_conditions", "1", "no");
INSERT INTO `wp_options` VALUES("694", "options_enable_text_translation", "1", "no");
INSERT INTO `wp_options` VALUES("695", "options_enable_user_badges", "1", "no");
INSERT INTO `wp_options` VALUES("696", "options_enable_user_groups", "1", "no");
INSERT INTO `wp_options` VALUES("697", "options_enable_user_points", "1", "no");
INSERT INTO `wp_options` VALUES("698", "options_facebook_access_token", "497493024536079|8ZZp_3ZBEXLOyUpi9Aq7yf7b160", "no");
INSERT INTO `wp_options` VALUES("699", "options_facebook_share_app_id", "497493024536079", "no");
INSERT INTO `wp_options` VALUES("700", "options_facebook_share_description", "", "no");
INSERT INTO `wp_options` VALUES("701", "options_facebook_share_secret_key", "04f8d015e341741e64d0b7bf5ba59c51", "no");
INSERT INTO `wp_options` VALUES("702", "options_facebook_user_access_token", "", "no");
INSERT INTO `wp_options` VALUES("703", "options_fatfooter_background", "", "no");
INSERT INTO `wp_options` VALUES("704", "options_follow_button_background", "", "no");
INSERT INTO `wp_options` VALUES("705", "options_follow_button_text_color", "", "no");
INSERT INTO `wp_options` VALUES("706", "options_footer_background", "", "no");
INSERT INTO `wp_options` VALUES("707", "options_footer_copyright", "تمامی حقوق برای مدیر سایت محفوظ است. فارسی سازی توسط <a href=\"https://wpnovin.com/\">نوین وردپرس</a>", "no");
INSERT INTO `wp_options` VALUES("708", "options_footer_custom_link", "<li><a href=\"https://www.instagram.com/wpnovincom/\"><i class=\"fab fa-instagram\"></i></a></li>", "no");
INSERT INTO `wp_options` VALUES("709", "options_footer_facebook_link", "#", "no");
INSERT INTO `wp_options` VALUES("710", "options_footer_google_link", "", "no");
INSERT INTO `wp_options` VALUES("711", "options_footer_link_color", "", "no");
INSERT INTO `wp_options` VALUES("712", "options_footer_linkedin_link", "#", "no");
INSERT INTO `wp_options` VALUES("713", "options_footer_text_color", "", "no");
INSERT INTO `wp_options` VALUES("714", "options_footer_twitter_link", "#", "no");
INSERT INTO `wp_options` VALUES("715", "options_footer_widgets_title_background", "", "no");
INSERT INTO `wp_options` VALUES("716", "options_footer_widgets_title_color", "", "no");
INSERT INTO `wp_options` VALUES("717", "options_for_image_link", "", "no");
INSERT INTO `wp_options` VALUES("718", "options_for_image_link_for_image", "0", "no");
INSERT INTO `wp_options` VALUES("719", "options_for_music_link", "", "no");
INSERT INTO `wp_options` VALUES("720", "options_for_music_link_for_music", "0", "no");
INSERT INTO `wp_options` VALUES("721", "options_for_news_link", "", "no");
INSERT INTO `wp_options` VALUES("722", "options_for_news_link_for_news", "0", "no");
INSERT INTO `wp_options` VALUES("723", "options_for_news_link_links_in_mega_menu", "4", "no");
INSERT INTO `wp_options` VALUES("724", "options_for_news_link_links_in_mega_menu_0_mega_menu_link_text", "How to", "no");
INSERT INTO `wp_options` VALUES("725", "options_for_news_link_links_in_mega_menu_0_mega_menu_link_url", "https://king.kingthemes.org/", "no");
INSERT INTO `wp_options` VALUES("726", "options_for_news_link_links_in_mega_menu_1_mega_menu_link_text", "Internet", "no");
INSERT INTO `wp_options` VALUES("727", "options_for_news_link_links_in_mega_menu_1_mega_menu_link_url", "https://king.kingthemes.org/", "no");
INSERT INTO `wp_options` VALUES("728", "options_for_news_link_links_in_mega_menu_2_mega_menu_link_text", "Art", "no");
INSERT INTO `wp_options` VALUES("729", "options_for_news_link_links_in_mega_menu_2_mega_menu_link_url", "https://king.kingthemes.org/", "no");
INSERT INTO `wp_options` VALUES("730", "options_for_news_link_links_in_mega_menu_3_mega_menu_link_text", "News", "no");
INSERT INTO `wp_options` VALUES("731", "options_for_news_link_links_in_mega_menu_3_mega_menu_link_url", "https://king.kingthemes.org/", "no");
INSERT INTO `wp_options` VALUES("732", "options_for_news_link_mpost_number", "5", "no");
INSERT INTO `wp_options` VALUES("733", "options_for_news_link_show_in_mega_menu", "popular", "no");
INSERT INTO `wp_options` VALUES("734", "options_for_video_link", "", "no");
INSERT INTO `wp_options` VALUES("735", "options_for_video_link_for_video", "1", "no");
INSERT INTO `wp_options` VALUES("736", "options_for_video_link_links_in_mega_menu", "4", "no");
INSERT INTO `wp_options` VALUES("737", "options_for_video_link_links_in_mega_menu_0_mega_menu_link_text", "چطور", "no");
INSERT INTO `wp_options` VALUES("738", "options_for_video_link_links_in_mega_menu_0_mega_menu_link_url", "https://themes.wpnovin.com/King/Main", "no");
INSERT INTO `wp_options` VALUES("739", "options_for_video_link_links_in_mega_menu_1_mega_menu_link_text", "اینترنت", "no");
INSERT INTO `wp_options` VALUES("740", "options_for_video_link_links_in_mega_menu_1_mega_menu_link_url", "https://themes.wpnovin.com/King/Main", "no");
INSERT INTO `wp_options` VALUES("741", "options_for_video_link_links_in_mega_menu_2_mega_menu_link_text", "هنر", "no");
INSERT INTO `wp_options` VALUES("742", "options_for_video_link_links_in_mega_menu_2_mega_menu_link_url", "https://themes.wpnovin.com/King/Main", "no");
INSERT INTO `wp_options` VALUES("743", "options_for_video_link_links_in_mega_menu_3_mega_menu_link_text", "اخبار", "no");
INSERT INTO `wp_options` VALUES("744", "options_for_video_link_links_in_mega_menu_3_mega_menu_link_url", "https://themes.wpnovin.com/King/Main", "no");
INSERT INTO `wp_options` VALUES("745", "options_for_video_link_mpost_number", "5", "no");
INSERT INTO `wp_options` VALUES("746", "options_for_video_link_show_in_mega_menu", "popular", "no");
INSERT INTO `wp_options` VALUES("747", "options_gallery_background", "", "no");
INSERT INTO `wp_options` VALUES("748", "options_gallery_layout", "king-gallery-03", "no");
INSERT INTO `wp_options` VALUES("749", "options_gallery_text_color", "", "no");
INSERT INTO `wp_options` VALUES("750", "options_get_a_follower", "1", "no");
INSERT INTO `wp_options` VALUES("751", "options_google_fonts", "", "no");
INSERT INTO `wp_options` VALUES("752", "options_grid_height", "", "no");
INSERT INTO `wp_options` VALUES("753", "options_groups_create_posts", "", "no");
INSERT INTO `wp_options` VALUES("754", "options_groups_create_posts_without_approval", "a:1:{i:0;s:3:\"Pro\";}", "no");
INSERT INTO `wp_options` VALUES("755", "options_groups_edit_their_own_posts", "", "no");
INSERT INTO `wp_options` VALUES("756", "options_groups_view_posts", "", "no");
INSERT INTO `wp_options` VALUES("757", "options_groups_write_comments", "", "no");
INSERT INTO `wp_options` VALUES("758", "options_header_08_options", "", "no");
INSERT INTO `wp_options` VALUES("759", "options_header_08_options_bottom_icons", "", "no");
INSERT INTO `wp_options` VALUES("760", "options_header_08_options_font_color", "", "no");
INSERT INTO `wp_options` VALUES("761", "options_header_background", "", "no");
INSERT INTO `wp_options` VALUES("762", "options_header_link_color", "", "no");
INSERT INTO `wp_options` VALUES("763", "options_header_menu_background_color", "", "no");
INSERT INTO `wp_options` VALUES("764", "options_header_menu_columns", "columns-3", "no");
INSERT INTO `wp_options` VALUES("765", "options_header_menu_layout", "hmenu-template-2", "no");
INSERT INTO `wp_options` VALUES("766", "options_header_menu_link_colors", "", "no");
INSERT INTO `wp_options` VALUES("767", "options_header_menu_link_hover_colors", "", "no");
INSERT INTO `wp_options` VALUES("768", "options_header_search_background", "", "no");
INSERT INTO `wp_options` VALUES("769", "options_header_templates", "header-template-01", "no");
INSERT INTO `wp_options` VALUES("770", "options_headerstrip_background", "", "no");
INSERT INTO `wp_options` VALUES("771", "options_headerstrip_button_color", "", "no");
INSERT INTO `wp_options` VALUES("772", "options_headerstrip_button_text", "خرید قالب کینگ از نوین وردپرس", "no");
INSERT INTO `wp_options` VALUES("773", "options_headerstrip_button_url", "https://themes.wpnovin.com/King/Main/", "no");
INSERT INTO `wp_options` VALUES("774", "options_headerstrip_text", "قالب کینگ توسط نوین وردپرس توسعه و فارسی سازی شده است. همین امروز سایت خود را با قالب کینگ راه اندازی کنید.", "no");
INSERT INTO `wp_options` VALUES("775", "options_headerstrip_text_color", "", "no");
INSERT INTO `wp_options` VALUES("776", "options_hide_author_about_text", "0", "no");
INSERT INTO `wp_options` VALUES("777", "options_hide_author_social_links", "0", "no");
INSERT INTO `wp_options` VALUES("778", "options_hide_categories", "0", "no");
INSERT INTO `wp_options` VALUES("779", "options_hide_image_Link", "0", "no");
INSERT INTO `wp_options` VALUES("780", "options_hide_music_Link", "0", "no");
INSERT INTO `wp_options` VALUES("781", "options_hide_news_Link", "0", "no");
INSERT INTO `wp_options` VALUES("782", "options_hide_post_author_box", "0", "no");
INSERT INTO `wp_options` VALUES("783", "options_hide_video_Link", "0", "no");
INSERT INTO `wp_options` VALUES("784", "options_hs_expired_time", "1", "no");
INSERT INTO `wp_options` VALUES("785", "options_image_posts_templates", "image-template-1", "no");
INSERT INTO `wp_options` VALUES("786", "options_items_length", "2", "no");
INSERT INTO `wp_options` VALUES("787", "options_king_badges", "a:11:{i:0;s:16:\"badges_for_likes\";i:1;s:17:\"badges_for_points\";i:2;s:17:\"badges_for_points\";i:3;s:17:\"badges_for_points\";i:4;s:20:\"badges_for_followers\";i:5;s:19:\"badges_for_comments\";i:6;s:19:\"badges_for_comments\";i:7;s:19:\"badges_for_comments\";i:8;s:16:\"badges_for_posts\";i:9;s:16:\"badges_for_posts\";i:10;s:16:\"badges_for_posts\";}", "no");
INSERT INTO `wp_options` VALUES("788", "options_king_badges_0_badge_description", "شما می توانید بر اساس نشان ها امتیاز کاربر ایجاد کنید ", "no");
INSERT INTO `wp_options` VALUES("789", "options_king_badges_0_badge_icon", "506", "no");
INSERT INTO `wp_options` VALUES("790", "options_king_badges_0_badge_max_point", "0", "no");
INSERT INTO `wp_options` VALUES("791", "options_king_badges_0_badge_min_point", "0", "no");
INSERT INTO `wp_options` VALUES("792", "options_king_badges_0_badge_title", "نشان ها", "no");
INSERT INTO `wp_options` VALUES("793", "options_king_badges_1_badge_description", "شما می توانید بر اساس نشان ها امتیاز کاربر ایجاد کنید ", "no");
INSERT INTO `wp_options` VALUES("794", "options_king_badges_1_badge_icon", "503", "no");
INSERT INTO `wp_options` VALUES("795", "options_king_badges_1_badge_max_point", "50", "no");
INSERT INTO `wp_options` VALUES("796", "options_king_badges_1_badge_min_point", "2", "no");
INSERT INTO `wp_options` VALUES("797", "options_king_badges_1_badge_title", "نشان سطح 1", "no");
INSERT INTO `wp_options` VALUES("798", "options_king_badges_10_badge_description", "نشان نویسنده سطح 1", "no");
INSERT INTO `wp_options` VALUES("799", "options_king_badges_10_badge_icon", "497", "no");
INSERT INTO `wp_options` VALUES("800", "options_king_badges_10_badge_max_point", "500", "no");
INSERT INTO `wp_options` VALUES("801", "options_king_badges_10_badge_min_point", "100", "no");
INSERT INTO `wp_options` VALUES("802", "options_king_badges_10_badge_title", "نشان نویسنده سطح 3", "no");
INSERT INTO `wp_options` VALUES("803", "options_king_badges_2_badge_description", "شما می توانید بر اساس نشان ها امتیاز کاربر ایجاد کنید ", "no");
INSERT INTO `wp_options` VALUES("804", "options_king_badges_2_badge_icon", "504", "no");
INSERT INTO `wp_options` VALUES("805", "options_king_badges_2_badge_max_point", "1250", "no");
INSERT INTO `wp_options` VALUES("806", "options_king_badges_2_badge_min_point", "50", "no");
INSERT INTO `wp_options` VALUES("807", "options_king_badges_2_badge_title", "نشان سطح 2", "no");
INSERT INTO `wp_options` VALUES("808", "options_king_badges_3_badge_description", "شما می توانید بر اساس نشان ها امتیاز کاربر ایجاد کنید ", "no");
INSERT INTO `wp_options` VALUES("809", "options_king_badges_3_badge_icon", "505", "no");
INSERT INTO `wp_options` VALUES("810", "options_king_badges_3_badge_max_point", "5000", "no");
INSERT INTO `wp_options` VALUES("811", "options_king_badges_3_badge_min_point", "1250", "no");
INSERT INTO `wp_options` VALUES("812", "options_king_badges_3_badge_title", "نشان سطح 3", "no");
INSERT INTO `wp_options` VALUES("813", "options_king_badges_4_badge_description", "می‌توانید برای حساب‌های دنبال‌شده در انجمن خود نشان تنظیم کنید.", "no");
INSERT INTO `wp_options` VALUES("814", "options_king_badges_4_badge_icon", "498", "no");
INSERT INTO `wp_options` VALUES("815", "options_king_badges_4_badge_max_point", "10", "no");
INSERT INTO `wp_options` VALUES("816", "options_king_badges_4_badge_min_point", "0", "no");
INSERT INTO `wp_options` VALUES("817", "options_king_badges_4_badge_title", "حسابهای دنبال شده", "no");
INSERT INTO `wp_options` VALUES("818", "options_king_badges_5_badge_description", "نشان کامنت برتر سطح 1", "no");
INSERT INTO `wp_options` VALUES("819", "options_king_badges_5_badge_icon", "490", "no");
INSERT INTO `wp_options` VALUES("820", "options_king_badges_5_badge_max_point", "50", "no");
INSERT INTO `wp_options` VALUES("821", "options_king_badges_5_badge_min_point", "2", "no");
INSERT INTO `wp_options` VALUES("822", "options_king_badges_5_badge_title", "نشان سطح 1", "no");
INSERT INTO `wp_options` VALUES("823", "options_king_badges_6_badge_description", "نشان کامنت برتر سطح 2", "no");
INSERT INTO `wp_options` VALUES("824", "options_king_badges_6_badge_icon", "491", "no");
INSERT INTO `wp_options` VALUES("825", "options_king_badges_6_badge_max_point", "100", "no");
INSERT INTO `wp_options` VALUES("826", "options_king_badges_6_badge_min_point", "50", "no");
INSERT INTO `wp_options` VALUES("827", "options_king_badges_6_badge_title", "نشان سطح 2", "no");
INSERT INTO `wp_options` VALUES("828", "options_king_badges_7_badge_description", "نشان کامنت برتر سطح 3", "no");
INSERT INTO `wp_options` VALUES("829", "options_king_badges_7_badge_icon", "492", "no");
INSERT INTO `wp_options` VALUES("830", "options_king_badges_7_badge_max_point", "250", "no");
INSERT INTO `wp_options` VALUES("831", "options_king_badges_7_badge_min_point", "100", "no");
INSERT INTO `wp_options` VALUES("832", "options_king_badges_7_badge_title", "نشان سطح 3", "no");
INSERT INTO `wp_options` VALUES("833", "options_king_badges_8_badge_description", "نشان نویسنده سطح 1", "no");
INSERT INTO `wp_options` VALUES("834", "options_king_badges_8_badge_icon", "495", "no");
INSERT INTO `wp_options` VALUES("835", "options_king_badges_8_badge_max_point", "50", "no");
INSERT INTO `wp_options` VALUES("836", "options_king_badges_8_badge_min_point", "1", "no");
INSERT INTO `wp_options` VALUES("837", "options_king_badges_8_badge_title", "نشان نویسنده سطح 1", "no");
INSERT INTO `wp_options` VALUES("838", "options_king_badges_9_badge_description", "نشان نویسنده سطح 2", "no");
INSERT INTO `wp_options` VALUES("839", "options_king_badges_9_badge_icon", "496", "no");
INSERT INTO `wp_options` VALUES("840", "options_king_badges_9_badge_max_point", "100", "no");
INSERT INTO `wp_options` VALUES("841", "options_king_badges_9_badge_min_point", "50", "no");
INSERT INTO `wp_options` VALUES("842", "options_king_badges_9_badge_title", "نشان نویسنده سطح 2", "no");
INSERT INTO `wp_options` VALUES("843", "options_length_hot", "10", "no");
INSERT INTO `wp_options` VALUES("844", "options_length_nsfw", "10", "no");
INSERT INTO `wp_options` VALUES("845", "options_length_of_followers", "10", "no");
INSERT INTO `wp_options` VALUES("846", "options_length_of_following", "10", "no");
INSERT INTO `wp_options` VALUES("847", "options_length_of_posts_in_profile", "10", "no");
INSERT INTO `wp_options` VALUES("848", "options_length_of_users_dashboard", "10", "no");
INSERT INTO `wp_options` VALUES("849", "options_length_of_users_liked_posts", "10", "no");
INSERT INTO `wp_options` VALUES("850", "options_length_reaction", "10", "no");
INSERT INTO `wp_options` VALUES("851", "options_length_slider", "4", "no");
INSERT INTO `wp_options` VALUES("852", "options_length_trend", "10", "no");
INSERT INTO `wp_options` VALUES("853", "options_length_users", "10", "no");
INSERT INTO `wp_options` VALUES("854", "options_lightbox_gallery_ad_code", "<a href=\"https://themeforest.net/item/king-wordpress-theme/19436704?ref=RedKings\" target=\"_blank\"><img src=\"https://king.kingthemes.org/wp-content/uploads/2020/05/kingad.png\" /></a>", "no");
INSERT INTO `wp_options` VALUES("855", "options_load_more_background", "", "no");
INSERT INTO `wp_options` VALUES("856", "options_load_more_button_border", "", "no");
INSERT INTO `wp_options` VALUES("857", "options_load_more_button_show", "1", "no");
INSERT INTO `wp_options` VALUES("858", "options_load_more_button_text_color", "", "no");
INSERT INTO `wp_options` VALUES("859", "options_login_and_register_buttons_background", "", "no");
INSERT INTO `wp_options` VALUES("860", "options_max_avatar_size", "2", "no");
INSERT INTO `wp_options` VALUES("861", "options_max_cover_size", "2", "no");
INSERT INTO `wp_options` VALUES("862", "options_max_file_u_size", "4", "no");
INSERT INTO `wp_options` VALUES("863", "options_maximum_content_length", "2000", "no");
INSERT INTO `wp_options` VALUES("864", "options_maximum_title_length", "140", "no");
INSERT INTO `wp_options` VALUES("865", "options_mini_items_length", "5", "no");
INSERT INTO `wp_options` VALUES("866", "options_mini_slider_post_height", "", "no");
INSERT INTO `wp_options` VALUES("867", "options_moderate_posts_edit", "0", "no");
INSERT INTO `wp_options` VALUES("868", "options_navigation_background", "", "no");
INSERT INTO `wp_options` VALUES("869", "options_navigation_links", "", "no");
INSERT INTO `wp_options` VALUES("870", "options_navigation_links_active", "", "no");
INSERT INTO `wp_options` VALUES("871", "options_newsletter_cover_image", "845", "no");
INSERT INTO `wp_options` VALUES("872", "options_newsletter_delay_time", "3000", "no");
INSERT INTO `wp_options` VALUES("873", "options_newsletter_description", "عضو خبرنامه ما شوید و آخرین اخبار ما را از دست ندهید... ", "no");
INSERT INTO `wp_options` VALUES("874", "options_newsletter_expired", "1", "no");
INSERT INTO `wp_options` VALUES("875", "options_newsletter_submit_text", "عضویت", "no");
INSERT INTO `wp_options` VALUES("876", "options_newsletter_title", "گوش به زنگ باشید", "no");
INSERT INTO `wp_options` VALUES("877", "options_night_mode_logo", "604", "no");
INSERT INTO `wp_options` VALUES("878", "options_night_mode_mobile_logo", "", "no");
INSERT INTO `wp_options` VALUES("879", "options_notification_box_background", "", "no");
INSERT INTO `wp_options` VALUES("880", "options_notification_box_inside_background", "", "no");
INSERT INTO `wp_options` VALUES("881", "options_notification_icon_background", "", "no");
INSERT INTO `wp_options` VALUES("882", "options_notification_icon_color", "", "no");
INSERT INTO `wp_options` VALUES("883", "options_notifications_text_color", "", "no");
INSERT INTO `wp_options` VALUES("884", "options_only_verified", "0", "no");
INSERT INTO `wp_options` VALUES("885", "options_padding_between_grid_posts", "1", "no");
INSERT INTO `wp_options` VALUES("886", "options_page_header_background", "", "no");
INSERT INTO `wp_options` VALUES("887", "options_page_header_text_color", "", "no");
INSERT INTO `wp_options` VALUES("888", "options_page_link_color", "", "no");
INSERT INTO `wp_options` VALUES("889", "options_page_link_hover_color", "", "no");
INSERT INTO `wp_options` VALUES("890", "options_pagination_type", "king-pagination-01", "no");
INSERT INTO `wp_options` VALUES("891", "options_post_author_box_background", "", "no");
INSERT INTO `wp_options` VALUES("892", "options_post_author_box_text_color", "", "no");
INSERT INTO `wp_options` VALUES("893", "options_post_background", "", "no");
INSERT INTO `wp_options` VALUES("894", "options_post_column_numbers", "king-column-03", "no");
INSERT INTO `wp_options` VALUES("895", "options_post_content_background_color", "", "no");
INSERT INTO `wp_options` VALUES("896", "options_post_content_text_color", "", "no");
INSERT INTO `wp_options` VALUES("897", "options_post_entry_content_color", "", "no");
INSERT INTO `wp_options` VALUES("898", "options_post_like_button_background", "", "no");
INSERT INTO `wp_options` VALUES("899", "options_post_like_button_icon_color", "", "no");
INSERT INTO `wp_options` VALUES("900", "options_post_meta_background", "", "no");
INSERT INTO `wp_options` VALUES("901", "options_post_meta_text_color", "", "no");
INSERT INTO `wp_options` VALUES("902", "options_post_page_boxes_background", "", "no");
INSERT INTO `wp_options` VALUES("903", "options_post_page_boxes_title_background", "", "no");
INSERT INTO `wp_options` VALUES("904", "options_post_page_boxes_title_color", "", "no");
INSERT INTO `wp_options` VALUES("905", "options_post_title_color", "", "no");
INSERT INTO `wp_options` VALUES("906", "options_posting_a_comment", "1", "no");
INSERT INTO `wp_options` VALUES("907", "options_posts_meta_background", "", "no");
INSERT INTO `wp_options` VALUES("908", "options_posts_meta_color", "", "no");
INSERT INTO `wp_options` VALUES("909", "options_privacy_text", "با کلیک کردن، شما با شرایط ما موافقت می کنید.", "no");
INSERT INTO `wp_options` VALUES("910", "options_reactions_title_in_comment_form", "چطور بود؟", "no");
INSERT INTO `wp_options` VALUES("911", "options_related_length", "4", "no");
INSERT INTO `wp_options` VALUES("912", "options_related_posts_heading", "همچنین ممکن است بپسندید", "no");
INSERT INTO `wp_options` VALUES("913", "options_search_page_sidebar_template", "king-sidebar-04", "no");
INSERT INTO `wp_options` VALUES("914", "options_search_v2_box_background", "", "no");
INSERT INTO `wp_options` VALUES("915", "options_search_v2_button_background", "", "no");
INSERT INTO `wp_options` VALUES("916", "options_search_v2_icon_color", "", "no");
INSERT INTO `wp_options` VALUES("917", "options_search_v2_input_background", "", "no");
INSERT INTO `wp_options` VALUES("918", "options_select_default_display_option", "king-grid-01", "no");
INSERT INTO `wp_options` VALUES("919", "options_select_grid_template", "grid-template-1", "no");
INSERT INTO `wp_options` VALUES("920", "options_share_bar_background", "", "no");
INSERT INTO `wp_options` VALUES("921", "options_share_bar_buttons_background", "", "no");
INSERT INTO `wp_options` VALUES("922", "options_show_in_mini_slider", "editors_choice", "no");
INSERT INTO `wp_options` VALUES("923", "options_show_only_logged_users", "0", "no");
INSERT INTO `wp_options` VALUES("924", "options_show_slider", "featured-post", "no");
INSERT INTO `wp_options` VALUES("925", "options_show_user_results_in_search", "1", "no");
INSERT INTO `wp_options` VALUES("926", "options_sidebar_image_template", "king-sidebar-04", "no");
INSERT INTO `wp_options` VALUES("927", "options_sidebar_links", "", "no");
INSERT INTO `wp_options` VALUES("928", "options_sidebar_music_template", "king-sidebar-04", "no");
INSERT INTO `wp_options` VALUES("929", "options_sidebar_news_template", "king-sidebar-04", "no");
INSERT INTO `wp_options` VALUES("930", "options_sidebar_sticky_ad", "<a href=\"https://wpnovin.com/product/elementor-pro-website-builder-wordpress-plugin/\" target=\"_blank\"><img src=\"https://wpnovin.com/wp-content/uploads/2018/09/ElementorPro.jpg.webp\" /></a>", "no");
INSERT INTO `wp_options` VALUES("931", "options_sidebar_templates", "king-sidebar-01", "no");
INSERT INTO `wp_options` VALUES("932", "options_sidebar_text_color", "", "no");
INSERT INTO `wp_options` VALUES("933", "options_sidebar_video_template", "king-sidebar-04", "no");
INSERT INTO `wp_options` VALUES("934", "options_sidebar_widgets_post_meta_text_color", "", "no");
INSERT INTO `wp_options` VALUES("935", "options_sidebar_widgets_title_background", "", "no");
INSERT INTO `wp_options` VALUES("936", "options_sidebar_widgets_title_color", "", "no");
INSERT INTO `wp_options` VALUES("937", "options_single_post_templates", "template-3", "no");
INSERT INTO `wp_options` VALUES("938", "options_skip_ad_after", "5", "no");
INSERT INTO `wp_options` VALUES("939", "options_slider_height", "", "no");
INSERT INTO `wp_options` VALUES("940", "options_slider_template", "slider-template-1", "no");
INSERT INTO `wp_options` VALUES("941", "options_social_share_style", "share-2", "no");
INSERT INTO `wp_options` VALUES("942", "options_submit_background", "", "no");
INSERT INTO `wp_options` VALUES("943", "options_submit_button_link_colors", "", "no");
INSERT INTO `wp_options` VALUES("944", "options_submiticon_color", "", "no");
INSERT INTO `wp_options` VALUES("945", "options_submitting_a_post", "1", "no");
INSERT INTO `wp_options` VALUES("946", "options_twitter_share_description", "", "no");
INSERT INTO `wp_options` VALUES("947", "options_user_groups", "3", "no");
INSERT INTO `wp_options` VALUES("948", "options_user_groups_0_default_group_for_new_users", "0", "no");
INSERT INTO `wp_options` VALUES("949", "options_user_groups_0_group_color", "#23dae0", "no");
INSERT INTO `wp_options` VALUES("950", "options_user_groups_0_group_icon", "<i class=\"fas fa-robot\"></i>", "no");
INSERT INTO `wp_options` VALUES("951", "options_user_groups_0_group_name", "Pro", "no");
INSERT INTO `wp_options` VALUES("952", "options_user_groups_0_group_users", "", "no");
INSERT INTO `wp_options` VALUES("953", "options_user_groups_1_default_group_for_new_users", "0", "no");
INSERT INTO `wp_options` VALUES("954", "options_user_groups_1_group_color", "#0a0a0a", "no");
INSERT INTO `wp_options` VALUES("955", "options_user_groups_1_group_icon", "<i class=\"fas fa-fire-alt\"></i>", "no");
INSERT INTO `wp_options` VALUES("956", "options_user_groups_1_group_name", "admin", "no");
INSERT INTO `wp_options` VALUES("957", "options_user_groups_1_group_users", "", "no");
INSERT INTO `wp_options` VALUES("958", "options_user_groups_2_default_group_for_new_users", "0", "no");
INSERT INTO `wp_options` VALUES("959", "options_user_groups_2_group_color", "#fc3a3a", "no");
INSERT INTO `wp_options` VALUES("960", "options_user_groups_2_group_icon", "<i class=\"fas fa-crown\"></i>", "no");
INSERT INTO `wp_options` VALUES("961", "options_user_groups_2_group_name", "king", "no");
INSERT INTO `wp_options` VALUES("962", "options_user_groups_2_group_users", "", "no");
INSERT INTO `wp_options` VALUES("963", "options_user_points_badge_background", "", "no");
INSERT INTO `wp_options` VALUES("964", "options_user_points_badge_color", "", "no");
INSERT INTO `wp_options` VALUES("965", "options_verified_edit_posts", "0", "no");
INSERT INTO `wp_options` VALUES("966", "options_verified_posts", "0", "no");
INSERT INTO `wp_options` VALUES("967", "options_video_load_ad", "<a href=\"https://wpnovin.com/product/elementor-pro-website-builder-wordpress-plugin/\" target=\"_blank\"><img src=\"https://wpnovin.com/wp-content/uploads/2018/09/ElementorPro.jpg.webp\" /></a>", "no");
INSERT INTO `wp_options` VALUES("968", "options_video_posts_templates", "video-template-1", "no");
INSERT INTO `wp_options` VALUES("972", "widget_hot-posts", "a:4:{i:1;a:0:{}i:4;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}i:5;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("973", "widget_king-instagram", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("974", "widget_leaderboard", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("975", "widget_commented-posts", "a:3:{i:1;a:0:{}i:2;a:3:{s:5:\"title\";s:0:\"\";s:9:\"num_posts\";i:3;s:10:\"c_duration\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("976", "widget_recent-posts", "a:3:{i:1;a:0:{}i:2;a:3:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:3;s:9:\"show_date\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("977", "widget_related-posts", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("978", "widget_top-users", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("979", "widget_trending-posts", "a:3:{i:1;a:0:{}i:2;a:3:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:3;s:8:\"duration\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("980", "widget_king-youtube", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("982", "widget_recent-comments", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("986", "options_page_logo", "851", "no");
INSERT INTO `wp_options` VALUES("987", "_options_page_logo", "field_58519d525afb0", "no");
INSERT INTO `wp_options` VALUES("988", "options_mobile_page_logo", "606", "no");
INSERT INTO `wp_options` VALUES("989", "_options_mobile_page_logo", "field_5894e65d6db87", "no");
INSERT INTO `wp_options` VALUES("990", "options_disable_list", "0", "no");
INSERT INTO `wp_options` VALUES("991", "_options_disable_list", "field_6096d4f98be8d", "no");
INSERT INTO `wp_options` VALUES("992", "options_disable_polls", "0", "no");
INSERT INTO `wp_options` VALUES("993", "_options_disable_polls", "field_60ad74d978adb", "no");
INSERT INTO `wp_options` VALUES("994", "options_disable_trivia", "0", "no");
INSERT INTO `wp_options` VALUES("995", "_options_disable_trivia", "field_60b50a9f1b789", "no");
INSERT INTO `wp_options` VALUES("996", "options_enable_nsfw_for_music", "1", "no");
INSERT INTO `wp_options` VALUES("997", "_options_enable_nsfw_for_music", "field_60f6f3391ac32", "no");
INSERT INTO `wp_options` VALUES("998", "options_enable_nsfw_for_list", "1", "no");
INSERT INTO `wp_options` VALUES("999", "_options_enable_nsfw_for_list", "field_60f6f3521ac33", "no");
INSERT INTO `wp_options` VALUES("1000", "options_enable_nsfw_for_poll", "1", "no");
INSERT INTO `wp_options` VALUES("1001", "_options_enable_nsfw_for_poll", "field_60f6f3601ac34", "no");
INSERT INTO `wp_options` VALUES("1002", "options_enable_nsfw_for_trivia", "1", "no");
INSERT INTO `wp_options` VALUES("1003", "_options_enable_nsfw_for_trivia", "field_60f6f36e1ac35", "no");
INSERT INTO `wp_options` VALUES("1004", "options_enable_wp_login", "0", "no");
INSERT INTO `wp_options` VALUES("1005", "_options_enable_wp_login", "field_60f154d367c31", "no");
INSERT INTO `wp_options` VALUES("1006", "options_enable_recaptcha", "0", "no");
INSERT INTO `wp_options` VALUES("1007", "_options_enable_recaptcha", "field_58505b59edb1c", "no");
INSERT INTO `wp_options` VALUES("1008", "options_enable_facebook_login", "1", "no");
INSERT INTO `wp_options` VALUES("1009", "_options_enable_facebook_login", "field_57d9b645ca86f", "no");
INSERT INTO `wp_options` VALUES("1010", "options_enable_googleplus_login", "1", "no");
INSERT INTO `wp_options` VALUES("1011", "_options_enable_googleplus_login", "field_57d9c80dcd294", "no");
INSERT INTO `wp_options` VALUES("1012", "options_enable_stories", "1", "no");
INSERT INTO `wp_options` VALUES("1013", "_options_enable_stories", "field_61854bc6759ad", "no");
INSERT INTO `wp_options` VALUES("1038", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("1043", "wpp_settings", "a:16:{s:10:\"admin_lang\";s:6:\"enable\";s:9:\"user_lang\";s:6:\"enable\";s:12:\"persian_date\";s:6:\"enable\";s:20:\"disable_widget_block\";s:6:\"enable\";s:12:\"submenu_move\";s:6:\"enable\";s:8:\"dev_mode\";s:6:\"enable\";s:10:\"conv_title\";s:7:\"disable\";s:13:\"conv_contents\";s:7:\"disable\";s:12:\"conv_excerpt\";s:7:\"disable\";s:13:\"conv_comments\";s:7:\"disable\";s:18:\"conv_comment_count\";s:7:\"disable\";s:10:\"conv_dates\";s:7:\"disable\";s:9:\"conv_cats\";s:7:\"disable\";s:11:\"conv_arabic\";s:7:\"disable\";s:15:\"conv_permalinks\";s:7:\"disable\";s:11:\"news_source\";s:5:\"parsi\";}", "yes");
INSERT INTO `wp_options` VALUES("1044", "widget_parsidate_archive", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1045", "widget_parsidate_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1051", "fu_header_font", "KalamehFaNum-Black.ttf", "yes");
INSERT INTO `wp_options` VALUES("1052", "fu_lists_font", "KalamehFaNum-Medium.ttf", "yes");
INSERT INTO `wp_options` VALUES("1053", "fu_body_font", "KalamehFaNum-Regular.ttf", "yes");
INSERT INTO `wp_options` VALUES("1054", "fu_custom_one_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("1055", "fu_custom_one", "", "yes");
INSERT INTO `wp_options` VALUES("1056", "fu_custom_two_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("1057", "fu_custom_two", "", "yes");
INSERT INTO `wp_options` VALUES("1058", "fu_custom_three_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("1059", "fu_custom_three", "", "yes");
INSERT INTO `wp_options` VALUES("1060", "fu_custom_four_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("1061", "fu_custom_four", "", "yes");
INSERT INTO `wp_options` VALUES("1062", "fu_custom_five_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("1063", "fu_custom_five", "", "yes");
INSERT INTO `wp_options` VALUES("1064", "fu_google_font_urls", "", "yes");
INSERT INTO `wp_options` VALUES("1065", "fu_google_header_font_name", "", "yes");
INSERT INTO `wp_options` VALUES("1066", "fu_google_body_font_name", "", "yes");
INSERT INTO `wp_options` VALUES("1067", "fu_google_lists_font_name", "", "yes");
INSERT INTO `wp_options` VALUES("1068", "fu_ie_header_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("1069", "fu_ie_lists_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("1070", "fu_ie_body_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("1071", "fu_ie_custom_one", "", "yes");
INSERT INTO `wp_options` VALUES("1072", "fu_ie_custom_one_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("1073", "fu_ie_custom_two", "", "yes");
INSERT INTO `wp_options` VALUES("1074", "fu_ie_custom_two_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("1075", "fu_ie_custom_three", "", "yes");
INSERT INTO `wp_options` VALUES("1076", "fu_ie_custom_three_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("1077", "fu_ie_custom_four", "", "yes");
INSERT INTO `wp_options` VALUES("1078", "fu_ie_custom_four_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("1079", "fu_ie_custom_five", "", "yes");
INSERT INTO `wp_options` VALUES("1080", "fu_ie_custom_five_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("1081", "fu_header_font_size", "Choose a size", "yes");
INSERT INTO `wp_options` VALUES("1082", "fu_lists_font_size", "Choose a size", "yes");
INSERT INTO `wp_options` VALUES("1083", "fu_body_font_size", "Choose a size", "yes");
INSERT INTO `wp_options` VALUES("1084", "fu_custom_one_size_element", "", "yes");
INSERT INTO `wp_options` VALUES("1085", "fu_custom_one_size", "Choose a size", "yes");
INSERT INTO `wp_options` VALUES("1086", "fu_custom_two_size_element", "", "yes");
INSERT INTO `wp_options` VALUES("1087", "fu_custom_two_size", "Choose a size", "yes");
INSERT INTO `wp_options` VALUES("1088", "fu_custom_three_size_element", "", "yes");
INSERT INTO `wp_options` VALUES("1089", "fu_custom_three_size", "Choose a size", "yes");
INSERT INTO `wp_options` VALUES("1090", "fu_custom_four_size_element", "", "yes");
INSERT INTO `wp_options` VALUES("1091", "fu_custom_four_size", "Choose a size", "yes");
INSERT INTO `wp_options` VALUES("1092", "fu_custom_five_size_element", "", "yes");
INSERT INTO `wp_options` VALUES("1093", "fu_custom_five_size", "Choose a size", "yes");
INSERT INTO `wp_options` VALUES("1096", "options_amp_share_options", "a:6:{i:0;s:8:\"facebook\";i:1;s:7:\"twitter\";i:2;s:11:\"google_plus\";i:3;s:8:\"whatsapp\";i:4;s:3:\"sms\";i:5;s:5:\"email\";}", "no");
INSERT INTO `wp_options` VALUES("1097", "_options_amp_share_options", "field_5a4bf625a9545", "no");
INSERT INTO `wp_options` VALUES("1098", "options_amp_body_background_color", "", "no");
INSERT INTO `wp_options` VALUES("1099", "_options_amp_body_background_color", "field_5a4bf2a752501", "no");
INSERT INTO `wp_options` VALUES("1100", "options_amp_header_background", "", "no");
INSERT INTO `wp_options` VALUES("1101", "_options_amp_header_background", "field_5a4bf0c904467", "no");
INSERT INTO `wp_options` VALUES("1102", "options_amp_container_background", "", "no");
INSERT INTO `wp_options` VALUES("1103", "_options_amp_container_background", "field_5a4bf320b9bd4", "no");
INSERT INTO `wp_options` VALUES("1104", "options_amp_container_text_color", "", "no");
INSERT INTO `wp_options` VALUES("1105", "_options_amp_container_text_color", "field_5a4bf38cb9bd5", "no");
INSERT INTO `wp_options` VALUES("1106", "options_amp_share_box_background", "", "no");
INSERT INTO `wp_options` VALUES("1107", "_options_amp_share_box_background", "field_5a4bf42559121", "no");
INSERT INTO `wp_options` VALUES("1108", "options_amp_custom_css", "", "no");
INSERT INTO `wp_options` VALUES("1109", "_options_amp_custom_css", "field_5a4bf4c92fd47", "no");
INSERT INTO `wp_options` VALUES("1110", "options_stories_slider_title", "داستان ها", "no");
INSERT INTO `wp_options` VALUES("1111", "_options_stories_slider_title", "field_61923fece7c4b", "no");
INSERT INTO `wp_options` VALUES("1112", "options_display_stories_on_homepage", "1", "no");
INSERT INTO `wp_options` VALUES("1113", "_options_display_stories_on_homepage", "field_61854bf3759ae", "no");
INSERT INTO `wp_options` VALUES("1114", "options_total_number_of_stories", "14", "no");
INSERT INTO `wp_options` VALUES("1115", "_options_total_number_of_stories", "field_61a24df9a6280", "no");
INSERT INTO `wp_options` VALUES("1116", "options_stories_date_range", "all", "no");
INSERT INTO `wp_options` VALUES("1117", "_options_stories_date_range", "field_618e63744af65", "no");
INSERT INTO `wp_options` VALUES("1118", "options_stories_display_style", "all", "no");
INSERT INTO `wp_options` VALUES("1119", "_options_stories_display_style", "field_618cfd2b41df1", "no");
INSERT INTO `wp_options` VALUES("1120", "options_hide_create_story", "0", "no");
INSERT INTO `wp_options` VALUES("1121", "_options_hide_create_story", "field_6193a5db50c41", "no");
INSERT INTO `wp_options` VALUES("1122", "options_add_create_story_in_submit", "1", "no");
INSERT INTO `wp_options` VALUES("1123", "_options_add_create_story_in_submit", "field_61a24f8fd2004", "no");
INSERT INTO `wp_options` VALUES("1124", "options_disable_adding_links", "0", "no");
INSERT INTO `wp_options` VALUES("1125", "_options_disable_adding_links", "field_61b8890587434", "no");
INSERT INTO `wp_options` VALUES("1126", "options_moderate_stories", "1", "no");
INSERT INTO `wp_options` VALUES("1127", "_options_moderate_stories", "field_61af72ea5b82a", "no");
INSERT INTO `wp_options` VALUES("1128", "options_display_featured_stories", "1", "no");
INSERT INTO `wp_options` VALUES("1129", "_options_display_featured_stories", "field_61c064ac9870e", "no");
INSERT INTO `wp_options` VALUES("1136", "options_poll_posts_templates", "poll-template-1", "no");
INSERT INTO `wp_options` VALUES("1137", "_options_poll_posts_templates", "field_60ad359f94397", "no");
INSERT INTO `wp_options` VALUES("1138", "options_trivia_quiz_posts_templates", "trivia-template-1", "no");
INSERT INTO `wp_options` VALUES("1139", "_options_trivia_quiz_posts_templates", "field_60c4b3ad9aadb", "no");
INSERT INTO `wp_options` VALUES("1140", "options_homepage_template_sidebar", "king-sidebar-02", "no");
INSERT INTO `wp_options` VALUES("1141", "_options_homepage_template_sidebar", "field_5e69104d459ec", "no");
INSERT INTO `wp_options` VALUES("1142", "options_homepage_template_column", "king-column-03", "no");
INSERT INTO `wp_options` VALUES("1143", "_options_homepage_template_column", "field_61d420e31e11f", "no");
INSERT INTO `wp_options` VALUES("1144", "options_homepage_template", "", "no");
INSERT INTO `wp_options` VALUES("1145", "_options_homepage_template", "field_61d420a81e11e", "no");
INSERT INTO `wp_options` VALUES("1146", "options_archive_template_sidebar", "king-sidebar-01", "no");
INSERT INTO `wp_options` VALUES("1147", "_options_archive_template_sidebar", "field_61d4551c37fd1", "no");
INSERT INTO `wp_options` VALUES("1148", "options_archive_template_column", "", "no");
INSERT INTO `wp_options` VALUES("1149", "_options_archive_template_column", "field_61d4551c37fd2", "no");
INSERT INTO `wp_options` VALUES("1150", "options_archive_template", "", "no");
INSERT INTO `wp_options` VALUES("1151", "_options_archive_template", "field_61d4551c37fd0", "no");
INSERT INTO `wp_options` VALUES("1152", "options_search_page_template_sidebar", "king-sidebar-01", "no");
INSERT INTO `wp_options` VALUES("1153", "_options_search_page_template_sidebar", "field_61d57ef337e5c", "no");
INSERT INTO `wp_options` VALUES("1154", "options_search_page_template_column", "", "no");
INSERT INTO `wp_options` VALUES("1155", "_options_search_page_template_column", "field_61d57ef337e5d", "no");
INSERT INTO `wp_options` VALUES("1156", "options_search_page_template", "", "no");
INSERT INTO `wp_options` VALUES("1157", "_options_search_page_template", "field_61d57ef337e5b", "no");
INSERT INTO `wp_options` VALUES("1158", "options_dashboard_template_sidebar", "king-sidebar-01", "no");
INSERT INTO `wp_options` VALUES("1159", "_options_dashboard_template_sidebar", "field_61d5a26b8d150", "no");
INSERT INTO `wp_options` VALUES("1160", "options_dashboard_template_column", "", "no");
INSERT INTO `wp_options` VALUES("1161", "_options_dashboard_template_column", "field_61d5a26b8d151", "no");
INSERT INTO `wp_options` VALUES("1162", "options_dashboard_template", "", "no");
INSERT INTO `wp_options` VALUES("1163", "_options_dashboard_template", "field_61d5a26b8d14f", "no");
INSERT INTO `wp_options` VALUES("1164", "options_news_page_template_sidebar", "king-sidebar-01", "no");
INSERT INTO `wp_options` VALUES("1165", "_options_news_page_template_sidebar", "field_61d59359f7cce", "no");
INSERT INTO `wp_options` VALUES("1166", "options_news_page_template_column", "", "no");
INSERT INTO `wp_options` VALUES("1167", "_options_news_page_template_column", "field_61d59359f7ccf", "no");
INSERT INTO `wp_options` VALUES("1168", "options_news_page_template", "", "no");
INSERT INTO `wp_options` VALUES("1169", "_options_news_page_template", "field_61d59359f7ccd", "no");
INSERT INTO `wp_options` VALUES("1170", "options_videos_page_template_sidebar", "king-sidebar-01", "no");
INSERT INTO `wp_options` VALUES("1171", "_options_videos_page_template_sidebar", "field_61d593faf7cd1", "no");
INSERT INTO `wp_options` VALUES("1172", "options_videos_page_template_column", "", "no");
INSERT INTO `wp_options` VALUES("1173", "_options_videos_page_template_column", "field_61d593faf7cd2", "no");
INSERT INTO `wp_options` VALUES("1174", "options_videos_page_template", "", "no");
INSERT INTO `wp_options` VALUES("1175", "_options_videos_page_template", "field_61d593faf7cd0", "no");
INSERT INTO `wp_options` VALUES("1176", "options_images_page_template_sidebar", "king-sidebar-01", "no");
INSERT INTO `wp_options` VALUES("1177", "_options_images_page_template_sidebar", "field_61d59421f7cd4", "no");
INSERT INTO `wp_options` VALUES("1178", "options_images_page_template_column", "", "no");
INSERT INTO `wp_options` VALUES("1179", "_options_images_page_template_column", "field_61d59421f7cd5", "no");
INSERT INTO `wp_options` VALUES("1180", "options_images_page_template", "", "no");
INSERT INTO `wp_options` VALUES("1181", "_options_images_page_template", "field_61d59421f7cd3", "no");
INSERT INTO `wp_options` VALUES("1182", "options_profile_template_column", "", "no");
INSERT INTO `wp_options` VALUES("1183", "_options_profile_template_column", "field_61d5a5838b404", "no");
INSERT INTO `wp_options` VALUES("1184", "options_profile_template", "", "no");
INSERT INTO `wp_options` VALUES("1185", "_options_profile_template", "field_61d5a5838b402", "no");
INSERT INTO `wp_options` VALUES("1186", "options_mini_slider_title", "", "no");
INSERT INTO `wp_options` VALUES("1187", "_options_mini_slider_title", "field_5f930538d0503", "no");
INSERT INTO `wp_options` VALUES("1188", "options_mini_slider_paddings", "", "no");
INSERT INTO `wp_options` VALUES("1189", "_options_mini_slider_paddings", "field_5f930274cf35c", "no");
INSERT INTO `wp_options` VALUES("1190", "options_post_number_in_mini_slider", "6", "no");
INSERT INTO `wp_options` VALUES("1191", "_options_post_number_in_mini_slider", "field_5fa1575764b5e", "no");
INSERT INTO `wp_options` VALUES("1192", "options_king_header_nav", "a:4:{i:0;s:9:\"news_link\";i:1;s:11:\"videos_link\";i:2;s:11:\"images_link\";i:3;s:11:\"musics_link\";}", "no");
INSERT INTO `wp_options` VALUES("1193", "_options_king_header_nav", "field_60bf95fc1bfd1", "no");
INSERT INTO `wp_options` VALUES("1200", "options_minimum_age_for_registration", "13", "no");
INSERT INTO `wp_options` VALUES("1201", "_options_minimum_age_for_registration", "field_5ceaa116b26b0", "no");
INSERT INTO `wp_options` VALUES("1202", "options_facebook_app_id", "1", "no");
INSERT INTO `wp_options` VALUES("1203", "_options_facebook_app_id", "field_57d9b66eca870", "no");
INSERT INTO `wp_options` VALUES("1204", "options_facebook_secret_key", "1", "no");
INSERT INTO `wp_options` VALUES("1205", "_options_facebook_secret_key", "field_57d9b6cbca871", "no");
INSERT INTO `wp_options` VALUES("1206", "options_googleplus_client_id", "1", "no");
INSERT INTO `wp_options` VALUES("1207", "_options_googleplus_client_id", "field_57d9c873cd296", "no");
INSERT INTO `wp_options` VALUES("1208", "options_googleplus_client_secret", "1", "no");
INSERT INTO `wp_options` VALUES("1209", "_options_googleplus_client_secret", "field_57d9c8a2cd297", "no");
INSERT INTO `wp_options` VALUES("1210", "options_enable_social_logins_in_modal", "1", "no");
INSERT INTO `wp_options` VALUES("1211", "_options_enable_social_logins_in_modal", "field_5ab16883a1965", "no");
INSERT INTO `wp_options` VALUES("1212", "options_terms_and_conditions", "", "no");
INSERT INTO `wp_options` VALUES("1213", "_options_terms_and_conditions", "field_58505c38656af", "no");
INSERT INTO `wp_options` VALUES("1214", "options_news_text", "اخبار", "no");
INSERT INTO `wp_options` VALUES("1215", "_options_news_text", "field_5cf2b3cf25dfd", "no");
INSERT INTO `wp_options` VALUES("1216", "options_submit_news_text", "ارسال خبر", "no");
INSERT INTO `wp_options` VALUES("1217", "_options_submit_news_text", "field_5cf2b52795a06", "no");
INSERT INTO `wp_options` VALUES("1218", "options_videos_text", "ویدو", "no");
INSERT INTO `wp_options` VALUES("1219", "_options_videos_text", "field_5cf2b4e71e0eb", "no");
INSERT INTO `wp_options` VALUES("1220", "options_submit_video_text", "ارسال ویدیو", "no");
INSERT INTO `wp_options` VALUES("1221", "_options_submit_video_text", "field_5cf2b54195a07", "no");
INSERT INTO `wp_options` VALUES("1222", "options_image_text", "تصویر", "no");
INSERT INTO `wp_options` VALUES("1223", "_options_image_text", "field_5cf2b63a2c40f", "no");
INSERT INTO `wp_options` VALUES("1224", "options_submit_image_text", "ارسال تصویر", "no");
INSERT INTO `wp_options` VALUES("1225", "_options_submit_image_text", "field_5cf2b69f2c411", "no");
INSERT INTO `wp_options` VALUES("1226", "options_music_text", "موزیک", "no");
INSERT INTO `wp_options` VALUES("1227", "_options_music_text", "field_5ef7c280c4b2e", "no");
INSERT INTO `wp_options` VALUES("1228", "options_submit_music_text", "ارسال موزیک", "no");
INSERT INTO `wp_options` VALUES("1229", "_options_submit_music_text", "field_5ef7c2a0c4b2f", "no");
INSERT INTO `wp_options` VALUES("1230", "options_list_text", "لیست", "no");
INSERT INTO `wp_options` VALUES("1231", "_options_list_text", "field_60cb352d4cfae", "no");
INSERT INTO `wp_options` VALUES("1232", "options_submit_list_text", "ارسال لیست", "no");
INSERT INTO `wp_options` VALUES("1233", "_options_submit_list_text", "field_60cb352c4cfad", "no");
INSERT INTO `wp_options` VALUES("1234", "options_Poll_text", "نظرسنجی", "no");
INSERT INTO `wp_options` VALUES("1235", "_options_Poll_text", "field_60cb35704cfaf", "no");
INSERT INTO `wp_options` VALUES("1236", "options_submit_poll_text", "ارسال نظرسنجی", "no");
INSERT INTO `wp_options` VALUES("1237", "_options_submit_poll_text", "field_60cb35764cfb0", "no");
INSERT INTO `wp_options` VALUES("1238", "options_trivia_quiz_text", "پرسش", "no");
INSERT INTO `wp_options` VALUES("1239", "_options_trivia_quiz_text", "field_60cb35a44cfb1", "no");
INSERT INTO `wp_options` VALUES("1240", "options_submit_trivia_quiz_text", "ارسال پرسش", "no");
INSERT INTO `wp_options` VALUES("1241", "_options_submit_trivia_quiz_text", "field_60cb35a64cfb2", "no");
INSERT INTO `wp_options` VALUES("1242", "options_featured_text", "ویژه", "no");
INSERT INTO `wp_options` VALUES("1243", "_options_featured_text", "field_5cf2b6542c410", "no");
INSERT INTO `wp_options` VALUES("1244", "options_trending_text", "بحث روز", "no");
INSERT INTO `wp_options` VALUES("1245", "_options_trending_text", "field_5cf2b6b92c412", "no");
INSERT INTO `wp_options` VALUES("1246", "options_my_settings_text", "تنظیمات من", "no");
INSERT INTO `wp_options` VALUES("1247", "_options_my_settings_text", "field_5cf3b0aab5c12", "no");
INSERT INTO `wp_options` VALUES("1248", "options_inbox_text", "صندوق دریافت", "no");
INSERT INTO `wp_options` VALUES("1249", "_options_inbox_text", "field_5cf3b0c7b5c13", "no");
INSERT INTO `wp_options` VALUES("1250", "options_private_messages_text", "پیام شخصی", "no");
INSERT INTO `wp_options` VALUES("1251", "_options_private_messages_text", "field_5cf3b100b5c15", "no");
INSERT INTO `wp_options` VALUES("1252", "options_my_dashboard_text", "داشبورد من", "no");
INSERT INTO `wp_options` VALUES("1253", "_options_my_dashboard_text", "field_5cf3b0ddb5c14", "no");
INSERT INTO `wp_options` VALUES("1254", "options_submit_post_text", "ارسال پست", "no");
INSERT INTO `wp_options` VALUES("1255", "_options_submit_post_text", "field_5cf3b201ae737", "no");
INSERT INTO `wp_options` VALUES("1256", "options_save_text", "ذخیره", "no");
INSERT INTO `wp_options` VALUES("1257", "_options_save_text", "field_5cf3b221ae738", "no");
INSERT INTO `wp_options` VALUES("1258", "options_add_new_text", "افزودن جدید", "no");
INSERT INTO `wp_options` VALUES("1259", "_options_add_new_text", "field_5cf3b23aae739", "no");
INSERT INTO `wp_options` VALUES("1260", "options_select_image_text", "انتخاب تصویر", "no");
INSERT INTO `wp_options` VALUES("1261", "_options_select_image_text", "field_5cf3b32a80ccf", "no");
INSERT INTO `wp_options` VALUES("1262", "options_bookmark_text", "نشان کردن", "no");
INSERT INTO `wp_options` VALUES("1263", "_options_bookmark_text", "field_5f860d34ab24d", "no");
INSERT INTO `wp_options` VALUES("1264", "options_my_bookmarks_text", "مورد علاقه های من", "no");
INSERT INTO `wp_options` VALUES("1265", "_options_my_bookmarks_text", "field_5f860d65ab24e", "no");
INSERT INTO `wp_options` VALUES("1266", "options_stories_text", "داستان ها", "no");
INSERT INTO `wp_options` VALUES("1267", "_options_stories_text", "field_619a23d4fadc3", "no");
INSERT INTO `wp_options` VALUES("1268", "options_story_text", "داستان", "no");
INSERT INTO `wp_options` VALUES("1269", "_options_story_text", "field_61a754bdadd7f", "no");
INSERT INTO `wp_options` VALUES("1270", "options_create_story_text", "ایجاد داستان", "no");
INSERT INTO `wp_options` VALUES("1271", "_options_create_story_text", "field_619a239e5148e", "no");
INSERT INTO `wp_options` VALUES("1272", "options_footer_instagram_link", "", "no");
INSERT INTO `wp_options` VALUES("1273", "_options_footer_instagram_link", "field_585056d6d3af4", "no");
INSERT INTO `wp_options` VALUES("1274", "options_hide_navbar", "0", "no");
INSERT INTO `wp_options` VALUES("1275", "_options_hide_navbar", "field_5fa010391d306", "no");
INSERT INTO `wp_options` VALUES("1276", "options_hide_submit_button", "0", "no");
INSERT INTO `wp_options` VALUES("1277", "_options_hide_submit_button", "field_5fa418cd09651", "no");
INSERT INTO `wp_options` VALUES("1278", "options_add_new_icon_and_link_in_header", "", "no");
INSERT INTO `wp_options` VALUES("1279", "_options_add_new_icon_and_link_in_header", "field_5fa290c2cfe96", "no");
INSERT INTO `wp_options` VALUES("1280", "options_post_page_buttons_style", "badges-1", "no");
INSERT INTO `wp_options` VALUES("1281", "_options_post_page_buttons_style", "field_609d1b5da3f24", "no");
INSERT INTO `wp_options` VALUES("1282", "options_font_size_in_post_page", "", "no");
INSERT INTO `wp_options` VALUES("1283", "_options_font_size_in_post_page", "field_5fa5268bcadcd", "no");
INSERT INTO `wp_options` VALUES("1284", "options_enable_gifs_comments", "1", "no");
INSERT INTO `wp_options` VALUES("1285", "_options_enable_gifs_comments", "field_608acaeb12c30", "no");
INSERT INTO `wp_options` VALUES("1286", "options_giphy_api_key", "", "no");
INSERT INTO `wp_options` VALUES("1287", "_options_giphy_api_key", "field_60aa9b3362c19", "no");
INSERT INTO `wp_options` VALUES("1288", "options_enable_emoji_comments", "1", "no");
INSERT INTO `wp_options` VALUES("1289", "_options_enable_emoji_comments", "field_608acb2c12c31", "no");
INSERT INTO `wp_options` VALUES("1290", "options_hide_default_emojis", "0", "no");
INSERT INTO `wp_options` VALUES("1291", "_options_hide_default_emojis", "field_60aa92176159f", "no");
INSERT INTO `wp_options` VALUES("1292", "options_add_new_emoji", "", "no");
INSERT INTO `wp_options` VALUES("1293", "_options_add_new_emoji", "field_60aa85f1d70a0", "no");
INSERT INTO `wp_options` VALUES("1294", "options_up_vote_custom_icon", "", "no");
INSERT INTO `wp_options` VALUES("1295", "_options_up_vote_custom_icon", "field_60b92a04cd8e1", "no");
INSERT INTO `wp_options` VALUES("1296", "options_down_vote_custom_icon", "", "no");
INSERT INTO `wp_options` VALUES("1297", "_options_down_vote_custom_icon", "field_60b92a67cd8e2", "no");
INSERT INTO `wp_options` VALUES("1298", "options_disable_post_votes", "0", "no");
INSERT INTO `wp_options` VALUES("1299", "_options_disable_post_votes", "field_60cb3c87e6d24", "no");
INSERT INTO `wp_options` VALUES("1300", "options_disable_down_vote_in_posts", "0", "no");
INSERT INTO `wp_options` VALUES("1301", "_options_disable_down_vote_in_posts", "field_60b9082cfd394", "no");
INSERT INTO `wp_options` VALUES("1302", "options_disable_comment_votes", "0", "no");
INSERT INTO `wp_options` VALUES("1303", "_options_disable_comment_votes", "field_60b90800fd393", "no");
INSERT INTO `wp_options` VALUES("1304", "options_disable_down_vote_in_comments", "0", "no");
INSERT INTO `wp_options` VALUES("1305", "_options_disable_down_vote_in_comments", "field_60b9088efd395", "no");
INSERT INTO `wp_options` VALUES("1306", "options_enable_homepage_login", "0", "no");
INSERT INTO `wp_options` VALUES("1307", "_options_enable_homepage_login", "field_60e992d6aa880", "no");
INSERT INTO `wp_options` VALUES("1308", "options_default_background", "", "no");
INSERT INTO `wp_options` VALUES("1309", "_options_default_background", "field_5d4ee0794a595", "no");
INSERT INTO `wp_options` VALUES("1310", "options_enable_membership", "1", "no");
INSERT INTO `wp_options` VALUES("1311", "_options_enable_membership", "field_5fd0d93cdd098", "no");
INSERT INTO `wp_options` VALUES("1312", "options_membership_icon", "<i class=\"fas fa-fingerprint\"></i>", "no");
INSERT INTO `wp_options` VALUES("1313", "_options_membership_icon", "field_5fe869e5f0de7", "no");
INSERT INTO `wp_options` VALUES("1314", "options_restricted_post_title", "این پست برای اعضای حرفه ای می باشد", "no");
INSERT INTO `wp_options` VALUES("1315", "_options_restricted_post_title", "field_5fe868ed022ac", "no");
INSERT INTO `wp_options` VALUES("1316", "options_restricted_post_description", "بیایید یک اشتراک بخریم", "no");
INSERT INTO `wp_options` VALUES("1317", "_options_restricted_post_description", "field_5fe86a6df0de9", "no");
INSERT INTO `wp_options` VALUES("1318", "options_membership_icon_title", "حرفه ای", "no");
INSERT INTO `wp_options` VALUES("1319", "_options_membership_icon_title", "field_5ffda525a7d38", "no");
INSERT INTO `wp_options` VALUES("1320", "options_restricted_post_button_value", "مشاهده همه پلن ها", "no");
INSERT INTO `wp_options` VALUES("1321", "_options_restricted_post_button_value", "field_5fe86af2d3783", "no");
INSERT INTO `wp_options` VALUES("1322", "options_enable_flags_for_posts", "1", "no");
INSERT INTO `wp_options` VALUES("1323", "_options_enable_flags_for_posts", "field_61b8c37443d1d", "no");
INSERT INTO `wp_options` VALUES("1324", "options_enable_flags_for_comments", "1", "no");
INSERT INTO `wp_options` VALUES("1325", "_options_enable_flags_for_comments", "field_61b8c3c343d1e", "no");
INSERT INTO `wp_options` VALUES("1326", "options_hide_posts_flag", "0", "no");
INSERT INTO `wp_options` VALUES("1327", "_options_hide_posts_flag", "field_61b8c45443d1f", "no");
INSERT INTO `wp_options` VALUES("1399", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("1440", "max_file_size", "1073741824", "yes");
INSERT INTO `wp_options` VALUES("1488", "new_admin_email", "wpnovin.ir@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("1560", "puc_external_updates_theme-king", "O:8:\"stdClass\":5:{s:9:\"lastCheck\";i:1727596254;s:14:\"checkedVersion\";s:3:\"9.5\";s:6:\"update\";O:8:\"stdClass\":5:{s:4:\"slug\";s:4:\"king\";s:7:\"version\";s:3:\"9.1\";s:12:\"download_url\";s:110:\"http://cdn.wpnovin.com/dl3/Files/Themes/king/kingasd56SDFGHJH5666a4s5dfgh64j5j54hgf64d5s65sd546f4655465465.zip\";s:12:\"translations\";a:0:{}s:11:\"details_url\";s:1:\"#\";}s:11:\"updateClass\";s:21:\"Puc_v4p6_Theme_Update\";s:15:\"updateBaseClass\";s:12:\"Theme_Update\";}", "off");
INSERT INTO `wp_options` VALUES("1565", "duplicator_settings", "a:19:{s:7:\"version\";s:6:\"1.5.11\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:7;s:14:\"usage_tracking\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("1566", "duplicator_version_plugin", "1.5.11", "yes");
INSERT INTO `wp_options` VALUES("1571", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-09-29 07:53:50\";s:7:\"Version\";s:6:\"1.5.11\";s:9:\"VersionWP\";s:5:\"6.6.2\";s:9:\"VersionDB\";s:7:\"10.11.9\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20220214_d982d8a7d984d8a8d988d8b1d8afd9\";s:4:\"Hash\";s:35:\"bc003d560c0a429c1534_20240929075350\";s:8:\"NameHash\";s:75:\"20220214_d982d8a7d984d8a8d988d8b1d8afd9_bc003d560c0a429c1534_20240929075350\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"20220214_d982d8a7d984d8a8d988d8b1d8afd9_bc003d560c0a429c1534_20240929075350_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:37:\"/home/themeswpn/public_html/King/Main\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:698;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:5222;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-09-29 07:53:50\";s:7:\"Version\";s:6:\"1.5.11\";s:9:\"VersionWP\";s:5:\"6.6.2\";s:9:\"VersionDB\";s:7:\"10.11.9\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20220214_d982d8a7d984d8a8d988d8b1d8afd9\";s:4:\"Hash\";s:35:\"bc003d560c0a429c1534_20240929075350\";s:8:\"NameHash\";s:75:\"20220214_d982d8a7d984d8a8d988d8b1d8afd9_bc003d560c0a429c1534_20240929075350\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:51:\"/home/themeswpn/public_html/King/Main/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:46:\"/home/themeswpn/public_html/King/Main/wp-admin\";i:1;s:49:\"/home/themeswpn/public_html/King/Main/wp-includes\";i:2;s:58:\"/home/themeswpn/public_html/King/Main/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:37:\"/home/themeswpn/public_html/King/Main\";i:1;s:37:\"/home/themeswpn/public_html/King/Main\";i:2;s:48:\"/home/themeswpn/public_html/King/Main/wp-content\";i:3;s:56:\"/home/themeswpn/public_html/King/Main/wp-content/uploads\";i:4;s:56:\"/home/themeswpn/public_html/King/Main/wp-content/plugins\";i:5;s:59:\"/home/themeswpn/public_html/King/Main/wp-content/mu-plugins\";i:6;s:55:\"/home/themeswpn/public_html/King/Main/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:69:\"/home/themeswpn/public_html/King/Main/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "yes");
INSERT INTO `wp_options` VALUES("1987", "classic-editor-replace", "block", "yes");
INSERT INTO `wp_options` VALUES("1988", "classic-editor-allow-users", "disallow", "yes");
INSERT INTO `wp_options` VALUES("2271", "king_subscribers", "a:5:{i:0;s:20:\"FDsdsdfwef@yahoo.com\";i:1;s:22:\"Iran2022plus@gmail.com\";i:2;s:14:\"TEsr@gmail.com\";i:3;s:16:\"ferfef@gmail.com\";i:4;s:17:\"vasileh@gmail.com\";}", "yes");
INSERT INTO `wp_options` VALUES("6294", "user_count", "12", "no");
INSERT INTO `wp_options` VALUES("13087", "widget_latest-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("13088", "widget_postformat-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("13089", "widget_king-ad-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("18025", "duplicator_uninstall_package", "1", "yes");
INSERT INTO `wp_options` VALUES("18026", "duplicator_uninstall_settings", "1", "yes");
INSERT INTO `wp_options` VALUES("18027", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"HRp=TWBSNoHGd1xCZ-1XHE&RJdGS9FSURfjmK12CzL_G\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 1,\n    \"buildLastDate\": 1695714388,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 337.8899999999999863575794734060764312744140625,\n    \"siteNumFiles\": 5920,\n    \"siteDbSizeMB\": 1.9199999999999999289457264239899814128875732421875,\n    \"siteDbNumTables\": 13\n}", "yes");
INSERT INTO `wp_options` VALUES("18028", "duplicator_notifications", "a:4:{s:6:\"update\";i:1727596183;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("18033", "duplicator_dismissed_admin_notices", "a:1:{s:14:\"review_request\";a:1:{s:4:\"time\";i:1695714448;}}", "yes");
INSERT INTO `wp_options` VALUES("18748", "king_flag_count", "3", "yes");
INSERT INTO `wp_options` VALUES("18826", "wp_attachment_pages_enabled", "1", "yes");
INSERT INTO `wp_options` VALUES("21589", "can_compress_scripts", "0", "yes");
INSERT INTO `wp_options` VALUES("25794", "_site_transient_timeout_browser_e8db1a910ee088b469ecfd2b6a9b9da5", "1727950624", "off");
INSERT INTO `wp_options` VALUES("25795", "_site_transient_browser_e8db1a910ee088b469ecfd2b6a9b9da5", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"128.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("25796", "_site_transient_timeout_php_check_990bfacb848fa087bcfc06850f5e4447", "1727950625", "off");
INSERT INTO `wp_options` VALUES("25797", "_site_transient_php_check_990bfacb848fa087bcfc06850f5e4447", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("25805", "duplicator_email_summary_info", "{\"CL_-=_-=\":\"Duplicator\\\\Utils\\\\Email\\\\EmailSummary\",\"manualPackageIds\":[],\"failedPackageIds\":[]}", "auto");
INSERT INTO `wp_options` VALUES("25806", "duplicator_install_info", "a:3:{s:7:\"version\";s:5:\"1.5.6\";s:4:\"time\";i:1676972257;s:10:\"updateTime\";i:1727345871;}", "off");
INSERT INTO `wp_options` VALUES("25809", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fa_IR/wordpress-6.6.2.zip\";s:6:\"locale\";s:5:\"fa_IR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fa_IR/wordpress-6.6.2.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.6.2\";s:7:\"version\";s:5:\"6.6.2\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.4\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1727596220;s:15:\"version_checked\";s:5:\"6.6.2\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("25811", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1727596326;s:7:\"checked\";a:2:{s:10:\"king-child\";s:0:\"\";s:4:\"king\";s:3:\"9.5\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:0:{}s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("25845", "_transient_king_categories", "2", "on");
INSERT INTO `wp_options` VALUES("25870", "_transient_timeout_acf_plugin_updates", "1727769051", "off");
INSERT INTO `wp_options` VALUES("25871", "_transient_acf_plugin_updates", "a:5:{s:7:\"plugins\";a:0:{}s:9:\"no_update\";a:1:{s:34:\"advanced-custom-fields-pro/acf.php\";a:12:{s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:6:\"plugin\";s:34:\"advanced-custom-fields-pro/acf.php\";s:11:\"new_version\";s:5:\"6.3.6\";s:3:\"url\";s:36:\"https://www.advancedcustomfields.com\";s:6:\"tested\";s:5:\"6.6.1\";s:7:\"package\";s:0:\"\";s:5:\"icons\";a:1:{s:7:\"default\";s:75:\"https://ps.w.org/advanced-custom-fields/assets/icon-256x256.png?rev=3079482\";}s:7:\"banners\";a:2:{s:3:\"low\";s:77:\"https://ps.w.org/advanced-custom-fields/assets/banner-772x250.jpg?rev=1729102\";s:4:\"high\";s:78:\"https://ps.w.org/advanced-custom-fields/assets/banner-1544x500.jpg?rev=1729099\";}s:8:\"requires\";s:3:\"6.0\";s:12:\"requires_php\";s:3:\"7.4\";s:12:\"release_date\";s:8:\"20240828\";s:6:\"reason\";s:10:\"up_to_date\";}}s:10:\"expiration\";i:172800;s:6:\"status\";i:1;s:7:\"checked\";a:1:{s:34:\"advanced-custom-fields-pro/acf.php\";s:5:\"6.3.6\";}}", "off");
INSERT INTO `wp_options` VALUES("25881", "_site_transient_timeout_wp_theme_files_patterns-ebff63f628671a7fcd82a65ba32afc5a", "1727597957", "off");
INSERT INTO `wp_options` VALUES("25882", "_site_transient_wp_theme_files_patterns-ebff63f628671a7fcd82a65ba32afc5a", "a:2:{s:7:\"version\";s:3:\"9.5\";s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("25884", "_site_transient_timeout_browser_b9cbd8dc13f19f9e7eb854f472bfa274", "1728200984", "off");
INSERT INTO `wp_options` VALUES("25885", "_site_transient_browser_b9cbd8dc13f19f9e7eb854f472bfa274", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"109.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("25886", "_site_transient_timeout_envato_market_plugins", "1727599852", "off");
INSERT INTO `wp_options` VALUES("25887", "_site_transient_envato_market_plugins", "a:4:{s:9:\"purchased\";a:0:{}s:6:\"active\";a:0:{}s:9:\"installed\";a:0:{}s:7:\"install\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("25888", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("25889", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1727596251;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:7:{s:33:\"classic-editor/classic-editor.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/classic-editor\";s:4:\"slug\";s:14:\"classic-editor\";s:6:\"plugin\";s:33:\"classic-editor/classic-editor.php\";s:11:\"new_version\";s:5:\"1.6.5\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/classic-editor/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/classic-editor.1.6.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-256x256.png?rev=1998671\";s:2:\"1x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-128x128.png?rev=1998671\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/classic-editor/assets/banner-1544x500.png?rev=1998671\";s:2:\"1x\";s:69:\"https://ps.w.org/classic-editor/assets/banner-772x250.png?rev=1998676\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:35:\"classic-widgets/classic-widgets.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:29:\"w.org/plugins/classic-widgets\";s:4:\"slug\";s:15:\"classic-widgets\";s:6:\"plugin\";s:35:\"classic-widgets/classic-widgets.php\";s:11:\"new_version\";s:3:\"0.3\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/classic-widgets/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/classic-widgets.0.3.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:59:\"https://s.w.org/plugins/geopattern-icon/classic-widgets.svg\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.5.11\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.5.11.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:45:\"upload-max-file-size/upload-max-file-size.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:34:\"w.org/plugins/upload-max-file-size\";s:4:\"slug\";s:20:\"upload-max-file-size\";s:6:\"plugin\";s:45:\"upload-max-file-size/upload-max-file-size.php\";s:11:\"new_version\";s:5:\"2.0.4\";s:3:\"url\";s:51:\"https://wordpress.org/plugins/upload-max-file-size/\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/plugin/upload-max-file-size.2.0.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/upload-max-file-size/assets/icon-256x256.png?rev=2161684\";s:2:\"1x\";s:73:\"https://ps.w.org/upload-max-file-size/assets/icon-128x128.png?rev=2161684\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:76:\"https://ps.w.org/upload-max-file-size/assets/banner-1544x500.png?rev=2161684\";s:2:\"1x\";s:75:\"https://ps.w.org/upload-max-file-size/assets/banner-772x250.png?rev=2161684\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.0\";}s:47:\"one-click-demo-import/one-click-demo-import.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:35:\"w.org/plugins/one-click-demo-import\";s:4:\"slug\";s:21:\"one-click-demo-import\";s:6:\"plugin\";s:47:\"one-click-demo-import/one-click-demo-import.php\";s:11:\"new_version\";s:5:\"3.2.1\";s:3:\"url\";s:52:\"https://wordpress.org/plugins/one-click-demo-import/\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/plugin/one-click-demo-import.3.2.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:74:\"https://ps.w.org/one-click-demo-import/assets/icon-256x256.png?rev=2506685\";s:2:\"1x\";s:74:\"https://ps.w.org/one-click-demo-import/assets/icon-128x128.png?rev=2506685\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:77:\"https://ps.w.org/one-click-demo-import/assets/banner-1544x500.png?rev=2506685\";s:2:\"1x\";s:76:\"https://ps.w.org/one-click-demo-import/assets/banner-772x250.png?rev=2506685\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.5\";}s:53:\"widget-importer-exporter/widget-importer-exporter.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"w.org/plugins/widget-importer-exporter\";s:4:\"slug\";s:24:\"widget-importer-exporter\";s:6:\"plugin\";s:53:\"widget-importer-exporter/widget-importer-exporter.php\";s:11:\"new_version\";s:5:\"1.6.1\";s:3:\"url\";s:55:\"https://wordpress.org/plugins/widget-importer-exporter/\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/plugin/widget-importer-exporter.1.6.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:76:\"https://ps.w.org/widget-importer-exporter/assets/icon-256x256.jpg?rev=990577\";s:2:\"1x\";s:76:\"https://ps.w.org/widget-importer-exporter/assets/icon-128x128.jpg?rev=990577\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:79:\"https://ps.w.org/widget-importer-exporter/assets/banner-1544x500.jpg?rev=775677\";s:2:\"1x\";s:78:\"https://ps.w.org/widget-importer-exporter/assets/banner-772x250.jpg?rev=741218\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.5\";}s:29:\"wp-parsidate/wp-parsidate.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:26:\"w.org/plugins/wp-parsidate\";s:4:\"slug\";s:12:\"wp-parsidate\";s:6:\"plugin\";s:29:\"wp-parsidate/wp-parsidate.php\";s:11:\"new_version\";s:5:\"4.0.2\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/wp-parsidate/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/wp-parsidate.4.0.2.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:57:\"https://ps.w.org/wp-parsidate/assets/icon.svg?rev=1036248\";s:3:\"svg\";s:57:\"https://ps.w.org/wp-parsidate/assets/icon.svg?rev=1036248\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:67:\"https://ps.w.org/wp-parsidate/assets/banner-772x250.jpg?rev=2044005\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.3\";}}s:7:\"checked\";a:10:{s:34:\"advanced-custom-fields-pro/acf.php\";s:5:\"6.3.6\";s:33:\"classic-editor/classic-editor.php\";s:5:\"1.6.5\";s:35:\"classic-widgets/classic-widgets.php\";s:3:\"0.3\";s:25:\"duplicator/duplicator.php\";s:6:\"1.5.11\";s:31:\"envato-market/envato-market.php\";s:6:\"2.0.12\";s:45:\"upload-max-file-size/upload-max-file-size.php\";s:5:\"2.0.4\";s:47:\"one-click-demo-import/one-click-demo-import.php\";s:5:\"3.2.1\";s:53:\"widget-importer-exporter/widget-importer-exporter.php\";s:5:\"1.6.1\";s:29:\"wp-parsidate/wp-parsidate.php\";s:5:\"4.0.2\";s:29:\"Novin-Fonts/font-uploader.php\";s:5:\"3.1.0\";}}", "off");
INSERT INTO `wp_options` VALUES("25890", "_site_transient_timeout_theme_roots", "1727598126", "off");
INSERT INTO `wp_options` VALUES("25891", "_site_transient_theme_roots", "a:2:{s:10:\"king-child\";s:7:\"/themes\";s:4:\"king\";s:7:\"/themes\";}", "off");
INSERT INTO `wp_options` VALUES("25892", "_site_transient_timeout_envato_market_themes", "1727599926", "off");
INSERT INTO `wp_options` VALUES("25893", "_site_transient_envato_market_themes", "a:4:{s:9:\"purchased\";a:0:{}s:6:\"active\";a:0:{}s:9:\"installed\";a:0:{}s:7:\"install\";a:0:{}}", "off");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("2", "3", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("3", "6", "_wp_attached_file", "2022/02/log_file_2022-02-13__12-50-32.txt");
INSERT INTO `wp_postmeta` VALUES("4", "38", "_wp_attached_file", "2017/01/artworks-dQPq6diRUWuI-0-t500x500-1.jpg");
INSERT INTO `wp_postmeta` VALUES("5", "38", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:46:\"2017/01/artworks-dQPq6diRUWuI-0-t500x500-1.jpg\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:46:\"artworks-dQPq6diRUWuI-0-t500x500-1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:46:\"artworks-dQPq6diRUWuI-0-t500x500-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("6", "40", "_wp_attached_file", "2017/01/1-2.jpg");
INSERT INTO `wp_postmeta` VALUES("7", "40", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:941;s:6:\"height\";i:500;s:4:\"file\";s:15:\"2017/01/1-2.jpg\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"1-2-300x159.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:159;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"1-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:15:\"1-2-768x408.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:408;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("8", "41", "_wp_attached_file", "2017/01/2-2.jpg");
INSERT INTO `wp_postmeta` VALUES("9", "41", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1504;s:6:\"height\";i:1000;s:4:\"file\";s:15:\"2017/01/2-2.jpg\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"2-2-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:16:\"2-2-1024x681.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:681;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"2-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:15:\"2-2-768x511.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:511;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("10", "41", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("11", "41", "_post_views", "1");
INSERT INTO `wp_postmeta` VALUES("12", "42", "_wp_attached_file", "2017/01/3-2.jpg");
INSERT INTO `wp_postmeta` VALUES("13", "42", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1980;s:6:\"height\";i:735;s:4:\"file\";s:15:\"2017/01/3-2.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"3-2-300x111.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:111;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:16:\"3-2-1024x380.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:380;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"3-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:15:\"3-2-768x285.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:16:\"3-2-1536x570.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:570;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("14", "43", "_wp_attached_file", "2017/01/4-2.jpg");
INSERT INTO `wp_postmeta` VALUES("15", "43", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:500;s:4:\"file\";s:15:\"2017/01/4-2.jpg\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"4-2-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"4-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:15:\"4-2-768x384.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:384;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("16", "47", "_wp_attached_file", "2017/01/Big-Hero-6-Baymax-by-jsclemente-on-DeviantArt-1.png");
INSERT INTO `wp_postmeta` VALUES("17", "47", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:683;s:4:\"file\";s:59:\"2017/01/Big-Hero-6-Baymax-by-jsclemente-on-DeviantArt-1.png\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:59:\"Big-Hero-6-Baymax-by-jsclemente-on-DeviantArt-1-300x200.png\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:59:\"Big-Hero-6-Baymax-by-jsclemente-on-DeviantArt-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:59:\"Big-Hero-6-Baymax-by-jsclemente-on-DeviantArt-1-768x512.png\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("18", "49", "_wp_attached_file", "2017/01/473990304_1280x720-1.jpg");
INSERT INTO `wp_postmeta` VALUES("19", "49", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:32:\"2017/01/473990304_1280x720-1.jpg\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"473990304_1280x720-1-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:33:\"473990304_1280x720-1-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"473990304_1280x720-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:32:\"473990304_1280x720-1-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("20", "51", "_wp_attached_file", "2017/01/artworks-000093120638-z2z2xp-crop-1.jpg");
INSERT INTO `wp_postmeta` VALUES("21", "51", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:301;s:6:\"height\";i:300;s:4:\"file\";s:47:\"2017/01/artworks-000093120638-z2z2xp-crop-1.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:47:\"artworks-000093120638-z2z2xp-crop-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("22", "52", "_wp_attached_file", "2017/01/1-2.gif");
INSERT INTO `wp_postmeta` VALUES("23", "52", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:270;s:4:\"file\";s:15:\"2017/01/1-2.gif\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"1-2-300x162.gif\";s:5:\"width\";i:300;s:6:\"height\";i:162;s:9:\"mime-type\";s:9:\"image/gif\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"1-2-150x150.gif\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/gif\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("24", "52", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("25", "52", "_post_views", "1");
INSERT INTO `wp_postmeta` VALUES("26", "53", "_wp_attached_file", "2017/01/2-2.gif");
INSERT INTO `wp_postmeta` VALUES("27", "53", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:480;s:6:\"height\";i:270;s:4:\"file\";s:15:\"2017/01/2-2.gif\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"2-2-300x169.gif\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/gif\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"2-2-150x150.gif\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/gif\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("28", "54", "_wp_attached_file", "2017/01/3-2.gif");
INSERT INTO `wp_postmeta` VALUES("29", "54", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:234;s:4:\"file\";s:15:\"2017/01/3-2.gif\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"3-2-300x121.gif\";s:5:\"width\";i:300;s:6:\"height\";i:121;s:9:\"mime-type\";s:9:\"image/gif\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"3-2-150x150.gif\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/gif\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("30", "55", "_wp_attached_file", "2017/01/4-2.gif");
INSERT INTO `wp_postmeta` VALUES("31", "55", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:221;s:4:\"file\";s:15:\"2017/01/4-2.gif\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"4-2-300x133.gif\";s:5:\"width\";i:300;s:6:\"height\";i:133;s:9:\"mime-type\";s:9:\"image/gif\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"4-2-150x150.gif\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/gif\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("32", "56", "_wp_attached_file", "2017/01/5-2.gif");
INSERT INTO `wp_postmeta` VALUES("33", "56", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:425;s:6:\"height\";i:240;s:4:\"file\";s:15:\"2017/01/5-2.gif\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"5-2-300x169.gif\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/gif\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"5-2-150x150.gif\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/gif\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("34", "58", "_wp_attached_file", "2017/01/Capture-1.png");
INSERT INTO `wp_postmeta` VALUES("35", "58", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:794;s:6:\"height\";i:595;s:4:\"file\";s:21:\"2017/01/Capture-1.png\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"Capture-1-300x225.png\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"Capture-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"Capture-1-768x576.png\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("36", "59", "_wp_attached_file", "2017/01/image-1.png");
INSERT INTO `wp_postmeta` VALUES("37", "59", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:800;s:6:\"height\";i:600;s:4:\"file\";s:19:\"2017/01/image-1.png\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"image-1-300x225.png\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"image-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:19:\"image-1-768x576.png\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("38", "59", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("39", "59", "_post_views", "0");
INSERT INTO `wp_postmeta` VALUES("40", "67", "_wp_attached_file", "2017/01/avatarimg_user1-1.png");
INSERT INTO `wp_postmeta` VALUES("41", "67", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:300;s:4:\"file\";s:29:\"2017/01/avatarimg_user1-1.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"avatarimg_user1-1-300x225.png\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:29:\"avatarimg_user1-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("42", "69", "_wp_attached_file", "2017/01/539306657_1280x720-1.jpg");
INSERT INTO `wp_postmeta` VALUES("43", "69", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:32:\"2017/01/539306657_1280x720-1.jpg\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"539306657_1280x720-1-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:33:\"539306657_1280x720-1-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"539306657_1280x720-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:32:\"539306657_1280x720-1-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("44", "71", "_wp_attached_file", "2017/01/348090111_1280x693-1.jpg");
INSERT INTO `wp_postmeta` VALUES("45", "71", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:693;s:4:\"file\";s:32:\"2017/01/348090111_1280x693-1.jpg\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"348090111_1280x693-1-300x162.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:162;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:33:\"348090111_1280x693-1-1024x554.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:554;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"348090111_1280x693-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:32:\"348090111_1280x693-1-768x416.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:416;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("46", "73", "_wp_attached_file", "2017/01/perception_2-wallpaper-1280x800-1.jpg");
INSERT INTO `wp_postmeta` VALUES("47", "73", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:781;s:4:\"file\";s:45:\"2017/01/perception_2-wallpaper-1280x800-1.jpg\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:45:\"perception_2-wallpaper-1280x800-1-300x183.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:183;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:46:\"perception_2-wallpaper-1280x800-1-1024x625.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:625;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:45:\"perception_2-wallpaper-1280x800-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:45:\"perception_2-wallpaper-1280x800-1-768x469.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:469;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("48", "81", "_wp_attached_file", "2017/01/what-is-sales-activity-management-1.jpg");
INSERT INTO `wp_postmeta` VALUES("49", "81", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:960;s:6:\"height\";i:667;s:4:\"file\";s:47:\"2017/01/what-is-sales-activity-management-1.jpg\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:47:\"what-is-sales-activity-management-1-300x208.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:208;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:47:\"what-is-sales-activity-management-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:47:\"what-is-sales-activity-management-1-768x534.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:534;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("50", "84", "_wp_attached_file", "2017/01/maxresdefault-1.jpg");
INSERT INTO `wp_postmeta` VALUES("51", "84", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1080;s:4:\"file\";s:27:\"2017/01/maxresdefault-1.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"maxresdefault-1-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:28:\"maxresdefault-1-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"maxresdefault-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:27:\"maxresdefault-1-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:28:\"maxresdefault-1-1536x864.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:864;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("52", "87", "_wp_attached_file", "2017/01/14299149_10154742561704928_799543493_n-1.jpg");
INSERT INTO `wp_postmeta` VALUES("53", "87", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:480;s:6:\"height\";i:270;s:4:\"file\";s:52:\"2017/01/14299149_10154742561704928_799543493_n-1.jpg\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:52:\"14299149_10154742561704928_799543493_n-1-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:52:\"14299149_10154742561704928_799543493_n-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("54", "90", "_wp_attached_file", "2017/01/Screen-Shot-2016-09-09-at-1.57.00-PM-1150x693-1.png");
INSERT INTO `wp_postmeta` VALUES("55", "90", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1150;s:6:\"height\";i:693;s:4:\"file\";s:59:\"2017/01/Screen-Shot-2016-09-09-at-1.57.00-PM-1150x693-1.png\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:59:\"Screen-Shot-2016-09-09-at-1.57.00-PM-1150x693-1-300x181.png\";s:5:\"width\";i:300;s:6:\"height\";i:181;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:60:\"Screen-Shot-2016-09-09-at-1.57.00-PM-1150x693-1-1024x617.png\";s:5:\"width\";i:1024;s:6:\"height\";i:617;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:59:\"Screen-Shot-2016-09-09-at-1.57.00-PM-1150x693-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:59:\"Screen-Shot-2016-09-09-at-1.57.00-PM-1150x693-1-768x463.png\";s:5:\"width\";i:768;s:6:\"height\";i:463;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("56", "134", "_wp_attached_file", "2017/01/2-1-1.jpg");
INSERT INTO `wp_postmeta` VALUES("57", "134", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1504;s:6:\"height\";i:1000;s:4:\"file\";s:17:\"2017/01/2-1-1.jpg\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"2-1-1-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:18:\"2-1-1-1024x681.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:681;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"2-1-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:17:\"2-1-1-768x511.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:511;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("59", "136", "_wp_attached_file", "2017/01/3-1-1.jpg");
INSERT INTO `wp_postmeta` VALUES("60", "136", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1980;s:6:\"height\";i:735;s:4:\"file\";s:17:\"2017/01/3-1-1.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"3-1-1-300x111.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:111;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:18:\"3-1-1-1024x380.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:380;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"3-1-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:17:\"3-1-1-768x285.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:18:\"3-1-1-1536x570.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:570;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("62", "137", "_wp_attached_file", "2017/01/4-1-1.jpg");
INSERT INTO `wp_postmeta` VALUES("63", "137", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:500;s:4:\"file\";s:17:\"2017/01/4-1-1.jpg\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"4-1-1-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"4-1-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:17:\"4-1-1-768x384.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:384;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("65", "139", "_wp_attached_file", "2017/01/1-1-1.gif");
INSERT INTO `wp_postmeta` VALUES("66", "139", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:270;s:4:\"file\";s:17:\"2017/01/1-1-1.gif\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"1-1-1-300x162.gif\";s:5:\"width\";i:300;s:6:\"height\";i:162;s:9:\"mime-type\";s:9:\"image/gif\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"1-1-1-150x150.gif\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/gif\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("68", "140", "_wp_attached_file", "2017/01/2-1-1.gif");
INSERT INTO `wp_postmeta` VALUES("69", "140", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:480;s:6:\"height\";i:270;s:4:\"file\";s:17:\"2017/01/2-1-1.gif\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"2-1-1-300x169.gif\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/gif\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"2-1-1-150x150.gif\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/gif\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("71", "141", "_wp_attached_file", "2017/01/3-1-1.gif");
INSERT INTO `wp_postmeta` VALUES("72", "141", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:234;s:4:\"file\";s:17:\"2017/01/3-1-1.gif\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"3-1-1-300x121.gif\";s:5:\"width\";i:300;s:6:\"height\";i:121;s:9:\"mime-type\";s:9:\"image/gif\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"3-1-1-150x150.gif\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/gif\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("74", "142", "_wp_attached_file", "2017/01/4-1-1.gif");
INSERT INTO `wp_postmeta` VALUES("75", "142", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:221;s:4:\"file\";s:17:\"2017/01/4-1-1.gif\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"4-1-1-300x133.gif\";s:5:\"width\";i:300;s:6:\"height\";i:133;s:9:\"mime-type\";s:9:\"image/gif\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"4-1-1-150x150.gif\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/gif\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("77", "143", "_wp_attached_file", "2017/01/5-1-1.gif");
INSERT INTO `wp_postmeta` VALUES("78", "143", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:425;s:6:\"height\";i:240;s:4:\"file\";s:17:\"2017/01/5-1-1.gif\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"5-1-1-300x169.gif\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/gif\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"5-1-1-150x150.gif\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/gif\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("80", "453", "_wp_attached_file", "2017/04/birds-1.mp3");
INSERT INTO `wp_postmeta` VALUES("81", "453", "_wp_attachment_metadata", "a:18:{s:10:\"dataformat\";s:3:\"mp3\";s:8:\"channels\";i:2;s:11:\"sample_rate\";i:44100;s:7:\"bitrate\";d:192038.78214864319306798279285430908203125;s:11:\"channelmode\";s:6:\"stereo\";s:12:\"bitrate_mode\";s:3:\"cbr\";s:8:\"lossless\";b:0;s:15:\"encoder_options\";s:6:\"CBR192\";s:17:\"compression_ratio\";d:0.136081903450002261735107822460122406482696533203125;s:10:\"fileformat\";s:3:\"mp3\";s:8:\"filesize\";i:3097659;s:9:\"mime_type\";s:10:\"audio/mpeg\";s:6:\"length\";i:129;s:16:\"length_formatted\";s:4:\"2:09\";s:5:\"title\";s:2:\"HD\";s:16:\"encoder_settings\";s:13:\"Lavf56.19.100\";s:6:\"artist\";s:42:\"iPhone 6 Unboxing &amp; Review 09.19.2014 \";s:4:\"text\";s:8:\"isommp42\";}");
INSERT INTO `wp_postmeta` VALUES("83", "455", "_wp_attached_file", "2017/02/coverimg_user1-1.jpg");
INSERT INTO `wp_postmeta` VALUES("84", "455", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2560;s:6:\"height\";i:1440;s:4:\"file\";s:28:\"2017/02/coverimg_user1-1.jpg\";s:5:\"sizes\";a:6:{s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"coverimg_user1-1-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:29:\"coverimg_user1-1-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"coverimg_user1-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:28:\"coverimg_user1-1-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:29:\"coverimg_user1-1-1536x864.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:864;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"2048x2048\";a:4:{s:4:\"file\";s:30:\"coverimg_user1-1-2048x1152.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("85", "456", "_wp_attached_file", "2017/02/avatarimg_user1-1.jpg");
INSERT INTO `wp_postmeta` VALUES("86", "456", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:576;s:4:\"file\";s:29:\"2017/02/avatarimg_user1-1.jpg\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"avatarimg_user1-1-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:29:\"avatarimg_user1-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:29:\"avatarimg_user1-1-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("87", "457", "_wp_attached_file", "2017/02/coverimg_user1-2.jpg");
INSERT INTO `wp_postmeta` VALUES("88", "457", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2560;s:6:\"height\";i:1440;s:4:\"file\";s:28:\"2017/02/coverimg_user1-2.jpg\";s:5:\"sizes\";a:6:{s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"coverimg_user1-2-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:29:\"coverimg_user1-2-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"coverimg_user1-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:28:\"coverimg_user1-2-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:29:\"coverimg_user1-2-1536x864.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:864;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"2048x2048\";a:4:{s:4:\"file\";s:30:\"coverimg_user1-2-2048x1152.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("89", "458", "_wp_attached_file", "2017/02/coverimg_user1-3.jpg");
INSERT INTO `wp_postmeta` VALUES("90", "458", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2560;s:6:\"height\";i:1440;s:4:\"file\";s:28:\"2017/02/coverimg_user1-3.jpg\";s:5:\"sizes\";a:6:{s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"coverimg_user1-3-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:29:\"coverimg_user1-3-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"coverimg_user1-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:28:\"coverimg_user1-3-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:29:\"coverimg_user1-3-1536x864.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:864;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"2048x2048\";a:4:{s:4:\"file\";s:30:\"coverimg_user1-3-2048x1152.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("91", "459", "_wp_attached_file", "2017/04/girl_with_headphones_2-wallpaper-1152x720-1.jpg");
INSERT INTO `wp_postmeta` VALUES("92", "459", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1152;s:6:\"height\";i:699;s:4:\"file\";s:55:\"2017/04/girl_with_headphones_2-wallpaper-1152x720-1.jpg\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:55:\"girl_with_headphones_2-wallpaper-1152x720-1-300x182.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:56:\"girl_with_headphones_2-wallpaper-1152x720-1-1024x621.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:621;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:55:\"girl_with_headphones_2-wallpaper-1152x720-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:55:\"girl_with_headphones_2-wallpaper-1152x720-1-768x466.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:466;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("94", "461", "_wp_attached_file", "2017/04/3219680208-1.mp4");
INSERT INTO `wp_postmeta` VALUES("95", "461", "_wp_attachment_metadata", "a:10:{s:8:\"filesize\";i:2595276;s:9:\"mime_type\";s:9:\"video/mp4\";s:6:\"length\";i:31;s:16:\"length_formatted\";s:4:\"0:31\";s:5:\"width\";i:640;s:6:\"height\";i:360;s:10:\"fileformat\";s:3:\"mp4\";s:10:\"dataformat\";s:9:\"quicktime\";s:5:\"audio\";a:7:{s:10:\"dataformat\";s:3:\"mp4\";s:5:\"codec\";s:19:\"ISO/IEC 14496-3 AAC\";s:11:\"sample_rate\";d:44100;s:8:\"channels\";i:2;s:15:\"bits_per_sample\";i:16;s:8:\"lossless\";b:0;s:11:\"channelmode\";s:6:\"stereo\";}s:17:\"created_timestamp\";i:1259846285;}");
INSERT INTO `wp_postmeta` VALUES("97", "462", "_wp_attached_file", "2017/04/evolution1-1.jpg");
INSERT INTO `wp_postmeta` VALUES("98", "462", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:24:\"2017/04/evolution1-1.jpg\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"evolution1-1-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:25:\"evolution1-1-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"evolution1-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:24:\"evolution1-1-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("100", "464", "_wp_attached_file", "2017/02/cropped-wplogo2-1-1.png");
INSERT INTO `wp_postmeta` VALUES("101", "464", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:31:\"2017/02/cropped-wplogo2-1-1.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"cropped-wplogo2-1-1-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"cropped-wplogo2-1-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("102", "464", "_wp_attachment_context", "site-icon");
INSERT INTO `wp_postmeta` VALUES("103", "486", "_wp_attached_file", "2018/01/head.jpg");
INSERT INTO `wp_postmeta` VALUES("104", "486", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1920;s:4:\"file\";s:16:\"2018/01/head.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"head-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:18:\"head-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"head-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:16:\"head-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:18:\"head-1536x1536.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("106", "490", "_wp_attached_file", "2018/01/cb1.png");
INSERT INTO `wp_postmeta` VALUES("107", "490", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:132;s:6:\"height\";i:132;s:4:\"file\";s:15:\"2018/01/cb1.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("108", "491", "_wp_attached_file", "2018/01/cb2.png");
INSERT INTO `wp_postmeta` VALUES("109", "491", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:132;s:6:\"height\";i:132;s:4:\"file\";s:15:\"2018/01/cb2.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("110", "492", "_wp_attached_file", "2018/01/cb3.png");
INSERT INTO `wp_postmeta` VALUES("111", "492", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:132;s:6:\"height\";i:132;s:4:\"file\";s:15:\"2018/01/cb3.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("112", "495", "_wp_attached_file", "2018/01/pb1.png");
INSERT INTO `wp_postmeta` VALUES("113", "495", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:132;s:6:\"height\";i:132;s:4:\"file\";s:15:\"2018/01/pb1.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("114", "496", "_wp_attached_file", "2018/01/pb2.png");
INSERT INTO `wp_postmeta` VALUES("115", "496", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:132;s:6:\"height\";i:132;s:4:\"file\";s:15:\"2018/01/pb2.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("116", "497", "_wp_attached_file", "2018/01/pb3.png");
INSERT INTO `wp_postmeta` VALUES("117", "497", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:132;s:6:\"height\";i:132;s:4:\"file\";s:15:\"2018/01/pb3.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("118", "498", "_wp_attached_file", "2018/01/fb1.png");
INSERT INTO `wp_postmeta` VALUES("119", "498", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:132;s:6:\"height\";i:132;s:4:\"file\";s:15:\"2018/01/fb1.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("120", "503", "_wp_attached_file", "2018/01/pob1.png");
INSERT INTO `wp_postmeta` VALUES("121", "503", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:132;s:6:\"height\";i:132;s:4:\"file\";s:16:\"2018/01/pob1.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("122", "504", "_wp_attached_file", "2018/01/pob2.png");
INSERT INTO `wp_postmeta` VALUES("123", "504", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:132;s:6:\"height\";i:132;s:4:\"file\";s:16:\"2018/01/pob2.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("124", "505", "_wp_attached_file", "2018/01/pob3.png");
INSERT INTO `wp_postmeta` VALUES("125", "505", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:132;s:6:\"height\";i:132;s:4:\"file\";s:16:\"2018/01/pob3.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("126", "506", "_wp_attached_file", "2018/01/unlimited.png");
INSERT INTO `wp_postmeta` VALUES("127", "506", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:132;s:6:\"height\";i:132;s:4:\"file\";s:21:\"2018/01/unlimited.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("128", "525", "_wp_attached_file", "2018/07/dribbble-wind02.jpg");
INSERT INTO `wp_postmeta` VALUES("129", "525", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:800;s:6:\"height\";i:600;s:4:\"file\";s:27:\"2018/07/dribbble-wind02.jpg\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"dribbble-wind02-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"dribbble-wind02-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:27:\"dribbble-wind02-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("130", "526", "_wp_attached_file", "2018/07/dewapage_dribbble_1x.png");
INSERT INTO `wp_postmeta` VALUES("131", "526", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:300;s:4:\"file\";s:32:\"2018/07/dewapage_dribbble_1x.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"dewapage_dribbble_1x-300x225.png\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"dewapage_dribbble_1x-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("132", "527", "_wp_attached_file", "2018/07/no-service.jpg");
INSERT INTO `wp_postmeta` VALUES("133", "527", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:800;s:6:\"height\";i:600;s:4:\"file\";s:22:\"2018/07/no-service.jpg\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"no-service-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"no-service-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"no-service-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("134", "528", "_wp_attached_file", "2018/07/remote.png");
INSERT INTO `wp_postmeta` VALUES("135", "528", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:800;s:6:\"height\";i:600;s:4:\"file\";s:18:\"2018/07/remote.png\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"remote-300x225.png\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"remote-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:18:\"remote-768x576.png\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("136", "529", "_wp_attached_file", "2018/07/if_Attribute_category_label_shop_price_price_tag_tag_1886315.png");
INSERT INTO `wp_postmeta` VALUES("137", "529", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:72:\"2018/07/if_Attribute_category_label_shop_price_price_tag_tag_1886315.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:72:\"if_Attribute_category_label_shop_price_price_tag_tag_1886315-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:72:\"if_Attribute_category_label_shop_price_price_tag_tag_1886315-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("138", "530", "_wp_attached_file", "2018/07/if_Video-Camera-2_379365.png");
INSERT INTO `wp_postmeta` VALUES("139", "530", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:128;s:6:\"height\";i:128;s:4:\"file\";s:36:\"2018/07/if_Video-Camera-2_379365.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("140", "531", "_wp_attached_file", "2018/07/if_microphone_531899.png");
INSERT INTO `wp_postmeta` VALUES("141", "531", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:256;s:6:\"height\";i:256;s:4:\"file\";s:32:\"2018/07/if_microphone_531899.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"if_microphone_531899-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("142", "532", "_wp_attached_file", "2018/07/if_television_531913.png");
INSERT INTO `wp_postmeta` VALUES("143", "532", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:128;s:6:\"height\";i:128;s:4:\"file\";s:32:\"2018/07/if_television_531913.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("144", "533", "_wp_attached_file", "2018/07/if_easel_1055067.png");
INSERT INTO `wp_postmeta` VALUES("145", "533", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:28:\"2018/07/if_easel_1055067.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"if_easel_1055067-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"if_easel_1055067-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("146", "534", "_wp_attached_file", "2018/07/if_gamecontroller_1055053.png");
INSERT INTO `wp_postmeta` VALUES("147", "534", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:128;s:6:\"height\";i:128;s:4:\"file\";s:37:\"2018/07/if_gamecontroller_1055053.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("148", "535", "_wp_attached_file", "2018/07/if_smartphone_1054975.png");
INSERT INTO `wp_postmeta` VALUES("149", "535", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:128;s:6:\"height\";i:128;s:4:\"file\";s:33:\"2018/07/if_smartphone_1054975.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("150", "536", "_wp_attached_file", "2018/07/if_calculator_1055102.png");
INSERT INTO `wp_postmeta` VALUES("151", "536", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:33:\"2018/07/if_calculator_1055102.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"if_calculator_1055102-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"if_calculator_1055102-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("152", "537", "_wp_attached_file", "2018/07/if_image_1055042.png");
INSERT INTO `wp_postmeta` VALUES("153", "537", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:128;s:6:\"height\";i:128;s:4:\"file\";s:28:\"2018/07/if_image_1055042.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("154", "538", "_wp_attached_file", "2018/07/if_Food_fork_kitchen_knife_meanns_restaurant_1886929.png");
INSERT INTO `wp_postmeta` VALUES("155", "538", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:128;s:6:\"height\";i:128;s:4:\"file\";s:64:\"2018/07/if_Food_fork_kitchen_knife_meanns_restaurant_1886929.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("156", "539", "_wp_attached_file", "2018/07/if_Document_file_contract_agreement_certificate_degree_paper_1886906.png");
INSERT INTO `wp_postmeta` VALUES("157", "539", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:128;s:6:\"height\";i:128;s:4:\"file\";s:80:\"2018/07/if_Document_file_contract_agreement_certificate_degree_paper_1886906.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("158", "540", "_wp_attached_file", "2018/07/if_Flag_golf_pothole_sports_peace_nation_country_1886936.png");
INSERT INTO `wp_postmeta` VALUES("159", "540", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:128;s:6:\"height\";i:128;s:4:\"file\";s:68:\"2018/07/if_Flag_golf_pothole_sports_peace_nation_country_1886936.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("160", "542", "_wp_attached_file", "2018/07/if_Fasten_pin_push_pushpin_tack_thumb_thumbtack_1886926.png");
INSERT INTO `wp_postmeta` VALUES("161", "542", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:128;s:6:\"height\";i:128;s:4:\"file\";s:67:\"2018/07/if_Fasten_pin_push_pushpin_tack_thumb_thumbtack_1886926.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("162", "602", "_wp_attached_file", "2019/03/logo.png");
INSERT INTO `wp_postmeta` VALUES("163", "602", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:180;s:4:\"file\";s:16:\"2019/03/logo.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"logo-300x120.png\";s:5:\"width\";i:300;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"logo-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("165", "603", "_wp_attached_file", "2019/03/logon.png");
INSERT INTO `wp_postmeta` VALUES("166", "603", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:180;s:4:\"file\";s:17:\"2019/03/logon.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"logon-300x120.png\";s:5:\"width\";i:300;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"logon-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("167", "604", "_wp_attached_file", "2019/03/logon2.png");
INSERT INTO `wp_postmeta` VALUES("168", "604", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:180;s:4:\"file\";s:18:\"2019/03/logon2.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"logon2-300x120.png\";s:5:\"width\";i:300;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"logon2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("169", "605", "_wp_attached_file", "2019/03/favicon.png");
INSERT INTO `wp_postmeta` VALUES("170", "605", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:93;s:6:\"height\";i:93;s:4:\"file\";s:19:\"2019/03/favicon.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("171", "606", "_wp_attached_file", "2019/03/cropped-favicon.png");
INSERT INTO `wp_postmeta` VALUES("172", "606", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:27:\"2019/03/cropped-favicon.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"cropped-favicon-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"cropped-favicon-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("173", "606", "_wp_attachment_context", "site-icon");
INSERT INTO `wp_postmeta` VALUES("174", "608", "_wp_attached_file", "2019/03/favicon-1.png");
INSERT INTO `wp_postmeta` VALUES("175", "608", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:93;s:6:\"height\";i:93;s:4:\"file\";s:21:\"2019/03/favicon-1.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("176", "610", "_wp_attached_file", "2019/03/cropped-favicon-1.png");
INSERT INTO `wp_postmeta` VALUES("177", "610", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:29:\"2019/03/cropped-favicon-1.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"cropped-favicon-1-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:29:\"cropped-favicon-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("178", "610", "_wp_attachment_context", "site-icon");
INSERT INTO `wp_postmeta` VALUES("179", "671", "_wp_attached_file", "2017/05/2.jpg");
INSERT INTO `wp_postmeta` VALUES("180", "671", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:13:\"2017/05/2.jpg\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:13:\"2-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:14:\"2-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:13:\"2-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("182", "673", "_wp_attached_file", "2019/03/cropped-favicon-1-1.png");
INSERT INTO `wp_postmeta` VALUES("183", "673", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:31:\"2019/03/cropped-favicon-1-1.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"cropped-favicon-1-1-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"cropped-favicon-1-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("184", "673", "_wp_attachment_context", "site-icon");
INSERT INTO `wp_postmeta` VALUES("185", "687", "_wp_attached_file", "2017/05/typewriter.jpg");
INSERT INTO `wp_postmeta` VALUES("186", "687", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1920;s:4:\"file\";s:22:\"2017/05/typewriter.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"typewriter-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"typewriter-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"typewriter-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"typewriter-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:24:\"typewriter-1536x1536.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("188", "690", "_wp_attached_file", "2017/05/radio-1.jpg");
INSERT INTO `wp_postmeta` VALUES("189", "690", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1920;s:4:\"file\";s:19:\"2017/05/radio-1.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"radio-1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"radio-1-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"radio-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:19:\"radio-1-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:21:\"radio-1-1536x1536.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("191", "694", "_wp_attached_file", "2020/05/clement-dartigues-scirie.jpg");
INSERT INTO `wp_postmeta` VALUES("192", "694", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1067;s:4:\"file\";s:36:\"2020/05/clement-dartigues-scirie.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"clement-dartigues-scirie-300x167.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:167;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:37:\"clement-dartigues-scirie-1024x569.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:569;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"clement-dartigues-scirie-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"clement-dartigues-scirie-768x427.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:427;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:37:\"clement-dartigues-scirie-1536x854.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:854;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("194", "728", "_wp_attached_file", "2020/05/ezgif.com-webp-to-png-1.png");
INSERT INTO `wp_postmeta` VALUES("195", "728", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:35:\"2020/05/ezgif.com-webp-to-png-1.png\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:35:\"ezgif.com-webp-to-png-1-300x169.png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:36:\"ezgif.com-webp-to-png-1-1024x576.png\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:35:\"ezgif.com-webp-to-png-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:35:\"ezgif.com-webp-to-png-1-768x432.png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("196", "729", "_wp_attached_file", "2020/05/clement-dartigues-bivouac-def.jpg");
INSERT INTO `wp_postmeta` VALUES("197", "729", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1077;s:4:\"file\";s:41:\"2020/05/clement-dartigues-bivouac-def.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"clement-dartigues-bivouac-def-300x168.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:168;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:42:\"clement-dartigues-bivouac-def-1024x574.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:574;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"clement-dartigues-bivouac-def-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:41:\"clement-dartigues-bivouac-def-768x431.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:431;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:42:\"clement-dartigues-bivouac-def-1536x862.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:862;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("199", "730", "_wp_attached_file", "2020/05/battlefield_warrior_horse_running_smoke_illustration-wallpaper-1920x1080-1.jpg");
INSERT INTO `wp_postmeta` VALUES("200", "730", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1056;s:4:\"file\";s:86:\"2020/05/battlefield_warrior_horse_running_smoke_illustration-wallpaper-1920x1080-1.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:86:\"battlefield_warrior_horse_running_smoke_illustration-wallpaper-1920x1080-1-300x165.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:87:\"battlefield_warrior_horse_running_smoke_illustration-wallpaper-1920x1080-1-1024x563.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:563;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:86:\"battlefield_warrior_horse_running_smoke_illustration-wallpaper-1920x1080-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:86:\"battlefield_warrior_horse_running_smoke_illustration-wallpaper-1920x1080-1-768x422.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:422;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:87:\"battlefield_warrior_horse_running_smoke_illustration-wallpaper-1920x1080-1-1536x845.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:845;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("202", "731", "_wp_attached_file", "2020/05/the_starry_night-wallpaper-1920x1080-1.jpg");
INSERT INTO `wp_postmeta` VALUES("203", "731", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1050;s:4:\"file\";s:50:\"2020/05/the_starry_night-wallpaper-1920x1080-1.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:50:\"the_starry_night-wallpaper-1920x1080-1-300x164.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:164;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:51:\"the_starry_night-wallpaper-1920x1080-1-1024x560.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:50:\"the_starry_night-wallpaper-1920x1080-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:50:\"the_starry_night-wallpaper-1920x1080-1-768x420.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:51:\"the_starry_night-wallpaper-1920x1080-1-1536x840.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:840;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("205", "732", "_wp_attached_file", "2020/05/samurai_red_tree_wind_autumn-wallpaper-1920x1080-1.jpg");
INSERT INTO `wp_postmeta` VALUES("206", "732", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1050;s:4:\"file\";s:62:\"2020/05/samurai_red_tree_wind_autumn-wallpaper-1920x1080-1.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:62:\"samurai_red_tree_wind_autumn-wallpaper-1920x1080-1-300x164.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:164;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:63:\"samurai_red_tree_wind_autumn-wallpaper-1920x1080-1-1024x560.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:560;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:62:\"samurai_red_tree_wind_autumn-wallpaper-1920x1080-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:62:\"samurai_red_tree_wind_autumn-wallpaper-1920x1080-1-768x420.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:420;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:63:\"samurai_red_tree_wind_autumn-wallpaper-1920x1080-1-1536x840.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:840;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("208", "733", "_wp_attached_file", "2020/05/house_forest_3d-wallpaper-1920x1080-1.jpg");
INSERT INTO `wp_postmeta` VALUES("209", "733", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1047;s:4:\"file\";s:49:\"2020/05/house_forest_3d-wallpaper-1920x1080-1.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:49:\"house_forest_3d-wallpaper-1920x1080-1-300x164.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:164;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:50:\"house_forest_3d-wallpaper-1920x1080-1-1024x558.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:558;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:49:\"house_forest_3d-wallpaper-1920x1080-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:49:\"house_forest_3d-wallpaper-1920x1080-1-768x419.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:419;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:50:\"house_forest_3d-wallpaper-1920x1080-1-1536x838.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:838;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("211", "737", "_wp_attached_file", "2020/05/kingad.png");
INSERT INTO `wp_postmeta` VALUES("212", "737", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1180;s:6:\"height\";i:430;s:4:\"file\";s:18:\"2020/05/kingad.png\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"kingad-300x109.png\";s:5:\"width\";i:300;s:6:\"height\";i:109;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:19:\"kingad-1024x373.png\";s:5:\"width\";i:1024;s:6:\"height\";i:373;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"kingad-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:18:\"kingad-768x280.png\";s:5:\"width\";i:768;s:6:\"height\";i:280;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("213", "738", "_wp_attached_file", "2020/05/485743_3900039704282_366734302_n.jpg");
INSERT INTO `wp_postmeta` VALUES("214", "738", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:850;s:6:\"height\";i:320;s:4:\"file\";s:44:\"2020/05/485743_3900039704282_366734302_n.jpg\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:44:\"485743_3900039704282_366734302_n-300x113.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:113;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:44:\"485743_3900039704282_366734302_n-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:44:\"485743_3900039704282_366734302_n-768x289.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:289;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("215", "739", "_wp_attached_file", "2020/05/joker_50-wallpaper-1920x1080-1.jpg");
INSERT INTO `wp_postmeta` VALUES("216", "739", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1080;s:4:\"file\";s:42:\"2020/05/joker_50-wallpaper-1920x1080-1.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:42:\"joker_50-wallpaper-1920x1080-1-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:43:\"joker_50-wallpaper-1920x1080-1-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:42:\"joker_50-wallpaper-1920x1080-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:42:\"joker_50-wallpaper-1920x1080-1-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:43:\"joker_50-wallpaper-1920x1080-1-1536x864.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:864;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("217", "745", "_wp_attached_file", "2020/05/bottle-green-2.jpg");
INSERT INTO `wp_postmeta` VALUES("218", "745", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1920;s:4:\"file\";s:26:\"2020/05/bottle-green-2.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"bottle-green-2-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:28:\"bottle-green-2-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"bottle-green-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"bottle-green-2-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:28:\"bottle-green-2-1536x1536.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("220", "746", "_wp_attached_file", "2020/05/gramaphone.jpg");
INSERT INTO `wp_postmeta` VALUES("221", "746", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1920;s:4:\"file\";s:22:\"2020/05/gramaphone.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"gramaphone-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"gramaphone-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"gramaphone-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"gramaphone-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:24:\"gramaphone-1536x1536.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("223", "747", "_wp_attached_file", "2020/05/head.jpg");
INSERT INTO `wp_postmeta` VALUES("224", "747", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1920;s:4:\"file\";s:16:\"2020/05/head.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"head-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:18:\"head-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"head-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:16:\"head-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:18:\"head-1536x1536.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("226", "759", "_wp_attached_file", "2020/06/kingad-copy.png");
INSERT INTO `wp_postmeta` VALUES("227", "759", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:290;s:6:\"height\";i:290;s:4:\"file\";s:23:\"2020/06/kingad-copy.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"kingad-copy-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("228", "776", "_wp_attached_file", "2020/06/antelope_canyon-wallpaper-1440x900-1.jpg");
INSERT INTO `wp_postmeta` VALUES("229", "776", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1440;s:6:\"height\";i:882;s:4:\"file\";s:48:\"2020/06/antelope_canyon-wallpaper-1440x900-1.jpg\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:48:\"antelope_canyon-wallpaper-1440x900-1-300x184.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:184;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:49:\"antelope_canyon-wallpaper-1440x900-1-1024x627.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:627;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:48:\"antelope_canyon-wallpaper-1440x900-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:48:\"antelope_canyon-wallpaper-1440x900-1-768x470.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("231", "796", "_wp_attached_file", "2020/06/milky_way_mountain_by_yakub_nihat-wallpaper-1280x720-1.jpg");
INSERT INTO `wp_postmeta` VALUES("232", "796", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:690;s:4:\"file\";s:66:\"2020/06/milky_way_mountain_by_yakub_nihat-wallpaper-1280x720-1.jpg\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:66:\"milky_way_mountain_by_yakub_nihat-wallpaper-1280x720-1-300x162.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:162;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:67:\"milky_way_mountain_by_yakub_nihat-wallpaper-1280x720-1-1024x552.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:552;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:66:\"milky_way_mountain_by_yakub_nihat-wallpaper-1280x720-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:66:\"milky_way_mountain_by_yakub_nihat-wallpaper-1280x720-1-768x414.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:414;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("234", "802", "_wp_attached_file", "2020/06/httpsi.scdn_.coimageab67706f000000027e368901f39aae9d510c8fda.jpg");
INSERT INTO `wp_postmeta` VALUES("235", "802", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:300;s:6:\"height\";i:300;s:4:\"file\";s:72:\"2020/06/httpsi.scdn_.coimageab67706f000000027e368901f39aae9d510c8fda.jpg\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:72:\"httpsi.scdn_.coimageab67706f000000027e368901f39aae9d510c8fda-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:72:\"httpsi.scdn_.coimageab67706f000000027e368901f39aae9d510c8fda-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("237", "804", "_wp_attached_file", "2020/06/ab67616d0000b273ca801dab96017456b9847ac2.jpg");
INSERT INTO `wp_postmeta` VALUES("238", "804", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:640;s:6:\"height\";i:640;s:4:\"file\";s:52:\"2020/06/ab67616d0000b273ca801dab96017456b9847ac2.jpg\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:52:\"ab67616d0000b273ca801dab96017456b9847ac2-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:52:\"ab67616d0000b273ca801dab96017456b9847ac2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("240", "809", "_wp_attached_file", "2020/06/maxresdefault-1.jpg");
INSERT INTO `wp_postmeta` VALUES("241", "809", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:27:\"2020/06/maxresdefault-1.jpg\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"maxresdefault-1-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:28:\"maxresdefault-1-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"maxresdefault-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:27:\"maxresdefault-1-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("243", "541", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("244", "541", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("245", "541", "_menu_item_object_id", "541");
INSERT INTO `wp_postmeta` VALUES("246", "541", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("247", "541", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("248", "541", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("249", "541", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("250", "541", "_menu_item_url", "#");
INSERT INTO `wp_postmeta` VALUES("251", "541", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("252", "541", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("253", "621", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("254", "621", "_menu_item_menu_item_parent", "623");
INSERT INTO `wp_postmeta` VALUES("255", "621", "_menu_item_object_id", "621");
INSERT INTO `wp_postmeta` VALUES("256", "621", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("257", "621", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("258", "621", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("259", "621", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("260", "621", "_menu_item_url", "https://themes.wpnovin.com/King/Main/one-more-beer/");
INSERT INTO `wp_postmeta` VALUES("261", "621", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("262", "621", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("263", "622", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("264", "622", "_menu_item_menu_item_parent", "623");
INSERT INTO `wp_postmeta` VALUES("265", "622", "_menu_item_object_id", "622");
INSERT INTO `wp_postmeta` VALUES("266", "622", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("267", "622", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("268", "622", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("269", "622", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("270", "622", "_menu_item_url", "https://themes.wpnovin.com/King/Main/simple-news-post/");
INSERT INTO `wp_postmeta` VALUES("271", "622", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("272", "622", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("273", "623", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("274", "623", "_menu_item_menu_item_parent", "541");
INSERT INTO `wp_postmeta` VALUES("275", "623", "_menu_item_object_id", "623");
INSERT INTO `wp_postmeta` VALUES("276", "623", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("277", "623", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("278", "623", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("279", "623", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("280", "623", "_menu_item_url", "#");
INSERT INTO `wp_postmeta` VALUES("281", "623", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("282", "623", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("283", "624", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("284", "624", "_menu_item_menu_item_parent", "621");
INSERT INTO `wp_postmeta` VALUES("285", "624", "_menu_item_object_id", "624");
INSERT INTO `wp_postmeta` VALUES("286", "624", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("287", "624", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("288", "624", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("289", "624", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("290", "624", "_menu_item_url", "https://themes.wpnovin.com/King/Main/mp3-music-demo-post-barton-springs/");
INSERT INTO `wp_postmeta` VALUES("291", "624", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("292", "624", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("293", "625", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("294", "625", "_menu_item_menu_item_parent", "621");
INSERT INTO `wp_postmeta` VALUES("295", "625", "_menu_item_object_id", "625");
INSERT INTO `wp_postmeta` VALUES("296", "625", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("297", "625", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("298", "625", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("299", "625", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("300", "625", "_menu_item_url", "https://themes.wpnovin.com/King/Main/mp4-video-demo-evolution/");
INSERT INTO `wp_postmeta` VALUES("301", "625", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("302", "625", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("303", "626", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("304", "626", "_menu_item_menu_item_parent", "623");
INSERT INTO `wp_postmeta` VALUES("305", "626", "_menu_item_object_id", "626");
INSERT INTO `wp_postmeta` VALUES("306", "626", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("307", "626", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("308", "626", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("309", "626", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("310", "626", "_menu_item_url", "https://themes.wpnovin.com/King/Main/multiple-images-gallery/");
INSERT INTO `wp_postmeta` VALUES("311", "626", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("312", "626", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("313", "627", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("314", "627", "_menu_item_menu_item_parent", "623");
INSERT INTO `wp_postmeta` VALUES("315", "627", "_menu_item_object_id", "627");
INSERT INTO `wp_postmeta` VALUES("316", "627", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("317", "627", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("318", "627", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("319", "627", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("320", "627", "_menu_item_url", "https://themes.wpnovin.com/King/Main/5-dating-tips-people-wish-they-knew-in-their-twenties/");
INSERT INTO `wp_postmeta` VALUES("321", "627", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("322", "627", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("323", "628", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("324", "628", "_menu_item_menu_item_parent", "623");
INSERT INTO `wp_postmeta` VALUES("325", "628", "_menu_item_object_id", "628");
INSERT INTO `wp_postmeta` VALUES("326", "628", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("327", "628", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("328", "628", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("329", "628", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("330", "628", "_menu_item_url", "https://themes.wpnovin.com/King/Main/simple-news-post/");
INSERT INTO `wp_postmeta` VALUES("331", "628", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("332", "628", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("333", "629", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("334", "629", "_menu_item_menu_item_parent", "541");
INSERT INTO `wp_postmeta` VALUES("335", "629", "_menu_item_object_id", "629");
INSERT INTO `wp_postmeta` VALUES("336", "629", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("337", "629", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("338", "629", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("339", "629", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("340", "629", "_menu_item_url", "https://themes.wpnovin.com/King/Main/profile/king");
INSERT INTO `wp_postmeta` VALUES("341", "629", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("342", "629", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("343", "810", "_wp_attached_file", "2020/06/overlay.jpg");
INSERT INTO `wp_postmeta` VALUES("344", "810", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:19:\"2020/06/overlay.jpg\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"overlay-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:20:\"overlay-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"overlay-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:19:\"overlay-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("346", "811", "_wp_attached_file", "2020/06/overlay-1.jpg");
INSERT INTO `wp_postmeta` VALUES("347", "811", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:21:\"2020/06/overlay-1.jpg\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"overlay-1-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"overlay-1-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"overlay-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"overlay-1-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("349", "816", "_wp_attached_file", "2020/06/the-little-prince-characters-the-conceited-man.jpg");
INSERT INTO `wp_postmeta` VALUES("350", "816", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:530;s:4:\"file\";s:58:\"2020/06/the-little-prince-characters-the-conceited-man.jpg\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:58:\"the-little-prince-characters-the-conceited-man-300x159.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:159;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:58:\"the-little-prince-characters-the-conceited-man-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:58:\"the-little-prince-characters-the-conceited-man-768x407.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:407;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("352", "819", "_wp_attached_file", "2020/06/491616871.jpg");
INSERT INTO `wp_postmeta` VALUES("353", "819", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1080;s:4:\"file\";s:21:\"2020/06/491616871.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"491616871-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"491616871-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"491616871-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"491616871-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:22:\"491616871-1536x864.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:864;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("355", "821", "_wp_attached_file", "2020/06/maxresdefault-2.jpg");
INSERT INTO `wp_postmeta` VALUES("356", "821", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:27:\"2020/06/maxresdefault-2.jpg\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"maxresdefault-2-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:28:\"maxresdefault-2-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"maxresdefault-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:27:\"maxresdefault-2-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("358", "822", "_wp_attached_file", "2020/06/Barns-Courtney-Fire-AudioTrimmer.com_.mp3");
INSERT INTO `wp_postmeta` VALUES("359", "822", "_wp_attachment_metadata", "a:17:{s:10:\"dataformat\";s:3:\"mp3\";s:8:\"channels\";i:2;s:11:\"sample_rate\";i:44100;s:7:\"bitrate\";d:320147.0446182152372784912586212158203125;s:11:\"channelmode\";s:6:\"stereo\";s:12:\"bitrate_mode\";s:3:\"cbr\";s:8:\"lossless\";b:0;s:15:\"encoder_options\";s:6:\"CBR320\";s:17:\"compression_ratio\";d:0.2268615678983951500224947039896505884826183319091796875;s:10:\"fileformat\";s:3:\"mp3\";s:8:\"filesize\";i:2272697;s:9:\"mime_type\";s:10:\"audio/mpeg\";s:6:\"length\";i:57;s:16:\"length_formatted\";s:4:\"0:57\";s:16:\"encoder_settings\";s:13:\"Lavf57.83.100\";s:6:\"artist\";s:0:\"\";s:5:\"album\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("361", "825", "_wp_attached_file", "2020/06/516770578.jpg");
INSERT INTO `wp_postmeta` VALUES("362", "825", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:21:\"2020/06/516770578.jpg\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"516770578-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"516770578-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"516770578-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"516770578-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("364", "826", "_wp_attached_file", "2020/06/522fe3f2331081c1cd83dfa313755019.jpg");
INSERT INTO `wp_postmeta` VALUES("365", "826", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1000;s:4:\"file\";s:44:\"2020/06/522fe3f2331081c1cd83dfa313755019.jpg\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:44:\"522fe3f2331081c1cd83dfa313755019-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:44:\"522fe3f2331081c1cd83dfa313755019-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:44:\"522fe3f2331081c1cd83dfa313755019-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("367", "835", "_wp_attached_file", "2020/10/E9C0707A-630B-4585-8B29-938828E587C2.jpeg");
INSERT INTO `wp_postmeta` VALUES("368", "835", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:736;s:6:\"height\";i:1308;s:4:\"file\";s:49:\"2020/10/E9C0707A-630B-4585-8B29-938828E587C2.jpeg\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:49:\"E9C0707A-630B-4585-8B29-938828E587C2-169x300.jpeg\";s:5:\"width\";i:169;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:50:\"E9C0707A-630B-4585-8B29-938828E587C2-576x1024.jpeg\";s:5:\"width\";i:576;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:49:\"E9C0707A-630B-4585-8B29-938828E587C2-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("369", "845", "_wp_attached_file", "2020/10/Screenshot-2020-10-18-145042.jpg");
INSERT INTO `wp_postmeta` VALUES("370", "845", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1203;s:6:\"height\";i:887;s:4:\"file\";s:40:\"2020/10/Screenshot-2020-10-18-145042.jpg\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:40:\"Screenshot-2020-10-18-145042-300x221.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:221;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:41:\"Screenshot-2020-10-18-145042-1024x755.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:755;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:40:\"Screenshot-2020-10-18-145042-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:40:\"Screenshot-2020-10-18-145042-768x566.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:566;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("371", "630", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("372", "630", "_menu_item_menu_item_parent", "653");
INSERT INTO `wp_postmeta` VALUES("373", "630", "_menu_item_object_id", "8");
INSERT INTO `wp_postmeta` VALUES("374", "630", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("375", "630", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("376", "630", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("377", "630", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("378", "630", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("379", "630", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("380", "630", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("381", "641", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("382", "641", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("383", "641", "_menu_item_object_id", "641");
INSERT INTO `wp_postmeta` VALUES("384", "641", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("385", "641", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("386", "641", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("387", "641", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("388", "641", "_menu_item_url", "https://themes.wpnovin.com/King/Main");
INSERT INTO `wp_postmeta` VALUES("389", "641", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("390", "641", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("391", "644", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("392", "644", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("393", "644", "_menu_item_object_id", "22");
INSERT INTO `wp_postmeta` VALUES("394", "644", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("395", "644", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("396", "644", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("397", "644", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("398", "644", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("399", "644", "add_badge_to_menu", "1");
INSERT INTO `wp_postmeta` VALUES("400", "644", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("401", "644", "menu_badge_text", "داغ!");
INSERT INTO `wp_postmeta` VALUES("402", "644", "_menu_badge_text", "field_5c9bdc83674de");
INSERT INTO `wp_postmeta` VALUES("403", "644", "menu_badge_background_color", "#ea3535");
INSERT INTO `wp_postmeta` VALUES("404", "644", "_menu_badge_background_color", "field_5c9bdcbc674df");
INSERT INTO `wp_postmeta` VALUES("406", "645", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("407", "645", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("408", "645", "_menu_item_object_id", "95");
INSERT INTO `wp_postmeta` VALUES("409", "645", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("410", "645", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("411", "645", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("412", "645", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("413", "645", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("414", "645", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("415", "645", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("417", "646", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("418", "646", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("419", "646", "_menu_item_object_id", "98");
INSERT INTO `wp_postmeta` VALUES("420", "646", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("421", "646", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("422", "646", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("423", "646", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("424", "646", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("425", "646", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("426", "646", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("428", "647", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("429", "647", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("430", "647", "_menu_item_object_id", "25");
INSERT INTO `wp_postmeta` VALUES("431", "647", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("432", "647", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("433", "647", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("434", "647", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("435", "647", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("436", "647", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("437", "647", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("439", "648", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("440", "648", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("441", "648", "_menu_item_object_id", "28");
INSERT INTO `wp_postmeta` VALUES("442", "648", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("443", "648", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("444", "648", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("445", "648", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("446", "648", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("447", "648", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("448", "648", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("450", "649", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("451", "649", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("452", "649", "_menu_item_object_id", "469");
INSERT INTO `wp_postmeta` VALUES("453", "649", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("454", "649", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("455", "649", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("456", "649", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("457", "649", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("458", "649", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("459", "649", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("461", "650", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("462", "650", "_menu_item_menu_item_parent", "541");
INSERT INTO `wp_postmeta` VALUES("463", "650", "_menu_item_object_id", "105");
INSERT INTO `wp_postmeta` VALUES("464", "650", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("465", "650", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("466", "650", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("467", "650", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("468", "650", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("469", "650", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("470", "650", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("472", "651", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("473", "651", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("474", "651", "_menu_item_object_id", "493");
INSERT INTO `wp_postmeta` VALUES("475", "651", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("476", "651", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("477", "651", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("478", "651", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("479", "651", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("480", "651", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("481", "651", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("483", "652", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("484", "652", "_menu_item_menu_item_parent", "645");
INSERT INTO `wp_postmeta` VALUES("485", "652", "_menu_item_object_id", "522");
INSERT INTO `wp_postmeta` VALUES("486", "652", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("487", "652", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("488", "652", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("489", "652", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("490", "652", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("491", "652", "add_badge_to_menu", "1");
INSERT INTO `wp_postmeta` VALUES("492", "652", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("493", "652", "menu_badge_text", "جدید!");
INSERT INTO `wp_postmeta` VALUES("494", "652", "_menu_badge_text", "field_5c9bdc83674de");
INSERT INTO `wp_postmeta` VALUES("495", "652", "menu_badge_background_color", "#efe121");
INSERT INTO `wp_postmeta` VALUES("496", "652", "_menu_badge_background_color", "field_5c9bdcbc674df");
INSERT INTO `wp_postmeta` VALUES("498", "653", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("499", "653", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("500", "653", "_menu_item_object_id", "522");
INSERT INTO `wp_postmeta` VALUES("501", "653", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("502", "653", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("503", "653", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("504", "653", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("505", "653", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("506", "653", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("507", "653", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("509", "663", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("510", "663", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("511", "663", "_menu_item_object_id", "95");
INSERT INTO `wp_postmeta` VALUES("512", "663", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("513", "663", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("514", "663", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("515", "663", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("516", "663", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("517", "663", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("518", "663", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("520", "664", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("521", "664", "_menu_item_menu_item_parent", "641");
INSERT INTO `wp_postmeta` VALUES("522", "664", "_menu_item_object_id", "70");
INSERT INTO `wp_postmeta` VALUES("523", "664", "_menu_item_object", "post");
INSERT INTO `wp_postmeta` VALUES("524", "664", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("525", "664", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("526", "664", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("527", "664", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("528", "664", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("529", "664", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("531", "665", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("532", "665", "_menu_item_menu_item_parent", "641");
INSERT INTO `wp_postmeta` VALUES("533", "665", "_menu_item_object_id", "643");
INSERT INTO `wp_postmeta` VALUES("534", "665", "_menu_item_object", "post");
INSERT INTO `wp_postmeta` VALUES("535", "665", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("536", "665", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("537", "665", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("538", "665", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("539", "665", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("540", "665", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("542", "666", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("543", "666", "_menu_item_menu_item_parent", "641");
INSERT INTO `wp_postmeta` VALUES("544", "666", "_menu_item_object_id", "418");
INSERT INTO `wp_postmeta` VALUES("545", "666", "_menu_item_object", "post");
INSERT INTO `wp_postmeta` VALUES("546", "666", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("547", "666", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("548", "666", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("549", "666", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("550", "666", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("551", "666", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("553", "668", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("554", "668", "_menu_item_menu_item_parent", "641");
INSERT INTO `wp_postmeta` VALUES("555", "668", "_menu_item_object_id", "57");
INSERT INTO `wp_postmeta` VALUES("556", "668", "_menu_item_object", "post");
INSERT INTO `wp_postmeta` VALUES("557", "668", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("558", "668", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("559", "668", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("560", "668", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("561", "668", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("562", "668", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("564", "669", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("565", "669", "_menu_item_menu_item_parent", "645");
INSERT INTO `wp_postmeta` VALUES("566", "669", "_menu_item_object_id", "95");
INSERT INTO `wp_postmeta` VALUES("567", "669", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("568", "669", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("569", "669", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("570", "669", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("571", "669", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("572", "669", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("573", "669", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("575", "670", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("576", "670", "_menu_item_menu_item_parent", "648");
INSERT INTO `wp_postmeta` VALUES("577", "670", "_menu_item_object_id", "28");
INSERT INTO `wp_postmeta` VALUES("578", "670", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("579", "670", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("580", "670", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("581", "670", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("582", "670", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("583", "670", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("584", "670", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("586", "762", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("587", "762", "_menu_item_menu_item_parent", "541");
INSERT INTO `wp_postmeta` VALUES("588", "762", "_menu_item_object_id", "762");
INSERT INTO `wp_postmeta` VALUES("589", "762", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("590", "762", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("591", "762", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("592", "762", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("593", "762", "_menu_item_url", "#");
INSERT INTO `wp_postmeta` VALUES("594", "762", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("595", "762", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("596", "763", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("597", "763", "_menu_item_menu_item_parent", "762");
INSERT INTO `wp_postmeta` VALUES("598", "763", "_menu_item_object_id", "763");
INSERT INTO `wp_postmeta` VALUES("599", "763", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("600", "763", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("601", "763", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("602", "763", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("603", "763", "_menu_item_url", "https://themes.wpnovin.com/King/Main/category/internet/");
INSERT INTO `wp_postmeta` VALUES("604", "763", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("605", "763", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("606", "764", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("607", "764", "_menu_item_menu_item_parent", "762");
INSERT INTO `wp_postmeta` VALUES("608", "764", "_menu_item_object_id", "764");
INSERT INTO `wp_postmeta` VALUES("609", "764", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("610", "764", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("611", "764", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("612", "764", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("613", "764", "_menu_item_url", "https://themes.wpnovin.com/King/Main/category/art/");
INSERT INTO `wp_postmeta` VALUES("614", "764", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("615", "764", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("616", "765", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("617", "765", "_menu_item_menu_item_parent", "762");
INSERT INTO `wp_postmeta` VALUES("618", "765", "_menu_item_object_id", "765");
INSERT INTO `wp_postmeta` VALUES("619", "765", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("620", "765", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("621", "765", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("622", "765", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("623", "765", "_menu_item_url", "https://themes.wpnovin.com/King/Main/category/video/");
INSERT INTO `wp_postmeta` VALUES("624", "765", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("625", "765", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("626", "766", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("627", "766", "_menu_item_menu_item_parent", "762");
INSERT INTO `wp_postmeta` VALUES("628", "766", "_menu_item_object_id", "766");
INSERT INTO `wp_postmeta` VALUES("629", "766", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("630", "766", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("631", "766", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("632", "766", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("633", "766", "_menu_item_url", "https://themes.wpnovin.com/King/Main/category/uncategorized/");
INSERT INTO `wp_postmeta` VALUES("634", "766", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("635", "766", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("636", "773", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("637", "773", "_menu_item_menu_item_parent", "541");
INSERT INTO `wp_postmeta` VALUES("638", "773", "_menu_item_object_id", "773");
INSERT INTO `wp_postmeta` VALUES("639", "773", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("640", "773", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("641", "773", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("642", "773", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("643", "773", "_menu_item_url", "#");
INSERT INTO `wp_postmeta` VALUES("644", "773", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("645", "773", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("646", "774", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("647", "774", "_menu_item_menu_item_parent", "773");
INSERT INTO `wp_postmeta` VALUES("648", "774", "_menu_item_object_id", "774");
INSERT INTO `wp_postmeta` VALUES("649", "774", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("650", "774", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("651", "774", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("652", "774", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("653", "774", "_menu_item_url", "https://themes.wpnovin.com/King/Main/5-dating-tips-people-wish-they-knew-in-their-twenties/");
INSERT INTO `wp_postmeta` VALUES("654", "774", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("655", "774", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("656", "779", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("657", "779", "_menu_item_menu_item_parent", "773");
INSERT INTO `wp_postmeta` VALUES("658", "779", "_menu_item_object_id", "779");
INSERT INTO `wp_postmeta` VALUES("659", "779", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("660", "779", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("661", "779", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("662", "779", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("663", "779", "_menu_item_url", "https://themes.wpnovin.com/King/Main/6-awe-inspiring-natural-wonders-for-your-bucket-list/");
INSERT INTO `wp_postmeta` VALUES("664", "779", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("665", "779", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("666", "780", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("667", "780", "_menu_item_menu_item_parent", "773");
INSERT INTO `wp_postmeta` VALUES("668", "780", "_menu_item_object_id", "780");
INSERT INTO `wp_postmeta` VALUES("669", "780", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("670", "780", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("671", "780", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("672", "780", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("673", "780", "_menu_item_url", "https://themes.wpnovin.com/King/Main/simple-news-post/");
INSERT INTO `wp_postmeta` VALUES("674", "780", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("675", "780", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("676", "783", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("677", "783", "_menu_item_menu_item_parent", "773");
INSERT INTO `wp_postmeta` VALUES("678", "783", "_menu_item_object_id", "783");
INSERT INTO `wp_postmeta` VALUES("679", "783", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("680", "783", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("681", "783", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("682", "783", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("683", "783", "_menu_item_url", "https://themes.wpnovin.com/King/Main/big-hero-6-official-teaser-trailer/");
INSERT INTO `wp_postmeta` VALUES("684", "783", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("685", "783", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("686", "786", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("687", "786", "_menu_item_menu_item_parent", "773");
INSERT INTO `wp_postmeta` VALUES("688", "786", "_menu_item_object_id", "786");
INSERT INTO `wp_postmeta` VALUES("689", "786", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("690", "786", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("691", "786", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("692", "786", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("693", "786", "_menu_item_url", "https://themes.wpnovin.com/King/Main/vimeo-johnny-express/");
INSERT INTO `wp_postmeta` VALUES("694", "786", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("695", "786", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("698", "20", "video-url", "https://www.youtube.com/watch?v=OvgyXKDXdZY");
INSERT INTO `wp_postmeta` VALUES("699", "20", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("700", "20", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("701", "20", "_post_views", "172");
INSERT INTO `wp_postmeta` VALUES("702", "20", "_oembed_90e60e8b502f742cbdb884739e81ce1b", "<iframe width=\"640\" height=\"360\" src=\"https://www.youtube.com/embed/OvgyXKDXdZY?feature=oembed\" frameborder=\"0\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("703", "20", "_oembed_time_90e60e8b502f742cbdb884739e81ce1b", "1484667239");
INSERT INTO `wp_postmeta` VALUES("704", "20", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("705", "20", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("706", "20", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("707", "20", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("708", "20", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("709", "20", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("710", "20", "_thumbnail_id", "966");
INSERT INTO `wp_postmeta` VALUES("711", "20", "king_reaction_wow", "1");
INSERT INTO `wp_postmeta` VALUES("712", "20", "_oembed_ebc53e07e0e8376982840cb502ee1f4c", "{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("713", "20", "video-url", "https://www.youtube.com/watch?v=OvgyXKDXdZY");
INSERT INTO `wp_postmeta` VALUES("714", "20", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("715", "20", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("716", "20", "_post_views", "172");
INSERT INTO `wp_postmeta` VALUES("717", "20", "_oembed_90e60e8b502f742cbdb884739e81ce1b", "<iframe width=\"640\" height=\"360\" src=\"https://www.youtube.com/embed/OvgyXKDXdZY?feature=oembed\" frameborder=\"0\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("718", "20", "_oembed_time_90e60e8b502f742cbdb884739e81ce1b", "1484667239");
INSERT INTO `wp_postmeta` VALUES("719", "20", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("720", "20", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("721", "20", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("722", "20", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("723", "20", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("724", "20", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("725", "20", "_thumbnail_id", "966");
INSERT INTO `wp_postmeta` VALUES("726", "20", "king_reaction_wow", "1");
INSERT INTO `wp_postmeta` VALUES("727", "20", "_oembed_ebc53e07e0e8376982840cb502ee1f4c", "{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("728", "20", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("729", "20", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("730", "20", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("731", "20", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("732", "20", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("733", "20", "_post_like_count", "");
INSERT INTO `wp_postmeta` VALUES("734", "20", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("735", "20", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("736", "20", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("737", "20", "video_template", "video-template-3");
INSERT INTO `wp_postmeta` VALUES("738", "20", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("739", "22", "_wp_page_template", "king_page_hot.php");
INSERT INTO `wp_postmeta` VALUES("740", "22", "_wp_page_template", "king_page_hot.php");
INSERT INTO `wp_postmeta` VALUES("741", "25", "_wp_page_template", "king_page_trend.php");
INSERT INTO `wp_postmeta` VALUES("742", "25", "_wp_page_template", "king_page_trend.php");
INSERT INTO `wp_postmeta` VALUES("743", "28", "_wp_page_template", "king_page_users.php");
INSERT INTO `wp_postmeta` VALUES("744", "28", "_wp_page_template", "king_page_users.php");
INSERT INTO `wp_postmeta` VALUES("745", "95", "_wp_page_template", "king_page_categories.php");
INSERT INTO `wp_postmeta` VALUES("746", "95", "_wp_page_template", "king_page_categories.php");
INSERT INTO `wp_postmeta` VALUES("747", "98", "_wp_page_template", "king_page_nsfw.php");
INSERT INTO `wp_postmeta` VALUES("748", "98", "_wp_page_template", "king_page_nsfw.php");
INSERT INTO `wp_postmeta` VALUES("749", "105", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("750", "105", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("751", "469", "_wp_page_template", "king_page_reactions.php");
INSERT INTO `wp_postmeta` VALUES("752", "493", "_wp_page_template", "king_page_badges.php");
INSERT INTO `wp_postmeta` VALUES("753", "522", "_wp_page_template", "king_page_categories_2.php");
INSERT INTO `wp_postmeta` VALUES("754", "617", "_wp_page_template", "king_page_users_2.php");
INSERT INTO `wp_postmeta` VALUES("755", "789", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("756", "789", "_menu_item_menu_item_parent", "773");
INSERT INTO `wp_postmeta` VALUES("757", "789", "_menu_item_object_id", "789");
INSERT INTO `wp_postmeta` VALUES("758", "789", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("759", "789", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("760", "789", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("761", "789", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("762", "789", "_menu_item_url", "https://themes.wpnovin.com/King/Main/vimeo-alma/");
INSERT INTO `wp_postmeta` VALUES("763", "789", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("764", "789", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("765", "790", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("766", "790", "_menu_item_menu_item_parent", "773");
INSERT INTO `wp_postmeta` VALUES("767", "790", "_menu_item_object_id", "790");
INSERT INTO `wp_postmeta` VALUES("768", "790", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("769", "790", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("770", "790", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("771", "790", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("772", "790", "_menu_item_url", "https://themes.wpnovin.com/King/Main/one-more-beer/");
INSERT INTO `wp_postmeta` VALUES("773", "790", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("774", "790", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("775", "791", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("776", "791", "_menu_item_menu_item_parent", "773");
INSERT INTO `wp_postmeta` VALUES("777", "791", "_menu_item_object_id", "791");
INSERT INTO `wp_postmeta` VALUES("778", "791", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("779", "791", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("780", "791", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("781", "791", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("782", "791", "_menu_item_url", "https://themes.wpnovin.com/King/Main/single-image-post/");
INSERT INTO `wp_postmeta` VALUES("783", "791", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("784", "791", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("785", "794", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("786", "794", "_menu_item_menu_item_parent", "773");
INSERT INTO `wp_postmeta` VALUES("787", "794", "_menu_item_object_id", "794");
INSERT INTO `wp_postmeta` VALUES("788", "794", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("789", "794", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("790", "794", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("791", "794", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("792", "794", "_menu_item_url", "https://themes.wpnovin.com/King/Main/multiple-images-gallery/");
INSERT INTO `wp_postmeta` VALUES("793", "794", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("794", "794", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("795", "799", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("796", "799", "_menu_item_menu_item_parent", "773");
INSERT INTO `wp_postmeta` VALUES("797", "799", "_menu_item_object_id", "799");
INSERT INTO `wp_postmeta` VALUES("798", "799", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("799", "799", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("800", "799", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("801", "799", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("802", "799", "_menu_item_url", "https://themes.wpnovin.com/King/Main/milky-way-mountain-image/");
INSERT INTO `wp_postmeta` VALUES("803", "799", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("804", "799", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("805", "829", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("806", "829", "_menu_item_menu_item_parent", "621");
INSERT INTO `wp_postmeta` VALUES("807", "829", "_menu_item_object_id", "829");
INSERT INTO `wp_postmeta` VALUES("808", "829", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("809", "829", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("810", "829", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("811", "829", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("812", "829", "_menu_item_url", "https://themes.wpnovin.com/King/Main/video-playlist/");
INSERT INTO `wp_postmeta` VALUES("813", "829", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("814", "829", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("815", "830", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("816", "830", "_menu_item_menu_item_parent", "623");
INSERT INTO `wp_postmeta` VALUES("817", "830", "_menu_item_object_id", "830");
INSERT INTO `wp_postmeta` VALUES("818", "830", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("819", "830", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("820", "830", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("821", "830", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("822", "830", "_menu_item_url", "https://themes.wpnovin.com/King/Main/breaking-me/");
INSERT INTO `wp_postmeta` VALUES("823", "830", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("824", "830", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("825", "831", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("826", "831", "_menu_item_menu_item_parent", "830");
INSERT INTO `wp_postmeta` VALUES("827", "831", "_menu_item_object_id", "831");
INSERT INTO `wp_postmeta` VALUES("828", "831", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("829", "831", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("830", "831", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("831", "831", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("832", "831", "_menu_item_url", "https://themes.wpnovin.com/King/Main/music-playlist/");
INSERT INTO `wp_postmeta` VALUES("833", "831", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("834", "831", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("841", "37", "video-url", "https://soundcloud.com/wizkhalifa/king-of-everything");
INSERT INTO `wp_postmeta` VALUES("842", "37", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("843", "37", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("844", "37", "_post_views", "228");
INSERT INTO `wp_postmeta` VALUES("845", "37", "_oembed_8ffeb977ded1dfe57cebf1f06c72d4f3", "<iframe width=\"640\" height=\"400\" scrolling=\"no\" frameborder=\"no\" src=\"https://w.soundcloud.com/player/?visual=true&url=https%3A%2F%2Fapi.soundcloud.com%2Ftracks%2F225890693&show_artwork=true&maxwidth=640&maxheight=960\"></iframe>");
INSERT INTO `wp_postmeta` VALUES("846", "37", "_oembed_time_8ffeb977ded1dfe57cebf1f06c72d4f3", "1484669844");
INSERT INTO `wp_postmeta` VALUES("847", "37", "_thumbnail_id", "59");
INSERT INTO `wp_postmeta` VALUES("848", "37", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("849", "37", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("850", "37", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("851", "37", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("852", "37", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("853", "37", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("854", "37", "video-url", "https://soundcloud.com/wizkhalifa/king-of-everything");
INSERT INTO `wp_postmeta` VALUES("855", "37", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("856", "37", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("857", "37", "_post_views", "228");
INSERT INTO `wp_postmeta` VALUES("858", "37", "_oembed_8ffeb977ded1dfe57cebf1f06c72d4f3", "<iframe width=\"640\" height=\"400\" scrolling=\"no\" frameborder=\"no\" src=\"https://w.soundcloud.com/player/?visual=true&url=https%3A%2F%2Fapi.soundcloud.com%2Ftracks%2F225890693&show_artwork=true&maxwidth=640&maxheight=960\"></iframe>");
INSERT INTO `wp_postmeta` VALUES("859", "37", "_oembed_time_8ffeb977ded1dfe57cebf1f06c72d4f3", "1484669844");
INSERT INTO `wp_postmeta` VALUES("860", "37", "_thumbnail_id", "59");
INSERT INTO `wp_postmeta` VALUES("861", "37", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("862", "37", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("863", "37", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("864", "37", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("865", "37", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("866", "37", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("869", "44", "images_post_0_images_image", "41");
INSERT INTO `wp_postmeta` VALUES("870", "44", "_images_post_0_images_image", "field_57e96d04b74a6");
INSERT INTO `wp_postmeta` VALUES("871", "44", "images_post_1_images_image", "42");
INSERT INTO `wp_postmeta` VALUES("872", "44", "_images_post_1_images_image", "field_57e96d04b74a6");
INSERT INTO `wp_postmeta` VALUES("873", "44", "images_post_2_images_image", "43");
INSERT INTO `wp_postmeta` VALUES("874", "44", "_images_post_2_images_image", "field_57e96d04b74a6");
INSERT INTO `wp_postmeta` VALUES("875", "44", "images_post", "3");
INSERT INTO `wp_postmeta` VALUES("876", "44", "_images_post", "field_57e96cc7b74a5");
INSERT INTO `wp_postmeta` VALUES("877", "44", "_thumbnail_id", "40");
INSERT INTO `wp_postmeta` VALUES("878", "44", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("879", "44", "_post_views", "394");
INSERT INTO `wp_postmeta` VALUES("880", "44", "_user_liked", "a:2:{s:6:\"user-1\";i:1;s:7:\"user-52\";i:52;}");
INSERT INTO `wp_postmeta` VALUES("881", "44", "_post_like_count", "2");
INSERT INTO `wp_postmeta` VALUES("882", "44", "_post_like_modified", "2017-04-15 23:29:37");
INSERT INTO `wp_postmeta` VALUES("883", "44", "images_lists_0_images_list", "134");
INSERT INTO `wp_postmeta` VALUES("884", "44", "_images_lists_0_images_list", "field_58bf2f96ed6d4");
INSERT INTO `wp_postmeta` VALUES("885", "44", "images_lists_1_images_list", "136");
INSERT INTO `wp_postmeta` VALUES("886", "44", "_images_lists_1_images_list", "field_58bf2f96ed6d4");
INSERT INTO `wp_postmeta` VALUES("887", "44", "images_lists_2_images_list", "137");
INSERT INTO `wp_postmeta` VALUES("888", "44", "_images_lists_2_images_list", "field_58bf2f96ed6d4");
INSERT INTO `wp_postmeta` VALUES("889", "44", "images_lists", "3");
INSERT INTO `wp_postmeta` VALUES("890", "44", "_images_lists", "field_58bf2f79ed6d3");
INSERT INTO `wp_postmeta` VALUES("891", "44", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("892", "44", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("893", "44", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("894", "44", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("895", "44", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("896", "44", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("897", "44", "king_reaction_haha", "1");
INSERT INTO `wp_postmeta` VALUES("898", "44", "images_post_0_images_image", "41");
INSERT INTO `wp_postmeta` VALUES("899", "44", "_images_post_0_images_image", "field_57e96d04b74a6");
INSERT INTO `wp_postmeta` VALUES("900", "44", "images_post_1_images_image", "42");
INSERT INTO `wp_postmeta` VALUES("901", "44", "_images_post_1_images_image", "field_57e96d04b74a6");
INSERT INTO `wp_postmeta` VALUES("902", "44", "images_post_2_images_image", "43");
INSERT INTO `wp_postmeta` VALUES("903", "44", "_images_post_2_images_image", "field_57e96d04b74a6");
INSERT INTO `wp_postmeta` VALUES("904", "44", "images_post", "3");
INSERT INTO `wp_postmeta` VALUES("905", "44", "_images_post", "field_57e96cc7b74a5");
INSERT INTO `wp_postmeta` VALUES("906", "44", "_thumbnail_id", "40");
INSERT INTO `wp_postmeta` VALUES("907", "44", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("908", "44", "_post_views", "394");
INSERT INTO `wp_postmeta` VALUES("909", "44", "_user_liked", "a:2:{s:6:\"user-1\";i:1;s:7:\"user-52\";i:52;}");
INSERT INTO `wp_postmeta` VALUES("910", "44", "_post_like_count", "2");
INSERT INTO `wp_postmeta` VALUES("911", "44", "_post_like_modified", "2017-04-15 23:29:37");
INSERT INTO `wp_postmeta` VALUES("912", "44", "images_lists_0_images_list", "134");
INSERT INTO `wp_postmeta` VALUES("913", "44", "_images_lists_0_images_list", "field_58bf2f96ed6d4");
INSERT INTO `wp_postmeta` VALUES("914", "44", "images_lists_1_images_list", "136");
INSERT INTO `wp_postmeta` VALUES("915", "44", "_images_lists_1_images_list", "field_58bf2f96ed6d4");
INSERT INTO `wp_postmeta` VALUES("916", "44", "images_lists_2_images_list", "137");
INSERT INTO `wp_postmeta` VALUES("917", "44", "_images_lists_2_images_list", "field_58bf2f96ed6d4");
INSERT INTO `wp_postmeta` VALUES("918", "44", "images_lists", "3");
INSERT INTO `wp_postmeta` VALUES("919", "44", "_images_lists", "field_58bf2f79ed6d3");
INSERT INTO `wp_postmeta` VALUES("920", "44", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("921", "44", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("922", "44", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("923", "44", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("924", "44", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("925", "44", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("926", "44", "king_reaction_haha", "1");
INSERT INTO `wp_postmeta` VALUES("927", "44", "king_reaction_angry", "1");
INSERT INTO `wp_postmeta` VALUES("928", "44", "image_template", "image-template-1");
INSERT INTO `wp_postmeta` VALUES("929", "44", "_image_template", "field_5b5ce3de23ad5");
INSERT INTO `wp_postmeta` VALUES("930", "44", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("931", "44", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("932", "44", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("933", "44", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("934", "44", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("935", "44", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("938", "48", "video-url", "https://vimeo.com/94017018");
INSERT INTO `wp_postmeta` VALUES("939", "48", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("940", "48", "_thumbnail_id", "951");
INSERT INTO `wp_postmeta` VALUES("941", "48", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("942", "48", "_post_views", "487");
INSERT INTO `wp_postmeta` VALUES("943", "48", "_oembed_027710c911cbdc94b5e44b0e3fbfd258", "<iframe src=\"https://player.vimeo.com/video/94017018\" width=\"640\" height=\"360\" frameborder=\"0\" title=\"&quot;I am a...&quot;\" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("944", "48", "_oembed_time_027710c911cbdc94b5e44b0e3fbfd258", "1484740699");
INSERT INTO `wp_postmeta` VALUES("945", "48", "featured-post", "1");
INSERT INTO `wp_postmeta` VALUES("946", "48", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("947", "48", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("948", "48", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("949", "48", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("950", "48", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("951", "48", "king_reaction_wow", "1");
INSERT INTO `wp_postmeta` VALUES("952", "48", "video-url", "https://vimeo.com/94017018");
INSERT INTO `wp_postmeta` VALUES("953", "48", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("954", "48", "_thumbnail_id", "951");
INSERT INTO `wp_postmeta` VALUES("955", "48", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("956", "48", "_post_views", "487");
INSERT INTO `wp_postmeta` VALUES("957", "48", "_oembed_027710c911cbdc94b5e44b0e3fbfd258", "<iframe src=\"https://player.vimeo.com/video/94017018\" width=\"640\" height=\"360\" frameborder=\"0\" title=\"&quot;I am a...&quot;\" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("958", "48", "_oembed_time_027710c911cbdc94b5e44b0e3fbfd258", "1484740699");
INSERT INTO `wp_postmeta` VALUES("959", "48", "featured-post", "1");
INSERT INTO `wp_postmeta` VALUES("960", "48", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("961", "48", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("962", "48", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("963", "48", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("964", "48", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("965", "48", "king_reaction_wow", "1");
INSERT INTO `wp_postmeta` VALUES("966", "48", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("967", "48", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("968", "48", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("969", "48", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("970", "48", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("971", "48", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("972", "48", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("973", "48", "_post_like_count", "");
INSERT INTO `wp_postmeta` VALUES("974", "48", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("975", "48", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("976", "48", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("977", "48", "video_template", "");
INSERT INTO `wp_postmeta` VALUES("978", "48", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("981", "50", "video-url", "https://soundcloud.com/henri-pfr/novo-amor-from-gold-henri-pfr-remix");
INSERT INTO `wp_postmeta` VALUES("982", "50", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("983", "50", "_thumbnail_id", "51");
INSERT INTO `wp_postmeta` VALUES("984", "50", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("985", "50", "_post_views", "281");
INSERT INTO `wp_postmeta` VALUES("986", "50", "_oembed_a0a9babfae41c2fa2f0dac094f49968e", "<iframe width=\"640\" height=\"400\" scrolling=\"no\" frameborder=\"no\" src=\"https://w.soundcloud.com/player/?visual=true&url=https%3A%2F%2Fapi.soundcloud.com%2Ftracks%2F170901885&show_artwork=true&maxwidth=640&maxheight=960\"></iframe>");
INSERT INTO `wp_postmeta` VALUES("987", "50", "_oembed_time_a0a9babfae41c2fa2f0dac094f49968e", "1484740873");
INSERT INTO `wp_postmeta` VALUES("988", "50", "_user_liked", "a:2:{s:7:\"user-11\";i:11;s:7:\"user-87\";i:87;}");
INSERT INTO `wp_postmeta` VALUES("989", "50", "_post_like_count", "2");
INSERT INTO `wp_postmeta` VALUES("990", "50", "_post_like_modified", "2017-04-18 10:20:52");
INSERT INTO `wp_postmeta` VALUES("991", "50", "king_reaction_wow", "1");
INSERT INTO `wp_postmeta` VALUES("992", "50", "video-url", "https://soundcloud.com/henri-pfr/novo-amor-from-gold-henri-pfr-remix");
INSERT INTO `wp_postmeta` VALUES("993", "50", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("994", "50", "_thumbnail_id", "51");
INSERT INTO `wp_postmeta` VALUES("995", "50", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("996", "50", "_post_views", "281");
INSERT INTO `wp_postmeta` VALUES("997", "50", "_oembed_a0a9babfae41c2fa2f0dac094f49968e", "<iframe width=\"640\" height=\"400\" scrolling=\"no\" frameborder=\"no\" src=\"https://w.soundcloud.com/player/?visual=true&url=https%3A%2F%2Fapi.soundcloud.com%2Ftracks%2F170901885&show_artwork=true&maxwidth=640&maxheight=960\"></iframe>");
INSERT INTO `wp_postmeta` VALUES("998", "50", "_oembed_time_a0a9babfae41c2fa2f0dac094f49968e", "1484740873");
INSERT INTO `wp_postmeta` VALUES("999", "50", "_user_liked", "a:2:{s:7:\"user-11\";i:11;s:7:\"user-87\";i:87;}");
INSERT INTO `wp_postmeta` VALUES("1000", "50", "_post_like_count", "2");
INSERT INTO `wp_postmeta` VALUES("1001", "50", "_post_like_modified", "2017-04-18 10:20:52");
INSERT INTO `wp_postmeta` VALUES("1002", "50", "king_reaction_wow", "1");
INSERT INTO `wp_postmeta` VALUES("1003", "50", "king_reaction_love", "1");
INSERT INTO `wp_postmeta` VALUES("1004", "50", "king_reaction_like", "1");
INSERT INTO `wp_postmeta` VALUES("1007", "57", "list_post_0_list_title", "“Assume that you can get anyone to fall for you if you want them to.”");
INSERT INTO `wp_postmeta` VALUES("1008", "57", "_list_post_0_list_title", "field_57d31a5d4ee93");
INSERT INTO `wp_postmeta` VALUES("1009", "57", "list_post_0_list_image", "52");
INSERT INTO `wp_postmeta` VALUES("1010", "57", "_list_post_0_list_image", "field_57d31a314ee92");
INSERT INTO `wp_postmeta` VALUES("1011", "57", "list_post_0_list_media", "");
INSERT INTO `wp_postmeta` VALUES("1012", "57", "_list_post_0_list_media", "field_57d32ff383c0b");
INSERT INTO `wp_postmeta` VALUES("1013", "57", "list_post_0_list_content", "“It might not be true, but you should go into every date with that assumption, instead of worrying about whether or not the guy is into you.” –kristencarol");
INSERT INTO `wp_postmeta` VALUES("1014", "57", "_list_post_0_list_content", "field_57d31a724ee94");
INSERT INTO `wp_postmeta` VALUES("1015", "57", "list_post_1_list_title", "“Making the first move is terrifying but it will be the most awesome terrifying thing ever.”");
INSERT INTO `wp_postmeta` VALUES("1016", "57", "_list_post_1_list_title", "field_57d31a5d4ee93");
INSERT INTO `wp_postmeta` VALUES("1017", "57", "list_post_1_list_image", "53");
INSERT INTO `wp_postmeta` VALUES("1018", "57", "_list_post_1_list_image", "field_57d31a314ee92");
INSERT INTO `wp_postmeta` VALUES("1019", "57", "list_post_1_list_media", "");
INSERT INTO `wp_postmeta` VALUES("1020", "57", "_list_post_1_list_media", "field_57d32ff383c0b");
INSERT INTO `wp_postmeta` VALUES("1021", "57", "list_post_1_list_content", "");
INSERT INTO `wp_postmeta` VALUES("1022", "57", "_list_post_1_list_content", "field_57d31a724ee94");
INSERT INTO `wp_postmeta` VALUES("1023", "57", "list_post_2_list_title", "“The best pick up line in the world is ‘Hi, I’m (insert your name here).’”");
INSERT INTO `wp_postmeta` VALUES("1024", "57", "_list_post_2_list_title", "field_57d31a5d4ee93");
INSERT INTO `wp_postmeta` VALUES("1025", "57", "list_post_2_list_image", "54");
INSERT INTO `wp_postmeta` VALUES("1026", "57", "_list_post_2_list_image", "field_57d31a314ee92");
INSERT INTO `wp_postmeta` VALUES("1027", "57", "list_post_2_list_media", "");
INSERT INTO `wp_postmeta` VALUES("1028", "57", "_list_post_2_list_media", "field_57d32ff383c0b");
INSERT INTO `wp_postmeta` VALUES("1029", "57", "list_post_2_list_content", "");
INSERT INTO `wp_postmeta` VALUES("1030", "57", "_list_post_2_list_content", "field_57d31a724ee94");
INSERT INTO `wp_postmeta` VALUES("1031", "57", "list_post_3_list_title", "Believe people’s actions, not their words.");
INSERT INTO `wp_postmeta` VALUES("1032", "57", "_list_post_3_list_title", "field_57d31a5d4ee93");
INSERT INTO `wp_postmeta` VALUES("1033", "57", "list_post_3_list_image", "55");
INSERT INTO `wp_postmeta` VALUES("1034", "57", "_list_post_3_list_image", "field_57d31a314ee92");
INSERT INTO `wp_postmeta` VALUES("1035", "57", "list_post_3_list_media", "");
INSERT INTO `wp_postmeta` VALUES("1036", "57", "_list_post_3_list_media", "field_57d32ff383c0b");
INSERT INTO `wp_postmeta` VALUES("1037", "57", "list_post_3_list_content", "“If he/she’s not contacting you, or playing games, or being flaky, etc., it’s pretty clear what they actually think, despite what they may have said.” –Mcfly7719");
INSERT INTO `wp_postmeta` VALUES("1038", "57", "_list_post_3_list_content", "field_57d31a724ee94");
INSERT INTO `wp_postmeta` VALUES("1039", "57", "list_post_4_list_title", "And don’t feel like you need to change for anyone.");
INSERT INTO `wp_postmeta` VALUES("1040", "57", "_list_post_4_list_title", "field_57d31a5d4ee93");
INSERT INTO `wp_postmeta` VALUES("1041", "57", "list_post_4_list_image", "56");
INSERT INTO `wp_postmeta` VALUES("1042", "57", "_list_post_4_list_image", "field_57d31a314ee92");
INSERT INTO `wp_postmeta` VALUES("1043", "57", "list_post_4_list_media", "");
INSERT INTO `wp_postmeta` VALUES("1044", "57", "_list_post_4_list_media", "field_57d32ff383c0b");
INSERT INTO `wp_postmeta` VALUES("1045", "57", "list_post_4_list_content", "");
INSERT INTO `wp_postmeta` VALUES("1046", "57", "_list_post_4_list_content", "field_57d31a724ee94");
INSERT INTO `wp_postmeta` VALUES("1047", "57", "list_post", "5");
INSERT INTO `wp_postmeta` VALUES("1048", "57", "_list_post", "field_57d3199b4ee91");
INSERT INTO `wp_postmeta` VALUES("1049", "57", "_thumbnail_id", "58");
INSERT INTO `wp_postmeta` VALUES("1050", "57", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1051", "57", "_post_views", "570");
INSERT INTO `wp_postmeta` VALUES("1052", "57", "news_list_items_0_news_list_title", " “Assume that you can get anyone to fall for you if you want them to.”");
INSERT INTO `wp_postmeta` VALUES("1053", "57", "_news_list_items_0_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("1054", "57", "news_list_items_0_news_image_or_video", "0");
INSERT INTO `wp_postmeta` VALUES("1055", "57", "_news_list_items_0_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("1056", "57", "news_list_items_0_news_list_image", "139");
INSERT INTO `wp_postmeta` VALUES("1057", "57", "_news_list_items_0_news_list_image", "field_58bddb82f7501");
INSERT INTO `wp_postmeta` VALUES("1058", "57", "news_list_items_0_news_list_content", "“It might not be true, but you should go into every date with that assumption, instead of worrying about whether or not the guy is into you.” –kristencarol");
INSERT INTO `wp_postmeta` VALUES("1059", "57", "_news_list_items_0_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("1060", "57", "news_list_items_1_news_list_title", "“Making the first move is terrifying but it will be the most awesome terrifying thing ever.”");
INSERT INTO `wp_postmeta` VALUES("1061", "57", "_news_list_items_1_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("1062", "57", "news_list_items_1_news_image_or_video", "0");
INSERT INTO `wp_postmeta` VALUES("1063", "57", "_news_list_items_1_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("1064", "57", "news_list_items_1_news_list_image", "140");
INSERT INTO `wp_postmeta` VALUES("1065", "57", "_news_list_items_1_news_list_image", "field_58bddb82f7501");
INSERT INTO `wp_postmeta` VALUES("1066", "57", "news_list_items_1_news_list_content", "");
INSERT INTO `wp_postmeta` VALUES("1067", "57", "_news_list_items_1_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("1068", "57", "news_list_items_2_news_list_title", "“The best pick up line in the world is ‘Hi, I’m (insert your name here).’”");
INSERT INTO `wp_postmeta` VALUES("1069", "57", "_news_list_items_2_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("1070", "57", "news_list_items_2_news_image_or_video", "0");
INSERT INTO `wp_postmeta` VALUES("1071", "57", "_news_list_items_2_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("1072", "57", "news_list_items_2_news_list_image", "141");
INSERT INTO `wp_postmeta` VALUES("1073", "57", "_news_list_items_2_news_list_image", "field_58bddb82f7501");
INSERT INTO `wp_postmeta` VALUES("1074", "57", "news_list_items_2_news_list_content", "");
INSERT INTO `wp_postmeta` VALUES("1075", "57", "_news_list_items_2_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("1076", "57", "news_list_items_3_news_list_title", "Believe people’s actions, not their words.");
INSERT INTO `wp_postmeta` VALUES("1077", "57", "_news_list_items_3_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("1078", "57", "news_list_items_3_news_image_or_video", "0");
INSERT INTO `wp_postmeta` VALUES("1079", "57", "_news_list_items_3_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("1080", "57", "news_list_items_3_news_list_image", "142");
INSERT INTO `wp_postmeta` VALUES("1081", "57", "_news_list_items_3_news_list_image", "field_58bddb82f7501");
INSERT INTO `wp_postmeta` VALUES("1082", "57", "news_list_items_3_news_list_content", "“If he/she’s not contacting you, or playing games, or being flaky, etc., it’s pretty clear what they actually think, despite what they may have said.” –Mcfly7719");
INSERT INTO `wp_postmeta` VALUES("1083", "57", "_news_list_items_3_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("1084", "57", "news_list_items_4_news_list_title", "And don’t feel like you need to change for anyone.");
INSERT INTO `wp_postmeta` VALUES("1085", "57", "_news_list_items_4_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("1086", "57", "news_list_items_4_news_image_or_video", "0");
INSERT INTO `wp_postmeta` VALUES("1087", "57", "_news_list_items_4_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("1088", "57", "news_list_items_4_news_list_image", "143");
INSERT INTO `wp_postmeta` VALUES("1089", "57", "_news_list_items_4_news_list_image", "field_58bddb82f7501");
INSERT INTO `wp_postmeta` VALUES("1090", "57", "news_list_items_4_news_list_content", "");
INSERT INTO `wp_postmeta` VALUES("1091", "57", "_news_list_items_4_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("1092", "57", "news_list_items", "5");
INSERT INTO `wp_postmeta` VALUES("1093", "57", "_news_list_items", "field_58bddb0df74fe");
INSERT INTO `wp_postmeta` VALUES("1094", "57", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("1095", "57", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("1096", "57", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("1097", "57", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("1098", "57", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("1099", "57", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("1100", "57", "_user_liked", "a:1:{s:8:\"user-122\";i:122;}");
INSERT INTO `wp_postmeta` VALUES("1101", "57", "_post_like_count", "1");
INSERT INTO `wp_postmeta` VALUES("1102", "57", "_post_like_modified", "2017-04-23 01:27:48");
INSERT INTO `wp_postmeta` VALUES("1103", "57", "king_reaction_like", "2");
INSERT INTO `wp_postmeta` VALUES("1104", "57", "king_reaction_sad", "3");
INSERT INTO `wp_postmeta` VALUES("1105", "57", "list_post_0_list_title", "“Assume that you can get anyone to fall for you if you want them to.”");
INSERT INTO `wp_postmeta` VALUES("1106", "57", "_list_post_0_list_title", "field_57d31a5d4ee93");
INSERT INTO `wp_postmeta` VALUES("1107", "57", "list_post_0_list_image", "52");
INSERT INTO `wp_postmeta` VALUES("1108", "57", "_list_post_0_list_image", "field_57d31a314ee92");
INSERT INTO `wp_postmeta` VALUES("1109", "57", "list_post_0_list_media", "");
INSERT INTO `wp_postmeta` VALUES("1110", "57", "_list_post_0_list_media", "field_57d32ff383c0b");
INSERT INTO `wp_postmeta` VALUES("1111", "57", "list_post_0_list_content", "“It might not be true, but you should go into every date with that assumption, instead of worrying about whether or not the guy is into you.” –kristencarol");
INSERT INTO `wp_postmeta` VALUES("1112", "57", "_list_post_0_list_content", "field_57d31a724ee94");
INSERT INTO `wp_postmeta` VALUES("1113", "57", "list_post_1_list_title", "“Making the first move is terrifying but it will be the most awesome terrifying thing ever.”");
INSERT INTO `wp_postmeta` VALUES("1114", "57", "_list_post_1_list_title", "field_57d31a5d4ee93");
INSERT INTO `wp_postmeta` VALUES("1115", "57", "list_post_1_list_image", "53");
INSERT INTO `wp_postmeta` VALUES("1116", "57", "_list_post_1_list_image", "field_57d31a314ee92");
INSERT INTO `wp_postmeta` VALUES("1117", "57", "list_post_1_list_media", "");
INSERT INTO `wp_postmeta` VALUES("1118", "57", "_list_post_1_list_media", "field_57d32ff383c0b");
INSERT INTO `wp_postmeta` VALUES("1119", "57", "list_post_1_list_content", "");
INSERT INTO `wp_postmeta` VALUES("1120", "57", "_list_post_1_list_content", "field_57d31a724ee94");
INSERT INTO `wp_postmeta` VALUES("1121", "57", "list_post_2_list_title", "“The best pick up line in the world is ‘Hi, I’m (insert your name here).’”");
INSERT INTO `wp_postmeta` VALUES("1122", "57", "_list_post_2_list_title", "field_57d31a5d4ee93");
INSERT INTO `wp_postmeta` VALUES("1123", "57", "list_post_2_list_image", "54");
INSERT INTO `wp_postmeta` VALUES("1124", "57", "_list_post_2_list_image", "field_57d31a314ee92");
INSERT INTO `wp_postmeta` VALUES("1125", "57", "list_post_2_list_media", "");
INSERT INTO `wp_postmeta` VALUES("1126", "57", "_list_post_2_list_media", "field_57d32ff383c0b");
INSERT INTO `wp_postmeta` VALUES("1127", "57", "list_post_2_list_content", "");
INSERT INTO `wp_postmeta` VALUES("1128", "57", "_list_post_2_list_content", "field_57d31a724ee94");
INSERT INTO `wp_postmeta` VALUES("1129", "57", "list_post_3_list_title", "Believe people’s actions, not their words.");
INSERT INTO `wp_postmeta` VALUES("1130", "57", "_list_post_3_list_title", "field_57d31a5d4ee93");
INSERT INTO `wp_postmeta` VALUES("1131", "57", "list_post_3_list_image", "55");
INSERT INTO `wp_postmeta` VALUES("1132", "57", "_list_post_3_list_image", "field_57d31a314ee92");
INSERT INTO `wp_postmeta` VALUES("1133", "57", "list_post_3_list_media", "");
INSERT INTO `wp_postmeta` VALUES("1134", "57", "_list_post_3_list_media", "field_57d32ff383c0b");
INSERT INTO `wp_postmeta` VALUES("1135", "57", "list_post_3_list_content", "“If he/she’s not contacting you, or playing games, or being flaky, etc., it’s pretty clear what they actually think, despite what they may have said.” –Mcfly7719");
INSERT INTO `wp_postmeta` VALUES("1136", "57", "_list_post_3_list_content", "field_57d31a724ee94");
INSERT INTO `wp_postmeta` VALUES("1137", "57", "list_post_4_list_title", "And don’t feel like you need to change for anyone.");
INSERT INTO `wp_postmeta` VALUES("1138", "57", "_list_post_4_list_title", "field_57d31a5d4ee93");
INSERT INTO `wp_postmeta` VALUES("1139", "57", "list_post_4_list_image", "56");
INSERT INTO `wp_postmeta` VALUES("1140", "57", "_list_post_4_list_image", "field_57d31a314ee92");
INSERT INTO `wp_postmeta` VALUES("1141", "57", "list_post_4_list_media", "");
INSERT INTO `wp_postmeta` VALUES("1142", "57", "_list_post_4_list_media", "field_57d32ff383c0b");
INSERT INTO `wp_postmeta` VALUES("1143", "57", "list_post_4_list_content", "");
INSERT INTO `wp_postmeta` VALUES("1144", "57", "_list_post_4_list_content", "field_57d31a724ee94");
INSERT INTO `wp_postmeta` VALUES("1145", "57", "list_post", "5");
INSERT INTO `wp_postmeta` VALUES("1146", "57", "_list_post", "field_57d3199b4ee91");
INSERT INTO `wp_postmeta` VALUES("1147", "57", "_thumbnail_id", "58");
INSERT INTO `wp_postmeta` VALUES("1148", "57", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1149", "57", "_post_views", "570");
INSERT INTO `wp_postmeta` VALUES("1150", "57", "news_list_items_0_news_list_title", " “Assume that you can get anyone to fall for you if you want them to.”");
INSERT INTO `wp_postmeta` VALUES("1151", "57", "_news_list_items_0_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("1152", "57", "news_list_items_0_news_image_or_video", "0");
INSERT INTO `wp_postmeta` VALUES("1153", "57", "_news_list_items_0_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("1154", "57", "news_list_items_0_news_list_image", "139");
INSERT INTO `wp_postmeta` VALUES("1155", "57", "_news_list_items_0_news_list_image", "field_58bddb82f7501");
INSERT INTO `wp_postmeta` VALUES("1156", "57", "news_list_items_0_news_list_content", "“It might not be true, but you should go into every date with that assumption, instead of worrying about whether or not the guy is into you.” –kristencarol");
INSERT INTO `wp_postmeta` VALUES("1157", "57", "_news_list_items_0_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("1158", "57", "news_list_items_1_news_list_title", "“Making the first move is terrifying but it will be the most awesome terrifying thing ever.”");
INSERT INTO `wp_postmeta` VALUES("1159", "57", "_news_list_items_1_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("1160", "57", "news_list_items_1_news_image_or_video", "0");
INSERT INTO `wp_postmeta` VALUES("1161", "57", "_news_list_items_1_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("1162", "57", "news_list_items_1_news_list_image", "140");
INSERT INTO `wp_postmeta` VALUES("1163", "57", "_news_list_items_1_news_list_image", "field_58bddb82f7501");
INSERT INTO `wp_postmeta` VALUES("1164", "57", "news_list_items_1_news_list_content", "");
INSERT INTO `wp_postmeta` VALUES("1165", "57", "_news_list_items_1_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("1166", "57", "news_list_items_2_news_list_title", "“The best pick up line in the world is ‘Hi, I’m (insert your name here).’”");
INSERT INTO `wp_postmeta` VALUES("1167", "57", "_news_list_items_2_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("1168", "57", "news_list_items_2_news_image_or_video", "0");
INSERT INTO `wp_postmeta` VALUES("1169", "57", "_news_list_items_2_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("1170", "57", "news_list_items_2_news_list_image", "141");
INSERT INTO `wp_postmeta` VALUES("1171", "57", "_news_list_items_2_news_list_image", "field_58bddb82f7501");
INSERT INTO `wp_postmeta` VALUES("1172", "57", "news_list_items_2_news_list_content", "");
INSERT INTO `wp_postmeta` VALUES("1173", "57", "_news_list_items_2_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("1174", "57", "news_list_items_3_news_list_title", "Believe people’s actions, not their words.");
INSERT INTO `wp_postmeta` VALUES("1175", "57", "_news_list_items_3_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("1176", "57", "news_list_items_3_news_image_or_video", "0");
INSERT INTO `wp_postmeta` VALUES("1177", "57", "_news_list_items_3_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("1178", "57", "news_list_items_3_news_list_image", "142");
INSERT INTO `wp_postmeta` VALUES("1179", "57", "_news_list_items_3_news_list_image", "field_58bddb82f7501");
INSERT INTO `wp_postmeta` VALUES("1180", "57", "news_list_items_3_news_list_content", "“If he/she’s not contacting you, or playing games, or being flaky, etc., it’s pretty clear what they actually think, despite what they may have said.” –Mcfly7719");
INSERT INTO `wp_postmeta` VALUES("1181", "57", "_news_list_items_3_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("1182", "57", "news_list_items_4_news_list_title", "And don’t feel like you need to change for anyone.");
INSERT INTO `wp_postmeta` VALUES("1183", "57", "_news_list_items_4_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("1184", "57", "news_list_items_4_news_image_or_video", "0");
INSERT INTO `wp_postmeta` VALUES("1185", "57", "_news_list_items_4_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("1186", "57", "news_list_items_4_news_list_image", "143");
INSERT INTO `wp_postmeta` VALUES("1187", "57", "_news_list_items_4_news_list_image", "field_58bddb82f7501");
INSERT INTO `wp_postmeta` VALUES("1188", "57", "news_list_items_4_news_list_content", "");
INSERT INTO `wp_postmeta` VALUES("1189", "57", "_news_list_items_4_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("1190", "57", "news_list_items", "5");
INSERT INTO `wp_postmeta` VALUES("1191", "57", "_news_list_items", "field_58bddb0df74fe");
INSERT INTO `wp_postmeta` VALUES("1192", "57", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("1193", "57", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("1194", "57", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("1195", "57", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("1196", "57", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("1197", "57", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("1198", "57", "_user_liked", "a:1:{s:8:\"user-122\";i:122;}");
INSERT INTO `wp_postmeta` VALUES("1199", "57", "_post_like_count", "1");
INSERT INTO `wp_postmeta` VALUES("1200", "57", "_post_like_modified", "2017-04-23 01:27:48");
INSERT INTO `wp_postmeta` VALUES("1201", "57", "king_reaction_like", "2");
INSERT INTO `wp_postmeta` VALUES("1202", "57", "king_reaction_sad", "3");
INSERT INTO `wp_postmeta` VALUES("1203", "57", "king_reaction_wow", "1");
INSERT INTO `wp_postmeta` VALUES("1204", "57", "king_reaction_angry", "1");
INSERT INTO `wp_postmeta` VALUES("1205", "57", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("1206", "57", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("1207", "57", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("1208", "57", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("1209", "57", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("1210", "57", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("1211", "57", "post_template", "template-6");
INSERT INTO `wp_postmeta` VALUES("1212", "57", "_post_template", "field_5b5b94f0474bd");
INSERT INTO `wp_postmeta` VALUES("1213", "57", "king_reaction_love", "2");
INSERT INTO `wp_postmeta` VALUES("1216", "68", "video-url", "https://vimeo.com/94502406");
INSERT INTO `wp_postmeta` VALUES("1217", "68", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("1218", "68", "_thumbnail_id", "948");
INSERT INTO `wp_postmeta` VALUES("1219", "68", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1220", "68", "_post_views", "373");
INSERT INTO `wp_postmeta` VALUES("1221", "68", "_oembed_5f3c3601fadc939f5bd9c34858bc31d1", "<iframe src=\"https://player.vimeo.com/video/94502406\" width=\"640\" height=\"360\" frameborder=\"0\" title=\"JohnnyExpress\" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1222", "68", "_oembed_time_5f3c3601fadc939f5bd9c34858bc31d1", "1485005196");
INSERT INTO `wp_postmeta` VALUES("1223", "68", "video-url", "https://vimeo.com/94502406");
INSERT INTO `wp_postmeta` VALUES("1224", "68", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("1225", "68", "_thumbnail_id", "948");
INSERT INTO `wp_postmeta` VALUES("1226", "68", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1227", "68", "_post_views", "373");
INSERT INTO `wp_postmeta` VALUES("1228", "68", "_oembed_5f3c3601fadc939f5bd9c34858bc31d1", "<iframe src=\"https://player.vimeo.com/video/94502406\" width=\"640\" height=\"360\" frameborder=\"0\" title=\"JohnnyExpress\" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1229", "68", "_oembed_time_5f3c3601fadc939f5bd9c34858bc31d1", "1485005196");
INSERT INTO `wp_postmeta` VALUES("1230", "68", "king_reaction_love", "6");
INSERT INTO `wp_postmeta` VALUES("1231", "68", "king_reaction_haha", "2");
INSERT INTO `wp_postmeta` VALUES("1232", "68", "king_reaction_wow", "1");
INSERT INTO `wp_postmeta` VALUES("1233", "68", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("1234", "68", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("1235", "68", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("1236", "68", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("1237", "68", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("1238", "68", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("1239", "68", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("1240", "68", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("1241", "68", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("1242", "68", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("1243", "68", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("1244", "68", "_post_like_count", "");
INSERT INTO `wp_postmeta` VALUES("1245", "68", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("1246", "68", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("1247", "68", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("1248", "68", "video_template", "video-template-2");
INSERT INTO `wp_postmeta` VALUES("1249", "68", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("1252", "70", "video-url", "https://vimeo.com/50522981");
INSERT INTO `wp_postmeta` VALUES("1253", "70", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("1254", "70", "_thumbnail_id", "71");
INSERT INTO `wp_postmeta` VALUES("1255", "70", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1256", "70", "_post_views", "1199");
INSERT INTO `wp_postmeta` VALUES("1257", "70", "_oembed_77e4fc49200a7338902f3d2b3deff4f3", "<iframe src=\"https://player.vimeo.com/video/50522981\" width=\"640\" height=\"346\" frameborder=\"0\" title=\"One More Beer!\" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1258", "70", "_oembed_time_77e4fc49200a7338902f3d2b3deff4f3", "1485005369");
INSERT INTO `wp_postmeta` VALUES("1259", "70", "featured-post", "1");
INSERT INTO `wp_postmeta` VALUES("1260", "70", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("1261", "70", "keep_trending", "1");
INSERT INTO `wp_postmeta` VALUES("1262", "70", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("1263", "70", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("1264", "70", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("1265", "70", "_user_liked", "a:7:{s:6:\"user-1\";i:1;s:7:\"user-14\";i:14;s:7:\"user-34\";i:34;s:7:\"user-78\";i:78;s:8:\"user-101\";i:101;s:8:\"user-124\";i:124;s:7:\"user-17\";i:17;}");
INSERT INTO `wp_postmeta` VALUES("1266", "70", "_post_like_count", "7");
INSERT INTO `wp_postmeta` VALUES("1267", "70", "_post_like_modified", "2020-05-09 19:18:31");
INSERT INTO `wp_postmeta` VALUES("1268", "70", "king_reaction_haha", "2");
INSERT INTO `wp_postmeta` VALUES("1269", "70", "video-url", "https://vimeo.com/50522981");
INSERT INTO `wp_postmeta` VALUES("1270", "70", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("1271", "70", "_thumbnail_id", "71");
INSERT INTO `wp_postmeta` VALUES("1272", "70", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1273", "70", "_post_views", "1199");
INSERT INTO `wp_postmeta` VALUES("1274", "70", "_oembed_77e4fc49200a7338902f3d2b3deff4f3", "<iframe src=\"https://player.vimeo.com/video/50522981\" width=\"640\" height=\"346\" frameborder=\"0\" title=\"One More Beer!\" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1275", "70", "_oembed_time_77e4fc49200a7338902f3d2b3deff4f3", "1485005369");
INSERT INTO `wp_postmeta` VALUES("1276", "70", "featured-post", "1");
INSERT INTO `wp_postmeta` VALUES("1277", "70", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("1278", "70", "keep_trending", "1");
INSERT INTO `wp_postmeta` VALUES("1279", "70", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("1280", "70", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("1281", "70", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("1282", "70", "_user_liked", "a:7:{s:6:\"user-1\";i:1;s:7:\"user-14\";i:14;s:7:\"user-34\";i:34;s:7:\"user-78\";i:78;s:8:\"user-101\";i:101;s:8:\"user-124\";i:124;s:7:\"user-17\";i:17;}");
INSERT INTO `wp_postmeta` VALUES("1283", "70", "_post_like_count", "7");
INSERT INTO `wp_postmeta` VALUES("1284", "70", "_post_like_modified", "2020-05-09 19:18:31");
INSERT INTO `wp_postmeta` VALUES("1285", "70", "king_reaction_haha", "2");
INSERT INTO `wp_postmeta` VALUES("1286", "70", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("1287", "70", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("1288", "70", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("1289", "70", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("1290", "70", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("1291", "70", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("1292", "70", "king_reaction_like", "10");
INSERT INTO `wp_postmeta` VALUES("1293", "70", "king_reaction_love", "3");
INSERT INTO `wp_postmeta` VALUES("1294", "70", "editors_choice", "1");
INSERT INTO `wp_postmeta` VALUES("1295", "70", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("1296", "70", "editors_note", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.");
INSERT INTO `wp_postmeta` VALUES("1297", "70", "_editors_note", "field_5c9bda8ad6b0c");
INSERT INTO `wp_postmeta` VALUES("1298", "70", "video_template", "");
INSERT INTO `wp_postmeta` VALUES("1299", "70", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("1300", "70", "king_reaction_sad", "4");
INSERT INTO `wp_postmeta` VALUES("1301", "70", "king_reaction_wow", "3");
INSERT INTO `wp_postmeta` VALUES("1302", "70", "king_reaction_angry", "1");
INSERT INTO `wp_postmeta` VALUES("1303", "70", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("1304", "70", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("1309", "74", "images_post", "0");
INSERT INTO `wp_postmeta` VALUES("1310", "74", "_images_post", "field_57e96cc7b74a5");
INSERT INTO `wp_postmeta` VALUES("1311", "74", "_thumbnail_id", "73");
INSERT INTO `wp_postmeta` VALUES("1312", "74", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1313", "74", "_post_views", "735");
INSERT INTO `wp_postmeta` VALUES("1314", "74", "_user_liked", "a:5:{s:6:\"user-1\";i:1;s:7:\"user-35\";i:35;s:7:\"user-43\";i:43;s:7:\"user-68\";i:68;s:8:\"user-114\";i:114;}");
INSERT INTO `wp_postmeta` VALUES("1315", "74", "_post_like_count", "5");
INSERT INTO `wp_postmeta` VALUES("1316", "74", "_post_like_modified", "2017-04-22 07:05:41");
INSERT INTO `wp_postmeta` VALUES("1317", "74", "king_reaction_love", "4");
INSERT INTO `wp_postmeta` VALUES("1318", "74", "king_reaction_angry", "1");
INSERT INTO `wp_postmeta` VALUES("1319", "74", "king_reaction_like", "2");
INSERT INTO `wp_postmeta` VALUES("1320", "74", "king_reaction_sad", "1");
INSERT INTO `wp_postmeta` VALUES("1321", "74", "images_post", "0");
INSERT INTO `wp_postmeta` VALUES("1322", "74", "_images_post", "field_57e96cc7b74a5");
INSERT INTO `wp_postmeta` VALUES("1323", "74", "_thumbnail_id", "73");
INSERT INTO `wp_postmeta` VALUES("1324", "74", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1325", "74", "_post_views", "735");
INSERT INTO `wp_postmeta` VALUES("1326", "74", "_user_liked", "a:5:{s:6:\"user-1\";i:1;s:7:\"user-35\";i:35;s:7:\"user-43\";i:43;s:7:\"user-68\";i:68;s:8:\"user-114\";i:114;}");
INSERT INTO `wp_postmeta` VALUES("1327", "74", "_post_like_count", "5");
INSERT INTO `wp_postmeta` VALUES("1328", "74", "_post_like_modified", "2017-04-22 07:05:41");
INSERT INTO `wp_postmeta` VALUES("1329", "74", "king_reaction_love", "4");
INSERT INTO `wp_postmeta` VALUES("1330", "74", "king_reaction_angry", "1");
INSERT INTO `wp_postmeta` VALUES("1331", "74", "king_reaction_like", "2");
INSERT INTO `wp_postmeta` VALUES("1332", "74", "king_reaction_sad", "1");
INSERT INTO `wp_postmeta` VALUES("1333", "74", "king_reaction_wow", "1");
INSERT INTO `wp_postmeta` VALUES("1334", "74", "king_reaction_haha", "1");
INSERT INTO `wp_postmeta` VALUES("1337", "75", "list_post", "0");
INSERT INTO `wp_postmeta` VALUES("1338", "75", "_list_post", "field_57d3199b4ee91");
INSERT INTO `wp_postmeta` VALUES("1339", "75", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1340", "75", "_post_views", "1559");
INSERT INTO `wp_postmeta` VALUES("1341", "75", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("1342", "75", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("1343", "75", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("1344", "75", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("1345", "75", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("1346", "75", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("1347", "75", "_user_liked", "a:9:{s:6:\"user-1\";i:1;s:7:\"user-10\";i:10;s:7:\"user-34\";i:34;s:7:\"user-45\";i:45;s:7:\"user-47\";i:47;s:7:\"user-48\";i:48;s:7:\"user-80\";i:80;s:7:\"user-88\";i:88;s:7:\"user-57\";i:57;}");
INSERT INTO `wp_postmeta` VALUES("1348", "75", "_post_like_count", "9");
INSERT INTO `wp_postmeta` VALUES("1349", "75", "_post_like_modified", "2019-03-17 13:43:14");
INSERT INTO `wp_postmeta` VALUES("1350", "75", "_thumbnail_id", "81");
INSERT INTO `wp_postmeta` VALUES("1351", "75", "king_reaction_like", "7");
INSERT INTO `wp_postmeta` VALUES("1352", "75", "king_reaction_love", "4");
INSERT INTO `wp_postmeta` VALUES("1353", "75", "king_reaction_wow", "3");
INSERT INTO `wp_postmeta` VALUES("1354", "75", "king_reaction_haha", "5");
INSERT INTO `wp_postmeta` VALUES("1355", "75", "king_reaction_angry", "3");
INSERT INTO `wp_postmeta` VALUES("1356", "75", "list_post", "0");
INSERT INTO `wp_postmeta` VALUES("1357", "75", "_list_post", "field_57d3199b4ee91");
INSERT INTO `wp_postmeta` VALUES("1358", "75", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1359", "75", "_post_views", "1559");
INSERT INTO `wp_postmeta` VALUES("1360", "75", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("1361", "75", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("1362", "75", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("1363", "75", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("1364", "75", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("1365", "75", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("1366", "75", "_user_liked", "a:9:{s:6:\"user-1\";i:1;s:7:\"user-10\";i:10;s:7:\"user-34\";i:34;s:7:\"user-45\";i:45;s:7:\"user-47\";i:47;s:7:\"user-48\";i:48;s:7:\"user-80\";i:80;s:7:\"user-88\";i:88;s:7:\"user-57\";i:57;}");
INSERT INTO `wp_postmeta` VALUES("1367", "75", "_post_like_count", "9");
INSERT INTO `wp_postmeta` VALUES("1368", "75", "_post_like_modified", "2019-03-17 13:43:14");
INSERT INTO `wp_postmeta` VALUES("1369", "75", "_thumbnail_id", "81");
INSERT INTO `wp_postmeta` VALUES("1370", "75", "king_reaction_like", "7");
INSERT INTO `wp_postmeta` VALUES("1371", "75", "king_reaction_love", "4");
INSERT INTO `wp_postmeta` VALUES("1372", "75", "king_reaction_wow", "3");
INSERT INTO `wp_postmeta` VALUES("1373", "75", "king_reaction_haha", "5");
INSERT INTO `wp_postmeta` VALUES("1374", "75", "king_reaction_angry", "3");
INSERT INTO `wp_postmeta` VALUES("1375", "75", "news_list_items", "");
INSERT INTO `wp_postmeta` VALUES("1376", "75", "_news_list_items", "field_58bddb0df74fe");
INSERT INTO `wp_postmeta` VALUES("1377", "75", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("1378", "75", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("1379", "75", "add_sponsor", "1");
INSERT INTO `wp_postmeta` VALUES("1380", "75", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("1381", "75", "post_sponsor_logo", "602");
INSERT INTO `wp_postmeta` VALUES("1382", "75", "_post_sponsor_logo", "field_5a568b7e056cb");
INSERT INTO `wp_postmeta` VALUES("1383", "75", "post_sponsor_link", "https://themes.wpnovin.com/King/Main");
INSERT INTO `wp_postmeta` VALUES("1384", "75", "_post_sponsor_link", "field_5a568bbe056cc");
INSERT INTO `wp_postmeta` VALUES("1385", "75", "post_sponsor_description", "نمونه پست اسپانسری");
INSERT INTO `wp_postmeta` VALUES("1386", "75", "_post_sponsor_description", "field_5a568be7056cd");
INSERT INTO `wp_postmeta` VALUES("1387", "75", "editors_choice", "1");
INSERT INTO `wp_postmeta` VALUES("1388", "75", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("1389", "75", "editors_note", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.");
INSERT INTO `wp_postmeta` VALUES("1390", "75", "_editors_note", "field_5c9bda8ad6b0c");
INSERT INTO `wp_postmeta` VALUES("1391", "75", "post_template", "");
INSERT INTO `wp_postmeta` VALUES("1392", "75", "_post_template", "field_5b5b94f0474bd");
INSERT INTO `wp_postmeta` VALUES("1395", "82", "video-url", "https://www.youtube.com/watch?v=Nud5WD_nUY8");
INSERT INTO `wp_postmeta` VALUES("1396", "82", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("1397", "82", "_post_views", "832");
INSERT INTO `wp_postmeta` VALUES("1398", "82", "_oembed_3e6746947a7023f8625c89791d96bd97", "<iframe width=\"640\" height=\"360\" src=\"https://www.youtube.com/embed/Nud5WD_nUY8?feature=oembed\" frameborder=\"0\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1399", "82", "_oembed_time_3e6746947a7023f8625c89791d96bd97", "1485177416");
INSERT INTO `wp_postmeta` VALUES("1400", "82", "_thumbnail_id", "84");
INSERT INTO `wp_postmeta` VALUES("1401", "82", "featured-post", "1");
INSERT INTO `wp_postmeta` VALUES("1402", "82", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("1403", "82", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("1404", "82", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("1405", "82", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("1406", "82", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("1407", "82", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1408", "82", "_user_liked", "a:2:{s:6:\"user-1\";i:1;s:7:\"user-14\";i:14;}");
INSERT INTO `wp_postmeta` VALUES("1409", "82", "_post_like_count", "2");
INSERT INTO `wp_postmeta` VALUES("1410", "82", "_post_like_modified", "2017-04-14 02:11:34");
INSERT INTO `wp_postmeta` VALUES("1411", "82", "king_reaction_haha", "2");
INSERT INTO `wp_postmeta` VALUES("1412", "82", "king_reaction_angry", "1");
INSERT INTO `wp_postmeta` VALUES("1413", "82", "video-url", "https://www.youtube.com/watch?v=Nud5WD_nUY8");
INSERT INTO `wp_postmeta` VALUES("1414", "82", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("1415", "82", "_post_views", "832");
INSERT INTO `wp_postmeta` VALUES("1416", "82", "_oembed_3e6746947a7023f8625c89791d96bd97", "<iframe width=\"640\" height=\"360\" src=\"https://www.youtube.com/embed/Nud5WD_nUY8?feature=oembed\" frameborder=\"0\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1417", "82", "_oembed_time_3e6746947a7023f8625c89791d96bd97", "1485177416");
INSERT INTO `wp_postmeta` VALUES("1418", "82", "_thumbnail_id", "84");
INSERT INTO `wp_postmeta` VALUES("1419", "82", "featured-post", "1");
INSERT INTO `wp_postmeta` VALUES("1420", "82", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("1421", "82", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("1422", "82", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("1423", "82", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("1424", "82", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("1425", "82", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1426", "82", "_user_liked", "a:2:{s:6:\"user-1\";i:1;s:7:\"user-14\";i:14;}");
INSERT INTO `wp_postmeta` VALUES("1427", "82", "_post_like_count", "2");
INSERT INTO `wp_postmeta` VALUES("1428", "82", "_post_like_modified", "2017-04-14 02:11:34");
INSERT INTO `wp_postmeta` VALUES("1429", "82", "king_reaction_haha", "2");
INSERT INTO `wp_postmeta` VALUES("1430", "82", "king_reaction_angry", "1");
INSERT INTO `wp_postmeta` VALUES("1431", "82", "king_reaction_sad", "1");
INSERT INTO `wp_postmeta` VALUES("1432", "82", "king_reaction_like", "1");
INSERT INTO `wp_postmeta` VALUES("1435", "88", "video-url", "https://vimeo.com/4749536");
INSERT INTO `wp_postmeta` VALUES("1436", "88", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("1437", "88", "nsfw_post", "1");
INSERT INTO `wp_postmeta` VALUES("1438", "88", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("1439", "88", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1440", "88", "_post_views", "329");
INSERT INTO `wp_postmeta` VALUES("1441", "88", "_oembed_e6f240f5e336fda0d88f1ba114d76135", "<iframe src=\"https://player.vimeo.com/video/4749536\" width=\"640\" height=\"360\" frameborder=\"0\" title=\"Alma\" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1442", "88", "_oembed_time_e6f240f5e336fda0d88f1ba114d76135", "1485200276");
INSERT INTO `wp_postmeta` VALUES("1443", "88", "_thumbnail_id", "90");
INSERT INTO `wp_postmeta` VALUES("1444", "88", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("1445", "88", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("1446", "88", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("1447", "88", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("1448", "88", "_user_liked", "a:6:{s:7:\"user-13\";i:13;s:7:\"user-23\";i:23;s:7:\"user-27\";i:27;s:7:\"user-42\";i:42;s:7:\"user-43\";i:43;s:7:\"user-49\";i:49;}");
INSERT INTO `wp_postmeta` VALUES("1449", "88", "_post_like_count", "6");
INSERT INTO `wp_postmeta` VALUES("1450", "88", "_post_like_modified", "2017-04-15 14:57:03");
INSERT INTO `wp_postmeta` VALUES("1451", "88", "king_reaction_love", "1");
INSERT INTO `wp_postmeta` VALUES("1452", "88", "king_reaction_haha", "1");
INSERT INTO `wp_postmeta` VALUES("1453", "88", "king_reaction_like", "1");
INSERT INTO `wp_postmeta` VALUES("1454", "88", "king_reaction_wow", "1");
INSERT INTO `wp_postmeta` VALUES("1455", "88", "king_reaction_sad", "4");
INSERT INTO `wp_postmeta` VALUES("1456", "88", "video-url", "https://vimeo.com/4749536");
INSERT INTO `wp_postmeta` VALUES("1457", "88", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("1458", "88", "nsfw_post", "1");
INSERT INTO `wp_postmeta` VALUES("1459", "88", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("1460", "88", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1461", "88", "_post_views", "329");
INSERT INTO `wp_postmeta` VALUES("1462", "88", "_oembed_e6f240f5e336fda0d88f1ba114d76135", "<iframe src=\"https://player.vimeo.com/video/4749536\" width=\"640\" height=\"360\" frameborder=\"0\" title=\"Alma\" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1463", "88", "_oembed_time_e6f240f5e336fda0d88f1ba114d76135", "1485200276");
INSERT INTO `wp_postmeta` VALUES("1464", "88", "_thumbnail_id", "90");
INSERT INTO `wp_postmeta` VALUES("1465", "88", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("1466", "88", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("1467", "88", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("1468", "88", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("1469", "88", "_user_liked", "a:6:{s:7:\"user-13\";i:13;s:7:\"user-23\";i:23;s:7:\"user-27\";i:27;s:7:\"user-42\";i:42;s:7:\"user-43\";i:43;s:7:\"user-49\";i:49;}");
INSERT INTO `wp_postmeta` VALUES("1470", "88", "_post_like_count", "6");
INSERT INTO `wp_postmeta` VALUES("1471", "88", "_post_like_modified", "2017-04-15 14:57:03");
INSERT INTO `wp_postmeta` VALUES("1472", "88", "king_reaction_love", "1");
INSERT INTO `wp_postmeta` VALUES("1473", "88", "king_reaction_haha", "1");
INSERT INTO `wp_postmeta` VALUES("1474", "88", "king_reaction_like", "1");
INSERT INTO `wp_postmeta` VALUES("1475", "88", "king_reaction_wow", "1");
INSERT INTO `wp_postmeta` VALUES("1476", "88", "king_reaction_sad", "4");
INSERT INTO `wp_postmeta` VALUES("1477", "88", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("1478", "88", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("1479", "88", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("1480", "88", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("1481", "88", "editors_note", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
INSERT INTO `wp_postmeta` VALUES("1482", "88", "_editors_note", "field_5c7a918e60d3c");
INSERT INTO `wp_postmeta` VALUES("1483", "88", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("1484", "88", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("1485", "88", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("1486", "88", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("1487", "88", "video_template", "video-template-1");
INSERT INTO `wp_postmeta` VALUES("1488", "88", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("1491", "418", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("1492", "418", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("1493", "418", "video_upload", "453");
INSERT INTO `wp_postmeta` VALUES("1494", "418", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("1495", "418", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("1496", "418", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("1497", "418", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("1498", "418", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("1499", "418", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("1500", "418", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("1501", "418", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("1502", "418", "_post_views", "239");
INSERT INTO `wp_postmeta` VALUES("1503", "418", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1504", "418", "_thumbnail_id", "459");
INSERT INTO `wp_postmeta` VALUES("1505", "418", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("1506", "418", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("1507", "418", "video_upload", "453");
INSERT INTO `wp_postmeta` VALUES("1508", "418", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("1509", "418", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("1510", "418", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("1511", "418", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("1512", "418", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("1513", "418", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("1514", "418", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("1515", "418", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("1516", "418", "_post_views", "239");
INSERT INTO `wp_postmeta` VALUES("1517", "418", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1518", "418", "_thumbnail_id", "459");
INSERT INTO `wp_postmeta` VALUES("1519", "418", "king_reaction_haha", "1");
INSERT INTO `wp_postmeta` VALUES("1520", "418", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("1521", "418", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("1522", "418", "editors_choice", "1");
INSERT INTO `wp_postmeta` VALUES("1523", "418", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("1524", "418", "editors_note", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.");
INSERT INTO `wp_postmeta` VALUES("1525", "418", "_editors_note", "field_5c9bda8ad6b0c");
INSERT INTO `wp_postmeta` VALUES("1526", "418", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("1527", "418", "_post_like_count", "1");
INSERT INTO `wp_postmeta` VALUES("1528", "418", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("1529", "418", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("1530", "418", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("1531", "418", "video_template", "");
INSERT INTO `wp_postmeta` VALUES("1532", "418", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("1533", "418", "king_reaction_love", "4");
INSERT INTO `wp_postmeta` VALUES("1534", "418", "king_reaction_like", "5");
INSERT INTO `wp_postmeta` VALUES("1535", "418", "_user_liked", "a:1:{s:7:\"user-17\";i:17;}");
INSERT INTO `wp_postmeta` VALUES("1536", "418", "_post_like_modified", "2020-05-09 19:38:50");
INSERT INTO `wp_postmeta` VALUES("1537", "418", "king_reaction_angry", "2");
INSERT INTO `wp_postmeta` VALUES("1538", "418", "king_reaction_sad", "1");
INSERT INTO `wp_postmeta` VALUES("1541", "445", "video-url", "");
INSERT INTO `wp_postmeta` VALUES("1542", "445", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("1543", "445", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("1544", "445", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("1545", "445", "video_upload", "461");
INSERT INTO `wp_postmeta` VALUES("1546", "445", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("1547", "445", "_thumbnail_id", "462");
INSERT INTO `wp_postmeta` VALUES("1548", "445", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("1549", "445", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1550", "445", "_post_views", "192");
INSERT INTO `wp_postmeta` VALUES("1551", "445", "_user_liked", "a:2:{s:6:\"user-1\";i:1;s:6:\"user-7\";i:7;}");
INSERT INTO `wp_postmeta` VALUES("1552", "445", "_post_like_count", "2");
INSERT INTO `wp_postmeta` VALUES("1553", "445", "_post_like_modified", "2020-02-24 21:31:37");
INSERT INTO `wp_postmeta` VALUES("1554", "445", "video-url", "");
INSERT INTO `wp_postmeta` VALUES("1555", "445", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("1556", "445", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("1557", "445", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("1558", "445", "video_upload", "461");
INSERT INTO `wp_postmeta` VALUES("1559", "445", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("1560", "445", "_thumbnail_id", "462");
INSERT INTO `wp_postmeta` VALUES("1561", "445", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("1562", "445", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1563", "445", "_post_views", "192");
INSERT INTO `wp_postmeta` VALUES("1564", "445", "_user_liked", "a:2:{s:6:\"user-1\";i:1;s:6:\"user-7\";i:7;}");
INSERT INTO `wp_postmeta` VALUES("1565", "445", "_post_like_count", "2");
INSERT INTO `wp_postmeta` VALUES("1566", "445", "_post_like_modified", "2020-02-24 21:31:37");
INSERT INTO `wp_postmeta` VALUES("1567", "445", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("1568", "445", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("1569", "445", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("1570", "445", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("1571", "445", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("1572", "445", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("1573", "445", "king_reaction_angry", "1");
INSERT INTO `wp_postmeta` VALUES("1576", "485", "_thumbnail_id", "747");
INSERT INTO `wp_postmeta` VALUES("1577", "485", "ad_link", "https://themes.wpnovin.com/King/Main");
INSERT INTO `wp_postmeta` VALUES("1578", "485", "_ad_link", "field_5a568932429f7");
INSERT INTO `wp_postmeta` VALUES("1579", "485", "ad_button_value", "همین حالا بخرید!");
INSERT INTO `wp_postmeta` VALUES("1580", "485", "_ad_button_value", "field_5a5688cf34274");
INSERT INTO `wp_postmeta` VALUES("1581", "485", "ad_extra_field", "تخفیف 70 درصدی");
INSERT INTO `wp_postmeta` VALUES("1582", "485", "_ad_extra_field", "field_5a59195facec4");
INSERT INTO `wp_postmeta` VALUES("1583", "485", "sponsored_text", "پست تبلیغاتی");
INSERT INTO `wp_postmeta` VALUES("1584", "485", "_sponsored_text", "field_5a5a7ec420b5a");
INSERT INTO `wp_postmeta` VALUES("1585", "485", "_post_views", "49");
INSERT INTO `wp_postmeta` VALUES("1586", "485", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1589", "643", "video-url", "https://vimeo.com/95844798");
INSERT INTO `wp_postmeta` VALUES("1590", "643", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("1591", "643", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1592", "643", "_post_views", "526");
INSERT INTO `wp_postmeta` VALUES("1593", "643", "_oembed_500f5cf3a06c38039c9d5f5d975110b6", "<iframe src=\"https://player.vimeo.com/video/95844798\" width=\"640\" height=\"360\" frameborder=\"0\" title=\"A rather lovely thing\" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1594", "643", "_oembed_time_500f5cf3a06c38039c9d5f5d975110b6", "1484513004");
INSERT INTO `wp_postmeta` VALUES("1595", "643", "_user_liked", "a:1:{s:6:\"user-1\";i:1;}");
INSERT INTO `wp_postmeta` VALUES("1596", "643", "_post_like_count", "1");
INSERT INTO `wp_postmeta` VALUES("1597", "643", "_post_like_modified", "2020-05-09 19:38:34");
INSERT INTO `wp_postmeta` VALUES("1598", "643", "featured-post", "1");
INSERT INTO `wp_postmeta` VALUES("1599", "643", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("1600", "643", "keep_trending", "1");
INSERT INTO `wp_postmeta` VALUES("1601", "643", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("1602", "643", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("1603", "643", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("1604", "643", "video-url", "https://vimeo.com/95844798");
INSERT INTO `wp_postmeta` VALUES("1605", "643", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("1606", "643", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1607", "643", "_post_views", "526");
INSERT INTO `wp_postmeta` VALUES("1608", "643", "_oembed_500f5cf3a06c38039c9d5f5d975110b6", "<iframe src=\"https://player.vimeo.com/video/95844798\" width=\"640\" height=\"360\" frameborder=\"0\" title=\"A rather lovely thing\" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1609", "643", "_oembed_time_500f5cf3a06c38039c9d5f5d975110b6", "1484513004");
INSERT INTO `wp_postmeta` VALUES("1610", "643", "_user_liked", "a:1:{s:6:\"user-1\";i:1;}");
INSERT INTO `wp_postmeta` VALUES("1611", "643", "_post_like_count", "1");
INSERT INTO `wp_postmeta` VALUES("1612", "643", "_post_like_modified", "2020-05-09 19:38:34");
INSERT INTO `wp_postmeta` VALUES("1613", "643", "featured-post", "1");
INSERT INTO `wp_postmeta` VALUES("1614", "643", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("1615", "643", "keep_trending", "1");
INSERT INTO `wp_postmeta` VALUES("1616", "643", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("1617", "643", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("1618", "643", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("1619", "643", "king_reaction_sad", "1");
INSERT INTO `wp_postmeta` VALUES("1620", "643", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("1621", "643", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("1622", "643", "editors_choice", "1");
INSERT INTO `wp_postmeta` VALUES("1623", "643", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("1624", "643", "editors_note", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.");
INSERT INTO `wp_postmeta` VALUES("1625", "643", "_editors_note", "field_5c9bda8ad6b0c");
INSERT INTO `wp_postmeta` VALUES("1626", "643", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("1627", "643", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("1628", "643", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("1629", "643", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("1630", "643", "video_template", "");
INSERT INTO `wp_postmeta` VALUES("1631", "643", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("1632", "643", "king_reaction_wow", "1");
INSERT INTO `wp_postmeta` VALUES("1633", "643", "king_reaction_love", "2");
INSERT INTO `wp_postmeta` VALUES("1634", "643", "_thumbnail_id", "671");
INSERT INTO `wp_postmeta` VALUES("1635", "643", "king_reaction_angry", "2");
INSERT INTO `wp_postmeta` VALUES("1636", "643", "king_reaction_like", "1");
INSERT INTO `wp_postmeta` VALUES("1639", "693", "_thumbnail_id", "694");
INSERT INTO `wp_postmeta` VALUES("1640", "693", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("1641", "693", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("1642", "693", "video-url", "https://vimeo.com/150522409");
INSERT INTO `wp_postmeta` VALUES("1643", "693", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("1644", "693", "featured-post", "1");
INSERT INTO `wp_postmeta` VALUES("1645", "693", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("1646", "693", "keep_trending", "1");
INSERT INTO `wp_postmeta` VALUES("1647", "693", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("1648", "693", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("1649", "693", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("1650", "693", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("1651", "693", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("1652", "693", "_post_views", "2687");
INSERT INTO `wp_postmeta` VALUES("1653", "693", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("1654", "693", "_post_like_count", "23");
INSERT INTO `wp_postmeta` VALUES("1655", "693", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("1656", "693", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("1657", "693", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("1658", "693", "video_template", "");
INSERT INTO `wp_postmeta` VALUES("1659", "693", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("1660", "693", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1661", "693", "king_reaction_angry", "1");
INSERT INTO `wp_postmeta` VALUES("1662", "693", "king_reaction_like", "5");
INSERT INTO `wp_postmeta` VALUES("1663", "693", "king_reaction_love", "2");
INSERT INTO `wp_postmeta` VALUES("1664", "693", "king_reaction_wow", "1");
INSERT INTO `wp_postmeta` VALUES("1665", "693", "king_reaction_sad", "3");
INSERT INTO `wp_postmeta` VALUES("1666", "693", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("1667", "693", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("1668", "693", "king_reaction_haha", "1");
INSERT INTO `wp_postmeta` VALUES("1671", "734", "images_lists_0_images_list", "730");
INSERT INTO `wp_postmeta` VALUES("1672", "734", "_images_lists_0_images_list", "field_58bf2f96ed6d4");
INSERT INTO `wp_postmeta` VALUES("1673", "734", "images_lists_1_images_list", "731");
INSERT INTO `wp_postmeta` VALUES("1674", "734", "_images_lists_1_images_list", "field_58bf2f96ed6d4");
INSERT INTO `wp_postmeta` VALUES("1675", "734", "images_lists_2_images_list", "732");
INSERT INTO `wp_postmeta` VALUES("1676", "734", "_images_lists_2_images_list", "field_58bf2f96ed6d4");
INSERT INTO `wp_postmeta` VALUES("1677", "734", "images_lists_3_images_list", "729");
INSERT INTO `wp_postmeta` VALUES("1678", "734", "_images_lists_3_images_list", "field_58bf2f96ed6d4");
INSERT INTO `wp_postmeta` VALUES("1679", "734", "images_lists_4_images_list", "733");
INSERT INTO `wp_postmeta` VALUES("1680", "734", "_images_lists_4_images_list", "field_58bf2f96ed6d4");
INSERT INTO `wp_postmeta` VALUES("1681", "734", "images_lists", "5");
INSERT INTO `wp_postmeta` VALUES("1682", "734", "_images_lists", "field_58bf2f79ed6d3");
INSERT INTO `wp_postmeta` VALUES("1683", "734", "_thumbnail_id", "819");
INSERT INTO `wp_postmeta` VALUES("1684", "734", "_post_views", "202");
INSERT INTO `wp_postmeta` VALUES("1685", "734", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1686", "734", "king_reaction_haha", "2");
INSERT INTO `wp_postmeta` VALUES("1687", "734", "king_reaction_love", "1");
INSERT INTO `wp_postmeta` VALUES("1690", "775", "news_list_items_0_news_list_title", "Twitter Video – Antelope Canyon");
INSERT INTO `wp_postmeta` VALUES("1691", "775", "_news_list_items_0_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("1692", "775", "news_list_items_0_news_image_or_video", "1");
INSERT INTO `wp_postmeta` VALUES("1693", "775", "_news_list_items_0_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("1694", "775", "news_list_items_0_news_list_media", "https://twitter.com/NatGeoTravel/status/934436537638436864?s=20");
INSERT INTO `wp_postmeta` VALUES("1695", "775", "_news_list_items_0_news_list_media", "field_58bddbb9f7502");
INSERT INTO `wp_postmeta` VALUES("1696", "775", "news_list_items_0_news_list_content", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
INSERT INTO `wp_postmeta` VALUES("1697", "775", "_news_list_items_0_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("1698", "775", "news_list_items_1_news_list_title", "Instagram Video Embed Flamingos ");
INSERT INTO `wp_postmeta` VALUES("1699", "775", "_news_list_items_1_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("1700", "775", "news_list_items_1_news_image_or_video", "1");
INSERT INTO `wp_postmeta` VALUES("1701", "775", "_news_list_items_1_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("1702", "775", "news_list_items_1_news_list_media", "https://www.instagram.com/p/CBeIxrqBd6X/?utm_source=ig_web_copy_link");
INSERT INTO `wp_postmeta` VALUES("1703", "775", "_news_list_items_1_news_list_media", "field_58bddbb9f7502");
INSERT INTO `wp_postmeta` VALUES("1704", "775", "news_list_items_1_news_list_content", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
INSERT INTO `wp_postmeta` VALUES("1705", "775", "_news_list_items_1_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("1706", "775", "news_list_items_2_news_list_title", "Instagram Post Embed");
INSERT INTO `wp_postmeta` VALUES("1707", "775", "_news_list_items_2_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("1708", "775", "news_list_items_2_news_image_or_video", "1");
INSERT INTO `wp_postmeta` VALUES("1709", "775", "_news_list_items_2_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("1710", "775", "news_list_items_2_news_list_media", "https://www.instagram.com/p/CBpFHeQK-nM/");
INSERT INTO `wp_postmeta` VALUES("1711", "775", "_news_list_items_2_news_list_media", "field_58bddbb9f7502");
INSERT INTO `wp_postmeta` VALUES("1712", "775", "news_list_items_2_news_list_content", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
INSERT INTO `wp_postmeta` VALUES("1713", "775", "_news_list_items_2_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("1714", "775", "news_list_items_3_news_list_title", "Seven Wonders Youtube");
INSERT INTO `wp_postmeta` VALUES("1715", "775", "_news_list_items_3_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("1716", "775", "news_list_items_3_news_image_or_video", "1");
INSERT INTO `wp_postmeta` VALUES("1717", "775", "_news_list_items_3_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("1718", "775", "news_list_items_3_news_list_media", "https://www.youtube.com/watch?v=hcCVe5MamN4");
INSERT INTO `wp_postmeta` VALUES("1719", "775", "_news_list_items_3_news_list_media", "field_58bddbb9f7502");
INSERT INTO `wp_postmeta` VALUES("1720", "775", "news_list_items_3_news_list_content", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
INSERT INTO `wp_postmeta` VALUES("1721", "775", "_news_list_items_3_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("1722", "775", "news_list_items_4_news_list_title", "Northern lights - Vimeo");
INSERT INTO `wp_postmeta` VALUES("1723", "775", "_news_list_items_4_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("1724", "775", "news_list_items_4_news_image_or_video", "1");
INSERT INTO `wp_postmeta` VALUES("1725", "775", "_news_list_items_4_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("1726", "775", "news_list_items_4_news_list_media", "https://vimeo.com/185472558");
INSERT INTO `wp_postmeta` VALUES("1727", "775", "_news_list_items_4_news_list_media", "field_58bddbb9f7502");
INSERT INTO `wp_postmeta` VALUES("1728", "775", "news_list_items_4_news_list_content", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
INSERT INTO `wp_postmeta` VALUES("1729", "775", "_news_list_items_4_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("1730", "775", "news_list_items_5_news_list_title", "Leopard Seals Play and Hunt - Facebook");
INSERT INTO `wp_postmeta` VALUES("1731", "775", "_news_list_items_5_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("1732", "775", "news_list_items_5_news_image_or_video", "1");
INSERT INTO `wp_postmeta` VALUES("1733", "775", "_news_list_items_5_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("1734", "775", "news_list_items_5_news_list_media", "https://www.facebook.com/natgeo/videos/2555654941353324/");
INSERT INTO `wp_postmeta` VALUES("1735", "775", "_news_list_items_5_news_list_media", "field_58bddbb9f7502");
INSERT INTO `wp_postmeta` VALUES("1736", "775", "news_list_items_5_news_list_content", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
INSERT INTO `wp_postmeta` VALUES("1737", "775", "_news_list_items_5_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("1738", "775", "news_list_items", "6");
INSERT INTO `wp_postmeta` VALUES("1739", "775", "_news_list_items", "field_58bddb0df74fe");
INSERT INTO `wp_postmeta` VALUES("1740", "775", "_thumbnail_id", "776");
INSERT INTO `wp_postmeta` VALUES("1741", "775", "_post_views", "208");
INSERT INTO `wp_postmeta` VALUES("1742", "775", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1743", "775", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("1744", "775", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("1745", "775", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("1746", "775", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("1747", "775", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("1748", "775", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("1749", "775", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("1750", "775", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("1751", "775", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("1752", "775", "_post_like_count", "");
INSERT INTO `wp_postmeta` VALUES("1753", "775", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("1754", "775", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("1755", "775", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("1756", "775", "post_template", "template-5");
INSERT INTO `wp_postmeta` VALUES("1757", "775", "_post_template", "field_5b5b94f0474bd");
INSERT INTO `wp_postmeta` VALUES("1758", "775", "_oembed_3b0a74f70bd2d8cdc75e65c605623d0a", "<blockquote class=\"instagram-media\" data-instgrm-captioned data-instgrm-permalink=\"https://www.instagram.com/p/CBeIxrqBd6X/?utm_source=ig_embed&amp;utm_campaign=loading\" data-instgrm-version=\"12\" style=\" background:#FFF; border:0; border-radius:3px; box-shadow:0 0 1px 0 rgba(0,0,0,0.5),0 1px 10px 0 rgba(0,0,0,0.15); margin: 1px; max-width:640px; min-width:326px; padding:0; width:99.375%; width:-webkit-calc(100% - 2px); width:calc(100% - 2px);\"><div style=\"padding:16px;\"> <a href=\"https://www.instagram.com/p/CBeIxrqBd6X/?utm_source=ig_embed&amp;utm_campaign=loading\" style=\" background:#FFFFFF; line-height:0; padding:0 0; text-align:center; text-decoration:none; width:100%;\" target=\"_blank\"> <div style=\" display: flex; flex-direction: row; align-items: center;\"> <div style=\"background-color: #F4F4F4; border-radius: 50%; flex-grow: 0; height: 40px; margin-right: 14px; width: 40px;\"></div> <div style=\"display: flex; flex-direction: column; flex-grow: 1; justify-content: center;\"> <div style=\" background-color: #F4F4F4; border-radius: 4px; flex-grow: 0; height: 14px; margin-bottom: 6px; width: 100px;\"></div> <div style=\" background-color: #F4F4F4; border-radius: 4px; flex-grow: 0; height: 14px; width: 60px;\"></div></div></div><div style=\"padding: 19% 0;\"></div> <div style=\"display:block; height:50px; margin:0 auto 12px; width:50px;\"><svg width=\"50px\" height=\"50px\" viewBox=\"0 0 60 60\" version=\"1.1\" xmlns=\"https://www.w3.org/2000/svg\" xmlns:xlink=\"https://www.w3.org/1999/xlink\"><g stroke=\"none\" stroke-width=\"1\" fill=\"none\" fill-rule=\"evenodd\"><g transform=\"translate(-511.000000, -20.000000)\" fill=\"#000000\"><g><path d=\"M556.869,30.41 C554.814,30.41 553.148,32.076 553.148,34.131 C553.148,36.186 554.814,37.852 556.869,37.852 C558.924,37.852 560.59,36.186 560.59,34.131 C560.59,32.076 558.924,30.41 556.869,30.41 M541,60.657 C535.114,60.657 530.342,55.887 530.342,50 C530.342,44.114 535.114,39.342 541,39.342 C546.887,39.342 551.658,44.114 551.658,50 C551.658,55.887 546.887,60.657 541,60.657 M541,33.886 C532.1,33.886 524.886,41.1 524.886,50 C524.886,58.899 532.1,66.113 541,66.113 C549.9,66.113 557.115,58.899 557.115,50 C557.115,41.1 549.9,33.886 541,33.886 M565.378,62.101 C565.244,65.022 564.756,66.606 564.346,67.663 C563.803,69.06 563.154,70.057 562.106,71.106 C561.058,72.155 560.06,72.803 558.662,73.347 C557.607,73.757 556.021,74.244 553.102,74.378 C549.944,74.521 548.997,74.552 541,74.552 C533.003,74.552 532.056,74.521 528.898,74.378 C525.979,74.244 524.393,73.757 523.338,73.347 C521.94,72.803 520.942,72.155 519.894,71.106 C518.846,70.057 518.197,69.06 517.654,67.663 C517.244,66.606 516.755,65.022 516.623,62.101 C516.479,58.943 516.448,57.996 516.448,50 C516.448,42.003 516.479,41.056 516.623,37.899 C516.755,34.978 517.244,33.391 517.654,32.338 C518.197,30.938 518.846,29.942 519.894,28.894 C520.942,27.846 521.94,27.196 523.338,26.654 C524.393,26.244 525.979,25.756 528.898,25.623 C532.057,25.479 533.004,25.448 541,25.448 C548.997,25.448 549.943,25.479 553.102,25.623 C556.021,25.756 557.607,26.244 558.662,26.654 C560.06,27.196 561.058,27.846 562.106,28.894 C563.154,29.942 563.803,30.938 564.346,32.338 C564.756,33.391 565.244,34.978 565.378,37.899 C565.522,41.056 565.552,42.003 565.552,50 C565.552,57.996 565.522,58.943 565.378,62.101 M570.82,37.631 C570.674,34.438 570.167,32.258 569.425,30.349 C568.659,28.377 567.633,26.702 565.965,25.035 C564.297,23.368 562.623,22.342 560.652,21.575 C558.743,20.834 556.562,20.326 553.369,20.18 C550.169,20.033 549.148,20 541,20 C532.853,20 531.831,20.033 528.631,20.18 C525.438,20.326 523.257,20.834 521.349,21.575 C519.376,22.342 517.703,23.368 516.035,25.035 C514.368,26.702 513.342,28.377 512.574,30.349 C511.834,32.258 511.326,34.438 511.181,37.631 C511.035,40.831 511,41.851 511,50 C511,58.147 511.035,59.17 511.181,62.369 C511.326,65.562 511.834,67.743 512.574,69.651 C513.342,71.625 514.368,73.296 516.035,74.965 C517.703,76.634 519.376,77.658 521.349,78.425 C523.257,79.167 525.438,79.673 528.631,79.82 C531.831,79.965 532.853,80.001 541,80.001 C549.148,80.001 550.169,79.965 553.369,79.82 C556.562,79.673 558.743,79.167 560.652,78.425 C562.623,77.658 564.297,76.634 565.965,74.965 C567.633,73.296 568.659,71.625 569.425,69.651 C570.167,67.743 570.674,65.562 570.82,62.369 C570.966,59.17 571,58.147 571,50 C571,41.851 570.966,40.831 570.82,37.631\"></path></g></g></g></svg></div><div style=\"padding-top: 8px;\"> <div style=\" color:#3897f0; font-family:Arial,sans-serif; font-size:14px; font-style:normal; font-weight:550; line-height:18px;\"> View this post on Instagram</div></div><div style=\"padding: 12.5% 0;\"></div> <div style=\"display: flex; flex-direction: row; margin-bottom: 14px; align-items: center;\"><div> <div style=\"background-color: #F4F4F4; border-radius: 50%; height: 12.5px; width: 12.5px; transform: translateX(0px) translateY(7px);\"></div> <div style=\"background-color: #F4F4F4; height: 12.5px; transform: rotate(-45deg) translateX(3px) translateY(1px); width: 12.5px; flex-grow: 0; margin-right: 14px; margin-left: 2px;\"></div> <div style=\"background-color: #F4F4F4; border-radius: 50%; height: 12.5px; width: 12.5px; transform: translateX(9px) translateY(-18px);\"></div></div><div style=\"margin-left: 8px;\"> <div style=\" background-color: #F4F4F4; border-radius: 50%; flex-grow: 0; height: 20px; width: 20px;\"></div> <div style=\" width: 0; height: 0; border-top: 2px solid transparent; border-left: 6px solid #f4f4f4; border-bottom: 2px solid transparent; transform: translateX(16px) translateY(-4px) rotate(30deg)\"></div></div><div style=\"margin-left: auto;\"> <div style=\" width: 0px; border-top: 8px solid #F4F4F4; border-right: 8px solid transparent; transform: translateY(16px);\"></div> <div style=\" background-color: #F4F4F4; flex-grow: 0; height: 12px; width: 16px; transform: translateY(-4px);\"></div> <div style=\" width: 0; height: 0; border-top: 8px solid #F4F4F4; border-left: 8px solid transparent; transform: translateY(-4px) translateX(8px);\"></div></div></div></a> <p style=\" margin:8px 0 0 0; padding:0 4px;\"> <a href=\"https://www.instagram.com/p/CBeIxrqBd6X/?utm_source=ig_embed&amp;utm_campaign=loading\" style=\" color:#000; font-family:Arial,sans-serif; font-size:14px; font-style:normal; font-weight:normal; line-height:17px; text-decoration:none; word-wrap:break-word;\" target=\"_blank\">Video by @joelsartore I Found on all continents except Antarctica and Australia, flamingos are one of the most recognized bird species in the world. Flamingos like these @lincolnchildrenszoo live in large colonies, sometimes numbering into the thousands of individuals. In the wild, these colonies often occupy mud flats with nearby estuaries, as this habitat provides the birds with breeding sites as well as abundant sources of food and reduced competition. Follow this flock over to @joelsartore to see more species featured in the Photo Ark. #flamingo #bird #pink #PhotoArk #savetogether</a></p> <p style=\" color:#c9c8cd; font-family:Arial,sans-serif; font-size:14px; line-height:17px; margin-bottom:0; margin-top:8px; overflow:hidden; padding:8px 0 7px; text-align:center; text-overflow:ellipsis; white-space:nowrap;\">A post shared by <a href=\"https://www.instagram.com/natgeo/?utm_source=ig_embed&amp;utm_campaign=loading\" style=\" color:#c9c8cd; font-family:Arial,sans-serif; font-size:14px; font-style:normal; font-weight:normal; line-height:17px;\" target=\"_blank\"> National Geographic</a> (@natgeo) on <time style=\" font-family:Arial,sans-serif; font-size:14px; line-height:17px;\" datetime=\"2020-06-15T21:35:48+00:00\">Jun 15, 2020 at 2:35pm PDT</time></p></div></blockquote><script async src=\"//www.instagram.com/embed.js\"></script>");
INSERT INTO `wp_postmeta` VALUES("1759", "775", "_oembed_time_3b0a74f70bd2d8cdc75e65c605623d0a", "1593470276");
INSERT INTO `wp_postmeta` VALUES("1760", "775", "king_reaction_like", "3");
INSERT INTO `wp_postmeta` VALUES("1761", "775", "_oembed_4594e1645b7f926fc19dcae682a53655", "<div id=\"fb-root\"></div><script async=\"1\" defer=\"1\" crossorigin=\"anonymous\" src=\"https://connect.facebook.net/en_US/sdk.js#xfbml=1&amp;version=v8.0\" nonce=\"HbQkg59j\"></script><div class=\"fb-video\" data-href=\"https://www.facebook.com/natgeo/videos/2555654941353324/\" data-width=\"640\"><blockquote cite=\"https://www.facebook.com/natgeo/videos/2555654941353324/\" class=\"fb-xfbml-parse-ignore\"><a href=\"https://www.facebook.com/natgeo/videos/2555654941353324/\">Watch Leopard Seals Play and Hunt</a><p>Get up close and personal with leopard seals in Antarctica—and see why they’re at the top of their food chain.</p>Posted by <a href=\"https://www.facebook.com/natgeo/\">National Geographic</a> on Thursday, May 21, 2020</blockquote></div>");
INSERT INTO `wp_postmeta` VALUES("1762", "775", "_oembed_time_4594e1645b7f926fc19dcae682a53655", "1601847205");
INSERT INTO `wp_postmeta` VALUES("1763", "775", "_oembed_101e5e0b40e1ea24495c4b5563d530c1", "{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("1766", "795", "_wp_old_date", "2020-06-20");
INSERT INTO `wp_postmeta` VALUES("1767", "795", "_thumbnail_id", "796");
INSERT INTO `wp_postmeta` VALUES("1768", "795", "images_lists", "");
INSERT INTO `wp_postmeta` VALUES("1769", "795", "_images_lists", "field_58bf2f79ed6d3");
INSERT INTO `wp_postmeta` VALUES("1770", "795", "image_template", "image-template-2");
INSERT INTO `wp_postmeta` VALUES("1771", "795", "_image_template", "field_5b5ce3de23ad5");
INSERT INTO `wp_postmeta` VALUES("1772", "795", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("1773", "795", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("1774", "795", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("1775", "795", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("1776", "795", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("1777", "795", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("1778", "795", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("1779", "795", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("1780", "795", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("1781", "795", "_post_like_count", "");
INSERT INTO `wp_postmeta` VALUES("1782", "795", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("1783", "795", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("1784", "795", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("1785", "795", "_post_views", "56");
INSERT INTO `wp_postmeta` VALUES("1786", "795", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1789", "803", "_wp_old_date", "2020-06-29");
INSERT INTO `wp_postmeta` VALUES("1790", "803", "_thumbnail_id", "804");
INSERT INTO `wp_postmeta` VALUES("1791", "803", "video_tab", "0");
INSERT INTO `wp_postmeta` VALUES("1792", "803", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("1793", "803", "video-url", "https://open.spotify.com/track/3H7ihDc1dqLriiWXwsc2po?si=rXshOp06SCGvFjYAPKAM1A");
INSERT INTO `wp_postmeta` VALUES("1794", "803", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("1795", "803", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("1796", "803", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("1797", "803", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("1798", "803", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("1799", "803", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("1800", "803", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("1801", "803", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("1802", "803", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("1803", "803", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("1804", "803", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("1805", "803", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("1806", "803", "_post_like_count", "");
INSERT INTO `wp_postmeta` VALUES("1807", "803", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("1808", "803", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("1809", "803", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("1810", "803", "_post_views", "113");
INSERT INTO `wp_postmeta` VALUES("1811", "803", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1814", "801", "video-url", "https://open.spotify.com/playlist/37i9dQZF1DX4fpCWaHOned");
INSERT INTO `wp_postmeta` VALUES("1815", "801", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("1816", "801", "_thumbnail_id", "802");
INSERT INTO `wp_postmeta` VALUES("1817", "801", "video_tab", "0");
INSERT INTO `wp_postmeta` VALUES("1818", "801", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("1819", "801", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("1820", "801", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("1821", "801", "_post_views", "114");
INSERT INTO `wp_postmeta` VALUES("1822", "801", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1823", "801", "king_reaction_angry", "1");
INSERT INTO `wp_postmeta` VALUES("1826", "807", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("1827", "807", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("1828", "807", "video-url", "https://vimeo.com/108018156");
INSERT INTO `wp_postmeta` VALUES("1829", "807", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("1830", "807", "media_lists_0_media_title", "موزیک ویدیو علیرضا طلیسچی");
INSERT INTO `wp_postmeta` VALUES("1831", "807", "_media_lists_0_media_title", "field_5ee7d35b7603b");
INSERT INTO `wp_postmeta` VALUES("1832", "807", "media_lists_0_media_url_or_upload", "1");
INSERT INTO `wp_postmeta` VALUES("1833", "807", "_media_lists_0_media_url_or_upload", "field_5ee7d3c77603d");
INSERT INTO `wp_postmeta` VALUES("1834", "807", "media_lists_0_media_url", "https://vimeo.com/164860211");
INSERT INTO `wp_postmeta` VALUES("1835", "807", "_media_lists_0_media_url", "field_5ee7d3987603c");
INSERT INTO `wp_postmeta` VALUES("1836", "807", "media_lists_0_media_thumb", "816");
INSERT INTO `wp_postmeta` VALUES("1837", "807", "_media_lists_0_media_thumb", "field_5ee7d4f37603f");
INSERT INTO `wp_postmeta` VALUES("1838", "807", "media_lists_1_media_title", "علیرضا طلیسچی ای دل غافل");
INSERT INTO `wp_postmeta` VALUES("1839", "807", "_media_lists_1_media_title", "field_5ee7d35b7603b");
INSERT INTO `wp_postmeta` VALUES("1840", "807", "media_lists_1_media_url_or_upload", "1");
INSERT INTO `wp_postmeta` VALUES("1841", "807", "_media_lists_1_media_url_or_upload", "field_5ee7d3c77603d");
INSERT INTO `wp_postmeta` VALUES("1842", "807", "media_lists_1_media_url", "https://www.youtube.com/watch?v=0FXJUP6_O1w");
INSERT INTO `wp_postmeta` VALUES("1843", "807", "_media_lists_1_media_url", "field_5ee7d3987603c");
INSERT INTO `wp_postmeta` VALUES("1844", "807", "media_lists_1_media_thumb", "890");
INSERT INTO `wp_postmeta` VALUES("1845", "807", "_media_lists_1_media_thumb", "field_5ee7d4f37603f");
INSERT INTO `wp_postmeta` VALUES("1846", "807", "media_lists_2_media_title", "موزیک ویدیو بهنام بانی");
INSERT INTO `wp_postmeta` VALUES("1847", "807", "_media_lists_2_media_title", "field_5ee7d35b7603b");
INSERT INTO `wp_postmeta` VALUES("1848", "807", "media_lists_2_media_url_or_upload", "1");
INSERT INTO `wp_postmeta` VALUES("1849", "807", "_media_lists_2_media_url_or_upload", "field_5ee7d3c77603d");
INSERT INTO `wp_postmeta` VALUES("1850", "807", "media_lists_2_media_url", "https://vimeo.com/222729677");
INSERT INTO `wp_postmeta` VALUES("1851", "807", "_media_lists_2_media_url", "field_5ee7d3987603c");
INSERT INTO `wp_postmeta` VALUES("1852", "807", "media_lists_2_media_thumb", "892");
INSERT INTO `wp_postmeta` VALUES("1853", "807", "_media_lists_2_media_thumb", "field_5ee7d4f37603f");
INSERT INTO `wp_postmeta` VALUES("1854", "807", "media_lists", "4");
INSERT INTO `wp_postmeta` VALUES("1855", "807", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("1856", "807", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("1857", "807", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("1858", "807", "keep_trending", "1");
INSERT INTO `wp_postmeta` VALUES("1859", "807", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("1860", "807", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("1861", "807", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("1862", "807", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("1863", "807", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("1864", "807", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("1865", "807", "_post_like_count", "");
INSERT INTO `wp_postmeta` VALUES("1866", "807", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("1867", "807", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("1868", "807", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("1869", "807", "video_template", "");
INSERT INTO `wp_postmeta` VALUES("1870", "807", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("1871", "807", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1872", "807", "_thumbnail_id", "887");
INSERT INTO `wp_postmeta` VALUES("1873", "807", "media_lists_3_media_title", "موزیک ویدیو میثم ابراهیمی");
INSERT INTO `wp_postmeta` VALUES("1874", "807", "_media_lists_3_media_title", "field_5ee7d35b7603b");
INSERT INTO `wp_postmeta` VALUES("1875", "807", "media_lists_3_media_url_or_upload", "1");
INSERT INTO `wp_postmeta` VALUES("1876", "807", "_media_lists_3_media_url_or_upload", "field_5ee7d3c77603d");
INSERT INTO `wp_postmeta` VALUES("1877", "807", "media_lists_3_media_url", "https://vimeo.com/146226360");
INSERT INTO `wp_postmeta` VALUES("1878", "807", "_media_lists_3_media_url", "field_5ee7d3987603c");
INSERT INTO `wp_postmeta` VALUES("1879", "807", "media_lists_3_media_thumb", "894");
INSERT INTO `wp_postmeta` VALUES("1880", "807", "_media_lists_3_media_thumb", "field_5ee7d4f37603f");
INSERT INTO `wp_postmeta` VALUES("1881", "807", "_post_views", "445");
INSERT INTO `wp_postmeta` VALUES("1884", "823", "video-url", "https://vimeo.com/126355970");
INSERT INTO `wp_postmeta` VALUES("1885", "823", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("1886", "823", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("1887", "823", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("1888", "823", "media_lists_0_media_title", "موزیک آصف آریا - هیس");
INSERT INTO `wp_postmeta` VALUES("1889", "823", "_media_lists_0_media_title", "field_5ee7d35b7603b");
INSERT INTO `wp_postmeta` VALUES("1890", "823", "media_lists_0_media_url_or_upload", "1");
INSERT INTO `wp_postmeta` VALUES("1891", "823", "_media_lists_0_media_url_or_upload", "field_5ee7d3c77603d");
INSERT INTO `wp_postmeta` VALUES("1892", "823", "media_lists_0_media_upload", "896");
INSERT INTO `wp_postmeta` VALUES("1893", "823", "_media_lists_0_media_upload", "field_5ee7d4327603e");
INSERT INTO `wp_postmeta` VALUES("1894", "823", "media_lists_0_media_thumb", "901");
INSERT INTO `wp_postmeta` VALUES("1895", "823", "_media_lists_0_media_thumb", "field_5ee7d4f37603f");
INSERT INTO `wp_postmeta` VALUES("1896", "823", "media_lists_1_media_title", "موزیک مسعود صادقلو");
INSERT INTO `wp_postmeta` VALUES("1897", "823", "_media_lists_1_media_title", "field_5ee7d35b7603b");
INSERT INTO `wp_postmeta` VALUES("1898", "823", "media_lists_1_media_url_or_upload", "1");
INSERT INTO `wp_postmeta` VALUES("1899", "823", "_media_lists_1_media_url_or_upload", "field_5ee7d3c77603d");
INSERT INTO `wp_postmeta` VALUES("1900", "823", "media_lists_1_media_url", "https://www.youtube.com/watch?v=Gz2GVlQkn4Q");
INSERT INTO `wp_postmeta` VALUES("1901", "823", "_media_lists_1_media_url", "field_5ee7d3987603c");
INSERT INTO `wp_postmeta` VALUES("1902", "823", "media_lists_1_media_thumb", "900");
INSERT INTO `wp_postmeta` VALUES("1903", "823", "_media_lists_1_media_thumb", "field_5ee7d4f37603f");
INSERT INTO `wp_postmeta` VALUES("1904", "823", "media_lists", "2");
INSERT INTO `wp_postmeta` VALUES("1905", "823", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("1906", "823", "_post_views", "292");
INSERT INTO `wp_postmeta` VALUES("1907", "823", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("1908", "823", "_thumbnail_id", "825");
INSERT INTO `wp_postmeta` VALUES("1909", "823", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("1910", "823", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("1911", "823", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("1912", "823", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("1913", "823", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("1914", "823", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("1915", "823", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("1916", "823", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("1917", "823", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("1918", "823", "_post_like_count", "");
INSERT INTO `wp_postmeta` VALUES("1919", "823", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("1920", "823", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("1921", "823", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("1922", "823", "king_reaction_haha", "1");
INSERT INTO `wp_postmeta` VALUES("1924", "851", "_wp_attached_file", "2022/02/v7logo2.png");
INSERT INTO `wp_postmeta` VALUES("1925", "851", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:180;s:4:\"file\";s:19:\"2022/02/v7logo2.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"v7logo2-300x120.png\";s:5:\"width\";i:300;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"v7logo2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1936", "855", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1937", "855", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1938", "855", "_menu_item_object_id", "493");
INSERT INTO `wp_postmeta` VALUES("1939", "855", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1940", "855", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1941", "855", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1942", "855", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1943", "855", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1945", "856", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1946", "856", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1947", "856", "_menu_item_object_id", "95");
INSERT INTO `wp_postmeta` VALUES("1948", "856", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1949", "856", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1950", "856", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1951", "856", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1952", "856", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1954", "857", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1955", "857", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1956", "857", "_menu_item_object_id", "522");
INSERT INTO `wp_postmeta` VALUES("1957", "857", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1958", "857", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1959", "857", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1960", "857", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1961", "857", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1963", "858", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1964", "858", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1965", "858", "_menu_item_object_id", "22");
INSERT INTO `wp_postmeta` VALUES("1966", "858", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1967", "858", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1968", "858", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1969", "858", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1970", "858", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1972", "859", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1973", "859", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1974", "859", "_menu_item_object_id", "98");
INSERT INTO `wp_postmeta` VALUES("1975", "859", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1976", "859", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1977", "859", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1978", "859", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1979", "859", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1981", "860", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1982", "860", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1983", "860", "_menu_item_object_id", "469");
INSERT INTO `wp_postmeta` VALUES("1984", "860", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1985", "860", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1986", "860", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1987", "860", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1988", "860", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1990", "855", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("1991", "855", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("1992", "855", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("1993", "855", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("1994", "856", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("1995", "856", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("1996", "856", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("1997", "856", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("1998", "857", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("1999", "857", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("2000", "857", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("2001", "857", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("2002", "858", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("2003", "858", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("2004", "858", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("2005", "858", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("2006", "859", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("2007", "859", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("2008", "859", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("2009", "859", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("2010", "860", "add_badge_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("2011", "860", "_add_badge_to_menu", "field_5c9bdc62674dd");
INSERT INTO `wp_postmeta` VALUES("2012", "860", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("2013", "860", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("2014", "861", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2015", "861", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("2016", "861", "_menu_item_object_id", "28");
INSERT INTO `wp_postmeta` VALUES("2017", "861", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2018", "861", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2019", "861", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2020", "861", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2021", "861", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2022", "861", "_menu_item_orphaned", "1644757491");
INSERT INTO `wp_postmeta` VALUES("2023", "862", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2024", "862", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("2025", "862", "_menu_item_object_id", "25");
INSERT INTO `wp_postmeta` VALUES("2026", "862", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2027", "862", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2028", "862", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2029", "862", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2030", "862", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2031", "862", "_menu_item_orphaned", "1644757491");
INSERT INTO `wp_postmeta` VALUES("2032", "863", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2033", "863", "_edit_lock", "1644874823:1");
INSERT INTO `wp_postmeta` VALUES("2034", "863", "_thumbnail_id", "835");
INSERT INTO `wp_postmeta` VALUES("2035", "863", "featured_story", "1");
INSERT INTO `wp_postmeta` VALUES("2036", "863", "_featured_story", "field_61c063bae3e39");
INSERT INTO `wp_postmeta` VALUES("2037", "863", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("2123", "863", "_post_views", "40");
INSERT INTO `wp_postmeta` VALUES("2126", "493", "_edit_lock", "1644855655:1");
INSERT INTO `wp_postmeta` VALUES("2127", "95", "_edit_lock", "1644855655:1");
INSERT INTO `wp_postmeta` VALUES("2128", "522", "_edit_lock", "1644855656:1");
INSERT INTO `wp_postmeta` VALUES("2129", "22", "_edit_lock", "1644855656:1");
INSERT INTO `wp_postmeta` VALUES("2130", "98", "_edit_lock", "1644855657:1");
INSERT INTO `wp_postmeta` VALUES("2131", "493", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2132", "95", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2133", "522", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2134", "22", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2135", "22", "page_template_sidebar", "");
INSERT INTO `wp_postmeta` VALUES("2136", "22", "_page_template_sidebar", "field_61dd8f09d4b34");
INSERT INTO `wp_postmeta` VALUES("2137", "22", "page_template_column", "");
INSERT INTO `wp_postmeta` VALUES("2138", "22", "_page_template_column", "field_61dd8f21d4b35");
INSERT INTO `wp_postmeta` VALUES("2139", "22", "page_template", "");
INSERT INTO `wp_postmeta` VALUES("2140", "22", "_page_template", "field_61dd8edfd4b33");
INSERT INTO `wp_postmeta` VALUES("2141", "870", "page_template_sidebar", "");
INSERT INTO `wp_postmeta` VALUES("2142", "870", "_page_template_sidebar", "field_61dd8f09d4b34");
INSERT INTO `wp_postmeta` VALUES("2143", "870", "page_template_column", "");
INSERT INTO `wp_postmeta` VALUES("2144", "870", "_page_template_column", "field_61dd8f21d4b35");
INSERT INTO `wp_postmeta` VALUES("2145", "870", "page_template", "");
INSERT INTO `wp_postmeta` VALUES("2146", "870", "_page_template", "field_61dd8edfd4b33");
INSERT INTO `wp_postmeta` VALUES("2147", "98", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2148", "98", "page_template_sidebar", "");
INSERT INTO `wp_postmeta` VALUES("2149", "98", "_page_template_sidebar", "field_61dd8f09d4b34");
INSERT INTO `wp_postmeta` VALUES("2150", "98", "page_template_column", "");
INSERT INTO `wp_postmeta` VALUES("2151", "98", "_page_template_column", "field_61dd8f21d4b35");
INSERT INTO `wp_postmeta` VALUES("2152", "98", "page_template", "");
INSERT INTO `wp_postmeta` VALUES("2153", "98", "_page_template", "field_61dd8edfd4b33");
INSERT INTO `wp_postmeta` VALUES("2154", "871", "page_template_sidebar", "");
INSERT INTO `wp_postmeta` VALUES("2155", "871", "_page_template_sidebar", "field_61dd8f09d4b34");
INSERT INTO `wp_postmeta` VALUES("2156", "871", "page_template_column", "");
INSERT INTO `wp_postmeta` VALUES("2157", "871", "_page_template_column", "field_61dd8f21d4b35");
INSERT INTO `wp_postmeta` VALUES("2158", "871", "page_template", "");
INSERT INTO `wp_postmeta` VALUES("2159", "871", "_page_template", "field_61dd8edfd4b33");
INSERT INTO `wp_postmeta` VALUES("2160", "469", "_edit_lock", "1644855725:1");
INSERT INTO `wp_postmeta` VALUES("2161", "105", "_edit_lock", "1644855725:1");
INSERT INTO `wp_postmeta` VALUES("2162", "25", "_edit_lock", "1644855726:1");
INSERT INTO `wp_postmeta` VALUES("2163", "28", "_edit_lock", "1644855726:1");
INSERT INTO `wp_postmeta` VALUES("2164", "617", "_edit_lock", "1644855727:1");
INSERT INTO `wp_postmeta` VALUES("2165", "469", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2166", "469", "page_template_sidebar", "");
INSERT INTO `wp_postmeta` VALUES("2167", "469", "_page_template_sidebar", "field_61dd8f09d4b34");
INSERT INTO `wp_postmeta` VALUES("2168", "469", "page_template_column", "");
INSERT INTO `wp_postmeta` VALUES("2169", "469", "_page_template_column", "field_61dd8f21d4b35");
INSERT INTO `wp_postmeta` VALUES("2170", "469", "page_template", "");
INSERT INTO `wp_postmeta` VALUES("2171", "469", "_page_template", "field_61dd8edfd4b33");
INSERT INTO `wp_postmeta` VALUES("2172", "872", "page_template_sidebar", "");
INSERT INTO `wp_postmeta` VALUES("2173", "872", "_page_template_sidebar", "field_61dd8f09d4b34");
INSERT INTO `wp_postmeta` VALUES("2174", "872", "page_template_column", "");
INSERT INTO `wp_postmeta` VALUES("2175", "872", "_page_template_column", "field_61dd8f21d4b35");
INSERT INTO `wp_postmeta` VALUES("2176", "872", "page_template", "");
INSERT INTO `wp_postmeta` VALUES("2177", "872", "_page_template", "field_61dd8edfd4b33");
INSERT INTO `wp_postmeta` VALUES("2178", "105", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2179", "25", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2180", "25", "page_template_sidebar", "");
INSERT INTO `wp_postmeta` VALUES("2181", "25", "_page_template_sidebar", "field_61dd8f09d4b34");
INSERT INTO `wp_postmeta` VALUES("2182", "25", "page_template_column", "");
INSERT INTO `wp_postmeta` VALUES("2183", "25", "_page_template_column", "field_61dd8f21d4b35");
INSERT INTO `wp_postmeta` VALUES("2184", "25", "page_template", "");
INSERT INTO `wp_postmeta` VALUES("2185", "25", "_page_template", "field_61dd8edfd4b33");
INSERT INTO `wp_postmeta` VALUES("2186", "874", "page_template_sidebar", "");
INSERT INTO `wp_postmeta` VALUES("2187", "874", "_page_template_sidebar", "field_61dd8f09d4b34");
INSERT INTO `wp_postmeta` VALUES("2188", "874", "page_template_column", "");
INSERT INTO `wp_postmeta` VALUES("2189", "874", "_page_template_column", "field_61dd8f21d4b35");
INSERT INTO `wp_postmeta` VALUES("2190", "874", "page_template", "");
INSERT INTO `wp_postmeta` VALUES("2191", "874", "_page_template", "field_61dd8edfd4b33");
INSERT INTO `wp_postmeta` VALUES("2192", "28", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2193", "617", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2194", "70", "_oembed_2e086725e242df60d682964719d3c49a", "<iframe title=\"One More Beer!\" src=\"https://player.vimeo.com/video/50522981?h=9da431679d&amp;dnt=1&amp;app_id=122963\" width=\"640\" height=\"346\" frameborder=\"0\" allow=\"autoplay; fullscreen; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("2195", "70", "_oembed_time_2e086725e242df60d682964719d3c49a", "1644858792");
INSERT INTO `wp_postmeta` VALUES("2196", "807", "_edit_lock", "1644937555:1");
INSERT INTO `wp_postmeta` VALUES("2197", "823", "_edit_lock", "1644937558:1");
INSERT INTO `wp_postmeta` VALUES("2198", "801", "_edit_lock", "1645712298:1");
INSERT INTO `wp_postmeta` VALUES("2199", "775", "_edit_lock", "1644963623:1");
INSERT INTO `wp_postmeta` VALUES("2200", "734", "_edit_lock", "1644937632:1");
INSERT INTO `wp_postmeta` VALUES("2201", "807", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2204", "807", "video_upload", "886");
INSERT INTO `wp_postmeta` VALUES("2205", "807", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("2206", "807", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("2207", "807", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("2208", "807", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("2209", "807", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2210", "807", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2211", "882", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("2212", "882", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("2213", "882", "video-url", "https://vimeo.com/108018156");
INSERT INTO `wp_postmeta` VALUES("2214", "882", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("2215", "882", "media_lists_0_media_title", "Little Prince All Stop Motion");
INSERT INTO `wp_postmeta` VALUES("2216", "882", "_media_lists_0_media_title", "field_5ee7d35b7603b");
INSERT INTO `wp_postmeta` VALUES("2217", "882", "media_lists_0_media_url_or_upload", "0");
INSERT INTO `wp_postmeta` VALUES("2218", "882", "_media_lists_0_media_url_or_upload", "field_5ee7d3c77603d");
INSERT INTO `wp_postmeta` VALUES("2219", "882", "media_lists_0_media_url", "https://vimeo.com/164860211");
INSERT INTO `wp_postmeta` VALUES("2220", "882", "_media_lists_0_media_url", "field_5ee7d3987603c");
INSERT INTO `wp_postmeta` VALUES("2221", "882", "media_lists_0_media_thumb", "816");
INSERT INTO `wp_postmeta` VALUES("2222", "882", "_media_lists_0_media_thumb", "field_5ee7d4f37603f");
INSERT INTO `wp_postmeta` VALUES("2223", "882", "media_lists_1_media_title", "Where Are the Stars? See How Light Pollution Affects Night Skies");
INSERT INTO `wp_postmeta` VALUES("2224", "882", "_media_lists_1_media_title", "field_5ee7d35b7603b");
INSERT INTO `wp_postmeta` VALUES("2225", "882", "media_lists_1_media_url_or_upload", "0");
INSERT INTO `wp_postmeta` VALUES("2226", "882", "_media_lists_1_media_url_or_upload", "field_5ee7d3c77603d");
INSERT INTO `wp_postmeta` VALUES("2227", "882", "media_lists_1_media_url", "https://www.youtube.com/watch?v=0FXJUP6_O1w");
INSERT INTO `wp_postmeta` VALUES("2228", "882", "_media_lists_1_media_url", "field_5ee7d3987603c");
INSERT INTO `wp_postmeta` VALUES("2229", "882", "media_lists_1_media_thumb", "809");
INSERT INTO `wp_postmeta` VALUES("2230", "882", "_media_lists_1_media_thumb", "field_5ee7d4f37603f");
INSERT INTO `wp_postmeta` VALUES("2231", "882", "media_lists_2_media_title", "FOOD Stop Motion");
INSERT INTO `wp_postmeta` VALUES("2232", "882", "_media_lists_2_media_title", "field_5ee7d35b7603b");
INSERT INTO `wp_postmeta` VALUES("2233", "882", "media_lists_2_media_url_or_upload", "0");
INSERT INTO `wp_postmeta` VALUES("2234", "882", "_media_lists_2_media_url_or_upload", "field_5ee7d3c77603d");
INSERT INTO `wp_postmeta` VALUES("2235", "882", "media_lists_2_media_url", "https://vimeo.com/222729677");
INSERT INTO `wp_postmeta` VALUES("2236", "882", "_media_lists_2_media_url", "field_5ee7d3987603c");
INSERT INTO `wp_postmeta` VALUES("2237", "882", "media_lists_2_media_thumb", "810");
INSERT INTO `wp_postmeta` VALUES("2238", "882", "_media_lists_2_media_thumb", "field_5ee7d4f37603f");
INSERT INTO `wp_postmeta` VALUES("2239", "882", "media_lists", "4");
INSERT INTO `wp_postmeta` VALUES("2240", "882", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("2241", "882", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("2242", "882", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("2243", "882", "keep_trending", "1");
INSERT INTO `wp_postmeta` VALUES("2244", "882", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("2245", "882", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("2246", "882", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("2247", "882", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("2248", "882", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("2249", "882", "_post_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2250", "882", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2251", "882", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("2252", "882", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("2253", "882", "video_template", "");
INSERT INTO `wp_postmeta` VALUES("2254", "882", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("2255", "882", "_thumbnail_id", "819");
INSERT INTO `wp_postmeta` VALUES("2256", "882", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("2257", "882", "media_lists_3_media_title", "Lost Property");
INSERT INTO `wp_postmeta` VALUES("2258", "882", "_media_lists_3_media_title", "field_5ee7d35b7603b");
INSERT INTO `wp_postmeta` VALUES("2259", "882", "media_lists_3_media_url_or_upload", "0");
INSERT INTO `wp_postmeta` VALUES("2260", "882", "_media_lists_3_media_url_or_upload", "field_5ee7d3c77603d");
INSERT INTO `wp_postmeta` VALUES("2261", "882", "media_lists_3_media_url", "https://vimeo.com/146226360");
INSERT INTO `wp_postmeta` VALUES("2262", "882", "_media_lists_3_media_url", "field_5ee7d3987603c");
INSERT INTO `wp_postmeta` VALUES("2263", "882", "media_lists_3_media_thumb", "811");
INSERT INTO `wp_postmeta` VALUES("2264", "882", "_media_lists_3_media_thumb", "field_5ee7d4f37603f");
INSERT INTO `wp_postmeta` VALUES("2265", "882", "_post_views", "42");
INSERT INTO `wp_postmeta` VALUES("2266", "882", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("2267", "882", "video_upload", "");
INSERT INTO `wp_postmeta` VALUES("2268", "882", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("2269", "882", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("2270", "882", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("2271", "882", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2272", "882", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2273", "823", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2276", "823", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2277", "823", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2278", "883", "video-url", "https://vimeo.com/126355970");
INSERT INTO `wp_postmeta` VALUES("2279", "883", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("2280", "883", "video_tab", "0");
INSERT INTO `wp_postmeta` VALUES("2281", "883", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("2282", "883", "media_lists_0_media_title", "Barns Courtney - fire ");
INSERT INTO `wp_postmeta` VALUES("2283", "883", "_media_lists_0_media_title", "field_5ee7d35b7603b");
INSERT INTO `wp_postmeta` VALUES("2284", "883", "media_lists_0_media_url_or_upload", "1");
INSERT INTO `wp_postmeta` VALUES("2285", "883", "_media_lists_0_media_url_or_upload", "field_5ee7d3c77603d");
INSERT INTO `wp_postmeta` VALUES("2286", "883", "media_lists_0_media_upload", "822");
INSERT INTO `wp_postmeta` VALUES("2287", "883", "_media_lists_0_media_upload", "field_5ee7d4327603e");
INSERT INTO `wp_postmeta` VALUES("2288", "883", "media_lists_0_media_thumb", "826");
INSERT INTO `wp_postmeta` VALUES("2289", "883", "_media_lists_0_media_thumb", "field_5ee7d4f37603f");
INSERT INTO `wp_postmeta` VALUES("2290", "883", "media_lists_1_media_title", "KONGOS - Come with Me Now");
INSERT INTO `wp_postmeta` VALUES("2291", "883", "_media_lists_1_media_title", "field_5ee7d35b7603b");
INSERT INTO `wp_postmeta` VALUES("2292", "883", "media_lists_1_media_url_or_upload", "0");
INSERT INTO `wp_postmeta` VALUES("2293", "883", "_media_lists_1_media_url_or_upload", "field_5ee7d3c77603d");
INSERT INTO `wp_postmeta` VALUES("2294", "883", "media_lists_1_media_url", "https://www.youtube.com/watch?v=Gz2GVlQkn4Q");
INSERT INTO `wp_postmeta` VALUES("2295", "883", "_media_lists_1_media_url", "field_5ee7d3987603c");
INSERT INTO `wp_postmeta` VALUES("2296", "883", "media_lists_1_media_thumb", "821");
INSERT INTO `wp_postmeta` VALUES("2297", "883", "_media_lists_1_media_thumb", "field_5ee7d4f37603f");
INSERT INTO `wp_postmeta` VALUES("2298", "883", "media_lists", "2");
INSERT INTO `wp_postmeta` VALUES("2299", "883", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("2300", "883", "_post_views", "23");
INSERT INTO `wp_postmeta` VALUES("2301", "883", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("2302", "883", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("2303", "883", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("2304", "883", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("2305", "883", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("2306", "883", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("2307", "883", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("2308", "883", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("2309", "883", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("2310", "883", "_post_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2311", "883", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2312", "883", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("2313", "883", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("2314", "883", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2315", "883", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2316", "801", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2319", "801", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("2320", "801", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("2321", "801", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("2322", "801", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("2323", "801", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("2324", "801", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("2325", "801", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("2326", "801", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("2327", "801", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("2328", "801", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2329", "801", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2330", "801", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("2331", "801", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("2332", "884", "video-url", "https://open.spotify.com/playlist/37i9dQZF1DX4fpCWaHOned");
INSERT INTO `wp_postmeta` VALUES("2333", "884", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("2334", "884", "video_tab", "0");
INSERT INTO `wp_postmeta` VALUES("2335", "884", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("2336", "884", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("2337", "884", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("2338", "884", "_post_views", "15");
INSERT INTO `wp_postmeta` VALUES("2339", "884", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("2340", "884", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("2341", "884", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("2342", "884", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("2343", "884", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("2344", "884", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("2345", "884", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("2346", "884", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("2347", "884", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("2348", "884", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2349", "884", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2350", "884", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("2351", "884", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("2352", "775", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2355", "775", "king_like_count", "1");
INSERT INTO `wp_postmeta` VALUES("2356", "775", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2357", "885", "news_list_items_0_news_list_title", "Twitter Video – Antelope Canyon");
INSERT INTO `wp_postmeta` VALUES("2358", "885", "_news_list_items_0_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("2359", "885", "news_list_items_0_news_image_or_video", "1");
INSERT INTO `wp_postmeta` VALUES("2360", "885", "_news_list_items_0_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("2361", "885", "news_list_items_0_news_list_media", "https://twitter.com/NatGeoTravel/status/934436537638436864?s=20");
INSERT INTO `wp_postmeta` VALUES("2362", "885", "_news_list_items_0_news_list_media", "field_58bddbb9f7502");
INSERT INTO `wp_postmeta` VALUES("2363", "885", "news_list_items_0_news_list_content", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
INSERT INTO `wp_postmeta` VALUES("2364", "885", "_news_list_items_0_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("2365", "885", "news_list_items_1_news_list_title", "Instagram Video Embed Flamingos ");
INSERT INTO `wp_postmeta` VALUES("2366", "885", "_news_list_items_1_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("2367", "885", "news_list_items_1_news_image_or_video", "1");
INSERT INTO `wp_postmeta` VALUES("2368", "885", "_news_list_items_1_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("2369", "885", "news_list_items_1_news_list_media", "https://www.instagram.com/p/CBeIxrqBd6X/?utm_source=ig_web_copy_link");
INSERT INTO `wp_postmeta` VALUES("2370", "885", "_news_list_items_1_news_list_media", "field_58bddbb9f7502");
INSERT INTO `wp_postmeta` VALUES("2371", "885", "news_list_items_1_news_list_content", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
INSERT INTO `wp_postmeta` VALUES("2372", "885", "_news_list_items_1_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("2373", "885", "news_list_items_2_news_list_title", "Instagram Post Embed");
INSERT INTO `wp_postmeta` VALUES("2374", "885", "_news_list_items_2_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("2375", "885", "news_list_items_2_news_image_or_video", "1");
INSERT INTO `wp_postmeta` VALUES("2376", "885", "_news_list_items_2_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("2377", "885", "news_list_items_2_news_list_media", "https://www.instagram.com/p/CBpFHeQK-nM/");
INSERT INTO `wp_postmeta` VALUES("2378", "885", "_news_list_items_2_news_list_media", "field_58bddbb9f7502");
INSERT INTO `wp_postmeta` VALUES("2379", "885", "news_list_items_2_news_list_content", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
INSERT INTO `wp_postmeta` VALUES("2380", "885", "_news_list_items_2_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("2381", "885", "news_list_items_3_news_list_title", "Seven Wonders Youtube");
INSERT INTO `wp_postmeta` VALUES("2382", "885", "_news_list_items_3_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("2383", "885", "news_list_items_3_news_image_or_video", "1");
INSERT INTO `wp_postmeta` VALUES("2384", "885", "_news_list_items_3_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("2385", "885", "news_list_items_3_news_list_media", "https://www.youtube.com/watch?v=hcCVe5MamN4");
INSERT INTO `wp_postmeta` VALUES("2386", "885", "_news_list_items_3_news_list_media", "field_58bddbb9f7502");
INSERT INTO `wp_postmeta` VALUES("2387", "885", "news_list_items_3_news_list_content", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
INSERT INTO `wp_postmeta` VALUES("2388", "885", "_news_list_items_3_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("2389", "885", "news_list_items_4_news_list_title", "Northern lights - Vimeo");
INSERT INTO `wp_postmeta` VALUES("2390", "885", "_news_list_items_4_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("2391", "885", "news_list_items_4_news_image_or_video", "1");
INSERT INTO `wp_postmeta` VALUES("2392", "885", "_news_list_items_4_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("2393", "885", "news_list_items_4_news_list_media", "https://vimeo.com/185472558");
INSERT INTO `wp_postmeta` VALUES("2394", "885", "_news_list_items_4_news_list_media", "field_58bddbb9f7502");
INSERT INTO `wp_postmeta` VALUES("2395", "885", "news_list_items_4_news_list_content", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
INSERT INTO `wp_postmeta` VALUES("2396", "885", "_news_list_items_4_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("2397", "885", "news_list_items_5_news_list_title", "Leopard Seals Play and Hunt - Facebook");
INSERT INTO `wp_postmeta` VALUES("2398", "885", "_news_list_items_5_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("2399", "885", "news_list_items_5_news_image_or_video", "1");
INSERT INTO `wp_postmeta` VALUES("2400", "885", "_news_list_items_5_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("2401", "885", "news_list_items_5_news_list_media", "https://www.facebook.com/natgeo/videos/2555654941353324/");
INSERT INTO `wp_postmeta` VALUES("2402", "885", "_news_list_items_5_news_list_media", "field_58bddbb9f7502");
INSERT INTO `wp_postmeta` VALUES("2403", "885", "news_list_items_5_news_list_content", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
INSERT INTO `wp_postmeta` VALUES("2404", "885", "_news_list_items_5_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("2405", "885", "news_list_items", "6");
INSERT INTO `wp_postmeta` VALUES("2406", "885", "_news_list_items", "field_58bddb0df74fe");
INSERT INTO `wp_postmeta` VALUES("2407", "885", "_post_views", "43");
INSERT INTO `wp_postmeta` VALUES("2408", "885", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("2409", "885", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("2410", "885", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("2411", "885", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("2412", "885", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("2413", "885", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("2414", "885", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("2415", "885", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("2416", "885", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("2417", "885", "_post_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2418", "885", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2419", "885", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("2420", "885", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("2421", "885", "post_template", "template-5");
INSERT INTO `wp_postmeta` VALUES("2422", "885", "_post_template", "field_5b5b94f0474bd");
INSERT INTO `wp_postmeta` VALUES("2423", "885", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2424", "885", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2425", "886", "_wp_attached_file", "2020/06/Alireza-Talischi-2.mp4");
INSERT INTO `wp_postmeta` VALUES("2426", "886", "_wp_attachment_metadata", "a:10:{s:8:\"filesize\";i:18794857;s:9:\"mime_type\";s:9:\"video/mp4\";s:6:\"length\";i:177;s:16:\"length_formatted\";s:4:\"2:57\";s:5:\"width\";i:854;s:6:\"height\";i:480;s:10:\"fileformat\";s:3:\"mp4\";s:10:\"dataformat\";s:9:\"quicktime\";s:5:\"audio\";a:7:{s:10:\"dataformat\";s:3:\"mp4\";s:5:\"codec\";s:19:\"ISO/IEC 14496-3 AAC\";s:11:\"sample_rate\";d:44100;s:8:\"channels\";i:2;s:15:\"bits_per_sample\";i:16;s:8:\"lossless\";b:0;s:11:\"channelmode\";s:6:\"stereo\";}s:17:\"created_timestamp\";i:-2082844800;}");
INSERT INTO `wp_postmeta` VALUES("2427", "887", "_wp_attached_file", "2020/06/Alireza-Talischi-2.jpg");
INSERT INTO `wp_postmeta` VALUES("2428", "887", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:506;s:4:\"file\";s:30:\"2020/06/Alireza-Talischi-2.jpg\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"Alireza-Talischi-2-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"Alireza-Talischi-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:30:\"Alireza-Talischi-2-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2429", "888", "_wp_attached_file", "2020/06/Alireza-Talischi.mp4");
INSERT INTO `wp_postmeta` VALUES("2430", "888", "_wp_attachment_metadata", "a:10:{s:8:\"filesize\";i:2316426;s:9:\"mime_type\";s:9:\"video/mp4\";s:6:\"length\";i:54;s:16:\"length_formatted\";s:4:\"0:54\";s:5:\"width\";i:1920;s:6:\"height\";i:1080;s:10:\"fileformat\";s:3:\"mp4\";s:10:\"dataformat\";s:9:\"quicktime\";s:5:\"audio\";a:7:{s:10:\"dataformat\";s:3:\"mp4\";s:5:\"codec\";s:19:\"ISO/IEC 14496-3 AAC\";s:11:\"sample_rate\";d:44100;s:8:\"channels\";i:2;s:15:\"bits_per_sample\";i:16;s:8:\"lossless\";b:0;s:11:\"channelmode\";s:6:\"stereo\";}s:17:\"created_timestamp\";i:1644784311;}");
INSERT INTO `wp_postmeta` VALUES("2431", "889", "_wp_attached_file", "2020/06/Behnam-Bani.mp4");
INSERT INTO `wp_postmeta` VALUES("2432", "889", "_wp_attachment_metadata", "a:10:{s:8:\"filesize\";i:16701865;s:9:\"mime_type\";s:9:\"video/mp4\";s:6:\"length\";i:200;s:16:\"length_formatted\";s:4:\"3:20\";s:5:\"width\";i:854;s:6:\"height\";i:480;s:10:\"fileformat\";s:3:\"mp4\";s:10:\"dataformat\";s:9:\"quicktime\";s:5:\"audio\";a:7:{s:10:\"dataformat\";s:3:\"mp4\";s:5:\"codec\";s:19:\"ISO/IEC 14496-3 AAC\";s:11:\"sample_rate\";d:44100;s:8:\"channels\";i:2;s:15:\"bits_per_sample\";i:16;s:8:\"lossless\";b:0;s:11:\"channelmode\";s:6:\"stereo\";}s:17:\"created_timestamp\";i:-2082844800;}");
INSERT INTO `wp_postmeta` VALUES("2433", "890", "_wp_attached_file", "2020/06/Behnam-Bani-Dota-Dele-Ashegh.jpg");
INSERT INTO `wp_postmeta` VALUES("2434", "890", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:40:\"2020/06/Behnam-Bani-Dota-Dele-Ashegh.jpg\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:40:\"Behnam-Bani-Dota-Dele-Ashegh-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:40:\"Behnam-Bani-Dota-Dele-Ashegh-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2435", "891", "_wp_attached_file", "2020/06/Meysam-Ebrahimi.mp4");
INSERT INTO `wp_postmeta` VALUES("2436", "891", "_wp_attachment_metadata", "a:10:{s:8:\"filesize\";i:19879255;s:9:\"mime_type\";s:9:\"video/mp4\";s:6:\"length\";i:137;s:16:\"length_formatted\";s:4:\"2:17\";s:5:\"width\";i:854;s:6:\"height\";i:480;s:10:\"fileformat\";s:3:\"mp4\";s:10:\"dataformat\";s:9:\"quicktime\";s:5:\"audio\";a:7:{s:10:\"dataformat\";s:3:\"mp4\";s:5:\"codec\";s:19:\"ISO/IEC 14496-3 AAC\";s:11:\"sample_rate\";d:44100;s:8:\"channels\";i:2;s:15:\"bits_per_sample\";i:16;s:8:\"lossless\";b:0;s:11:\"channelmode\";s:6:\"stereo\";}s:17:\"created_timestamp\";i:-2082844800;}");
INSERT INTO `wp_postmeta` VALUES("2437", "892", "_wp_attached_file", "2020/06/Meysam-Ebrahimi-Halish-Nemishe.jpg");
INSERT INTO `wp_postmeta` VALUES("2438", "892", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:42:\"2020/06/Meysam-Ebrahimi-Halish-Nemishe.jpg\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:42:\"Meysam-Ebrahimi-Halish-Nemishe-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:42:\"Meysam-Ebrahimi-Halish-Nemishe-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2439", "893", "_wp_attached_file", "2020/06/Majid-Razavi.mp4");
INSERT INTO `wp_postmeta` VALUES("2440", "893", "_wp_attachment_metadata", "a:10:{s:8:\"filesize\";i:11227625;s:9:\"mime_type\";s:9:\"video/mp4\";s:6:\"length\";i:35;s:16:\"length_formatted\";s:4:\"0:35\";s:5:\"width\";i:1280;s:6:\"height\";i:720;s:10:\"fileformat\";s:3:\"mp4\";s:10:\"dataformat\";s:9:\"quicktime\";s:5:\"audio\";a:7:{s:10:\"dataformat\";s:3:\"mp4\";s:5:\"codec\";s:19:\"ISO/IEC 14496-3 AAC\";s:11:\"sample_rate\";d:44100;s:8:\"channels\";i:2;s:15:\"bits_per_sample\";i:16;s:8:\"lossless\";b:0;s:11:\"channelmode\";s:6:\"stereo\";}s:17:\"created_timestamp\";i:1637690014;}");
INSERT INTO `wp_postmeta` VALUES("2441", "894", "_wp_attached_file", "2020/06/Majid-Razavi-Remix-5e-Sobh-Music-fa.com_.jpg");
INSERT INTO `wp_postmeta` VALUES("2442", "894", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:450;s:4:\"file\";s:52:\"2020/06/Majid-Razavi-Remix-5e-Sobh-Music-fa.com_.jpg\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:52:\"Majid-Razavi-Remix-5e-Sobh-Music-fa.com_-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:52:\"Majid-Razavi-Remix-5e-Sobh-Music-fa.com_-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2445", "807", "media_lists_0_media_upload", "888");
INSERT INTO `wp_postmeta` VALUES("2446", "807", "_media_lists_0_media_upload", "field_5ee7d4327603e");
INSERT INTO `wp_postmeta` VALUES("2447", "807", "media_lists_1_media_upload", "889");
INSERT INTO `wp_postmeta` VALUES("2448", "807", "_media_lists_1_media_upload", "field_5ee7d4327603e");
INSERT INTO `wp_postmeta` VALUES("2449", "807", "media_lists_2_media_upload", "891");
INSERT INTO `wp_postmeta` VALUES("2450", "807", "_media_lists_2_media_upload", "field_5ee7d4327603e");
INSERT INTO `wp_postmeta` VALUES("2451", "807", "media_lists_3_media_upload", "893");
INSERT INTO `wp_postmeta` VALUES("2452", "807", "_media_lists_3_media_upload", "field_5ee7d4327603e");
INSERT INTO `wp_postmeta` VALUES("2453", "895", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("2454", "895", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("2455", "895", "video-url", "https://vimeo.com/108018156");
INSERT INTO `wp_postmeta` VALUES("2456", "895", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("2457", "895", "media_lists_0_media_title", "موزیک ویدیو علیرضا طلیسچی");
INSERT INTO `wp_postmeta` VALUES("2458", "895", "_media_lists_0_media_title", "field_5ee7d35b7603b");
INSERT INTO `wp_postmeta` VALUES("2459", "895", "media_lists_0_media_url_or_upload", "1");
INSERT INTO `wp_postmeta` VALUES("2460", "895", "_media_lists_0_media_url_or_upload", "field_5ee7d3c77603d");
INSERT INTO `wp_postmeta` VALUES("2461", "895", "media_lists_0_media_url", "https://vimeo.com/164860211");
INSERT INTO `wp_postmeta` VALUES("2462", "895", "_media_lists_0_media_url", "field_5ee7d3987603c");
INSERT INTO `wp_postmeta` VALUES("2463", "895", "media_lists_0_media_thumb", "816");
INSERT INTO `wp_postmeta` VALUES("2464", "895", "_media_lists_0_media_thumb", "field_5ee7d4f37603f");
INSERT INTO `wp_postmeta` VALUES("2465", "895", "media_lists_1_media_title", "علیرضا طلیسچی ای دل غافل");
INSERT INTO `wp_postmeta` VALUES("2466", "895", "_media_lists_1_media_title", "field_5ee7d35b7603b");
INSERT INTO `wp_postmeta` VALUES("2467", "895", "media_lists_1_media_url_or_upload", "1");
INSERT INTO `wp_postmeta` VALUES("2468", "895", "_media_lists_1_media_url_or_upload", "field_5ee7d3c77603d");
INSERT INTO `wp_postmeta` VALUES("2469", "895", "media_lists_1_media_url", "https://www.youtube.com/watch?v=0FXJUP6_O1w");
INSERT INTO `wp_postmeta` VALUES("2470", "895", "_media_lists_1_media_url", "field_5ee7d3987603c");
INSERT INTO `wp_postmeta` VALUES("2471", "895", "media_lists_1_media_thumb", "890");
INSERT INTO `wp_postmeta` VALUES("2472", "895", "_media_lists_1_media_thumb", "field_5ee7d4f37603f");
INSERT INTO `wp_postmeta` VALUES("2473", "895", "media_lists_2_media_title", "موزیک ویدیو بهنام بانی");
INSERT INTO `wp_postmeta` VALUES("2474", "895", "_media_lists_2_media_title", "field_5ee7d35b7603b");
INSERT INTO `wp_postmeta` VALUES("2475", "895", "media_lists_2_media_url_or_upload", "1");
INSERT INTO `wp_postmeta` VALUES("2476", "895", "_media_lists_2_media_url_or_upload", "field_5ee7d3c77603d");
INSERT INTO `wp_postmeta` VALUES("2477", "895", "media_lists_2_media_url", "https://vimeo.com/222729677");
INSERT INTO `wp_postmeta` VALUES("2478", "895", "_media_lists_2_media_url", "field_5ee7d3987603c");
INSERT INTO `wp_postmeta` VALUES("2479", "895", "media_lists_2_media_thumb", "892");
INSERT INTO `wp_postmeta` VALUES("2480", "895", "_media_lists_2_media_thumb", "field_5ee7d4f37603f");
INSERT INTO `wp_postmeta` VALUES("2481", "895", "media_lists", "4");
INSERT INTO `wp_postmeta` VALUES("2482", "895", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("2483", "895", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("2484", "895", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("2485", "895", "keep_trending", "1");
INSERT INTO `wp_postmeta` VALUES("2486", "895", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("2487", "895", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("2488", "895", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("2489", "895", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("2490", "895", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("2491", "895", "_post_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2492", "895", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2493", "895", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("2494", "895", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("2495", "895", "video_template", "");
INSERT INTO `wp_postmeta` VALUES("2496", "895", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("2497", "895", "_thumbnail_id", "887");
INSERT INTO `wp_postmeta` VALUES("2498", "895", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("2499", "895", "media_lists_3_media_title", "موزیک ویدیو میثم ابراهیمی");
INSERT INTO `wp_postmeta` VALUES("2500", "895", "_media_lists_3_media_title", "field_5ee7d35b7603b");
INSERT INTO `wp_postmeta` VALUES("2501", "895", "media_lists_3_media_url_or_upload", "1");
INSERT INTO `wp_postmeta` VALUES("2502", "895", "_media_lists_3_media_url_or_upload", "field_5ee7d3c77603d");
INSERT INTO `wp_postmeta` VALUES("2503", "895", "media_lists_3_media_url", "https://vimeo.com/146226360");
INSERT INTO `wp_postmeta` VALUES("2504", "895", "_media_lists_3_media_url", "field_5ee7d3987603c");
INSERT INTO `wp_postmeta` VALUES("2505", "895", "media_lists_3_media_thumb", "894");
INSERT INTO `wp_postmeta` VALUES("2506", "895", "_media_lists_3_media_thumb", "field_5ee7d4f37603f");
INSERT INTO `wp_postmeta` VALUES("2507", "895", "_post_views", "42");
INSERT INTO `wp_postmeta` VALUES("2508", "895", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("2509", "895", "video_upload", "886");
INSERT INTO `wp_postmeta` VALUES("2510", "895", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("2511", "895", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("2512", "895", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("2513", "895", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2514", "895", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2515", "895", "media_lists_0_media_upload", "888");
INSERT INTO `wp_postmeta` VALUES("2516", "895", "_media_lists_0_media_upload", "field_5ee7d4327603e");
INSERT INTO `wp_postmeta` VALUES("2517", "895", "media_lists_1_media_upload", "889");
INSERT INTO `wp_postmeta` VALUES("2518", "895", "_media_lists_1_media_upload", "field_5ee7d4327603e");
INSERT INTO `wp_postmeta` VALUES("2519", "895", "media_lists_2_media_upload", "891");
INSERT INTO `wp_postmeta` VALUES("2520", "895", "_media_lists_2_media_upload", "field_5ee7d4327603e");
INSERT INTO `wp_postmeta` VALUES("2521", "895", "media_lists_3_media_upload", "893");
INSERT INTO `wp_postmeta` VALUES("2522", "895", "_media_lists_3_media_upload", "field_5ee7d4327603e");
INSERT INTO `wp_postmeta` VALUES("2523", "896", "_wp_attached_file", "2020/06/Asef-Aria-Hiss-320.mp3");
INSERT INTO `wp_postmeta` VALUES("2524", "897", "_wp_attached_file", "2022/02/Asef-Aria-Hiss-320-mp3-image.jpg");
INSERT INTO `wp_postmeta` VALUES("2525", "897", "_cover_hash", "d4673b93a432d24da49550102ec72217");
INSERT INTO `wp_postmeta` VALUES("2526", "897", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:40:\"2022/02/Asef-Aria-Hiss-320-mp3-image.jpg\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:40:\"Asef-Aria-Hiss-320-mp3-image-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:40:\"Asef-Aria-Hiss-320-mp3-image-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2527", "896", "_thumbnail_id", "897");
INSERT INTO `wp_postmeta` VALUES("2528", "896", "_wp_attachment_metadata", "a:21:{s:10:\"dataformat\";s:3:\"mp3\";s:8:\"channels\";i:2;s:11:\"sample_rate\";i:44100;s:7:\"bitrate\";i:320000;s:11:\"channelmode\";s:12:\"joint stereo\";s:12:\"bitrate_mode\";s:3:\"cbr\";s:8:\"lossless\";b:0;s:15:\"encoder_options\";s:6:\"CBR320\";s:17:\"compression_ratio\";d:0.226757369614512482858259545537293888628482818603515625;s:10:\"fileformat\";s:3:\"mp3\";s:8:\"filesize\";i:7802597;s:9:\"mime_type\";s:10:\"audio/mpeg\";s:6:\"length\";i:192;s:16:\"length_formatted\";s:4:\"3:12\";s:5:\"title\";s:14:\"Hiss ~ UpMusic\";s:6:\"artist\";s:19:\"Asef Aria ~ UpMusic\";s:5:\"album\";s:13:\"Hiss (Single)\";s:4:\"year\";s:4:\"2020\";s:5:\"genre\";s:4:\"2020\";s:7:\"comment\";s:16:\"[ UpMusics.Com ]\";s:5:\"image\";a:3:{s:4:\"mime\";s:10:\"image/jpeg\";s:5:\"width\";i:500;s:6:\"height\";i:500;}}");
INSERT INTO `wp_postmeta` VALUES("2529", "898", "_wp_attached_file", "2020/06/Masoud-Sadeghlo-Zade-Baroon320.mp3");
INSERT INTO `wp_postmeta` VALUES("2530", "899", "_wp_attached_file", "2022/02/Masoud-Sadeghlo-Zade-Baroon320-mp3-image.jpg");
INSERT INTO `wp_postmeta` VALUES("2531", "899", "_cover_hash", "c8d1f7af4cf1d3a1ebdae129ecdb010a");
INSERT INTO `wp_postmeta` VALUES("2532", "899", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:450;s:4:\"file\";s:52:\"2022/02/Masoud-Sadeghlo-Zade-Baroon320-mp3-image.jpg\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:52:\"Masoud-Sadeghlo-Zade-Baroon320-mp3-image-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:52:\"Masoud-Sadeghlo-Zade-Baroon320-mp3-image-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2533", "898", "_thumbnail_id", "899");
INSERT INTO `wp_postmeta` VALUES("2534", "898", "_wp_attachment_metadata", "a:23:{s:10:\"dataformat\";s:3:\"mp3\";s:8:\"channels\";i:2;s:11:\"sample_rate\";i:44100;s:7:\"bitrate\";i:320000;s:11:\"channelmode\";s:6:\"stereo\";s:12:\"bitrate_mode\";s:3:\"cbr\";s:5:\"codec\";s:4:\"LAME\";s:7:\"encoder\";s:9:\"LAME3.96r\";s:8:\"lossless\";b:0;s:15:\"encoder_options\";s:15:\"--preset insane\";s:17:\"compression_ratio\";d:0.226757369614512482858259545537293888628482818603515625;s:10:\"fileformat\";s:3:\"mp3\";s:8:\"filesize\";i:7041271;s:9:\"mime_type\";s:10:\"audio/mpeg\";s:6:\"length\";i:166;s:16:\"length_formatted\";s:4:\"2:46\";s:5:\"title\";s:20:\"Zade Baroon~ UpMusic\";s:6:\"artist\";s:25:\"Masoud Sadeghlo ~ UpMusic\";s:5:\"album\";s:19:\"Zade Baroon(Single)\";s:4:\"year\";s:4:\"2020\";s:5:\"genre\";s:4:\"2020\";s:7:\"comment\";s:16:\"[ UpMusics.Com ]\";s:5:\"image\";a:3:{s:4:\"mime\";s:10:\"image/jpeg\";s:5:\"width\";i:450;s:6:\"height\";i:450;}}");
INSERT INTO `wp_postmeta` VALUES("2535", "900", "_wp_attached_file", "2020/06/Masoud-Sadeghloo-Zade-Baroon.jpg");
INSERT INTO `wp_postmeta` VALUES("2536", "900", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:450;s:4:\"file\";s:40:\"2020/06/Masoud-Sadeghloo-Zade-Baroon.jpg\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:40:\"Masoud-Sadeghloo-Zade-Baroon-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:40:\"Masoud-Sadeghloo-Zade-Baroon-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2537", "901", "_wp_attached_file", "2020/06/Asef-Aria-Hiss-Remix.jpg");
INSERT INTO `wp_postmeta` VALUES("2538", "901", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:32:\"2020/06/Asef-Aria-Hiss-Remix.jpg\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"Asef-Aria-Hiss-Remix-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"Asef-Aria-Hiss-Remix-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2541", "823", "video_upload", "822");
INSERT INTO `wp_postmeta` VALUES("2542", "823", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("2543", "823", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("2544", "823", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("2545", "823", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("2546", "823", "media_lists_1_media_upload", "898");
INSERT INTO `wp_postmeta` VALUES("2547", "823", "_media_lists_1_media_upload", "field_5ee7d4327603e");
INSERT INTO `wp_postmeta` VALUES("2548", "902", "video-url", "https://vimeo.com/126355970");
INSERT INTO `wp_postmeta` VALUES("2549", "902", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("2550", "902", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("2551", "902", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("2552", "902", "media_lists_0_media_title", "موزیک آصف آریا - هیس");
INSERT INTO `wp_postmeta` VALUES("2553", "902", "_media_lists_0_media_title", "field_5ee7d35b7603b");
INSERT INTO `wp_postmeta` VALUES("2554", "902", "media_lists_0_media_url_or_upload", "1");
INSERT INTO `wp_postmeta` VALUES("2555", "902", "_media_lists_0_media_url_or_upload", "field_5ee7d3c77603d");
INSERT INTO `wp_postmeta` VALUES("2556", "902", "media_lists_0_media_upload", "896");
INSERT INTO `wp_postmeta` VALUES("2557", "902", "_media_lists_0_media_upload", "field_5ee7d4327603e");
INSERT INTO `wp_postmeta` VALUES("2558", "902", "media_lists_0_media_thumb", "901");
INSERT INTO `wp_postmeta` VALUES("2559", "902", "_media_lists_0_media_thumb", "field_5ee7d4f37603f");
INSERT INTO `wp_postmeta` VALUES("2560", "902", "media_lists_1_media_title", "موزیک مسعود صادقلو");
INSERT INTO `wp_postmeta` VALUES("2561", "902", "_media_lists_1_media_title", "field_5ee7d35b7603b");
INSERT INTO `wp_postmeta` VALUES("2562", "902", "media_lists_1_media_url_or_upload", "1");
INSERT INTO `wp_postmeta` VALUES("2563", "902", "_media_lists_1_media_url_or_upload", "field_5ee7d3c77603d");
INSERT INTO `wp_postmeta` VALUES("2564", "902", "media_lists_1_media_url", "https://www.youtube.com/watch?v=Gz2GVlQkn4Q");
INSERT INTO `wp_postmeta` VALUES("2565", "902", "_media_lists_1_media_url", "field_5ee7d3987603c");
INSERT INTO `wp_postmeta` VALUES("2566", "902", "media_lists_1_media_thumb", "900");
INSERT INTO `wp_postmeta` VALUES("2567", "902", "_media_lists_1_media_thumb", "field_5ee7d4f37603f");
INSERT INTO `wp_postmeta` VALUES("2568", "902", "media_lists", "2");
INSERT INTO `wp_postmeta` VALUES("2569", "902", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("2570", "902", "_post_views", "23");
INSERT INTO `wp_postmeta` VALUES("2571", "902", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("2572", "902", "_thumbnail_id", "825");
INSERT INTO `wp_postmeta` VALUES("2573", "902", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("2574", "902", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("2575", "902", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("2576", "902", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("2577", "902", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("2578", "902", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("2579", "902", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("2580", "902", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("2581", "902", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("2582", "902", "_post_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2583", "902", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2584", "902", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("2585", "902", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("2586", "902", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2587", "902", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2588", "902", "video_upload", "822");
INSERT INTO `wp_postmeta` VALUES("2589", "902", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("2590", "902", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("2591", "902", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("2592", "902", "media_lists_1_media_upload", "898");
INSERT INTO `wp_postmeta` VALUES("2593", "902", "_media_lists_1_media_upload", "field_5ee7d4327603e");
INSERT INTO `wp_postmeta` VALUES("2596", "903", "video-url", "https://open.spotify.com/playlist/37i9dQZF1DX4fpCWaHOned");
INSERT INTO `wp_postmeta` VALUES("2597", "903", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("2598", "903", "video_tab", "0");
INSERT INTO `wp_postmeta` VALUES("2599", "903", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("2600", "903", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("2601", "903", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("2602", "903", "_post_views", "15");
INSERT INTO `wp_postmeta` VALUES("2603", "903", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("2604", "903", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("2605", "903", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("2606", "903", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("2607", "903", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("2608", "903", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("2609", "903", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("2610", "903", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("2611", "903", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("2612", "903", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2613", "903", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2614", "903", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("2615", "903", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("2618", "904", "news_list_items_0_news_list_title", "Twitter Video – Antelope Canyon");
INSERT INTO `wp_postmeta` VALUES("2619", "904", "_news_list_items_0_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("2620", "904", "news_list_items_0_news_image_or_video", "1");
INSERT INTO `wp_postmeta` VALUES("2621", "904", "_news_list_items_0_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("2622", "904", "news_list_items_0_news_list_media", "https://twitter.com/NatGeoTravel/status/934436537638436864?s=20");
INSERT INTO `wp_postmeta` VALUES("2623", "904", "_news_list_items_0_news_list_media", "field_58bddbb9f7502");
INSERT INTO `wp_postmeta` VALUES("2624", "904", "news_list_items_0_news_list_content", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
INSERT INTO `wp_postmeta` VALUES("2625", "904", "_news_list_items_0_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("2626", "904", "news_list_items_1_news_list_title", "Instagram Video Embed Flamingos ");
INSERT INTO `wp_postmeta` VALUES("2627", "904", "_news_list_items_1_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("2628", "904", "news_list_items_1_news_image_or_video", "1");
INSERT INTO `wp_postmeta` VALUES("2629", "904", "_news_list_items_1_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("2630", "904", "news_list_items_1_news_list_media", "https://www.instagram.com/p/CBeIxrqBd6X/?utm_source=ig_web_copy_link");
INSERT INTO `wp_postmeta` VALUES("2631", "904", "_news_list_items_1_news_list_media", "field_58bddbb9f7502");
INSERT INTO `wp_postmeta` VALUES("2632", "904", "news_list_items_1_news_list_content", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
INSERT INTO `wp_postmeta` VALUES("2633", "904", "_news_list_items_1_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("2634", "904", "news_list_items_2_news_list_title", "Instagram Post Embed");
INSERT INTO `wp_postmeta` VALUES("2635", "904", "_news_list_items_2_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("2636", "904", "news_list_items_2_news_image_or_video", "1");
INSERT INTO `wp_postmeta` VALUES("2637", "904", "_news_list_items_2_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("2638", "904", "news_list_items_2_news_list_media", "https://www.instagram.com/p/CBpFHeQK-nM/");
INSERT INTO `wp_postmeta` VALUES("2639", "904", "_news_list_items_2_news_list_media", "field_58bddbb9f7502");
INSERT INTO `wp_postmeta` VALUES("2640", "904", "news_list_items_2_news_list_content", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
INSERT INTO `wp_postmeta` VALUES("2641", "904", "_news_list_items_2_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("2642", "904", "news_list_items_3_news_list_title", "Seven Wonders Youtube");
INSERT INTO `wp_postmeta` VALUES("2643", "904", "_news_list_items_3_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("2644", "904", "news_list_items_3_news_image_or_video", "1");
INSERT INTO `wp_postmeta` VALUES("2645", "904", "_news_list_items_3_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("2646", "904", "news_list_items_3_news_list_media", "https://www.youtube.com/watch?v=hcCVe5MamN4");
INSERT INTO `wp_postmeta` VALUES("2647", "904", "_news_list_items_3_news_list_media", "field_58bddbb9f7502");
INSERT INTO `wp_postmeta` VALUES("2648", "904", "news_list_items_3_news_list_content", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
INSERT INTO `wp_postmeta` VALUES("2649", "904", "_news_list_items_3_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("2650", "904", "news_list_items_4_news_list_title", "Northern lights - Vimeo");
INSERT INTO `wp_postmeta` VALUES("2651", "904", "_news_list_items_4_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("2652", "904", "news_list_items_4_news_image_or_video", "1");
INSERT INTO `wp_postmeta` VALUES("2653", "904", "_news_list_items_4_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("2654", "904", "news_list_items_4_news_list_media", "https://vimeo.com/185472558");
INSERT INTO `wp_postmeta` VALUES("2655", "904", "_news_list_items_4_news_list_media", "field_58bddbb9f7502");
INSERT INTO `wp_postmeta` VALUES("2656", "904", "news_list_items_4_news_list_content", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
INSERT INTO `wp_postmeta` VALUES("2657", "904", "_news_list_items_4_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("2658", "904", "news_list_items_5_news_list_title", "Leopard Seals Play and Hunt - Facebook");
INSERT INTO `wp_postmeta` VALUES("2659", "904", "_news_list_items_5_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("2660", "904", "news_list_items_5_news_image_or_video", "1");
INSERT INTO `wp_postmeta` VALUES("2661", "904", "_news_list_items_5_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("2662", "904", "news_list_items_5_news_list_media", "https://www.facebook.com/natgeo/videos/2555654941353324/");
INSERT INTO `wp_postmeta` VALUES("2663", "904", "_news_list_items_5_news_list_media", "field_58bddbb9f7502");
INSERT INTO `wp_postmeta` VALUES("2664", "904", "news_list_items_5_news_list_content", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
INSERT INTO `wp_postmeta` VALUES("2665", "904", "_news_list_items_5_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("2666", "904", "news_list_items", "6");
INSERT INTO `wp_postmeta` VALUES("2667", "904", "_news_list_items", "field_58bddb0df74fe");
INSERT INTO `wp_postmeta` VALUES("2668", "904", "_post_views", "43");
INSERT INTO `wp_postmeta` VALUES("2669", "904", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("2670", "904", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("2671", "904", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("2672", "904", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("2673", "904", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("2674", "904", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("2675", "904", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("2676", "904", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("2677", "904", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("2678", "904", "_post_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2679", "904", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2680", "904", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("2681", "904", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("2682", "904", "post_template", "template-5");
INSERT INTO `wp_postmeta` VALUES("2683", "904", "_post_template", "field_5b5b94f0474bd");
INSERT INTO `wp_postmeta` VALUES("2684", "904", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2685", "904", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2686", "734", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2689", "734", "images_gallery", "a:5:{i:0;s:3:\"733\";i:1;s:3:\"732\";i:2;s:3:\"731\";i:3;s:3:\"730\";i:4;s:3:\"729\";}");
INSERT INTO `wp_postmeta` VALUES("2690", "734", "_images_gallery", "field_60ae46d02f589");
INSERT INTO `wp_postmeta` VALUES("2691", "734", "image_template", "");
INSERT INTO `wp_postmeta` VALUES("2692", "734", "_image_template", "field_5b5ce3de23ad5");
INSERT INTO `wp_postmeta` VALUES("2693", "734", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("2694", "734", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("2695", "734", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("2696", "734", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("2697", "734", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("2698", "734", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("2699", "734", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("2700", "734", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("2701", "734", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("2702", "734", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2703", "734", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2704", "734", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("2705", "734", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("2706", "905", "images_lists_0_images_list", "730");
INSERT INTO `wp_postmeta` VALUES("2707", "905", "_images_lists_0_images_list", "field_58bf2f96ed6d4");
INSERT INTO `wp_postmeta` VALUES("2708", "905", "images_lists_1_images_list", "731");
INSERT INTO `wp_postmeta` VALUES("2709", "905", "_images_lists_1_images_list", "field_58bf2f96ed6d4");
INSERT INTO `wp_postmeta` VALUES("2710", "905", "images_lists_2_images_list", "732");
INSERT INTO `wp_postmeta` VALUES("2711", "905", "_images_lists_2_images_list", "field_58bf2f96ed6d4");
INSERT INTO `wp_postmeta` VALUES("2712", "905", "images_lists_3_images_list", "729");
INSERT INTO `wp_postmeta` VALUES("2713", "905", "_images_lists_3_images_list", "field_58bf2f96ed6d4");
INSERT INTO `wp_postmeta` VALUES("2714", "905", "images_lists_4_images_list", "733");
INSERT INTO `wp_postmeta` VALUES("2715", "905", "_images_lists_4_images_list", "field_58bf2f96ed6d4");
INSERT INTO `wp_postmeta` VALUES("2716", "905", "images_lists", "5");
INSERT INTO `wp_postmeta` VALUES("2717", "905", "_images_lists", "field_58bf2f79ed6d3");
INSERT INTO `wp_postmeta` VALUES("2718", "905", "_post_views", "74");
INSERT INTO `wp_postmeta` VALUES("2719", "905", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("2720", "905", "images_gallery", "a:5:{i:0;s:3:\"733\";i:1;s:3:\"732\";i:2;s:3:\"731\";i:3;s:3:\"730\";i:4;s:3:\"729\";}");
INSERT INTO `wp_postmeta` VALUES("2721", "905", "_images_gallery", "field_60ae46d02f589");
INSERT INTO `wp_postmeta` VALUES("2722", "905", "image_template", "");
INSERT INTO `wp_postmeta` VALUES("2723", "905", "_image_template", "field_5b5ce3de23ad5");
INSERT INTO `wp_postmeta` VALUES("2724", "905", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("2725", "905", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("2726", "905", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("2727", "905", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("2728", "905", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("2729", "905", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("2730", "905", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("2731", "905", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("2732", "905", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2733", "905", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2734", "905", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("2735", "905", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("2736", "693", "_edit_lock", "1644937640:1");
INSERT INTO `wp_postmeta` VALUES("2737", "803", "_edit_lock", "1644937646:1");
INSERT INTO `wp_postmeta` VALUES("2738", "70", "_edit_lock", "1645712511:1");
INSERT INTO `wp_postmeta` VALUES("2739", "643", "_edit_lock", "1644937658:1");
INSERT INTO `wp_postmeta` VALUES("2740", "485", "_edit_lock", "1644937662:1");
INSERT INTO `wp_postmeta` VALUES("2741", "75", "_edit_lock", "1644937671:1");
INSERT INTO `wp_postmeta` VALUES("2742", "418", "_edit_lock", "1644937678:1");
INSERT INTO `wp_postmeta` VALUES("2743", "445", "_edit_lock", "1644937683:1");
INSERT INTO `wp_postmeta` VALUES("2744", "914", "_wp_attached_file", "2020/05/Lost-in-Space-_-Official-Trailer-_-Netflix.mp4");
INSERT INTO `wp_postmeta` VALUES("2745", "915", "_wp_attached_file", "2022/02/Lost-in-Space-_-Official-Trailer-_-Netflix-mp4-image.png");
INSERT INTO `wp_postmeta` VALUES("2746", "915", "_cover_hash", "a580e4aa35d511382dc4579ee8d60e77");
INSERT INTO `wp_postmeta` VALUES("2747", "915", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:64:\"2022/02/Lost-in-Space-_-Official-Trailer-_-Netflix-mp4-image.png\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:64:\"Lost-in-Space-_-Official-Trailer-_-Netflix-mp4-image-300x169.png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:65:\"Lost-in-Space-_-Official-Trailer-_-Netflix-mp4-image-1024x576.png\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:64:\"Lost-in-Space-_-Official-Trailer-_-Netflix-mp4-image-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:64:\"Lost-in-Space-_-Official-Trailer-_-Netflix-mp4-image-768x432.png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2748", "914", "_thumbnail_id", "915");
INSERT INTO `wp_postmeta` VALUES("2749", "914", "_wp_attachment_metadata", "a:11:{s:8:\"filesize\";i:12800338;s:9:\"mime_type\";s:15:\"video/quicktime\";s:6:\"length\";i:172;s:16:\"length_formatted\";s:4:\"2:52\";s:5:\"width\";i:854;s:6:\"height\";i:480;s:10:\"fileformat\";s:9:\"quicktime\";s:10:\"dataformat\";s:9:\"quicktime\";s:5:\"audio\";a:7:{s:10:\"dataformat\";s:9:\"quicktime\";s:5:\"codec\";s:0:\"\";s:11:\"sample_rate\";d:48000;s:8:\"channels\";i:2;s:15:\"bits_per_sample\";i:16;s:8:\"lossless\";b:0;s:11:\"channelmode\";s:6:\"stereo\";}s:17:\"created_timestamp\";i:-2082844800;s:5:\"image\";a:1:{s:4:\"mime\";s:9:\"image/png\";}}");
INSERT INTO `wp_postmeta` VALUES("2750", "693", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2753", "693", "video_upload", "914");
INSERT INTO `wp_postmeta` VALUES("2754", "693", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("2755", "693", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("2756", "693", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("2757", "693", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("2758", "693", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2759", "693", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2760", "916", "_thumbnail_id", "694");
INSERT INTO `wp_postmeta` VALUES("2761", "916", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("2762", "916", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("2763", "916", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("2764", "916", "video-url", "https://vimeo.com/150522409");
INSERT INTO `wp_postmeta` VALUES("2765", "916", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("2766", "916", "featured-post", "1");
INSERT INTO `wp_postmeta` VALUES("2767", "916", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("2768", "916", "keep_trending", "1");
INSERT INTO `wp_postmeta` VALUES("2769", "916", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("2770", "916", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("2771", "916", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("2772", "916", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("2773", "916", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("2774", "916", "_post_views", "2520");
INSERT INTO `wp_postmeta` VALUES("2775", "916", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("2776", "916", "_post_like_count", "23");
INSERT INTO `wp_postmeta` VALUES("2777", "916", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2778", "916", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("2779", "916", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("2780", "916", "video_template", "");
INSERT INTO `wp_postmeta` VALUES("2781", "916", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("2782", "916", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("2783", "916", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("2784", "916", "video_upload", "914");
INSERT INTO `wp_postmeta` VALUES("2785", "916", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("2786", "916", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("2787", "916", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("2788", "916", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2789", "916", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2790", "803", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2793", "803", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2794", "803", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2795", "917", "video_tab", "0");
INSERT INTO `wp_postmeta` VALUES("2796", "917", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("2797", "917", "video-url", "https://open.spotify.com/track/3H7ihDc1dqLriiWXwsc2po?si=rXshOp06SCGvFjYAPKAM1A");
INSERT INTO `wp_postmeta` VALUES("2798", "917", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("2799", "917", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("2800", "917", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("2801", "917", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("2802", "917", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("2803", "917", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("2804", "917", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("2805", "917", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("2806", "917", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("2807", "917", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("2808", "917", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("2809", "917", "_post_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2810", "917", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2811", "917", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("2812", "917", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("2813", "917", "_post_views", "8");
INSERT INTO `wp_postmeta` VALUES("2814", "917", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("2815", "917", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2816", "917", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2817", "918", "_wp_attached_file", "2017/05/The-Dark-Crystal-Age-of-Resistance-_-Trailer-_-Netflix.mp4");
INSERT INTO `wp_postmeta` VALUES("2818", "919", "_wp_attached_file", "2022/02/The-Dark-Crystal-Age-of-Resistance-_-Trailer-_-Netflix-mp4-image.png");
INSERT INTO `wp_postmeta` VALUES("2819", "919", "_cover_hash", "0301c4300b18ce0a29c8da80d80b7b13");
INSERT INTO `wp_postmeta` VALUES("2820", "919", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:76:\"2022/02/The-Dark-Crystal-Age-of-Resistance-_-Trailer-_-Netflix-mp4-image.png\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:76:\"The-Dark-Crystal-Age-of-Resistance-_-Trailer-_-Netflix-mp4-image-300x169.png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:77:\"The-Dark-Crystal-Age-of-Resistance-_-Trailer-_-Netflix-mp4-image-1024x576.png\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:76:\"The-Dark-Crystal-Age-of-Resistance-_-Trailer-_-Netflix-mp4-image-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:76:\"The-Dark-Crystal-Age-of-Resistance-_-Trailer-_-Netflix-mp4-image-768x432.png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2821", "918", "_thumbnail_id", "919");
INSERT INTO `wp_postmeta` VALUES("2822", "918", "_wp_attachment_metadata", "a:11:{s:8:\"filesize\";i:10974061;s:9:\"mime_type\";s:15:\"video/quicktime\";s:6:\"length\";i:157;s:16:\"length_formatted\";s:4:\"2:37\";s:5:\"width\";i:854;s:6:\"height\";i:480;s:10:\"fileformat\";s:9:\"quicktime\";s:10:\"dataformat\";s:9:\"quicktime\";s:5:\"audio\";a:7:{s:10:\"dataformat\";s:9:\"quicktime\";s:5:\"codec\";s:0:\"\";s:11:\"sample_rate\";d:48000;s:8:\"channels\";i:2;s:15:\"bits_per_sample\";i:16;s:8:\"lossless\";b:0;s:11:\"channelmode\";s:6:\"stereo\";}s:17:\"created_timestamp\";i:-2082844800;s:5:\"image\";a:1:{s:4:\"mime\";s:9:\"image/png\";}}");
INSERT INTO `wp_postmeta` VALUES("2823", "70", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2826", "70", "video_upload", "918");
INSERT INTO `wp_postmeta` VALUES("2827", "70", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("2828", "70", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("2829", "70", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("2830", "70", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("2831", "70", "king_like_count", "1");
INSERT INTO `wp_postmeta` VALUES("2832", "70", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2833", "920", "video-url", "https://vimeo.com/50522981");
INSERT INTO `wp_postmeta` VALUES("2834", "920", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("2835", "920", "_thumbnail_id", "71");
INSERT INTO `wp_postmeta` VALUES("2836", "920", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("2837", "920", "_post_views", "1018");
INSERT INTO `wp_postmeta` VALUES("2838", "920", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("2839", "920", "featured-post", "1");
INSERT INTO `wp_postmeta` VALUES("2840", "920", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("2841", "920", "keep_trending", "1");
INSERT INTO `wp_postmeta` VALUES("2842", "920", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("2843", "920", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("2844", "920", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("2845", "920", "_post_like_count", "7");
INSERT INTO `wp_postmeta` VALUES("2846", "920", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2847", "920", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("2848", "920", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("2849", "920", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("2850", "920", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("2851", "920", "editors_choice", "1");
INSERT INTO `wp_postmeta` VALUES("2852", "920", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("2853", "920", "editors_note", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.");
INSERT INTO `wp_postmeta` VALUES("2854", "920", "_editors_note", "field_5c9bda8ad6b0c");
INSERT INTO `wp_postmeta` VALUES("2855", "920", "video_template", "");
INSERT INTO `wp_postmeta` VALUES("2856", "920", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("2857", "920", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("2858", "920", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("2859", "920", "video_upload", "918");
INSERT INTO `wp_postmeta` VALUES("2860", "920", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("2861", "920", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("2862", "920", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("2863", "920", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2864", "920", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2865", "921", "_wp_attached_file", "2017/05/Stranger-Things-_-Official-Final-Trailer-_-Netflix.mp4");
INSERT INTO `wp_postmeta` VALUES("2866", "922", "_wp_attached_file", "2022/02/Stranger-Things-_-Official-Final-Trailer-_-Netflix-mp4-image.png");
INSERT INTO `wp_postmeta` VALUES("2867", "922", "_cover_hash", "49ac23a6ca7e9229c30e8b3c142b9ccc");
INSERT INTO `wp_postmeta` VALUES("2868", "922", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:72:\"2022/02/Stranger-Things-_-Official-Final-Trailer-_-Netflix-mp4-image.png\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:72:\"Stranger-Things-_-Official-Final-Trailer-_-Netflix-mp4-image-300x169.png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:73:\"Stranger-Things-_-Official-Final-Trailer-_-Netflix-mp4-image-1024x576.png\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:72:\"Stranger-Things-_-Official-Final-Trailer-_-Netflix-mp4-image-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:72:\"Stranger-Things-_-Official-Final-Trailer-_-Netflix-mp4-image-768x432.png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2869", "921", "_thumbnail_id", "922");
INSERT INTO `wp_postmeta` VALUES("2870", "921", "_wp_attachment_metadata", "a:11:{s:8:\"filesize\";i:8896251;s:9:\"mime_type\";s:15:\"video/quicktime\";s:6:\"length\";i:131;s:16:\"length_formatted\";s:4:\"2:11\";s:5:\"width\";i:854;s:6:\"height\";i:480;s:10:\"fileformat\";s:9:\"quicktime\";s:10:\"dataformat\";s:9:\"quicktime\";s:5:\"audio\";a:7:{s:10:\"dataformat\";s:9:\"quicktime\";s:5:\"codec\";s:0:\"\";s:11:\"sample_rate\";d:48000;s:8:\"channels\";i:2;s:15:\"bits_per_sample\";i:16;s:8:\"lossless\";b:0;s:11:\"channelmode\";s:6:\"stereo\";}s:17:\"created_timestamp\";i:-2082844800;s:5:\"image\";a:1:{s:4:\"mime\";s:9:\"image/png\";}}");
INSERT INTO `wp_postmeta` VALUES("2871", "643", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2874", "643", "video_upload", "921");
INSERT INTO `wp_postmeta` VALUES("2875", "643", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("2876", "643", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("2877", "643", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("2878", "643", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("2879", "643", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("2880", "643", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("2881", "643", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2882", "643", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2883", "923", "video-url", "https://vimeo.com/95844798");
INSERT INTO `wp_postmeta` VALUES("2884", "923", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("2885", "923", "_post_views", "406");
INSERT INTO `wp_postmeta` VALUES("2886", "923", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("2887", "923", "_post_like_count", "1");
INSERT INTO `wp_postmeta` VALUES("2888", "923", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2889", "923", "featured-post", "1");
INSERT INTO `wp_postmeta` VALUES("2890", "923", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("2891", "923", "keep_trending", "1");
INSERT INTO `wp_postmeta` VALUES("2892", "923", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("2893", "923", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("2894", "923", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("2895", "923", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("2896", "923", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("2897", "923", "editors_choice", "1");
INSERT INTO `wp_postmeta` VALUES("2898", "923", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("2899", "923", "editors_note", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.");
INSERT INTO `wp_postmeta` VALUES("2900", "923", "_editors_note", "field_5c9bda8ad6b0c");
INSERT INTO `wp_postmeta` VALUES("2901", "923", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("2902", "923", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("2903", "923", "video_template", "");
INSERT INTO `wp_postmeta` VALUES("2904", "923", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("2905", "923", "_thumbnail_id", "671");
INSERT INTO `wp_postmeta` VALUES("2906", "923", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("2907", "923", "video_upload", "921");
INSERT INTO `wp_postmeta` VALUES("2908", "923", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("2909", "923", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("2910", "923", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("2911", "923", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("2912", "923", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("2913", "923", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2914", "923", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2915", "485", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2918", "924", "ad_link", "https://themes.wpnovin.com/King/Main");
INSERT INTO `wp_postmeta` VALUES("2919", "924", "_ad_link", "field_5a568932429f7");
INSERT INTO `wp_postmeta` VALUES("2920", "924", "ad_button_value", "همین حالا بخرید!");
INSERT INTO `wp_postmeta` VALUES("2921", "924", "_ad_button_value", "field_5a5688cf34274");
INSERT INTO `wp_postmeta` VALUES("2922", "924", "ad_extra_field", "تخفیف 70 درصدی");
INSERT INTO `wp_postmeta` VALUES("2923", "924", "_ad_extra_field", "field_5a59195facec4");
INSERT INTO `wp_postmeta` VALUES("2924", "924", "sponsored_text", "پست تبلیغاتی");
INSERT INTO `wp_postmeta` VALUES("2925", "924", "_sponsored_text", "field_5a5a7ec420b5a");
INSERT INTO `wp_postmeta` VALUES("2926", "75", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2929", "75", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2930", "75", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2931", "925", "list_post", "0");
INSERT INTO `wp_postmeta` VALUES("2932", "925", "_list_post", "field_57d3199b4ee91");
INSERT INTO `wp_postmeta` VALUES("2933", "925", "_post_views", "1404");
INSERT INTO `wp_postmeta` VALUES("2934", "925", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("2935", "925", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("2936", "925", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("2937", "925", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("2938", "925", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("2939", "925", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("2940", "925", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("2941", "925", "_post_like_count", "9");
INSERT INTO `wp_postmeta` VALUES("2942", "925", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2943", "925", "news_list_items", "");
INSERT INTO `wp_postmeta` VALUES("2944", "925", "_news_list_items", "field_58bddb0df74fe");
INSERT INTO `wp_postmeta` VALUES("2945", "925", "add_sponsor", "1");
INSERT INTO `wp_postmeta` VALUES("2946", "925", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("2947", "925", "post_sponsor_logo", "602");
INSERT INTO `wp_postmeta` VALUES("2948", "925", "_post_sponsor_logo", "field_5a568b7e056cb");
INSERT INTO `wp_postmeta` VALUES("2949", "925", "post_sponsor_link", "https://themes.wpnovin.com/King/Main");
INSERT INTO `wp_postmeta` VALUES("2950", "925", "_post_sponsor_link", "field_5a568bbe056cc");
INSERT INTO `wp_postmeta` VALUES("2951", "925", "post_sponsor_description", "نمونه پست اسپانسری");
INSERT INTO `wp_postmeta` VALUES("2952", "925", "_post_sponsor_description", "field_5a568be7056cd");
INSERT INTO `wp_postmeta` VALUES("2953", "925", "editors_choice", "1");
INSERT INTO `wp_postmeta` VALUES("2954", "925", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("2955", "925", "editors_note", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.");
INSERT INTO `wp_postmeta` VALUES("2956", "925", "_editors_note", "field_5c9bda8ad6b0c");
INSERT INTO `wp_postmeta` VALUES("2957", "925", "post_template", "");
INSERT INTO `wp_postmeta` VALUES("2958", "925", "_post_template", "field_5b5b94f0474bd");
INSERT INTO `wp_postmeta` VALUES("2959", "925", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2960", "925", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2961", "418", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2964", "418", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("2965", "418", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("2966", "418", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2967", "418", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2968", "926", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("2969", "926", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("2970", "926", "video_upload", "453");
INSERT INTO `wp_postmeta` VALUES("2971", "926", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("2972", "926", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("2973", "926", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("2974", "926", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("2975", "926", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("2976", "926", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("2977", "926", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("2978", "926", "_post_views", "146");
INSERT INTO `wp_postmeta` VALUES("2979", "926", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("2980", "926", "_thumbnail_id", "459");
INSERT INTO `wp_postmeta` VALUES("2981", "926", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("2982", "926", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("2983", "926", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("2984", "926", "editors_choice", "1");
INSERT INTO `wp_postmeta` VALUES("2985", "926", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("2986", "926", "editors_note", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.");
INSERT INTO `wp_postmeta` VALUES("2987", "926", "_editors_note", "field_5c9bda8ad6b0c");
INSERT INTO `wp_postmeta` VALUES("2988", "926", "_post_like_count", "1");
INSERT INTO `wp_postmeta` VALUES("2989", "926", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2990", "926", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("2991", "926", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("2992", "926", "video_template", "");
INSERT INTO `wp_postmeta` VALUES("2993", "926", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("2994", "926", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("2995", "926", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("2996", "926", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("2997", "926", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("2998", "445", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3001", "445", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("3002", "445", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("3003", "445", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("3004", "445", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("3005", "445", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("3006", "445", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("3007", "445", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("3008", "445", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3009", "445", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3010", "445", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("3011", "445", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("3012", "445", "video_template", "");
INSERT INTO `wp_postmeta` VALUES("3013", "445", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("3014", "927", "video-url", "");
INSERT INTO `wp_postmeta` VALUES("3015", "927", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("3016", "927", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("3017", "927", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("3018", "927", "video_upload", "461");
INSERT INTO `wp_postmeta` VALUES("3019", "927", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("3020", "927", "_thumbnail_id", "462");
INSERT INTO `wp_postmeta` VALUES("3021", "927", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("3022", "927", "_post_views", "91");
INSERT INTO `wp_postmeta` VALUES("3023", "927", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("3024", "927", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("3025", "927", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("3026", "927", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("3027", "927", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("3028", "927", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("3029", "927", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("3030", "927", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("3031", "927", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("3032", "927", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("3033", "927", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("3034", "927", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("3035", "927", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("3036", "927", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3037", "927", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3038", "927", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("3039", "927", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("3040", "927", "video_template", "");
INSERT INTO `wp_postmeta` VALUES("3041", "927", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("3042", "88", "_edit_lock", "1644937689:1");
INSERT INTO `wp_postmeta` VALUES("3043", "82", "_edit_lock", "1644937696:1");
INSERT INTO `wp_postmeta` VALUES("3044", "74", "_edit_lock", "1644937701:1");
INSERT INTO `wp_postmeta` VALUES("3045", "68", "_edit_lock", "1644937707:1");
INSERT INTO `wp_postmeta` VALUES("3046", "57", "_edit_lock", "1644937713:1");
INSERT INTO `wp_postmeta` VALUES("3047", "50", "_edit_lock", "1644937719:1");
INSERT INTO `wp_postmeta` VALUES("3048", "48", "_edit_lock", "1644937725:1");
INSERT INTO `wp_postmeta` VALUES("3049", "935", "_wp_attached_file", "2017/01/Beauty-shop-16.jpg");
INSERT INTO `wp_postmeta` VALUES("3050", "935", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:1200;s:4:\"file\";s:26:\"2017/01/Beauty-shop-16.jpg\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"Beauty-shop-16-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:28:\"Beauty-shop-16-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"Beauty-shop-16-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"Beauty-shop-16-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("3051", "936", "_wp_attached_file", "2017/01/Beauty-shop-17.jpg");
INSERT INTO `wp_postmeta` VALUES("3052", "936", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1600;s:6:\"height\";i:1600;s:4:\"file\";s:26:\"2017/01/Beauty-shop-17.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"Beauty-shop-17-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:28:\"Beauty-shop-17-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"Beauty-shop-17-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"Beauty-shop-17-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:28:\"Beauty-shop-17-1536x1536.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("3053", "937", "_wp_attached_file", "2017/01/Beauty-shop-18.jpg");
INSERT INTO `wp_postmeta` VALUES("3054", "937", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1600;s:6:\"height\";i:1600;s:4:\"file\";s:26:\"2017/01/Beauty-shop-18.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"Beauty-shop-18-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:28:\"Beauty-shop-18-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"Beauty-shop-18-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"Beauty-shop-18-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:28:\"Beauty-shop-18-1536x1536.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("3055", "938", "_wp_attached_file", "2017/01/Beauty-shop-19.jpg");
INSERT INTO `wp_postmeta` VALUES("3056", "938", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1252;s:6:\"height\";i:1252;s:4:\"file\";s:26:\"2017/01/Beauty-shop-19.jpg\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"Beauty-shop-19-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:28:\"Beauty-shop-19-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"Beauty-shop-19-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"Beauty-shop-19-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("3057", "939", "_wp_attached_file", "2017/01/Turning-Red.mp4");
INSERT INTO `wp_postmeta` VALUES("3058", "939", "_wp_attachment_metadata", "a:10:{s:8:\"filesize\";i:18035760;s:9:\"mime_type\";s:9:\"video/mp4\";s:6:\"length\";i:144;s:16:\"length_formatted\";s:4:\"2:24\";s:5:\"width\";i:892;s:6:\"height\";i:480;s:10:\"fileformat\";s:3:\"mp4\";s:10:\"dataformat\";s:9:\"quicktime\";s:5:\"audio\";a:7:{s:10:\"dataformat\";s:3:\"mp4\";s:5:\"codec\";s:19:\"ISO/IEC 14496-3 AAC\";s:11:\"sample_rate\";d:44100;s:8:\"channels\";i:2;s:15:\"bits_per_sample\";i:16;s:8:\"lossless\";b:0;s:11:\"channelmode\";s:6:\"stereo\";}s:17:\"created_timestamp\";i:-2082844800;}");
INSERT INTO `wp_postmeta` VALUES("3059", "940", "_wp_attached_file", "2017/01/Beauty-shop-32.jpg");
INSERT INTO `wp_postmeta` VALUES("3060", "940", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1600;s:6:\"height\";i:1060;s:4:\"file\";s:26:\"2017/01/Beauty-shop-32.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"Beauty-shop-32-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:27:\"Beauty-shop-32-1024x678.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:678;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"Beauty-shop-32-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"Beauty-shop-32-768x509.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:509;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:28:\"Beauty-shop-32-1536x1018.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1018;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("3061", "88", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3064", "88", "video_upload", "939");
INSERT INTO `wp_postmeta` VALUES("3065", "88", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("3066", "88", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("3067", "88", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("3068", "88", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("3069", "88", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("3070", "88", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("3071", "88", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3072", "88", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3073", "941", "video-url", "https://vimeo.com/4749536");
INSERT INTO `wp_postmeta` VALUES("3074", "941", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("3075", "941", "nsfw_post", "1");
INSERT INTO `wp_postmeta` VALUES("3076", "941", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("3077", "941", "_post_views", "274");
INSERT INTO `wp_postmeta` VALUES("3078", "941", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("3079", "941", "_thumbnail_id", "90");
INSERT INTO `wp_postmeta` VALUES("3080", "941", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("3081", "941", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("3082", "941", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("3083", "941", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("3084", "941", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("3085", "941", "_post_like_count", "6");
INSERT INTO `wp_postmeta` VALUES("3086", "941", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3087", "941", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("3088", "941", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("3089", "941", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("3090", "941", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("3091", "941", "editors_note", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
INSERT INTO `wp_postmeta` VALUES("3092", "941", "_editors_note", "field_5c7a918e60d3c");
INSERT INTO `wp_postmeta` VALUES("3093", "941", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("3094", "941", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("3095", "941", "video_template", "video-template-1");
INSERT INTO `wp_postmeta` VALUES("3096", "941", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("3097", "941", "video_upload", "939");
INSERT INTO `wp_postmeta` VALUES("3098", "941", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("3099", "941", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("3100", "941", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("3101", "941", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("3102", "941", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("3103", "941", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3104", "941", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3105", "74", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3108", "74", "images_gallery", "a:5:{i:0;s:3:\"935\";i:1;s:3:\"936\";i:2;s:3:\"937\";i:3;s:3:\"938\";i:4;s:3:\"940\";}");
INSERT INTO `wp_postmeta` VALUES("3109", "74", "_images_gallery", "field_60ae46d02f589");
INSERT INTO `wp_postmeta` VALUES("3110", "74", "image_template", "");
INSERT INTO `wp_postmeta` VALUES("3111", "74", "_image_template", "field_5b5ce3de23ad5");
INSERT INTO `wp_postmeta` VALUES("3112", "74", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("3113", "74", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("3114", "74", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("3115", "74", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("3116", "74", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("3117", "74", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("3118", "74", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("3119", "74", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("3120", "74", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("3121", "74", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3122", "74", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3123", "74", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("3124", "74", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("3125", "942", "images_post", "0");
INSERT INTO `wp_postmeta` VALUES("3126", "942", "_images_post", "field_57e96cc7b74a5");
INSERT INTO `wp_postmeta` VALUES("3127", "942", "_post_views", "624");
INSERT INTO `wp_postmeta` VALUES("3128", "942", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("3129", "942", "images_gallery", "a:5:{i:0;s:3:\"935\";i:1;s:3:\"936\";i:2;s:3:\"937\";i:3;s:3:\"938\";i:4;s:3:\"940\";}");
INSERT INTO `wp_postmeta` VALUES("3130", "942", "_images_gallery", "field_60ae46d02f589");
INSERT INTO `wp_postmeta` VALUES("3131", "942", "image_template", "");
INSERT INTO `wp_postmeta` VALUES("3132", "942", "_image_template", "field_5b5ce3de23ad5");
INSERT INTO `wp_postmeta` VALUES("3133", "942", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("3134", "942", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("3135", "942", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("3136", "942", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("3137", "942", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("3138", "942", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("3139", "942", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("3140", "942", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("3141", "942", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3142", "942", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3143", "942", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("3144", "942", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("3145", "943", "_wp_attached_file", "2017/01/Lost-in-Space-_-Official-Trailer-_-Netflix.mp4");
INSERT INTO `wp_postmeta` VALUES("3146", "943", "_thumbnail_id", "915");
INSERT INTO `wp_postmeta` VALUES("3147", "943", "_wp_attachment_metadata", "a:11:{s:8:\"filesize\";i:12800338;s:9:\"mime_type\";s:15:\"video/quicktime\";s:6:\"length\";i:172;s:16:\"length_formatted\";s:4:\"2:52\";s:5:\"width\";i:854;s:6:\"height\";i:480;s:10:\"fileformat\";s:9:\"quicktime\";s:10:\"dataformat\";s:9:\"quicktime\";s:5:\"audio\";a:7:{s:10:\"dataformat\";s:9:\"quicktime\";s:5:\"codec\";s:0:\"\";s:11:\"sample_rate\";d:48000;s:8:\"channels\";i:2;s:15:\"bits_per_sample\";i:16;s:8:\"lossless\";b:0;s:11:\"channelmode\";s:6:\"stereo\";}s:17:\"created_timestamp\";i:-2082844800;s:5:\"image\";a:1:{s:4:\"mime\";s:9:\"image/png\";}}");
INSERT INTO `wp_postmeta` VALUES("3148", "82", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3151", "82", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("3152", "82", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("3153", "82", "video_upload", "943");
INSERT INTO `wp_postmeta` VALUES("3154", "82", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("3155", "82", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("3156", "82", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("3157", "82", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("3158", "82", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("3159", "82", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("3160", "82", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("3161", "82", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("3162", "82", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("3163", "82", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3164", "82", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3165", "82", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("3166", "82", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("3167", "82", "video_template", "");
INSERT INTO `wp_postmeta` VALUES("3168", "82", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("3169", "944", "video-url", "https://www.youtube.com/watch?v=Nud5WD_nUY8");
INSERT INTO `wp_postmeta` VALUES("3170", "944", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("3171", "944", "_post_views", "659");
INSERT INTO `wp_postmeta` VALUES("3172", "944", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("3173", "944", "_thumbnail_id", "84");
INSERT INTO `wp_postmeta` VALUES("3174", "944", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("3175", "944", "featured-post", "1");
INSERT INTO `wp_postmeta` VALUES("3176", "944", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("3177", "944", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("3178", "944", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("3179", "944", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("3180", "944", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("3181", "944", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("3182", "944", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("3183", "944", "video_upload", "943");
INSERT INTO `wp_postmeta` VALUES("3184", "944", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("3185", "944", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("3186", "944", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("3187", "944", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("3188", "944", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("3189", "944", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("3190", "944", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("3191", "944", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3192", "944", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3193", "944", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("3194", "944", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("3195", "944", "video_template", "");
INSERT INTO `wp_postmeta` VALUES("3196", "944", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("3197", "945", "_wp_attached_file", "2017/01/Vaziat-Ghermez.mp4");
INSERT INTO `wp_postmeta` VALUES("3198", "945", "_wp_attachment_metadata", "a:10:{s:8:\"filesize\";i:11855757;s:9:\"mime_type\";s:9:\"video/mp4\";s:6:\"length\";i:106;s:16:\"length_formatted\";s:4:\"1:46\";s:5:\"width\";i:1140;s:6:\"height\";i:480;s:10:\"fileformat\";s:3:\"mp4\";s:10:\"dataformat\";s:9:\"quicktime\";s:5:\"audio\";a:7:{s:10:\"dataformat\";s:3:\"mp4\";s:5:\"codec\";s:19:\"ISO/IEC 14496-3 AAC\";s:11:\"sample_rate\";d:44100;s:8:\"channels\";i:2;s:15:\"bits_per_sample\";i:16;s:8:\"lossless\";b:0;s:11:\"channelmode\";s:6:\"stereo\";}s:17:\"created_timestamp\";i:-2082844800;}");
INSERT INTO `wp_postmeta` VALUES("3199", "57", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3202", "57", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3203", "57", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3204", "946", "list_post_0_list_title", "“Assume that you can get anyone to fall for you if you want them to.”");
INSERT INTO `wp_postmeta` VALUES("3205", "946", "_list_post_0_list_title", "field_57d31a5d4ee93");
INSERT INTO `wp_postmeta` VALUES("3206", "946", "list_post_0_list_image", "52");
INSERT INTO `wp_postmeta` VALUES("3207", "946", "_list_post_0_list_image", "field_57d31a314ee92");
INSERT INTO `wp_postmeta` VALUES("3208", "946", "list_post_0_list_media", "");
INSERT INTO `wp_postmeta` VALUES("3209", "946", "_list_post_0_list_media", "field_57d32ff383c0b");
INSERT INTO `wp_postmeta` VALUES("3210", "946", "list_post_0_list_content", "“It might not be true, but you should go into every date with that assumption, instead of worrying about whether or not the guy is into you.” –kristencarol");
INSERT INTO `wp_postmeta` VALUES("3211", "946", "_list_post_0_list_content", "field_57d31a724ee94");
INSERT INTO `wp_postmeta` VALUES("3212", "946", "list_post_1_list_title", "“Making the first move is terrifying but it will be the most awesome terrifying thing ever.”");
INSERT INTO `wp_postmeta` VALUES("3213", "946", "_list_post_1_list_title", "field_57d31a5d4ee93");
INSERT INTO `wp_postmeta` VALUES("3214", "946", "list_post_1_list_image", "53");
INSERT INTO `wp_postmeta` VALUES("3215", "946", "_list_post_1_list_image", "field_57d31a314ee92");
INSERT INTO `wp_postmeta` VALUES("3216", "946", "list_post_1_list_media", "");
INSERT INTO `wp_postmeta` VALUES("3217", "946", "_list_post_1_list_media", "field_57d32ff383c0b");
INSERT INTO `wp_postmeta` VALUES("3218", "946", "list_post_1_list_content", "");
INSERT INTO `wp_postmeta` VALUES("3219", "946", "_list_post_1_list_content", "field_57d31a724ee94");
INSERT INTO `wp_postmeta` VALUES("3220", "946", "list_post_2_list_title", "“The best pick up line in the world is ‘Hi, I’m (insert your name here).’”");
INSERT INTO `wp_postmeta` VALUES("3221", "946", "_list_post_2_list_title", "field_57d31a5d4ee93");
INSERT INTO `wp_postmeta` VALUES("3222", "946", "list_post_2_list_image", "54");
INSERT INTO `wp_postmeta` VALUES("3223", "946", "_list_post_2_list_image", "field_57d31a314ee92");
INSERT INTO `wp_postmeta` VALUES("3224", "946", "list_post_2_list_media", "");
INSERT INTO `wp_postmeta` VALUES("3225", "946", "_list_post_2_list_media", "field_57d32ff383c0b");
INSERT INTO `wp_postmeta` VALUES("3226", "946", "list_post_2_list_content", "");
INSERT INTO `wp_postmeta` VALUES("3227", "946", "_list_post_2_list_content", "field_57d31a724ee94");
INSERT INTO `wp_postmeta` VALUES("3228", "946", "list_post_3_list_title", "Believe people’s actions, not their words.");
INSERT INTO `wp_postmeta` VALUES("3229", "946", "_list_post_3_list_title", "field_57d31a5d4ee93");
INSERT INTO `wp_postmeta` VALUES("3230", "946", "list_post_3_list_image", "55");
INSERT INTO `wp_postmeta` VALUES("3231", "946", "_list_post_3_list_image", "field_57d31a314ee92");
INSERT INTO `wp_postmeta` VALUES("3232", "946", "list_post_3_list_media", "");
INSERT INTO `wp_postmeta` VALUES("3233", "946", "_list_post_3_list_media", "field_57d32ff383c0b");
INSERT INTO `wp_postmeta` VALUES("3234", "946", "list_post_3_list_content", "“If he/she’s not contacting you, or playing games, or being flaky, etc., it’s pretty clear what they actually think, despite what they may have said.” –Mcfly7719");
INSERT INTO `wp_postmeta` VALUES("3235", "946", "_list_post_3_list_content", "field_57d31a724ee94");
INSERT INTO `wp_postmeta` VALUES("3236", "946", "list_post_4_list_title", "And don’t feel like you need to change for anyone.");
INSERT INTO `wp_postmeta` VALUES("3237", "946", "_list_post_4_list_title", "field_57d31a5d4ee93");
INSERT INTO `wp_postmeta` VALUES("3238", "946", "list_post_4_list_image", "56");
INSERT INTO `wp_postmeta` VALUES("3239", "946", "_list_post_4_list_image", "field_57d31a314ee92");
INSERT INTO `wp_postmeta` VALUES("3240", "946", "list_post_4_list_media", "");
INSERT INTO `wp_postmeta` VALUES("3241", "946", "_list_post_4_list_media", "field_57d32ff383c0b");
INSERT INTO `wp_postmeta` VALUES("3242", "946", "list_post_4_list_content", "");
INSERT INTO `wp_postmeta` VALUES("3243", "946", "_list_post_4_list_content", "field_57d31a724ee94");
INSERT INTO `wp_postmeta` VALUES("3244", "946", "list_post", "5");
INSERT INTO `wp_postmeta` VALUES("3245", "946", "_list_post", "field_57d3199b4ee91");
INSERT INTO `wp_postmeta` VALUES("3246", "946", "_post_views", "499");
INSERT INTO `wp_postmeta` VALUES("3247", "946", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("3248", "946", "news_list_items_0_news_list_title", " “Assume that you can get anyone to fall for you if you want them to.”");
INSERT INTO `wp_postmeta` VALUES("3249", "946", "_news_list_items_0_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("3250", "946", "news_list_items_0_news_image_or_video", "0");
INSERT INTO `wp_postmeta` VALUES("3251", "946", "_news_list_items_0_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("3252", "946", "news_list_items_0_news_list_image", "139");
INSERT INTO `wp_postmeta` VALUES("3253", "946", "_news_list_items_0_news_list_image", "field_58bddb82f7501");
INSERT INTO `wp_postmeta` VALUES("3254", "946", "news_list_items_0_news_list_content", "“It might not be true, but you should go into every date with that assumption, instead of worrying about whether or not the guy is into you.” –kristencarol");
INSERT INTO `wp_postmeta` VALUES("3255", "946", "_news_list_items_0_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("3256", "946", "news_list_items_1_news_list_title", "“Making the first move is terrifying but it will be the most awesome terrifying thing ever.”");
INSERT INTO `wp_postmeta` VALUES("3257", "946", "_news_list_items_1_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("3258", "946", "news_list_items_1_news_image_or_video", "0");
INSERT INTO `wp_postmeta` VALUES("3259", "946", "_news_list_items_1_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("3260", "946", "news_list_items_1_news_list_image", "140");
INSERT INTO `wp_postmeta` VALUES("3261", "946", "_news_list_items_1_news_list_image", "field_58bddb82f7501");
INSERT INTO `wp_postmeta` VALUES("3262", "946", "news_list_items_1_news_list_content", "");
INSERT INTO `wp_postmeta` VALUES("3263", "946", "_news_list_items_1_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("3264", "946", "news_list_items_2_news_list_title", "“The best pick up line in the world is ‘Hi, I’m (insert your name here).’”");
INSERT INTO `wp_postmeta` VALUES("3265", "946", "_news_list_items_2_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("3266", "946", "news_list_items_2_news_image_or_video", "0");
INSERT INTO `wp_postmeta` VALUES("3267", "946", "_news_list_items_2_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("3268", "946", "news_list_items_2_news_list_image", "141");
INSERT INTO `wp_postmeta` VALUES("3269", "946", "_news_list_items_2_news_list_image", "field_58bddb82f7501");
INSERT INTO `wp_postmeta` VALUES("3270", "946", "news_list_items_2_news_list_content", "");
INSERT INTO `wp_postmeta` VALUES("3271", "946", "_news_list_items_2_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("3272", "946", "news_list_items_3_news_list_title", "Believe people’s actions, not their words.");
INSERT INTO `wp_postmeta` VALUES("3273", "946", "_news_list_items_3_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("3274", "946", "news_list_items_3_news_image_or_video", "0");
INSERT INTO `wp_postmeta` VALUES("3275", "946", "_news_list_items_3_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("3276", "946", "news_list_items_3_news_list_image", "142");
INSERT INTO `wp_postmeta` VALUES("3277", "946", "_news_list_items_3_news_list_image", "field_58bddb82f7501");
INSERT INTO `wp_postmeta` VALUES("3278", "946", "news_list_items_3_news_list_content", "“If he/she’s not contacting you, or playing games, or being flaky, etc., it’s pretty clear what they actually think, despite what they may have said.” –Mcfly7719");
INSERT INTO `wp_postmeta` VALUES("3279", "946", "_news_list_items_3_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("3280", "946", "news_list_items_4_news_list_title", "And don’t feel like you need to change for anyone.");
INSERT INTO `wp_postmeta` VALUES("3281", "946", "_news_list_items_4_news_list_title", "field_58bddb31f74ff");
INSERT INTO `wp_postmeta` VALUES("3282", "946", "news_list_items_4_news_image_or_video", "0");
INSERT INTO `wp_postmeta` VALUES("3283", "946", "_news_list_items_4_news_image_or_video", "field_58bddb5ef7500");
INSERT INTO `wp_postmeta` VALUES("3284", "946", "news_list_items_4_news_list_image", "143");
INSERT INTO `wp_postmeta` VALUES("3285", "946", "_news_list_items_4_news_list_image", "field_58bddb82f7501");
INSERT INTO `wp_postmeta` VALUES("3286", "946", "news_list_items_4_news_list_content", "");
INSERT INTO `wp_postmeta` VALUES("3287", "946", "_news_list_items_4_news_list_content", "field_58bddbd2f7503");
INSERT INTO `wp_postmeta` VALUES("3288", "946", "news_list_items", "5");
INSERT INTO `wp_postmeta` VALUES("3289", "946", "_news_list_items", "field_58bddb0df74fe");
INSERT INTO `wp_postmeta` VALUES("3290", "946", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("3291", "946", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("3292", "946", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("3293", "946", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("3294", "946", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("3295", "946", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("3296", "946", "_post_like_count", "1");
INSERT INTO `wp_postmeta` VALUES("3297", "946", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3298", "946", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("3299", "946", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("3300", "946", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("3301", "946", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("3302", "946", "post_template", "template-6");
INSERT INTO `wp_postmeta` VALUES("3303", "946", "_post_template", "field_5b5b94f0474bd");
INSERT INTO `wp_postmeta` VALUES("3304", "946", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3305", "946", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3306", "50", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3309", "50", "video_tab", "0");
INSERT INTO `wp_postmeta` VALUES("3310", "50", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("3311", "50", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("3312", "50", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("3313", "50", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("3314", "50", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("3315", "50", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("3316", "50", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("3317", "50", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("3318", "50", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("3319", "50", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("3320", "50", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("3321", "50", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("3322", "50", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3323", "50", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3324", "50", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("3325", "50", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("3326", "50", "video_template", "");
INSERT INTO `wp_postmeta` VALUES("3327", "50", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("3328", "947", "video-url", "https://soundcloud.com/henri-pfr/novo-amor-from-gold-henri-pfr-remix");
INSERT INTO `wp_postmeta` VALUES("3329", "947", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("3330", "947", "_post_views", "240");
INSERT INTO `wp_postmeta` VALUES("3331", "947", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("3332", "947", "video_tab", "0");
INSERT INTO `wp_postmeta` VALUES("3333", "947", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("3334", "947", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("3335", "947", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("3336", "947", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("3337", "947", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("3338", "947", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("3339", "947", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("3340", "947", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("3341", "947", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("3342", "947", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("3343", "947", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("3344", "947", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3345", "947", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3346", "947", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("3347", "947", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("3348", "947", "video_template", "");
INSERT INTO `wp_postmeta` VALUES("3349", "947", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("3350", "948", "_wp_attached_file", "2017/01/Vaziat-Ghermez.jpg");
INSERT INTO `wp_postmeta` VALUES("3351", "948", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:506;s:4:\"file\";s:26:\"2017/01/Vaziat-Ghermez.jpg\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"Vaziat-Ghermez-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"Vaziat-Ghermez-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"Vaziat-Ghermez-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("3352", "68", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3355", "68", "video_upload", "945");
INSERT INTO `wp_postmeta` VALUES("3356", "68", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("3357", "68", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("3358", "68", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("3359", "68", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("3360", "68", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("3361", "68", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("3362", "68", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3363", "68", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3364", "949", "video-url", "https://vimeo.com/94502406");
INSERT INTO `wp_postmeta` VALUES("3365", "949", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("3366", "949", "_thumbnail_id", "948");
INSERT INTO `wp_postmeta` VALUES("3367", "949", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("3368", "949", "_post_views", "305");
INSERT INTO `wp_postmeta` VALUES("3369", "949", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("3370", "949", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("3371", "949", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("3372", "949", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("3373", "949", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("3374", "949", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("3375", "949", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("3376", "949", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("3377", "949", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("3378", "949", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("3379", "949", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("3380", "949", "_post_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3381", "949", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3382", "949", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("3383", "949", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("3384", "949", "video_template", "video-template-2");
INSERT INTO `wp_postmeta` VALUES("3385", "949", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("3386", "949", "video_upload", "945");
INSERT INTO `wp_postmeta` VALUES("3387", "949", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("3388", "949", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("3389", "949", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("3390", "949", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("3391", "949", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("3392", "949", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3393", "949", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3394", "950", "_wp_attached_file", "2017/01/Joker.mp4");
INSERT INTO `wp_postmeta` VALUES("3395", "950", "_wp_attachment_metadata", "a:10:{s:8:\"filesize\";i:3299309;s:9:\"mime_type\";s:9:\"video/mp4\";s:6:\"length\";i:51;s:16:\"length_formatted\";s:4:\"0:51\";s:5:\"width\";i:854;s:6:\"height\";i:480;s:10:\"fileformat\";s:3:\"mp4\";s:10:\"dataformat\";s:9:\"quicktime\";s:5:\"audio\";a:7:{s:10:\"dataformat\";s:3:\"mp4\";s:5:\"codec\";s:19:\"ISO/IEC 14496-3 AAC\";s:11:\"sample_rate\";d:44100;s:8:\"channels\";i:2;s:15:\"bits_per_sample\";i:16;s:8:\"lossless\";b:0;s:11:\"channelmode\";s:6:\"stereo\";}s:17:\"created_timestamp\";i:-2082844800;}");
INSERT INTO `wp_postmeta` VALUES("3396", "951", "_wp_attached_file", "2017/01/Joker.jpg");
INSERT INTO `wp_postmeta` VALUES("3397", "951", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:800;s:6:\"height\";i:500;s:4:\"file\";s:17:\"2017/01/Joker.jpg\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"Joker-300x188.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:188;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"Joker-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:17:\"Joker-768x480.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("3398", "48", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3401", "48", "video_upload", "950");
INSERT INTO `wp_postmeta` VALUES("3402", "48", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("3403", "48", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("3404", "48", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("3405", "48", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("3406", "48", "king_like_count", "1");
INSERT INTO `wp_postmeta` VALUES("3407", "48", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3408", "952", "video-url", "https://vimeo.com/94017018");
INSERT INTO `wp_postmeta` VALUES("3409", "952", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("3410", "952", "_thumbnail_id", "951");
INSERT INTO `wp_postmeta` VALUES("3411", "952", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("3412", "952", "_post_views", "253");
INSERT INTO `wp_postmeta` VALUES("3413", "952", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("3414", "952", "featured-post", "1");
INSERT INTO `wp_postmeta` VALUES("3415", "952", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("3416", "952", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("3417", "952", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("3418", "952", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("3419", "952", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("3420", "952", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("3421", "952", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("3422", "952", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("3423", "952", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("3424", "952", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("3425", "952", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("3426", "952", "_post_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3427", "952", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3428", "952", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("3429", "952", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("3430", "952", "video_template", "");
INSERT INTO `wp_postmeta` VALUES("3431", "952", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("3432", "952", "video_upload", "950");
INSERT INTO `wp_postmeta` VALUES("3433", "952", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("3434", "952", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("3435", "952", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("3436", "952", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3437", "952", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3438", "795", "_edit_lock", "1644937744:1");
INSERT INTO `wp_postmeta` VALUES("3439", "44", "_edit_lock", "1644937749:1");
INSERT INTO `wp_postmeta` VALUES("3440", "37", "_edit_lock", "1644937753:1");
INSERT INTO `wp_postmeta` VALUES("3441", "20", "_edit_lock", "1644937760:1");
INSERT INTO `wp_postmeta` VALUES("3442", "956", "_wp_attached_file", "2017/01/Moshaver-Amlak-5.jpg");
INSERT INTO `wp_postmeta` VALUES("3443", "956", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:768;s:4:\"file\";s:28:\"2017/01/Moshaver-Amlak-5.jpg\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"Moshaver-Amlak-5-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"Moshaver-Amlak-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:28:\"Moshaver-Amlak-5-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("3444", "957", "_wp_attached_file", "2017/01/Moshaver-Amlak-6.jpg");
INSERT INTO `wp_postmeta` VALUES("3445", "957", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:683;s:4:\"file\";s:28:\"2017/01/Moshaver-Amlak-6.jpg\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"Moshaver-Amlak-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"Moshaver-Amlak-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:28:\"Moshaver-Amlak-6-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("3446", "958", "_wp_attached_file", "2017/01/Moshaver-Amlak-8.jpg");
INSERT INTO `wp_postmeta` VALUES("3447", "958", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:683;s:4:\"file\";s:28:\"2017/01/Moshaver-Amlak-8.jpg\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"Moshaver-Amlak-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"Moshaver-Amlak-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:28:\"Moshaver-Amlak-8-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("3448", "959", "_wp_attached_file", "2017/01/Moshaver-Amlak-carosel-2.jpg");
INSERT INTO `wp_postmeta` VALUES("3449", "959", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1080;s:4:\"file\";s:36:\"2017/01/Moshaver-Amlak-carosel-2.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"Moshaver-Amlak-carosel-2-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:37:\"Moshaver-Amlak-carosel-2-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"Moshaver-Amlak-carosel-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"Moshaver-Amlak-carosel-2-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:37:\"Moshaver-Amlak-carosel-2-1536x864.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:864;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("3450", "795", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3453", "795", "images_gallery", "a:5:{i:0;s:3:\"956\";i:1;s:3:\"957\";i:2;s:3:\"958\";i:3;s:3:\"959\";i:4;s:3:\"796\";}");
INSERT INTO `wp_postmeta` VALUES("3454", "795", "_images_gallery", "field_60ae46d02f589");
INSERT INTO `wp_postmeta` VALUES("3455", "795", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3456", "795", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3457", "960", "images_lists", "");
INSERT INTO `wp_postmeta` VALUES("3458", "960", "_images_lists", "field_58bf2f79ed6d3");
INSERT INTO `wp_postmeta` VALUES("3459", "960", "image_template", "image-template-2");
INSERT INTO `wp_postmeta` VALUES("3460", "960", "_image_template", "field_5b5ce3de23ad5");
INSERT INTO `wp_postmeta` VALUES("3461", "960", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("3462", "960", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("3463", "960", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("3464", "960", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("3465", "960", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("3466", "960", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("3467", "960", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("3468", "960", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("3469", "960", "_post_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3470", "960", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3471", "960", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("3472", "960", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("3473", "960", "_post_views", "10");
INSERT INTO `wp_postmeta` VALUES("3474", "960", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("3475", "960", "images_gallery", "a:5:{i:0;s:3:\"956\";i:1;s:3:\"957\";i:2;s:3:\"958\";i:3;s:3:\"959\";i:4;s:3:\"796\";}");
INSERT INTO `wp_postmeta` VALUES("3476", "960", "_images_gallery", "field_60ae46d02f589");
INSERT INTO `wp_postmeta` VALUES("3477", "960", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3478", "960", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3479", "44", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3482", "44", "images_gallery", "a:3:{i:0;s:3:\"134\";i:1;s:3:\"136\";i:2;s:3:\"137\";}");
INSERT INTO `wp_postmeta` VALUES("3483", "44", "_images_gallery", "field_60ae46d02f589");
INSERT INTO `wp_postmeta` VALUES("3484", "44", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3485", "44", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3486", "961", "images_post_0_images_image", "41");
INSERT INTO `wp_postmeta` VALUES("3487", "961", "_images_post_0_images_image", "field_57e96d04b74a6");
INSERT INTO `wp_postmeta` VALUES("3488", "961", "images_post_1_images_image", "42");
INSERT INTO `wp_postmeta` VALUES("3489", "961", "_images_post_1_images_image", "field_57e96d04b74a6");
INSERT INTO `wp_postmeta` VALUES("3490", "961", "images_post_2_images_image", "43");
INSERT INTO `wp_postmeta` VALUES("3491", "961", "_images_post_2_images_image", "field_57e96d04b74a6");
INSERT INTO `wp_postmeta` VALUES("3492", "961", "images_post", "3");
INSERT INTO `wp_postmeta` VALUES("3493", "961", "_images_post", "field_57e96cc7b74a5");
INSERT INTO `wp_postmeta` VALUES("3494", "961", "_post_views", "270");
INSERT INTO `wp_postmeta` VALUES("3495", "961", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("3496", "961", "_post_like_count", "2");
INSERT INTO `wp_postmeta` VALUES("3497", "961", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3498", "961", "images_lists_0_images_list", "134");
INSERT INTO `wp_postmeta` VALUES("3499", "961", "_images_lists_0_images_list", "field_58bf2f96ed6d4");
INSERT INTO `wp_postmeta` VALUES("3500", "961", "images_lists_1_images_list", "136");
INSERT INTO `wp_postmeta` VALUES("3501", "961", "_images_lists_1_images_list", "field_58bf2f96ed6d4");
INSERT INTO `wp_postmeta` VALUES("3502", "961", "images_lists_2_images_list", "137");
INSERT INTO `wp_postmeta` VALUES("3503", "961", "_images_lists_2_images_list", "field_58bf2f96ed6d4");
INSERT INTO `wp_postmeta` VALUES("3504", "961", "images_lists", "3");
INSERT INTO `wp_postmeta` VALUES("3505", "961", "_images_lists", "field_58bf2f79ed6d3");
INSERT INTO `wp_postmeta` VALUES("3506", "961", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("3507", "961", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("3508", "961", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("3509", "961", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("3510", "961", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("3511", "961", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("3512", "961", "image_template", "image-template-1");
INSERT INTO `wp_postmeta` VALUES("3513", "961", "_image_template", "field_5b5ce3de23ad5");
INSERT INTO `wp_postmeta` VALUES("3514", "961", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("3515", "961", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("3516", "961", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("3517", "961", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("3518", "961", "images_gallery", "a:3:{i:0;s:3:\"134\";i:1;s:3:\"136\";i:2;s:3:\"137\";}");
INSERT INTO `wp_postmeta` VALUES("3519", "961", "_images_gallery", "field_60ae46d02f589");
INSERT INTO `wp_postmeta` VALUES("3520", "961", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3521", "961", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3522", "962", "_wp_attached_file", "2017/01/Sina-Derakhshande_Engar-Na-Engar.mp3");
INSERT INTO `wp_postmeta` VALUES("3523", "962", "_wp_attachment_metadata", "a:20:{s:10:\"dataformat\";s:3:\"mp3\";s:8:\"channels\";i:2;s:11:\"sample_rate\";i:44100;s:7:\"bitrate\";i:320000;s:11:\"channelmode\";s:12:\"joint stereo\";s:12:\"bitrate_mode\";s:3:\"cbr\";s:8:\"lossless\";b:0;s:15:\"encoder_options\";s:6:\"CBR320\";s:17:\"compression_ratio\";d:0.226757369614512482858259545537293888628482818603515625;s:10:\"fileformat\";s:3:\"mp3\";s:8:\"filesize\";i:5980525;s:9:\"mime_type\";s:10:\"audio/mpeg\";s:6:\"length\";i:146;s:16:\"length_formatted\";s:4:\"2:26\";s:5:\"title\";s:26:\"Engar Na Engar - [Nex1.ir]\";s:6:\"artist\";s:17:\"Sina Derakhshande\";s:5:\"album\";s:12:\"Single Album\";s:4:\"year\";s:4:\"2020\";s:5:\"genre\";s:4:\"2020\";s:7:\"comment\";s:11:\"[ Nex1.ir ]\";}");
INSERT INTO `wp_postmeta` VALUES("3524", "37", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3527", "37", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("3528", "37", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("3529", "37", "video_upload", "962");
INSERT INTO `wp_postmeta` VALUES("3530", "37", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("3531", "37", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("3532", "37", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("3533", "37", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("3534", "37", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("3535", "37", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("3536", "37", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("3537", "37", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("3538", "37", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("3539", "37", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3540", "37", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3541", "37", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("3542", "37", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("3543", "37", "video_template", "");
INSERT INTO `wp_postmeta` VALUES("3544", "37", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("3545", "963", "video-url", "https://soundcloud.com/wizkhalifa/king-of-everything");
INSERT INTO `wp_postmeta` VALUES("3546", "963", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("3547", "963", "_post_views", "140");
INSERT INTO `wp_postmeta` VALUES("3548", "963", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("3549", "963", "_thumbnail_id", "59");
INSERT INTO `wp_postmeta` VALUES("3550", "963", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("3551", "963", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("3552", "963", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("3553", "963", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("3554", "963", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("3555", "963", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("3556", "963", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("3557", "963", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("3558", "963", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("3559", "963", "video_upload", "962");
INSERT INTO `wp_postmeta` VALUES("3560", "963", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("3561", "963", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("3562", "963", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("3563", "963", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("3564", "963", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("3565", "963", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("3566", "963", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("3567", "963", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3568", "963", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3569", "963", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("3570", "963", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("3571", "963", "video_template", "");
INSERT INTO `wp_postmeta` VALUES("3572", "963", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("3573", "964", "_wp_attached_file", "2017/01/Jaws-Official-Trailer-1-Richard-Dreyfuss-Steven-Spielberg-Movie-1975-HD.mp4");
INSERT INTO `wp_postmeta` VALUES("3574", "965", "_wp_attached_file", "2022/02/Jaws-Official-Trailer-1-Richard-Dreyfuss-Steven-Spielberg-Movie-1975-HD-mp4-image.jpg");
INSERT INTO `wp_postmeta` VALUES("3575", "965", "_cover_hash", "6ddaa3fa623c5e143d6d6b722eeca8e4");
INSERT INTO `wp_postmeta` VALUES("3576", "965", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:720;s:4:\"file\";s:93:\"2022/02/Jaws-Official-Trailer-1-Richard-Dreyfuss-Steven-Spielberg-Movie-1975-HD-mp4-image.jpg\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:93:\"Jaws-Official-Trailer-1-Richard-Dreyfuss-Steven-Spielberg-Movie-1975-HD-mp4-image-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:94:\"Jaws-Official-Trailer-1-Richard-Dreyfuss-Steven-Spielberg-Movie-1975-HD-mp4-image-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:93:\"Jaws-Official-Trailer-1-Richard-Dreyfuss-Steven-Spielberg-Movie-1975-HD-mp4-image-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:93:\"Jaws-Official-Trailer-1-Richard-Dreyfuss-Steven-Spielberg-Movie-1975-HD-mp4-image-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("3577", "964", "_thumbnail_id", "965");
INSERT INTO `wp_postmeta` VALUES("3578", "964", "_wp_attachment_metadata", "a:11:{s:8:\"filesize\";i:6112497;s:9:\"mime_type\";s:15:\"video/quicktime\";s:6:\"length\";i:201;s:16:\"length_formatted\";s:4:\"3:21\";s:5:\"width\";i:426;s:6:\"height\";i:182;s:10:\"fileformat\";s:9:\"quicktime\";s:10:\"dataformat\";s:9:\"quicktime\";s:5:\"audio\";a:7:{s:10:\"dataformat\";s:9:\"quicktime\";s:5:\"codec\";s:0:\"\";s:11:\"sample_rate\";d:48000;s:8:\"channels\";i:2;s:15:\"bits_per_sample\";i:16;s:8:\"lossless\";b:0;s:11:\"channelmode\";s:6:\"stereo\";}s:17:\"created_timestamp\";i:-2082844800;s:5:\"image\";a:1:{s:4:\"mime\";s:10:\"image/jpeg\";}}");
INSERT INTO `wp_postmeta` VALUES("3579", "966", "_wp_attached_file", "2017/01/Ejdehaye-Chini.jpg");
INSERT INTO `wp_postmeta` VALUES("3580", "966", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:324;s:4:\"file\";s:26:\"2017/01/Ejdehaye-Chini.jpg\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"Ejdehaye-Chini-300x162.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:162;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"Ejdehaye-Chini-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("3581", "20", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3584", "20", "video_upload", "964");
INSERT INTO `wp_postmeta` VALUES("3585", "20", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("3586", "20", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("3587", "20", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("3588", "20", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("3589", "20", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("3590", "20", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("3591", "20", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3592", "20", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3593", "967", "video-url", "https://www.youtube.com/watch?v=OvgyXKDXdZY");
INSERT INTO `wp_postmeta` VALUES("3594", "967", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("3595", "967", "_post_views", "98");
INSERT INTO `wp_postmeta` VALUES("3596", "967", "__post_views", "field_592499e8bbd9a");
INSERT INTO `wp_postmeta` VALUES("3597", "967", "featured-post", "0");
INSERT INTO `wp_postmeta` VALUES("3598", "967", "_featured-post", "field_587be13bfc2f0");
INSERT INTO `wp_postmeta` VALUES("3599", "967", "keep_trending", "0");
INSERT INTO `wp_postmeta` VALUES("3600", "967", "_keep_trending", "field_587be15ffc2f1");
INSERT INTO `wp_postmeta` VALUES("3601", "967", "nsfw_post", "0");
INSERT INTO `wp_postmeta` VALUES("3602", "967", "_nsfw_post", "field_587be16ffc2f2");
INSERT INTO `wp_postmeta` VALUES("3603", "967", "_thumbnail_id", "966");
INSERT INTO `wp_postmeta` VALUES("3604", "967", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("3605", "967", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("3606", "967", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("3607", "967", "editors_choice", "0");
INSERT INTO `wp_postmeta` VALUES("3608", "967", "_editors_choice", "field_5c9bda3ad6b0b");
INSERT INTO `wp_postmeta` VALUES("3609", "967", "_post_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3610", "967", "__post_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3611", "967", "add_sponsor", "0");
INSERT INTO `wp_postmeta` VALUES("3612", "967", "_add_sponsor", "field_5a568a7c056ca");
INSERT INTO `wp_postmeta` VALUES("3613", "967", "video_template", "video-template-3");
INSERT INTO `wp_postmeta` VALUES("3614", "967", "_video_template", "field_5b5b932a71d23");
INSERT INTO `wp_postmeta` VALUES("3615", "967", "video_upload", "964");
INSERT INTO `wp_postmeta` VALUES("3616", "967", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("3617", "967", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("3618", "967", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("3619", "967", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("3620", "967", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("3621", "967", "king_like_count", "");
INSERT INTO `wp_postmeta` VALUES("3622", "967", "_king_like_count", "field_593098698a880");
INSERT INTO `wp_postmeta` VALUES("3623", "653", "enable_mega_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3624", "653", "_enable_mega_menu", "field_61964183f0755");
INSERT INTO `wp_postmeta` VALUES("3625", "653", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3626", "653", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3627", "630", "enable_mega_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3628", "630", "_enable_mega_menu", "field_61964183f0755");
INSERT INTO `wp_postmeta` VALUES("3629", "630", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3630", "630", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3631", "663", "enable_mega_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3632", "663", "_enable_mega_menu", "field_61964183f0755");
INSERT INTO `wp_postmeta` VALUES("3633", "663", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3634", "663", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3635", "641", "enable_mega_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3636", "641", "_enable_mega_menu", "field_61964183f0755");
INSERT INTO `wp_postmeta` VALUES("3637", "641", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3638", "641", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3639", "664", "enable_mega_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3640", "664", "_enable_mega_menu", "field_61964183f0755");
INSERT INTO `wp_postmeta` VALUES("3641", "664", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3642", "664", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3643", "666", "enable_mega_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3644", "666", "_enable_mega_menu", "field_61964183f0755");
INSERT INTO `wp_postmeta` VALUES("3645", "666", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3646", "666", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3647", "665", "enable_mega_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3648", "665", "_enable_mega_menu", "field_61964183f0755");
INSERT INTO `wp_postmeta` VALUES("3649", "665", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3650", "665", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3651", "668", "enable_mega_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3652", "668", "_enable_mega_menu", "field_61964183f0755");
INSERT INTO `wp_postmeta` VALUES("3653", "668", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3654", "668", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3655", "653", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3656", "630", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3657", "663", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3658", "641", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3659", "664", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3660", "666", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3661", "665", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3662", "668", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3663", "644", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3664", "644", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3665", "647", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3666", "647", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3667", "648", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3668", "648", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3669", "670", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3670", "670", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3671", "645", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3672", "645", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3673", "669", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3674", "669", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3675", "652", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3676", "652", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3677", "646", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3678", "646", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3679", "649", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3680", "649", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3681", "651", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3682", "651", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3683", "541", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3684", "541", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3685", "650", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3686", "650", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3687", "623", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3688", "623", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3689", "621", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3690", "621", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3691", "829", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3692", "829", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3693", "624", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3694", "624", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3695", "625", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3696", "625", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3697", "622", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3698", "622", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3699", "627", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3700", "627", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3701", "626", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3702", "626", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3703", "830", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3704", "830", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3705", "831", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3706", "831", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3707", "628", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3708", "628", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3709", "762", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3710", "762", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3711", "766", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3712", "766", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3713", "763", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3714", "763", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3715", "764", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3716", "764", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3717", "765", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3718", "765", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3719", "773", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3720", "773", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3721", "780", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3722", "780", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3723", "779", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3724", "779", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3725", "774", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3726", "774", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3727", "790", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3728", "790", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3729", "783", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3730", "783", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3731", "786", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3732", "786", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3733", "789", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3734", "789", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3735", "791", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3736", "791", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3737", "794", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3738", "794", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3739", "799", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3740", "799", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3741", "629", "add_icon_to_menu", "0");
INSERT INTO `wp_postmeta` VALUES("3742", "629", "_add_icon_to_menu", "field_60bfbf2ba014f");
INSERT INTO `wp_postmeta` VALUES("3743", "644", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3744", "647", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3745", "648", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3746", "670", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3747", "645", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3748", "669", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3749", "652", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3750", "646", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3751", "649", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3752", "651", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3753", "541", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3754", "650", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3755", "623", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3756", "621", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3757", "829", "_wp_old_date", "2020-06-29");
INSERT INTO `wp_postmeta` VALUES("3758", "624", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3759", "625", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3760", "622", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3761", "627", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3762", "626", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3763", "830", "_wp_old_date", "2020-06-29");
INSERT INTO `wp_postmeta` VALUES("3764", "831", "_wp_old_date", "2020-06-29");
INSERT INTO `wp_postmeta` VALUES("3765", "628", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3766", "762", "_wp_old_date", "2020-06-20");
INSERT INTO `wp_postmeta` VALUES("3767", "766", "_wp_old_date", "2020-06-20");
INSERT INTO `wp_postmeta` VALUES("3768", "763", "_wp_old_date", "2020-06-20");
INSERT INTO `wp_postmeta` VALUES("3769", "764", "_wp_old_date", "2020-06-20");
INSERT INTO `wp_postmeta` VALUES("3770", "765", "_wp_old_date", "2020-06-20");
INSERT INTO `wp_postmeta` VALUES("3771", "773", "_wp_old_date", "2020-06-20");
INSERT INTO `wp_postmeta` VALUES("3772", "780", "_wp_old_date", "2020-06-20");
INSERT INTO `wp_postmeta` VALUES("3773", "779", "_wp_old_date", "2020-06-20");
INSERT INTO `wp_postmeta` VALUES("3774", "774", "_wp_old_date", "2020-06-20");
INSERT INTO `wp_postmeta` VALUES("3775", "790", "_wp_old_date", "2020-06-20");
INSERT INTO `wp_postmeta` VALUES("3776", "783", "_wp_old_date", "2020-06-20");
INSERT INTO `wp_postmeta` VALUES("3777", "786", "_wp_old_date", "2020-06-20");
INSERT INTO `wp_postmeta` VALUES("3778", "789", "_wp_old_date", "2020-06-20");
INSERT INTO `wp_postmeta` VALUES("3779", "791", "_wp_old_date", "2020-06-20");
INSERT INTO `wp_postmeta` VALUES("3780", "794", "_wp_old_date", "2020-06-20");
INSERT INTO `wp_postmeta` VALUES("3781", "799", "_wp_old_date", "2020-06-20");
INSERT INTO `wp_postmeta` VALUES("3782", "629", "_wp_old_date", "2020-02-16");
INSERT INTO `wp_postmeta` VALUES("3783", "968", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3784", "968", "_edit_lock", "1644874963:1");
INSERT INTO `wp_postmeta` VALUES("3785", "969", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3786", "969", "_edit_lock", "1644874969:1");
INSERT INTO `wp_postmeta` VALUES("3787", "970", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3788", "970", "_edit_lock", "1644875356:1");
INSERT INTO `wp_postmeta` VALUES("3789", "971", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3790", "971", "_edit_lock", "1644875356:1");
INSERT INTO `wp_postmeta` VALUES("3791", "972", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3792", "972", "_edit_lock", "1644875356:1");
INSERT INTO `wp_postmeta` VALUES("3793", "973", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3794", "973", "_edit_lock", "1644875357:1");
INSERT INTO `wp_postmeta` VALUES("3795", "974", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3796", "974", "_edit_lock", "1644875357:1");
INSERT INTO `wp_postmeta` VALUES("3797", "975", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3798", "975", "_edit_lock", "1644875357:1");
INSERT INTO `wp_postmeta` VALUES("3799", "976", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3800", "976", "_edit_lock", "1645712226:1");
INSERT INTO `wp_postmeta` VALUES("3801", "977", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3802", "977", "_thumbnail_id", "935");
INSERT INTO `wp_postmeta` VALUES("3803", "977", "featured_story", "1");
INSERT INTO `wp_postmeta` VALUES("3804", "977", "_featured_story", "field_61c063bae3e39");
INSERT INTO `wp_postmeta` VALUES("3805", "977", "_edit_lock", "1644875358:1");
INSERT INTO `wp_postmeta` VALUES("3806", "968", "_thumbnail_id", "965");
INSERT INTO `wp_postmeta` VALUES("3807", "968", "featured_story", "1");
INSERT INTO `wp_postmeta` VALUES("3808", "968", "_featured_story", "field_61c063bae3e39");
INSERT INTO `wp_postmeta` VALUES("3809", "969", "_thumbnail_id", "936");
INSERT INTO `wp_postmeta` VALUES("3810", "969", "featured_story", "1");
INSERT INTO `wp_postmeta` VALUES("3811", "969", "_featured_story", "field_61c063bae3e39");
INSERT INTO `wp_postmeta` VALUES("3812", "970", "_thumbnail_id", "937");
INSERT INTO `wp_postmeta` VALUES("3813", "970", "featured_story", "1");
INSERT INTO `wp_postmeta` VALUES("3814", "970", "_featured_story", "field_61c063bae3e39");
INSERT INTO `wp_postmeta` VALUES("3815", "971", "_thumbnail_id", "948");
INSERT INTO `wp_postmeta` VALUES("3816", "971", "featured_story", "1");
INSERT INTO `wp_postmeta` VALUES("3817", "971", "_featured_story", "field_61c063bae3e39");
INSERT INTO `wp_postmeta` VALUES("3818", "972", "_thumbnail_id", "938");
INSERT INTO `wp_postmeta` VALUES("3819", "972", "featured_story", "1");
INSERT INTO `wp_postmeta` VALUES("3820", "972", "_featured_story", "field_61c063bae3e39");
INSERT INTO `wp_postmeta` VALUES("3821", "973", "_thumbnail_id", "894");
INSERT INTO `wp_postmeta` VALUES("3822", "973", "featured_story", "1");
INSERT INTO `wp_postmeta` VALUES("3823", "973", "_featured_story", "field_61c063bae3e39");
INSERT INTO `wp_postmeta` VALUES("3824", "974", "_thumbnail_id", "940");
INSERT INTO `wp_postmeta` VALUES("3825", "974", "featured_story", "1");
INSERT INTO `wp_postmeta` VALUES("3826", "974", "_featured_story", "field_61c063bae3e39");
INSERT INTO `wp_postmeta` VALUES("3827", "976", "_thumbnail_id", "957");
INSERT INTO `wp_postmeta` VALUES("3828", "976", "featured_story", "1");
INSERT INTO `wp_postmeta` VALUES("3829", "976", "_featured_story", "field_61c063bae3e39");
INSERT INTO `wp_postmeta` VALUES("3830", "975", "_thumbnail_id", "845");
INSERT INTO `wp_postmeta` VALUES("3831", "975", "featured_story", "1");
INSERT INTO `wp_postmeta` VALUES("3832", "975", "_featured_story", "field_61c063bae3e39");
INSERT INTO `wp_postmeta` VALUES("3833", "775", "_oembed_87705656a97b25ee9fbccca4c455c506", "<iframe title=\"Northern lights: Nature&amp;rsquo;s own rhythms\" src=\"https://player.vimeo.com/video/185472558?h=a2eb163dbc&amp;dnt=1&amp;app_id=122963\" width=\"640\" height=\"360\" frameborder=\"0\" allow=\"autoplay; fullscreen; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("3834", "775", "_oembed_time_87705656a97b25ee9fbccca4c455c506", "1644875878");
INSERT INTO `wp_postmeta` VALUES("3841", "970", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("3913", "970", "_post_views", "93");
INSERT INTO `wp_postmeta` VALUES("3914", "973", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("4006", "973", "_post_views", "78");
INSERT INTO `wp_postmeta` VALUES("4007", "971", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("4008", "971", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("4091", "971", "_post_views", "102");
INSERT INTO `wp_postmeta` VALUES("4092", "972", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("4093", "972", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("4094", "972", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("4186", "972", "_post_views", "121");
INSERT INTO `wp_postmeta` VALUES("4187", "976", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("4254", "976", "_post_views", "73");
INSERT INTO `wp_postmeta` VALUES("4255", "974", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("4256", "974", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("4334", "974", "_post_views", "80");
INSERT INTO `wp_postmeta` VALUES("4335", "969", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("4418", "969", "_post_views", "62");
INSERT INTO `wp_postmeta` VALUES("4419", "807", "king_reaction_like", "2");
INSERT INTO `wp_postmeta` VALUES("4420", "968", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("4511", "968", "_post_views", "41");
INSERT INTO `wp_postmeta` VALUES("4512", "803", "_oembed_7302f8918e67e5760821d4f5852d73e7", "<iframe title=\"Spotify Embed: Breaking Me\" width=\"100%\" height=\"80\" style=\"[object Object]\" frameborder=\"0\" allowfullscreen allow=\"autoplay; clipboard-write; encrypted-media; fullscreen; picture-in-picture\" src=\"https://open.spotify.com/embed/track/3H7ihDc1dqLriiWXwsc2po?si=rXshOp06SCGvFjYAPKAM1A&utm_source=oembed\"></iframe>");
INSERT INTO `wp_postmeta` VALUES("4513", "803", "_oembed_time_7302f8918e67e5760821d4f5852d73e7", "1644916693");
INSERT INTO `wp_postmeta` VALUES("4514", "801", "_oembed_35060f193908af6fa60c717af6874260", "{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("4515", "977", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("4596", "977", "_post_views", "26");
INSERT INTO `wp_postmeta` VALUES("4597", "807", "_oembed_bd28188fa47e682d88d9e79e2ac8351a", "<iframe title=\"The Little Prince (stop-motion)\" src=\"https://player.vimeo.com/video/164860211?h=d6ded5b094&amp;dnt=1&amp;app_id=122963\" width=\"640\" height=\"360\" frameborder=\"0\" allow=\"autoplay; fullscreen; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("4598", "807", "_oembed_time_bd28188fa47e682d88d9e79e2ac8351a", "1644926368");
INSERT INTO `wp_postmeta` VALUES("4599", "775", "king_vote_dislikes", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("4600", "775", "king_dislike_count", "0");
INSERT INTO `wp_postmeta` VALUES("4601", "775", "king_vote_likes", "a:1:{i:0;i:1;}");
INSERT INTO `wp_postmeta` VALUES("4602", "734", "king_reaction_like", "1");
INSERT INTO `wp_postmeta` VALUES("4605", "48", "king_reaction_sad", "1");
INSERT INTO `wp_postmeta` VALUES("4606", "48", "king_reaction_like", "1");
INSERT INTO `wp_postmeta` VALUES("4607", "975", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("4691", "975", "_post_views", "56");
INSERT INTO `wp_postmeta` VALUES("4692", "775", "king_reaction_love", "1");
INSERT INTO `wp_postmeta` VALUES("4693", "807", "king_reaction_love", "3");
INSERT INTO `wp_postmeta` VALUES("4694", "75", "king_reaction_sad", "1");
INSERT INTO `wp_postmeta` VALUES("4695", "775", "_oembed_9905ce944fe6873df7e2ff8661296603", "<blockquote class=\"twitter-tweet\" data-width=\"550\" data-dnt=\"true\"><p lang=\"en\" dir=\"ltr\">Each and every turn at the otherworldly Antelope Canyon is another incredible sight <a href=\"https://t.co/eZMbQZMmYd\">pic.twitter.com/eZMbQZMmYd</a></p>&mdash; Nat Geo Travel (@NatGeoTravel) <a href=\"https://twitter.com/NatGeoTravel/status/934436537638436864?ref_src=twsrc%5Etfw\">November 25, 2017</a></blockquote><script async src=\"https://platform.twitter.com/widgets.js\" charset=\"utf-8\"></script>");
INSERT INTO `wp_postmeta` VALUES("4696", "775", "_oembed_time_9905ce944fe6873df7e2ff8661296603", "1650269561");
INSERT INTO `wp_postmeta` VALUES("4697", "48", "king_reaction_angry", "2");
INSERT INTO `wp_postmeta` VALUES("4698", "807", "king_reaction_angry", "1");
INSERT INTO `wp_postmeta` VALUES("4699", "803", "king_reaction_wow", "1");
INSERT INTO `wp_postmeta` VALUES("4700", "807", "king_reaction_haha", "1");
INSERT INTO `wp_postmeta` VALUES("4701", "807", "_oembed_00d7f15542ef96af3aa13055076f9758", "<iframe title=\"Where Are the Stars? See How Light Pollution Affects Night Skies | Short Film Showcase\" width=\"640\" height=\"360\" src=\"https://www.youtube.com/embed/0FXJUP6_O1w?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("4702", "807", "_oembed_time_00d7f15542ef96af3aa13055076f9758", "1666604693");
INSERT INTO `wp_postmeta` VALUES("4703", "643", "king_reaction_haha", "1");
INSERT INTO `wp_postmeta` VALUES("4704", "807", "_oembed_41e0297f3c2a811422de5643d5a49d84", "{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("4705", "50", "_oembed_6a5fc570801a35b58bdac44af9f63872", "<iframe title=\"Novo Amor - From Gold (Henri Pfr Remix) by Henri PFR\" width=\"640\" height=\"390\" scrolling=\"no\" frameborder=\"no\" src=\"https://w.soundcloud.com/player/?visual=true&url=https%3A%2F%2Fapi.soundcloud.com%2Ftracks%2F170901885&show_artwork=true&maxheight=390&maxwidth=640\"></iframe>");
INSERT INTO `wp_postmeta` VALUES("4706", "50", "_oembed_time_6a5fc570801a35b58bdac44af9f63872", "1670105377");
INSERT INTO `wp_postmeta` VALUES("4707", "823", "_oembed_91e4cc36decabe9787fa62d0eb5be958", "<iframe title=\"KONGOS - Come with Me Now\" width=\"640\" height=\"360\" src=\"https://www.youtube.com/embed/Gz2GVlQkn4Q?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("4708", "823", "_oembed_time_91e4cc36decabe9787fa62d0eb5be958", "1670709171");
INSERT INTO `wp_postmeta` VALUES("4709", "734", "king_reaction_wow", "1");
INSERT INTO `wp_postmeta` VALUES("4710", "775", "_oembed_8eadba2f818caf9a8140fe3ba9699a73", "<iframe title=\"Seven Wonders of the New World | Cosmos: Possible Worlds\" width=\"640\" height=\"360\" src=\"https://www.youtube.com/embed/hcCVe5MamN4?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("4711", "775", "_oembed_time_8eadba2f818caf9a8140fe3ba9699a73", "1688065818");
INSERT INTO `wp_postmeta` VALUES("4712", "992", "_wp_attached_file", "2023/07/ب-کینگ-14.jpg.webp");
INSERT INTO `wp_postmeta` VALUES("4713", "992", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1180;s:6:\"height\";i:1696;s:4:\"file\";s:31:\"2023/07/ب-کینگ-14.jpg.webp\";s:8:\"filesize\";i:77012;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"ب-کینگ-14.jpg-209x300.webp\";s:5:\"width\";i:209;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:8618;}s:5:\"large\";a:5:{s:4:\"file\";s:32:\"ب-کینگ-14.jpg-712x1024.webp\";s:5:\"width\";i:712;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:48898;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"ب-کینگ-14.jpg-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:4638;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:32:\"ب-کینگ-14.jpg-768x1104.webp\";s:5:\"width\";i:768;s:6:\"height\";i:1104;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:53694;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:33:\"ب-کینگ-14.jpg-1069x1536.webp\";s:5:\"width\";i:1069;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:82726;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4714", "807", "king_reaction_sad", "2");
INSERT INTO `wp_postmeta` VALUES("4715", "993", "_wp_attached_file", "2023/08/1.png");
INSERT INTO `wp_postmeta` VALUES("4716", "993", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:1080;s:4:\"file\";s:13:\"2023/08/1.png\";s:8:\"filesize\";i:3485960;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:13:\"1-300x169.png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:100640;}s:5:\"large\";a:5:{s:4:\"file\";s:14:\"1-1024x576.png\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1042219;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:13:\"1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:49966;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:13:\"1-768x432.png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:612552;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:14:\"1-1536x864.png\";s:5:\"width\";i:1536;s:6:\"height\";i:864;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2181164;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4717", "994", "images_gallery", "a:1:{i:0;s:3:\"993\";}");
INSERT INTO `wp_postmeta` VALUES("4718", "994", "_images_gallery", "field_60ae46d02f589");
INSERT INTO `wp_postmeta` VALUES("4719", "994", "_thumbnail_id", "993");
INSERT INTO `wp_postmeta` VALUES("4720", "994", "_post_views", "1");
INSERT INTO `wp_postmeta` VALUES("4721", "994", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("4722", "995", "king_story_0", "");
INSERT INTO `wp_postmeta` VALUES("4723", "995", "_thumbnail_id", "993");
INSERT INTO `wp_postmeta` VALUES("4724", "48", "king_vote_likes", "a:1:{i:0;i:5;}");
INSERT INTO `wp_postmeta` VALUES("4725", "48", "king_flags", "a:2:{i:0;i:5;i:1;i:9;}");
INSERT INTO `wp_postmeta` VALUES("4726", "70", "king_vote_likes", "a:1:{i:0;i:5;}");
INSERT INTO `wp_postmeta` VALUES("4727", "807", "king_reaction_wow", "1");
INSERT INTO `wp_postmeta` VALUES("4728", "997", "_wp_attached_file", "2023/11/mygila-tea.png");
INSERT INTO `wp_postmeta` VALUES("4729", "997", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:591;s:6:\"height\";i:591;s:4:\"file\";s:22:\"2023/11/mygila-tea.png\";s:8:\"filesize\";i:50137;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"mygila-tea-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:24096;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"mygila-tea-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:9743;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4730", "998", "king_story_0", "{\"version\":\"4.6.0\",\"objects\":[{\"type\":\"textbox\",\"version\":\"4.6.0\",\"originX\":\"center\",\"originY\":\"center\",\"left\":212,\"top\":200,\"width\":186.96,\"height\":142.56,\"fill\":\"#FFF\",\"erasable\":true,\"fontFamily\":\"Ubuntu\",\"fontWeight\":400,\"fontSize\":38,\"text\":\"Type Something Here!\",\"styles\":{},\"minWidth\":20,\"splitByGrapheme\":false},{\"type\":\"textbox\",\"version\":\"4.6.0\",\"originX\":\"center\",\"originY\":\"center\",\"left\":213.34,\"top\":202.68,\"width\":196,\"height\":142.56,\"fill\":\"#FFF\",\"erasable\":true,\"fontFamily\":\"Ubuntu\",\"fontWeight\":400,\"fontSize\":38,\"text\":\"Type Someاthing Here!\",\"styles\":{},\"minWidth\":20,\"splitByGrapheme\":false}],\"background\":\"#5ed5ff\"}");
INSERT INTO `wp_postmeta` VALUES("4731", "998", "_thumbnail_id", "997");
INSERT INTO `wp_postmeta` VALUES("4732", "999", "king_story_0", "{\"version\":\"4.6.0\",\"objects\":[],\"background\":\"#88bf4b\"}");
INSERT INTO `wp_postmeta` VALUES("4733", "999", "_thumbnail_id", "997");
INSERT INTO `wp_postmeta` VALUES("4734", "1000", "king_story_0", "{\"version\":\"4.6.0\",\"objects\":[{\"type\":\"image\",\"version\":\"4.6.0\",\"originX\":\"center\",\"originY\":\"center\",\"left\":270.77,\"top\":196.39,\"width\":591,\"height\":591,\"erasable\":true,\"src\":\"https://themes.wpnovin.com/King/Main/wp-content/uploads/2023/11/mygila-tea.png\",\"crossOrigin\":null,\"filters\":[]}]}");
INSERT INTO `wp_postmeta` VALUES("4735", "1000", "_thumbnail_id", "997");
INSERT INTO `wp_postmeta` VALUES("4736", "1001", "king_story_0", "{\"version\":\"4.6.0\",\"objects\":[{\"type\":\"image\",\"version\":\"4.6.0\",\"originX\":\"center\",\"originY\":\"center\",\"left\":212,\"top\":355,\"width\":591,\"height\":591,\"erasable\":true,\"src\":\"https://themes.wpnovin.com/King/Main/wp-content/uploads/2023/11/mygila-tea.png\",\"crossOrigin\":null,\"filters\":[]}]}");
INSERT INTO `wp_postmeta` VALUES("4737", "1001", "_thumbnail_id", "997");
INSERT INTO `wp_postmeta` VALUES("4738", "1003", "video-url", "https://www.kwciran.com/fa/video/293-%D9%86%D9%85%D8%A7%DB%8C%D8%B4%DA%AF%D8%A7%D9%87-%D8%B5%D9%86%D8%B9%D8%AA-%D8%B3%D8%A7%D8%AE%D8%AA%D9%85%D8%A7%D9%86-%D8%B4%DB%8C%D8%B1%D8%A7%D8%B2-%D8%AA%DB%8C%D8%B1%D9%85%D8%A7%D9%87-1402-%D8%B3%D8%A7%D9%84%D9%86-%D8%AD%D8%A7%D9%81%D8%B8.html");
INSERT INTO `wp_postmeta` VALUES("4739", "1003", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("4740", "1004", "_wp_attached_file", "2023/11/1689660262-_DSC1842-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("4741", "1004", "_wp_attachment_metadata", "a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1708;s:4:\"file\";s:38:\"2023/11/1689660262-_DSC1842-scaled.jpg\";s:8:\"filesize\";i:626523;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"1689660262-_DSC1842-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:65846;}s:5:\"large\";a:5:{s:4:\"file\";s:32:\"1689660262-_DSC1842-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:179121;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"1689660262-_DSC1842-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:56531;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:31:\"1689660262-_DSC1842-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:130140;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:33:\"1689660262-_DSC1842-1536x1025.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1025;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:300817;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:33:\"1689660262-_DSC1842-2048x1366.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1366;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:449773;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:23:\"1689660262-_DSC1842.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("4742", "1003", "_thumbnail_id", "1004");
INSERT INTO `wp_postmeta` VALUES("4743", "1003", "video_tab", "1");
INSERT INTO `wp_postmeta` VALUES("4744", "1003", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("4745", "1003", "media_lists", "");
INSERT INTO `wp_postmeta` VALUES("4746", "1003", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("4747", "1003", "_oembed_c3be5d74690760927ad36c4227beaf13", "{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("4748", "1003", "_post_views", "3");
INSERT INTO `wp_postmeta` VALUES("4749", "1003", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("4750", "807", "_oembed_c3be5d74690760927ad36c4227beaf13", "{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("4751", "1003", "video_upload", "");
INSERT INTO `wp_postmeta` VALUES("4752", "1003", "_video_upload", "field_58f5335001eed");
INSERT INTO `wp_postmeta` VALUES("4753", "1003", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("4754", "1003", "media_embed_code", "");
INSERT INTO `wp_postmeta` VALUES("4755", "1003", "_media_embed_code", "field_59c9812458fe6");
INSERT INTO `wp_postmeta` VALUES("4756", "1003", "_validate_email", "");
INSERT INTO `wp_postmeta` VALUES("4757", "1003", "__validate_email", "_validate_email");
INSERT INTO `wp_postmeta` VALUES("4758", "1007", "video-url", "https://www.aparat.com/v/upysH");
INSERT INTO `wp_postmeta` VALUES("4759", "1007", "_video-url", "field_587be2665e807");
INSERT INTO `wp_postmeta` VALUES("4760", "1007", "video_tab", "0");
INSERT INTO `wp_postmeta` VALUES("4761", "1007", "_video_tab", "field_58f533f201eee");
INSERT INTO `wp_postmeta` VALUES("4762", "1007", "media_lists_0_media_title", "ewewewew");
INSERT INTO `wp_postmeta` VALUES("4763", "1007", "_media_lists_0_media_title", "field_5ee7d35b7603b");
INSERT INTO `wp_postmeta` VALUES("4764", "1007", "media_lists_0_media_url_or_upload", "0");
INSERT INTO `wp_postmeta` VALUES("4765", "1007", "_media_lists_0_media_url_or_upload", "field_5ee7d3c77603d");
INSERT INTO `wp_postmeta` VALUES("4766", "1007", "media_lists_0_media_url", "https://www.aparat.com/v/SoWgk");
INSERT INTO `wp_postmeta` VALUES("4767", "1007", "_media_lists_0_media_url", "field_5ee7d3987603c");
INSERT INTO `wp_postmeta` VALUES("4768", "1007", "media_lists_0_media_thumb", "");
INSERT INTO `wp_postmeta` VALUES("4769", "1007", "_media_lists_0_media_thumb", "field_5ee7d4f37603f");
INSERT INTO `wp_postmeta` VALUES("4770", "1007", "media_lists", "1");
INSERT INTO `wp_postmeta` VALUES("4771", "1007", "_media_lists", "field_5ee7d2907603a");
INSERT INTO `wp_postmeta` VALUES("4772", "1007", "_oembed_fa82a8855bb7388963d6a29179ef98fa", "{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("4773", "1007", "_oembed_3fdbd1396497c5fae4c93c6b7b350b41", "{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("4774", "1007", "_post_views", "2");
INSERT INTO `wp_postmeta` VALUES("4775", "1007", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("4776", "801", "king_reaction_sad", "1");
INSERT INTO `wp_postmeta` VALUES("4777", "823", "king_reaction_angry", "1");
INSERT INTO `wp_postmeta` VALUES("4778", "1008", "_wp_attached_file", "2023/12/download-1.jpg");
INSERT INTO `wp_postmeta` VALUES("4779", "1008", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:1080;s:4:\"file\";s:22:\"2023/12/download-1.jpg\";s:8:\"filesize\";i:1382003;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"download-1-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10650;}s:5:\"large\";a:5:{s:4:\"file\";s:23:\"download-1-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:79720;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"download-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8290;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:22:\"download-1-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:48175;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:23:\"download-1-1536x864.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:864;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:160621;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4780", "1009", "_wp_attached_file", "2023/12/Israel_flag_fire-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("4781", "1009", "_wp_attachment_metadata", "a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:2560;s:4:\"file\";s:35:\"2023/12/Israel_flag_fire-scaled.jpg\";s:8:\"filesize\";i:694610;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:28:\"Israel_flag_fire-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20271;}s:5:\"large\";a:5:{s:4:\"file\";s:30:\"Israel_flag_fire-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:141018;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:28:\"Israel_flag_fire-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7202;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:28:\"Israel_flag_fire-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:86650;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:30:\"Israel_flag_fire-1536x1536.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:276754;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:30:\"Israel_flag_fire-2048x2048.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:2048;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:458438;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:20:\"Israel_flag_fire.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("4782", "1010", "king_story_0", "{\"version\":\"4.6.0\",\"objects\":[{\"type\":\"image\",\"version\":\"4.6.0\",\"originX\":\"center\",\"originY\":\"center\",\"left\":50.53,\"top\":331.47,\"width\":1024,\"height\":1024,\"scaleX\":0.75,\"scaleY\":0.75,\"erasable\":true,\"src\":\"https://themes.wpnovin.com/King/Main/wp-content/uploads/2023/12/Israel_flag_fire-1024x1024.jpg\",\"crossOrigin\":null,\"filters\":[]},{\"type\":\"textbox\",\"version\":\"4.6.0\",\"originX\":\"center\",\"originY\":\"center\",\"left\":296.57,\"top\":597.5,\"width\":103.6,\"height\":32.77,\"fill\":\"#000000\",\"erasable\":true,\"fontFamily\":\"\'Ubuntu\', sans-serif\",\"fontWeight\":400,\"fontSize\":\"29\",\"text\":\"@sdd\",\"textAlign\":\"center\",\"textBackgroundColor\":\"#fff\",\"styles\":{},\"minWidth\":20,\"splitByGrapheme\":false}]}");
INSERT INTO `wp_postmeta` VALUES("4783", "1010", "_thumbnail_id", "1009");
INSERT INTO `wp_postmeta` VALUES("4784", "44", "king_flags", "a:1:{i:0;i:8;}");
INSERT INTO `wp_postmeta` VALUES("4785", "734", "king_reaction_sad", "1");
INSERT INTO `wp_postmeta` VALUES("4786", "1012", "_wp_attached_file", "2024/03/crown-5-Top.jpg");
INSERT INTO `wp_postmeta` VALUES("4787", "1012", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:590;s:6:\"height\";i:300;s:4:\"file\";s:23:\"2024/03/crown-5-Top.jpg\";s:8:\"filesize\";i:48351;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:23:\"crown-5-Top-300x153.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:153;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14256;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:23:\"crown-5-Top-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6752;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4788", "775", "king_reaction_angry", "1");
INSERT INTO `wp_postmeta` VALUES("4789", "775", "king_reaction_haha", "2");
INSERT INTO `wp_postmeta` VALUES("4790", "1013", "_thumbnail_id", "");
INSERT INTO `wp_postmeta` VALUES("4791", "1013", "__thumbnail_id", "field_58f5594a975cb");
INSERT INTO `wp_postmeta` VALUES("4792", "1013", "_post_views", "1");
INSERT INTO `wp_postmeta` VALUES("4793", "1013", "share_counter", "0");
INSERT INTO `wp_postmeta` VALUES("4794", "1014", "king_story_0", "{\"version\":\"4.6.0\",\"objects\":[{\"type\":\"image\",\"version\":\"4.6.0\",\"originX\":\"center\",\"originY\":\"center\",\"left\":36.68,\"top\":365.17,\"width\":1024,\"height\":576,\"scaleY\":1.33,\"erasable\":true,\"src\":\"https://themes.wpnovin.com/King/Main/wp-content/uploads/2023/12/download-1-1024x576.jpg\",\"crossOrigin\":null,\"filters\":[]},{\"type\":\"textbox\",\"version\":\"4.6.0\",\"originX\":\"center\",\"originY\":\"center\",\"left\":296.02,\"top\":545.63,\"width\":186.96,\"height\":42.94,\"fill\":\"#ffffff\",\"erasable\":true,\"fontFamily\":\"Ubuntu\",\"fontWeight\":400,\"fontSize\":38,\"text\":\"سلام \",\"textAlign\":\"center\",\"textBackgroundColor\":\"#88bf4b\",\"styles\":{},\"minWidth\":20,\"splitByGrapheme\":false}]}");
INSERT INTO `wp_postmeta` VALUES("4795", "1014", "_thumbnail_id", "1008");
INSERT INTO `wp_postmeta` VALUES("4796", "82", "king_reaction_love", "1");

/* INSERT TABLE DATA: wp_posts */
INSERT INTO `wp_posts` VALUES("3", "1", "2022-01-15 02:28:09", "2022-01-14 22:58:09", "<!-- wp:heading --><h2>ما که هستیم</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>نشانی وب‌سایت ما: https://themes.wpnovin.com/King/Main.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>دیدگاه‌ها</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>هنگامی که بازدیدکنندگان نظرات خود را در سایت می‌نویسند، ما اطلاعاتی را که در فرم نظرات و همچنین بازدید کننده‌ها ارائه می‌شود جمع آوری می‌کنیم &#8217;s آدرس IP و رجیستر عامل کاربر مرورگر برای کمک به تشخیص هرزنامه.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>یک رشته ناشناس ایجاد شده از آدرس ایمیل شما (همچنین هش نامیده می‌شود) ممکن است به سرویس Gravatar ارائه شود تا ببینید آیا از آن استفاده می‌کنید. سیاست حفظ حریم خصوصی خدمات Gravatar در اینجا در دسترس است: https://automattic.com/privacy/. پس از تأیید نظر شما، تصویر نمایه شما در متن نظر شما قابل مشاهده است.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>رسانه</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>اگر تصاویر را به وبسایت آپلود کنید، نباید آپلود تصاویر با داده‌های مکان جغرافیایی (EXIF GPS) شامل شود. بازدیدکنندگان وب سایت می‌توانند هر گونه اطلاعات مکان را از تصاویر در وب سایت دانلود و استخراج کنند.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>کوکی‌ها</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>اگر شما نظر خود را در سایت ما ثبت کنید، ممکن است برای ذخیره نام، آدرس ایمیل و وب سایت خود در کوکی‌ها تصمیم گیری کنید. اینها برای راحتی شما هستند، به طوری که شما مجبور نیستید دوباره جزئیات خود را پر کنید زمانی که نظر دیگری را ترک کنید. این کوکی‌ها یک سال طول خواهد کشید.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>اگر از برگه ورود ما بازدید نمایید، ما یک کوکی موقت برای مشخص نمودن اینکه آیا مروگر شما کوکی قبول می‌کند را تنظیم می‌کنیم. این کوکی محتوای اطلاعات شخصی شما نیست و وقتی مرورگر شما بسته می‌شود از بین می‌رود.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>هنگام ورود به سیستم، ما همچنین کوکی‌ها را تنظیم خواهیم کرد تا اطلاعات ورود به سیستم و گزینه‌های صفحه نمایش خود را ذخیره کنید. کوکی‌های ورود به سیستم برای دو روز گذشته و کوکی‌های گزینه‌های صفحه نمایش برای یک سال گذشته است. اگر شما انتخاب کنید &quot; به یاد داشته باشید من Me&quot;، ورود شما برای دو هفته ادامه خواهد داشت. اگر از حساب خود خارج شوید، کوکی‌های ورود حذف خواهند شد.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>اگر یک مقاله را ویرایش یا منتشر کنید، یک کوکی اضافی در مرورگر شما ذخیره خواهد شد. این کوکی حاوی اطلاعات شخصی نیست و به سادگی نشان می‌دهد که شناسه پست مقاله شما فقط ویرایش شده است. بعد از یک روز منقضی می‌شود.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>محتوای جاسازی‌شده از دیگر وب‌سایت‌ها</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>مقالات موجود در این سایت ممکن است شامل محتوای تعبیه شده (مثلا ویدئوها، تصاویر، مقالات و غیره) باشد. مطالب جاسازی شده از وب سایت‌های دیگر رفتار دقیقا همان طوری که بازدید کننده از وب سایت دیگر بازدید کرده است.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>این وبسایت‌ها ممکن است اطلاعاتی مربوط به شما را جمع‌آوری کنند، از کوکی‌ها استفاده کنند، ردیابی سوم شخص اضافه را جاسازی کنند و تعامل شما را با محتوای تعبیه شده نظارت کنند که شامل ردیابی تعامل شما با محتوای جاسازی شده است اگر حساب کاربری داشته و به آن وبسایت وارد شده باشید.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>اطلاعات شما را با چه کسی به اشتراک می‌گذاریم</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>اگر شما یک تنظیم دوباره رمز عبور را درخواست دادید، نشانی IP شما در ایمیل تنظیم دوباره وجود خواهد داشت.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>چه مدت ما اطلاعات شما را حفظ می‌کنیم</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>اگر یک نظر را ترک کنید، نظر و متادیتای آن به طور نامحدود حفظ می‌شوند. این به این معنا است که ما می‌توانیم به جای برگزاری آنها در یک خط مؤثر، به طور خودکار هر نظر پیگیری را تصدیق و تأیید کنیم.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>برای کاربرانی که در وب سایت ما ثبت نام می‌کنند (اگر وجود داشته باشند)، ما همچنین اطلاعات شخصی را که در مشخصات کاربر آنها ارائه می‌کنیم، ذخیره می‌کنیم. همه کاربران می‌توانند اطلاعات شخصی خود را در هر زمان (به جز آنها که نمی‌توانند نام کاربری خود را تغییر دهند) ببینند، ویرایش و یا حذف کنند. مدیران وب سایت همچنین می‌توانند این اطلاعات را مشاهده و ویرایش کنند.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>حقوقی که بر روی داده‌هایتان دارید</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>اگر در این سایت حساب کاربری دارید یا نظرها را ترک کرده اید، می‌توانید درخواست دریافت یک فایل صادر شده از اطلاعات شخصی که ما در مورد شما نگه می‌داریم، از جمله هر گونه داده‌ای که برای ما ارائه کرده اید. همچنین می‌توانید درخواست کنید که ما هر گونه اطلاعات شخصی که در مورد شما نگه داریم پاک کنیم. این شامل اطلاعاتی نیست که ما مجبور به نگهداری آنها برای اهداف اداری، قانونی یا امنیتی باشیم.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>داده‌های شما را به کجا ارسال می‌کنیم</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>دیدگاه‌های بازدیدکننده ممکن است از طریق یک سرویس تشخیص جفنگ خودکار بررسی شوند.</p><!-- /wp:paragraph -->", "سیاست حریم خصوصی", "", "draft", "closed", "open", "", "سیاست-حفظ-حریم-خصوصی", "", "", "2022-01-15 02:28:09", "2022-01-14 22:58:09", "", "0", "https://themes.wpnovin.com/King/Main/?page_id=3", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("6", "1", "2022-02-13 16:20:32", "2022-02-13 12:50:32", "", "درون ریزی نسخه نمایشی با یک کلیکlog_file_2022-02-13__12-50-32", "", "inherit", "open", "closed", "", "%d8%af%d8%b1%d9%88%d9%86-%d8%b1%db%8c%d8%b2%db%8c-%d9%86%d8%b3%d8%ae%d9%87-%d9%86%d9%85%d8%a7%db%8c%d8%b4%db%8c-%d8%a8%d8%a7-%db%8c%da%a9-%da%a9%d9%84%db%8c%da%a9log_file_2022-02-13__12-50-32", "", "", "2022-02-13 16:20:32", "2022-02-13 12:50:32", "", "0", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2022/02/log_file_2022-02-13__12-50-32.txt", "0", "attachment", "text/plain", "0");
INSERT INTO `wp_posts` VALUES("20", "1", "2017-01-17 15:33:55", "2017-01-17 15:33:55", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "تریلر فیلم سینمایی آرواره های کوسه", "", "publish", "open", "open", "", "big-hero-6-official-teaser-trailer", "", "", "2022-02-14 22:24:55", "2022-02-14 18:54:55", "", "0", "http://king.kingthemes.net/2017/01/17/big-hero-6-official-teaser-trailer/", "0", "post", "", "1");
INSERT INTO `wp_posts` VALUES("22", "1", "2017-01-17 15:36:59", "2017-01-17 15:36:59", "", "داغ", "", "publish", "closed", "closed", "", "hot", "", "", "2022-02-14 19:53:10", "2022-02-14 16:23:10", "", "0", "http://king.kingthemes.net/?page_id=22", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("25", "1", "2017-01-17 15:37:12", "2017-01-17 15:37:12", "", "ترند", "", "publish", "closed", "closed", "", "trend", "", "", "2022-02-14 19:54:13", "2022-02-14 16:24:13", "", "0", "http://king.kingthemes.net/?page_id=25", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("28", "1", "2017-01-17 15:37:27", "2017-01-17 15:37:27", "", "کاربران", "", "publish", "closed", "closed", "", "users", "", "", "2022-02-14 19:54:19", "2022-02-14 16:24:19", "", "0", "http://king.kingthemes.net/?page_id=28", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("37", "1", "2017-01-17 16:17:21", "2017-01-17 16:17:21", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "ساوند کلاد - سینا درخشنده ای وای به دلم", "", "publish", "open", "open", "", "soundcloud-king-of-everything", "", "", "2022-02-14 22:23:12", "2022-02-14 18:53:12", "", "0", "http://king.kingthemes.net/2017/01/17/soundcloud-king-of-everything/", "0", "post", "", "2");
INSERT INTO `wp_posts` VALUES("38", "1", "2017-01-17 16:18:56", "2017-01-17 16:18:56", "", "artworks-dQPq6diRUWuI-0-t500x500", "", "inherit", "open", "closed", "", "artworks-dqpq6diruwui-0-t500x500", "", "", "2017-01-17 16:18:56", "2017-01-17 16:18:56", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/artworks-dQPq6diRUWuI-0-t500x500-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("40", "1", "2017-01-17 16:38:34", "2017-01-17 16:38:34", "", "1", "", "inherit", "open", "closed", "", "1", "", "", "2017-01-17 16:38:34", "2017-01-17 16:38:34", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/1-2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("41", "1", "2017-01-17 16:38:53", "2017-01-17 16:38:53", "", "2", "", "inherit", "open", "closed", "", "2", "", "", "2017-01-17 16:38:53", "2017-01-17 16:38:53", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/2-2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("42", "1", "2017-01-17 16:39:10", "2017-01-17 16:39:10", "", "3", "", "inherit", "open", "closed", "", "3", "", "", "2017-01-17 16:39:10", "2017-01-17 16:39:10", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/3-2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("43", "1", "2017-01-17 16:39:21", "2017-01-17 16:39:21", "", "4", "", "inherit", "open", "closed", "", "4", "", "", "2017-01-17 16:39:21", "2017-01-17 16:39:21", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/4-2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("44", "1", "2017-01-17 16:40:16", "2017-01-17 16:40:16", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "گالری تصویر چند منظوره", "", "publish", "open", "open", "", "multiple-images-gallery", "", "", "2022-02-14 22:21:55", "2022-02-14 18:51:55", "", "0", "http://king.kingthemes.net/multiple-images-gallery/", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("47", "1", "2017-01-17 16:54:00", "2017-01-17 16:54:00", "", "Big Hero 6 Baymax by jsclemente on DeviantArt", "", "inherit", "open", "closed", "", "big-hero-6-baymax-by-jsclemente-on-deviantart", "", "", "2017-01-17 16:54:00", "2017-01-17 16:54:00", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/Big-Hero-6-Baymax-by-jsclemente-on-DeviantArt-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("48", "1", "2017-01-18 11:58:15", "2017-01-18 11:58:15", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "من هستم یک...", "", "publish", "open", "open", "", "vimeo-i-am-a", "", "", "2022-02-14 22:19:42", "2022-02-14 18:49:42", "", "0", "http://king.kingthemes.net/vimeo-i-am-a/", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("49", "1", "2017-01-18 11:58:16", "2017-01-18 11:58:16", "", "473990304_1280x720", "", "inherit", "open", "closed", "", "473990304_1280x720", "", "", "2017-01-18 11:58:16", "2017-01-18 11:58:16", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/473990304_1280x720-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("50", "1", "2017-01-18 12:01:09", "2017-01-18 12:01:09", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "موزیک نووا آمور با نام از جنس طلا", "", "publish", "open", "open", "", "soundcloud-novo-amor-from-gold", "", "", "2022-02-14 22:18:06", "2022-02-14 18:48:06", "", "0", "http://king.kingthemes.net/soundcloud-novo-amor-from-gold/", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("51", "1", "2017-01-18 12:01:10", "2017-01-18 12:01:10", "", "artworks-000093120638-z2z2xp-crop", "", "inherit", "open", "closed", "", "artworks-000093120638-z2z2xp-crop", "", "", "2017-01-18 12:01:10", "2017-01-18 12:01:10", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/artworks-000093120638-z2z2xp-crop-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("52", "1", "2017-01-18 12:07:05", "2017-01-18 12:07:05", "", "1", "", "inherit", "open", "closed", "", "1-2", "", "", "2017-01-18 12:07:05", "2017-01-18 12:07:05", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/1-2.gif", "0", "attachment", "image/gif", "0");
INSERT INTO `wp_posts` VALUES("53", "1", "2017-01-18 12:07:33", "2017-01-18 12:07:33", "", "2", "", "inherit", "open", "closed", "", "2-2", "", "", "2017-01-18 12:07:33", "2017-01-18 12:07:33", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/2-2.gif", "0", "attachment", "image/gif", "0");
INSERT INTO `wp_posts` VALUES("54", "1", "2017-01-18 12:08:30", "2017-01-18 12:08:30", "", "3", "", "inherit", "open", "closed", "", "3-2", "", "", "2017-01-18 12:08:30", "2017-01-18 12:08:30", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/3-2.gif", "0", "attachment", "image/gif", "0");
INSERT INTO `wp_posts` VALUES("55", "1", "2017-01-18 12:09:01", "2017-01-18 12:09:01", "", "4", "", "inherit", "open", "closed", "", "4-2", "", "", "2017-01-18 12:09:01", "2017-01-18 12:09:01", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/4-2.gif", "0", "attachment", "image/gif", "0");
INSERT INTO `wp_posts` VALUES("56", "1", "2017-01-18 12:09:49", "2017-01-18 12:09:49", "", "5", "", "inherit", "open", "closed", "", "5", "", "", "2017-01-18 12:09:49", "2017-01-18 12:09:49", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/5-2.gif", "0", "attachment", "image/gif", "0");
INSERT INTO `wp_posts` VALUES("57", "1", "2017-01-18 12:10:29", "2017-01-18 12:10:29", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "5 نکته در مورد دوست یابی که کاش مردم در بیست سالگی می دانستند", "", "publish", "open", "open", "", "5-dating-tips-people-wish-they-knew-in-their-twenties", "", "", "2022-02-14 22:17:39", "2022-02-14 18:47:39", "", "0", "http://king.kingthemes.net/5-dating-tips-people-wish-they-knew-in-their-twenties/", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("58", "1", "2017-01-18 12:10:29", "2017-01-18 12:10:29", "", "", "", "inherit", "open", "closed", "", "58", "", "", "2017-01-18 12:10:29", "2017-01-18 12:10:29", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/Capture-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("59", "1", "2017-01-18 15:36:45", "2017-01-18 15:36:45", "", "image", "", "inherit", "open", "closed", "", "image", "", "", "2022-02-14 22:23:12", "2022-02-14 18:53:12", "", "37", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/image-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("67", "1", "2017-01-20 13:41:56", "2017-01-20 13:41:56", "", "avatarimg_user1", "", "inherit", "open", "closed", "", "avatarimg_user1", "", "", "2017-01-20 13:41:56", "2017-01-20 13:41:56", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/avatarimg_user1-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("68", "1", "2017-01-21 13:26:31", "2017-01-21 13:26:31", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "تریلر فیلم سینمایی وضعیت قرمز", "", "publish", "open", "open", "", "vimeo-johnny-express", "", "", "2022-02-14 22:18:33", "2022-02-14 18:48:33", "", "0", "http://king.kingthemes.net/vimeo-johnny-express/", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("69", "1", "2017-01-21 13:26:32", "2017-01-21 13:26:32", "", "539306657_1280x720", "", "inherit", "open", "closed", "", "539306657_1280x720", "", "", "2017-01-21 13:26:32", "2017-01-21 13:26:32", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/539306657_1280x720-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("70", "1", "2017-05-21 13:29:26", "2017-05-21 13:29:26", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "انیمیشن کریستال تاریک", "", "publish", "open", "open", "", "one-more-beer", "", "", "2022-02-14 22:08:25", "2022-02-14 18:38:25", "", "0", "http://king.kingthemes.net/one-more-beer/", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("71", "1", "2017-01-21 13:29:27", "2017-01-21 13:29:27", "", "348090111_1280x693", "", "inherit", "open", "closed", "", "348090111_1280x693", "", "", "2022-02-14 22:08:25", "2022-02-14 18:38:25", "", "70", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/348090111_1280x693-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("73", "1", "2017-01-21 13:34:27", "2017-01-21 13:34:27", "", "perception_2-wallpaper-1280x800", "", "inherit", "open", "closed", "", "perception_2-wallpaper-1280x800", "", "", "2017-01-21 13:34:27", "2017-01-21 13:34:27", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/perception_2-wallpaper-1280x800-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("74", "1", "2017-01-21 13:37:01", "2017-01-21 13:37:01", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "پست تصویری تکی", "", "publish", "open", "open", "", "single-image-post", "", "", "2022-02-14 22:16:01", "2022-02-14 18:46:01", "", "0", "http://king.kingthemes.net/single-image-post/", "0", "post", "", "2");
INSERT INTO `wp_posts` VALUES("75", "1", "2017-05-19 13:45:48", "2017-05-19 13:45:48", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "پست جدید ساده", "", "publish", "open", "open", "", "simple-news-post", "", "", "2022-02-14 22:11:09", "2022-02-14 18:41:09", "", "0", "http://king.kingthemes.net/simple-news-post/", "0", "post", "", "9");
INSERT INTO `wp_posts` VALUES("81", "1", "2017-01-22 18:29:34", "2017-01-22 18:29:34", "", "what-is-sales-activity-management", "", "inherit", "open", "closed", "", "what-is-sales-activity-management", "", "", "2017-01-22 18:29:34", "2017-01-22 18:29:34", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/what-is-sales-activity-management-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("82", "1", "2017-01-23 13:16:53", "2017-01-23 13:16:53", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "موزیک ویدیوی دنیای تاریک", "", "publish", "open", "open", "", "youtube-eden-billie-jean", "", "", "2022-02-14 22:17:04", "2022-02-14 18:47:04", "", "0", "http://king.kingthemes.net/youtube-eden-billie-jean/", "0", "post", "", "1");
INSERT INTO `wp_posts` VALUES("84", "1", "2017-01-23 13:18:08", "2017-01-23 13:18:08", "", "maxresdefault", "", "inherit", "open", "closed", "", "maxresdefault", "", "", "2022-02-14 22:17:04", "2022-02-14 18:47:04", "", "82", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/maxresdefault-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("87", "1", "2017-01-23 15:16:55", "2017-01-23 15:16:55", "", "14299149_10154742561704928_799543493_n", "", "inherit", "open", "closed", "", "14299149_10154742561704928_799543493_n", "", "", "2017-01-23 15:16:55", "2017-01-23 15:16:55", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/14299149_10154742561704928_799543493_n-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("88", "1", "2017-01-23 19:37:48", "2017-01-23 19:37:48", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "انیمیشن آلما", "", "publish", "open", "open", "", "vimeo-alma", "", "", "2022-02-14 22:15:51", "2022-02-14 18:45:51", "", "0", "http://king.kingthemes.net/vimeo-alma/", "0", "post", "", "1");
INSERT INTO `wp_posts` VALUES("90", "1", "2017-01-23 21:10:46", "2017-01-23 21:10:46", "", "Screen-Shot-2016-09-09-at-1.57.00-PM-1150x693", "", "inherit", "open", "closed", "", "screen-shot-2016-09-09-at-1-57-00-pm-1150x693", "", "", "2022-02-14 22:15:51", "2022-02-14 18:45:51", "", "88", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/Screen-Shot-2016-09-09-at-1.57.00-PM-1150x693-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("95", "1", "2017-01-30 21:48:52", "2017-01-30 21:48:52", "", "دسته بندی ها", "", "publish", "closed", "closed", "", "categories", "", "", "2022-02-14 19:52:55", "2022-02-14 16:22:55", "", "0", "http://king.kingthemes.net/?page_id=95", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("98", "1", "2017-01-30 21:50:24", "2017-01-30 21:50:24", "", "حفاظت محتوا", "", "publish", "closed", "closed", "", "nsfw", "", "", "2022-02-14 19:53:17", "2022-02-14 16:23:17", "", "0", "http://king.kingthemes.net/?page_id=98", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("105", "1", "2017-04-23 10:53:38", "2017-04-23 10:53:38", "<p style=\"text-align: justify;\"><strong>لورم ایپسوم متن ساختگی</strong></p>\r\n<p style=\"text-align: justify;\">با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</p>\r\n<p style=\"text-align: justify;\"><strong>لورم ایپسوم متن ساختگی</strong></p>\r\n<p style=\"text-align: justify;\">با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</p>", "برگه نمونه", "", "publish", "closed", "open", "", "sample-page-2", "", "", "2022-02-14 19:53:59", "2022-02-14 16:23:59", "", "0", "http://localhost/word/?page_id=2", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("134", "1", "2017-03-17 21:13:25", "2017-03-17 21:13:25", "", "2", "", "inherit", "open", "closed", "", "2-3", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "44", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/2-1-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("136", "1", "2017-03-17 21:13:40", "2017-03-17 21:13:40", "", "3", "", "inherit", "open", "closed", "", "3-3", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "44", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/3-1-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("137", "1", "2017-03-17 21:13:52", "2017-03-17 21:13:52", "", "4", "", "inherit", "open", "closed", "", "4-3", "", "", "2022-02-14 22:21:51", "2022-02-14 18:51:51", "", "44", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/4-1-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("139", "1", "2017-03-17 21:16:58", "2017-03-17 21:16:58", "", "1", "", "inherit", "open", "closed", "", "1-4", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "57", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/1-1-1.gif", "0", "attachment", "image/gif", "0");
INSERT INTO `wp_posts` VALUES("140", "1", "2017-03-17 21:17:30", "2017-03-17 21:17:30", "", "2", "", "inherit", "open", "closed", "", "2-4", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "57", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/2-1-1.gif", "0", "attachment", "image/gif", "0");
INSERT INTO `wp_posts` VALUES("141", "1", "2017-03-17 21:17:52", "2017-03-17 21:17:52", "", "3", "", "inherit", "open", "closed", "", "3-4", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "57", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/3-1-1.gif", "0", "attachment", "image/gif", "0");
INSERT INTO `wp_posts` VALUES("142", "1", "2017-03-17 21:18:13", "2017-03-17 21:18:13", "", "4", "", "inherit", "open", "closed", "", "4-4", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "57", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/4-1-1.gif", "0", "attachment", "image/gif", "0");
INSERT INTO `wp_posts` VALUES("143", "1", "2017-03-17 21:18:37", "2017-03-17 21:18:37", "", "5", "", "inherit", "open", "closed", "", "5-2", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "57", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/01/5-1-1.gif", "0", "attachment", "image/gif", "0");
INSERT INTO `wp_posts` VALUES("418", "1", "2017-04-22 12:05:30", "2017-04-22 12:05:30", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>\r\n<p style=\"text-align: justify;\"><em> </em></p>", "پست دموی موزیک - بارتون اسپرینگ", "", "publish", "open", "open", "", "mp3-music-demo-post-barton-springs", "", "", "2022-02-14 22:11:36", "2022-02-14 18:41:36", "", "0", "http://king.kingthemes.net/?p=418", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("445", "1", "2017-04-22 11:37:52", "2017-04-22 11:37:52", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "دموی ویدیویی انیمیشن", "", "publish", "open", "open", "", "mp4-video-demo-evolution", "", "", "2022-02-14 22:11:57", "2022-02-14 18:41:57", "", "0", "http://king.kingthemes.net/mp4-video-demo-evolution/", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("453", "1", "2017-04-23 12:13:54", "2017-04-23 12:13:54", "\"HD\" by iPhone 6 Unboxing &amp; Review 09.19.2014 .", "HD", "", "inherit", "open", "closed", "", "hd", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "418", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/04/birds-1.mp3", "0", "attachment", "audio/mpeg", "0");
INSERT INTO `wp_posts` VALUES("455", "1", "2017-02-03 13:24:19", "2017-02-03 13:24:19", "", "coverimg_user1", "", "inherit", "open", "closed", "", "coverimg_user1", "", "", "2017-02-03 13:24:19", "2017-02-03 13:24:19", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/02/coverimg_user1-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("456", "1", "2017-02-03 13:24:40", "2017-02-03 13:24:40", "", "avatarimg_user1", "", "inherit", "open", "closed", "", "avatarimg_user1-2", "", "", "2017-02-03 13:24:40", "2017-02-03 13:24:40", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/02/avatarimg_user1-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("457", "1", "2017-02-03 13:28:01", "2017-02-03 13:28:01", "", "coverimg_user1", "", "inherit", "open", "closed", "", "coverimg_user1-2", "", "", "2017-02-03 13:28:01", "2017-02-03 13:28:01", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/02/coverimg_user1-2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("458", "1", "2017-02-03 19:08:18", "2017-02-03 19:08:18", "", "coverimg_user1", "", "inherit", "open", "closed", "", "coverimg_user1-3", "", "", "2017-02-03 19:08:18", "2017-02-03 19:08:18", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/02/coverimg_user1-3.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("459", "1", "2017-04-23 12:17:39", "2017-04-23 12:17:39", "", "girl_with_headphones_2-wallpaper-1152x720", "", "inherit", "open", "closed", "", "girl_with_headphones_2-wallpaper-1152x720", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "418", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/04/girl_with_headphones_2-wallpaper-1152x720-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("461", "1", "2017-04-23 12:18:34", "2017-04-23 12:18:34", "", "3219680208", "", "inherit", "open", "closed", "", "3219680208", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "445", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/04/3219680208-1.mp4", "0", "attachment", "video/mp4", "0");
INSERT INTO `wp_posts` VALUES("462", "1", "2017-04-23 12:18:48", "2017-04-23 12:18:48", "", "evolution1", "", "inherit", "open", "closed", "", "evolution1", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "445", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/04/evolution1-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("464", "1", "2017-04-23 12:28:13", "2017-04-23 12:28:13", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/02/cropped-wplogo2-1-1.png", "cropped-wplogo2-1-1.png", "", "inherit", "open", "closed", "", "cropped-wplogo2-1-1-png", "", "", "2017-04-23 12:28:13", "2017-04-23 12:28:13", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/02/cropped-wplogo2-1-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("469", "1", "2017-04-29 09:08:58", "2017-04-29 09:08:58", "", "واکنش ها", "", "publish", "closed", "closed", "", "reactions", "", "", "2022-02-14 19:53:39", "2022-02-14 16:23:39", "", "0", "http://king.kingthemes.net/?page_id=469", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("485", "1", "2017-05-20 00:01:37", "2017-05-20 00:01:37", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "خرید عروسک دلقک", "", "publish", "open", "open", "", "buy-funny-toy", "", "", "2022-02-14 22:10:34", "2022-02-14 18:40:34", "", "0", "http://king.kingthemes.net/?p=485", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("486", "1", "2018-01-22 21:34:26", "2018-01-22 21:34:26", "", "head", "", "inherit", "open", "closed", "", "head", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "485", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/01/head.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("490", "1", "2018-01-25 22:41:54", "2018-01-25 22:41:54", "", "cb1", "", "inherit", "open", "closed", "", "cb1", "", "", "2018-01-25 22:41:54", "2018-01-25 22:41:54", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/01/cb1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("491", "1", "2018-01-25 22:44:46", "2018-01-25 22:44:46", "", "cb2", "", "inherit", "open", "closed", "", "cb2", "", "", "2018-01-25 22:44:46", "2018-01-25 22:44:46", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/01/cb2.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("492", "1", "2018-01-25 22:47:43", "2018-01-25 22:47:43", "", "cb3", "", "inherit", "open", "closed", "", "cb3", "", "", "2018-01-25 22:47:43", "2018-01-25 22:47:43", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/01/cb3.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("493", "1", "2018-01-25 22:48:34", "2018-01-25 22:48:34", "", "نشان ها", "", "publish", "closed", "closed", "", "badges", "", "", "2022-02-14 19:52:48", "2022-02-14 16:22:48", "", "0", "http://king.kingthemes.net/?page_id=493", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("495", "1", "2018-01-25 23:00:54", "2018-01-25 23:00:54", "", "pb1", "", "inherit", "open", "closed", "", "pb1", "", "", "2018-01-25 23:00:54", "2018-01-25 23:00:54", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/01/pb1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("496", "1", "2018-01-25 23:01:46", "2018-01-25 23:01:46", "", "pb2", "", "inherit", "open", "closed", "", "pb2", "", "", "2018-01-25 23:01:46", "2018-01-25 23:01:46", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/01/pb2.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("497", "1", "2018-01-25 23:02:27", "2018-01-25 23:02:27", "", "pb3", "", "inherit", "open", "closed", "", "pb3", "", "", "2018-01-25 23:02:27", "2018-01-25 23:02:27", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/01/pb3.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("498", "1", "2018-01-25 23:06:23", "2018-01-25 23:06:23", "", "fb1", "", "inherit", "open", "closed", "", "fb1", "", "", "2018-01-25 23:06:23", "2018-01-25 23:06:23", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/01/fb1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("503", "1", "2018-01-25 23:14:15", "2018-01-25 23:14:15", "", "pob1", "", "inherit", "open", "closed", "", "pob1", "", "", "2018-01-25 23:14:15", "2018-01-25 23:14:15", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/01/pob1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("504", "1", "2018-01-25 23:18:37", "2018-01-25 23:18:37", "", "pob2", "", "inherit", "open", "closed", "", "pob2", "", "", "2018-01-25 23:18:37", "2018-01-25 23:18:37", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/01/pob2.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("505", "1", "2018-01-25 23:19:05", "2018-01-25 23:19:05", "", "pob3", "", "inherit", "open", "closed", "", "pob3", "", "", "2018-01-25 23:19:05", "2018-01-25 23:19:05", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/01/pob3.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("506", "1", "2018-01-25 23:23:59", "2018-01-25 23:23:59", "", "unlimited", "", "inherit", "open", "closed", "", "unlimited", "", "", "2018-01-25 23:23:59", "2018-01-25 23:23:59", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/01/unlimited.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("522", "1", "2018-07-31 08:50:32", "2018-07-31 08:50:32", "", "دسته بندی های ورژن شماره دو", "", "publish", "closed", "closed", "", "categories-v2", "", "", "2022-02-14 19:53:04", "2022-02-14 16:23:04", "", "0", "http://king.kingthemes.net/?page_id=522", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("525", "1", "2018-07-31 08:53:45", "2018-07-31 08:53:45", "", "dribbble-wind02", "", "inherit", "open", "closed", "", "dribbble-wind02", "", "", "2018-07-31 08:53:45", "2018-07-31 08:53:45", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/07/dribbble-wind02.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("526", "1", "2018-07-31 08:54:07", "2018-07-31 08:54:07", "", "dewapage_dribbble_1x", "", "inherit", "open", "closed", "", "dewapage_dribbble_1x", "", "", "2018-07-31 08:54:07", "2018-07-31 08:54:07", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/07/dewapage_dribbble_1x.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("527", "1", "2018-07-31 08:55:05", "2018-07-31 08:55:05", "", "no-service", "", "inherit", "open", "closed", "", "no-service", "", "", "2018-07-31 08:55:05", "2018-07-31 08:55:05", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/07/no-service.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("528", "1", "2018-07-31 08:56:03", "2018-07-31 08:56:03", "", "remote", "", "inherit", "open", "closed", "", "remote", "", "", "2018-07-31 08:56:03", "2018-07-31 08:56:03", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/07/remote.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("529", "1", "2018-07-31 09:02:45", "2018-07-31 09:02:45", "", "if_Attribute_category_label_shop_price_price_tag_tag_1886315", "", "inherit", "open", "closed", "", "if_attribute_category_label_shop_price_price_tag_tag_1886315", "", "", "2018-07-31 09:02:45", "2018-07-31 09:02:45", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/07/if_Attribute_category_label_shop_price_price_tag_tag_1886315.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("530", "1", "2018-07-31 09:26:16", "2018-07-31 09:26:16", "", "if_Video-Camera-2_379365", "", "inherit", "open", "closed", "", "if_video-camera-2_379365", "", "", "2018-07-31 09:26:16", "2018-07-31 09:26:16", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/07/if_Video-Camera-2_379365.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("531", "1", "2018-07-31 09:27:42", "2018-07-31 09:27:42", "", "if_microphone_531899", "", "inherit", "open", "closed", "", "if_microphone_531899", "", "", "2018-07-31 09:27:42", "2018-07-31 09:27:42", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/07/if_microphone_531899.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("532", "1", "2018-07-31 09:28:56", "2018-07-31 09:28:56", "", "if_television_531913", "", "inherit", "open", "closed", "", "if_television_531913", "", "", "2018-07-31 09:28:56", "2018-07-31 09:28:56", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/07/if_television_531913.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("533", "1", "2018-07-31 09:36:00", "2018-07-31 09:36:00", "", "if_easel_1055067", "", "inherit", "open", "closed", "", "if_easel_1055067", "", "", "2018-07-31 09:36:00", "2018-07-31 09:36:00", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/07/if_easel_1055067.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("534", "1", "2018-07-31 09:37:34", "2018-07-31 09:37:34", "", "if_gamecontroller_1055053", "", "inherit", "open", "closed", "", "if_gamecontroller_1055053", "", "", "2018-07-31 09:37:34", "2018-07-31 09:37:34", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/07/if_gamecontroller_1055053.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("535", "1", "2018-07-31 09:44:11", "2018-07-31 09:44:11", "", "if_smartphone_1054975", "", "inherit", "open", "closed", "", "if_smartphone_1054975", "", "", "2018-07-31 09:44:11", "2018-07-31 09:44:11", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/07/if_smartphone_1054975.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("536", "1", "2018-07-31 09:46:19", "2018-07-31 09:46:19", "", "if_calculator_1055102", "", "inherit", "open", "closed", "", "if_calculator_1055102", "", "", "2018-07-31 09:46:19", "2018-07-31 09:46:19", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/07/if_calculator_1055102.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("537", "1", "2018-07-31 09:47:14", "2018-07-31 09:47:14", "", "if_image_1055042", "", "inherit", "open", "closed", "", "if_image_1055042", "", "", "2018-07-31 09:47:14", "2018-07-31 09:47:14", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/07/if_image_1055042.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("538", "1", "2018-07-31 09:49:03", "2018-07-31 09:49:03", "", "if_Food_fork_kitchen_knife_meanns_restaurant_1886929", "", "inherit", "open", "closed", "", "if_food_fork_kitchen_knife_meanns_restaurant_1886929", "", "", "2018-07-31 09:49:03", "2018-07-31 09:49:03", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/07/if_Food_fork_kitchen_knife_meanns_restaurant_1886929.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("539", "1", "2018-07-31 09:50:08", "2018-07-31 09:50:08", "", "if_Document_file_contract_agreement_certificate_degree_paper_1886906", "", "inherit", "open", "closed", "", "if_document_file_contract_agreement_certificate_degree_paper_1886906", "", "", "2018-07-31 09:50:08", "2018-07-31 09:50:08", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/07/if_Document_file_contract_agreement_certificate_degree_paper_1886906.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("540", "1", "2018-07-31 09:50:52", "2018-07-31 09:50:52", "", "if_Flag_golf_pothole_sports_peace_nation_country_1886936", "", "inherit", "open", "closed", "", "if_flag_golf_pothole_sports_peace_nation_country_1886936", "", "", "2018-07-31 09:50:52", "2018-07-31 09:50:52", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/07/if_Flag_golf_pothole_sports_peace_nation_country_1886936.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("541", "1", "2022-02-14 22:37:29", "2020-02-16 17:25:14", "", "ویژه ها", "", "publish", "closed", "closed", "", "features", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/features/", "11", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("542", "1", "2018-07-31 09:51:34", "2018-07-31 09:51:34", "", "if_Fasten_pin_push_pushpin_tack_thumb_thumbtack_1886926", "", "inherit", "open", "closed", "", "if_fasten_pin_push_pushpin_tack_thumb_thumbtack_1886926", "", "", "2018-07-31 09:51:34", "2018-07-31 09:51:34", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2018/07/if_Fasten_pin_push_pushpin_tack_thumb_thumbtack_1886926.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("602", "1", "2019-03-17 13:25:59", "2019-03-17 13:25:59", "", "logo", "", "inherit", "open", "closed", "", "logo", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "75", "https://wordpress.kingthemes.net/main/wp-content/uploads/2019/03/logo.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("603", "1", "2019-03-17 13:26:59", "2019-03-17 13:26:59", "", "logon", "", "inherit", "open", "closed", "", "logon", "", "", "2019-03-17 13:26:59", "2019-03-17 13:26:59", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2019/03/logon.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("604", "1", "2019-03-17 13:29:24", "2019-03-17 13:29:24", "", "logon2", "", "inherit", "open", "closed", "", "logon2", "", "", "2019-03-17 13:29:24", "2019-03-17 13:29:24", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2019/03/logon2.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("605", "1", "2019-03-17 13:31:40", "2019-03-17 13:31:40", "", "favicon", "", "inherit", "open", "closed", "", "favicon", "", "", "2019-03-17 13:31:40", "2019-03-17 13:31:40", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2019/03/favicon.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("606", "1", "2019-03-17 13:31:45", "2019-03-17 13:31:45", "https://wordpress.kingthemes.net/main/wp-content/uploads/2019/03/cropped-favicon.png", "cropped-favicon.png", "", "inherit", "open", "closed", "", "cropped-favicon-png", "", "", "2019-03-17 13:31:45", "2019-03-17 13:31:45", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2019/03/cropped-favicon.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("608", "1", "2019-03-17 13:40:22", "2019-03-17 13:40:22", "", "favicon", "", "inherit", "open", "closed", "", "favicon-2", "", "", "2019-03-17 13:40:22", "2019-03-17 13:40:22", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2019/03/favicon-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("610", "1", "2019-03-17 13:40:26", "2019-03-17 13:40:26", "https://wordpress.kingthemes.net/main/wp-content/uploads/2019/03/cropped-favicon-1.png", "cropped-favicon-1.png", "", "inherit", "open", "closed", "", "cropped-favicon-1-png", "", "", "2019-03-17 13:40:26", "2019-03-17 13:40:26", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2019/03/cropped-favicon-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("617", "1", "2019-06-07 18:24:28", "2019-06-07 18:24:28", "", "کاربران ورژن شماره دو", "", "publish", "closed", "closed", "", "users-v2", "", "", "2022-02-14 19:54:27", "2022-02-14 16:24:27", "", "0", "http://king.kingthemes.net/?page_id=617", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("621", "1", "2022-02-14 22:37:29", "2020-02-16 17:25:19", "", "پست ویدیویی", "", "publish", "closed", "closed", "", "video-post", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/video-post/", "14", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("622", "1", "2022-02-14 22:37:29", "2020-02-16 17:25:19", "", "جدیدترین پست ها", "", "publish", "closed", "closed", "", "news-post", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/news-post/", "18", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("623", "1", "2022-02-14 22:37:29", "2020-02-16 17:25:19", "", "نمونه پست", "", "publish", "closed", "closed", "", "post-examples", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/post-examples/", "13", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("624", "1", "2022-02-14 22:37:29", "2020-02-16 17:25:19", "", "پست صوتی", "", "publish", "closed", "closed", "", "mp3-post", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/mp3-post/", "16", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("625", "1", "2022-02-14 22:37:29", "2020-02-16 17:25:19", "", "پست ویدیویی Mp4", "", "publish", "closed", "closed", "", "mp4-video-post", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/mp4-video-post/", "17", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("626", "1", "2022-02-14 22:37:29", "2020-02-16 17:25:19", "", "پست گالری", "", "publish", "closed", "closed", "", "gallery-post", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/gallery-post/", "20", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("627", "1", "2022-02-14 22:37:29", "2020-02-16 17:25:19", "", "پست لیستی", "", "publish", "closed", "closed", "", "list-post", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/list-post/", "19", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("628", "1", "2022-02-14 22:37:29", "2020-02-16 17:25:19", "", "پست اسپانسر", "", "publish", "closed", "closed", "", "sponsored-post", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/sponsored-post/", "23", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("629", "1", "2022-02-14 22:37:30", "2020-02-16 17:25:19", "", "پروفایل کاربر", "", "publish", "closed", "closed", "", "users-profile", "", "", "2022-02-14 22:37:30", "2022-02-14 19:07:30", "", "0", "https://wordpress.kingthemes.net/main/users-profile/", "40", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("630", "1", "2022-02-14 22:32:09", "2020-02-16 17:25:19", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.", "", "", "publish", "closed", "closed", "", "630", "", "", "2022-02-14 22:32:09", "2022-02-14 19:02:09", "", "0", "https://wordpress.kingthemes.net/main/", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("641", "1", "2022-02-14 22:32:09", "2020-02-16 17:25:20", "", "نوشته های برتر", "", "publish", "closed", "closed", "", "top-posts", "", "", "2022-02-14 22:32:09", "2022-02-14 19:02:09", "", "0", "https://wordpress.kingthemes.net/main/top-posts/", "4", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("643", "1", "2017-05-20 20:43:20", "2017-05-20 20:43:20", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "اتفاقات عاشقانه ای که افتاد", "", "publish", "open", "open", "", "a-rather-lovely-thing", "", "", "2022-02-14 22:09:29", "2022-02-14 18:39:29", "", "0", "http://king.kingthemes.net/2017/01/15/a-rather-lovely-thing/", "0", "post", "", "1");
INSERT INTO `wp_posts` VALUES("644", "1", "2022-02-14 22:37:29", "2020-02-16 17:25:21", " ", "", "", "publish", "closed", "closed", "", "644", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/644/", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("645", "1", "2022-02-14 22:37:29", "2020-02-16 17:25:21", " ", "", "", "publish", "closed", "closed", "", "645", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/645/", "5", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("646", "1", "2022-02-14 22:37:29", "2020-02-16 17:25:21", " ", "", "", "publish", "closed", "closed", "", "646", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/646/", "8", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("647", "1", "2022-02-14 22:37:29", "2020-02-16 17:25:21", " ", "", "", "publish", "closed", "closed", "", "647", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/647/", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("648", "1", "2022-02-14 22:37:29", "2020-02-16 17:25:21", " ", "", "", "publish", "closed", "closed", "", "648", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/648/", "3", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("649", "1", "2022-02-14 22:37:29", "2020-02-16 17:25:21", " ", "", "", "publish", "closed", "closed", "", "649", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/649/", "9", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("650", "1", "2022-02-14 22:37:29", "2020-02-16 17:25:22", " ", "", "", "publish", "closed", "closed", "", "650", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/650/", "12", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("651", "1", "2022-02-14 22:37:29", "2020-02-16 17:25:22", " ", "", "", "publish", "closed", "closed", "", "651", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/651/", "10", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("652", "1", "2022-02-14 22:37:29", "2020-02-16 17:25:22", " ", "", "", "publish", "closed", "closed", "", "652", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/652/", "7", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("653", "1", "2022-02-14 22:32:09", "2020-02-16 17:25:22", " ", "", "", "publish", "closed", "closed", "", "653", "", "", "2022-02-14 22:32:09", "2022-02-14 19:02:09", "", "0", "https://wordpress.kingthemes.net/main/653/", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("663", "1", "2022-02-14 22:32:09", "2020-02-16 17:25:22", " ", "", "", "publish", "closed", "closed", "", "663", "", "", "2022-02-14 22:32:09", "2022-02-14 19:02:09", "", "0", "https://wordpress.kingthemes.net/main/663/", "3", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("664", "1", "2022-02-14 22:32:09", "2020-02-16 17:25:22", " ", "", "", "publish", "closed", "closed", "", "664", "", "", "2022-02-14 22:32:09", "2022-02-14 19:02:09", "", "0", "https://wordpress.kingthemes.net/main/664/", "5", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("665", "1", "2022-02-14 22:32:09", "2020-02-16 17:25:22", " ", "", "", "publish", "closed", "closed", "", "665", "", "", "2022-02-14 22:32:09", "2022-02-14 19:02:09", "", "0", "https://wordpress.kingthemes.net/main/665/", "7", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("666", "1", "2022-02-14 22:32:09", "2020-02-16 17:25:22", "", "دموی موزیک", "", "publish", "closed", "closed", "", "mp3-music-demo-post-barton-springs", "", "", "2022-02-14 22:32:09", "2022-02-14 19:02:09", "", "0", "https://wordpress.kingthemes.net/main/mp3-music-demo-post-barton-springs/", "6", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("668", "1", "2022-02-14 22:32:09", "2020-02-16 17:25:22", " ", "", "", "publish", "closed", "closed", "", "668", "", "", "2022-02-14 22:32:09", "2022-02-14 19:02:09", "", "0", "https://wordpress.kingthemes.net/main/668/", "8", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("669", "1", "2022-02-14 22:37:29", "2020-02-16 17:25:22", " ", "", "", "publish", "closed", "closed", "", "669", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/669/", "6", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("670", "1", "2022-02-14 22:37:29", "2020-02-16 17:25:22", " ", "", "", "publish", "closed", "closed", "", "670", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/670/", "4", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("671", "1", "2020-02-17 10:17:50", "2020-02-17 10:17:50", "", "2", "", "inherit", "open", "closed", "", "2-5", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "643", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/05/2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("673", "1", "2020-02-17 10:20:58", "2020-02-17 10:20:58", "https://wordpress.kingthemes.net/main/wp-content/uploads/2019/03/cropped-favicon-1-1.png", "cropped-favicon-1-1.png", "", "inherit", "open", "closed", "", "cropped-favicon-1-1-png", "", "", "2020-02-17 10:20:58", "2020-02-17 10:20:58", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2019/03/cropped-favicon-1-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("687", "1", "2020-04-30 17:37:16", "2020-04-30 17:37:16", "", "typewriter", "", "inherit", "open", "closed", "", "typewriter", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "485", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/05/typewriter.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("690", "1", "2020-04-30 17:38:31", "2020-04-30 17:38:31", "", "radio-1", "", "inherit", "open", "closed", "", "radio-1", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "485", "https://wordpress.kingthemes.net/main/wp-content/uploads/2017/05/radio-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("693", "1", "2020-05-03 12:48:00", "2020-05-03 12:48:00", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "انیمیشن جدید 2022", "", "publish", "open", "open", "", "sawmill-grizzy-and-the-lemmings", "", "\nhttps://vimeo.com/150522409", "2022-02-14 22:06:34", "2022-02-14 18:36:34", "", "0", "https://wordpress.kingthemes.net/main/?p=693", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("694", "1", "2020-05-03 12:47:40", "2020-05-03 12:47:40", "", "clement-dartigues-scirie", "", "inherit", "open", "closed", "", "clement-dartigues-scirie", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "693", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/05/clement-dartigues-scirie.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("728", "1", "2020-05-10 11:15:27", "2020-05-10 11:15:27", "", "ezgif.com-webp-to-png", "", "inherit", "open", "closed", "", "ezgif-com-webp-to-png", "", "", "2020-05-10 11:15:27", "2020-05-10 11:15:27", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/05/ezgif.com-webp-to-png-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("729", "1", "2020-05-10 11:16:12", "2020-05-10 11:16:12", "", "clement-dartigues-bivouac-def", "", "inherit", "open", "closed", "", "clement-dartigues-bivouac-def", "", "", "2022-02-14 22:04:00", "2022-02-14 18:34:00", "", "734", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/05/clement-dartigues-bivouac-def.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("730", "1", "2020-05-10 11:19:12", "2020-05-10 11:19:12", "", "battlefield_warrior_horse_running_smoke_illustration-wallpaper-1920x1080", "", "inherit", "open", "closed", "", "battlefield_warrior_horse_running_smoke_illustration-wallpaper-1920x1080", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "734", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/05/battlefield_warrior_horse_running_smoke_illustration-wallpaper-1920x1080-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("731", "1", "2020-05-10 11:19:43", "2020-05-10 11:19:43", "", "the_starry_night-wallpaper-1920x1080", "", "inherit", "open", "closed", "", "the_starry_night-wallpaper-1920x1080", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "734", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/05/the_starry_night-wallpaper-1920x1080-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("732", "1", "2020-05-10 11:20:17", "2020-05-10 11:20:17", "", "samurai_red_tree_wind_autumn-wallpaper-1920x1080", "", "inherit", "open", "closed", "", "samurai_red_tree_wind_autumn-wallpaper-1920x1080", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "734", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/05/samurai_red_tree_wind_autumn-wallpaper-1920x1080-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("733", "1", "2020-05-10 11:21:09", "2020-05-10 11:21:09", "", "house_forest_3d-wallpaper-1920x1080", "", "inherit", "open", "closed", "", "house_forest_3d-wallpaper-1920x1080", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "734", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/05/house_forest_3d-wallpaper-1920x1080-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("734", "1", "2020-05-10 11:22:36", "2020-05-10 11:22:36", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "تصاویر متعدد با گالری لایت باکس", "", "publish", "open", "open", "", "multiple-images-with-lightbox-gallery", "", "", "2022-02-14 22:04:17", "2022-02-14 18:34:17", "", "0", "https://wordpress.kingthemes.net/main/multiple-images-with-lightbox-gallery/", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("737", "1", "2020-05-10 11:41:38", "2020-05-10 11:41:38", "", "kingad", "", "inherit", "open", "closed", "", "kingad", "", "", "2020-05-10 11:41:38", "2020-05-10 11:41:38", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/05/kingad.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("738", "1", "2020-05-10 11:44:54", "2020-05-10 11:44:54", "", "485743_3900039704282_366734302_n", "", "inherit", "open", "closed", "", "485743_3900039704282_366734302_n", "", "", "2020-05-10 11:44:54", "2020-05-10 11:44:54", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/05/485743_3900039704282_366734302_n.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("739", "1", "2020-05-10 11:45:21", "2020-05-10 11:45:21", "", "joker_50-wallpaper-1920x1080", "", "inherit", "open", "closed", "", "joker_50-wallpaper-1920x1080", "", "", "2020-05-10 11:45:21", "2020-05-10 11:45:21", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/05/joker_50-wallpaper-1920x1080-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("745", "1", "2020-05-26 19:24:16", "2020-05-26 19:24:16", "", "bottle-green-2", "", "inherit", "open", "closed", "", "bottle-green-2", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "485", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/05/bottle-green-2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("746", "1", "2020-05-26 19:25:01", "2020-05-26 19:25:01", "", "gramaphone", "", "inherit", "open", "closed", "", "gramaphone", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "485", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/05/gramaphone.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("747", "1", "2020-05-26 19:25:55", "2020-05-26 19:25:55", "", "head", "", "inherit", "open", "closed", "", "head-2", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "485", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/05/head.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("759", "1", "2020-06-15 22:30:06", "2020-06-15 22:30:06", "", "kingad copy", "", "inherit", "open", "closed", "", "kingad-copy", "", "", "2020-06-15 22:30:06", "2020-06-15 22:30:06", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/06/kingad-copy.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("762", "1", "2022-02-14 22:37:29", "2020-06-20 17:02:58", "", "آرشیو", "", "publish", "closed", "closed", "", "archive", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/?p=762", "24", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("763", "1", "2022-02-14 22:37:29", "2020-06-20 17:02:58", "", "تصویر پس زمینه", "", "publish", "closed", "closed", "", "background-image", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/?p=763", "26", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("764", "1", "2022-02-14 22:37:29", "2020-06-20 17:02:58", "", "رنگ پس زمینه", "", "publish", "closed", "closed", "", "background-color-logo", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/?p=764", "27", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("765", "1", "2022-02-14 22:37:29", "2020-06-20 17:02:58", "", "توضیحات و لوگو", "", "publish", "closed", "closed", "", "description", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/?p=765", "28", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("766", "1", "2022-02-14 22:37:29", "2020-06-20 17:02:58", "", "پیشفرض", "", "publish", "closed", "closed", "", "default", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/?p=766", "25", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("773", "1", "2022-02-14 22:37:29", "2020-06-20 17:08:04", "", "قالب های پست", "", "publish", "closed", "closed", "", "post-templates", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/?p=773", "29", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("774", "1", "2022-02-14 22:37:30", "2020-06-20 18:23:38", "", "اخبار نسخه شماره شش", "", "publish", "closed", "closed", "", "news-v6", "", "", "2022-02-14 22:37:30", "2022-02-14 19:07:30", "", "0", "https://wordpress.kingthemes.net/main/?p=774", "32", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("775", "1", "2020-06-20 18:00:44", "2020-06-20 18:00:44", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "شش شگفتی ساز طبیعی برای لیست شما", "", "publish", "open", "open", "", "6-awe-inspiring-natural-wonders-for-your-bucket-list", "", "", "2022-02-14 22:03:34", "2022-02-14 18:33:34", "", "0", "https://wordpress.kingthemes.net/main/6-awe-inspiring-natural-wonders-for-your-bucket-list/", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("776", "1", "2020-06-20 18:00:45", "2020-06-20 18:00:45", "", "", "", "inherit", "open", "closed", "", "776", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "775", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/06/antelope_canyon-wallpaper-1440x900-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("779", "1", "2022-02-14 22:37:30", "2020-06-20 18:23:38", "", "اخبار نسخه شماره پنج", "", "publish", "closed", "closed", "", "news-v5", "", "", "2022-02-14 22:37:30", "2022-02-14 19:07:30", "", "0", "https://wordpress.kingthemes.net/main/?p=779", "31", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("780", "1", "2022-02-14 22:37:29", "2020-06-20 18:23:38", "", "اخبار پیشفرض", "", "publish", "closed", "closed", "", "news-default", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/?p=780", "30", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("783", "1", "2022-02-14 22:37:30", "2020-06-20 18:23:38", "", "ویدیو نسخه شماره سه", "", "publish", "closed", "closed", "", "video-v3", "", "", "2022-02-14 22:37:30", "2022-02-14 19:07:30", "", "0", "https://wordpress.kingthemes.net/main/?p=783", "34", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("786", "1", "2022-02-14 22:37:30", "2020-06-20 18:23:38", "", "ویدیو نسخه شماره دو", "", "publish", "closed", "closed", "", "video-v2", "", "", "2022-02-14 22:37:30", "2022-02-14 19:07:30", "", "0", "https://wordpress.kingthemes.net/main/?p=786", "35", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("789", "1", "2022-02-14 22:37:30", "2020-06-20 18:23:38", "", "ویدیو نسخه شماره یک", "", "publish", "closed", "closed", "", "video-v1", "", "", "2022-02-14 22:37:30", "2022-02-14 19:07:30", "", "0", "https://wordpress.kingthemes.net/main/?p=789", "36", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("790", "1", "2022-02-14 22:37:30", "2020-06-20 18:23:38", "", "پیشفرض ویدیو", "", "publish", "closed", "closed", "", "video-default", "", "", "2022-02-14 22:37:30", "2022-02-14 19:07:30", "", "0", "https://wordpress.kingthemes.net/main/?p=790", "33", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("791", "1", "2022-02-14 22:37:30", "2020-06-20 18:23:38", "", "تصویر پیشفرض", "", "publish", "closed", "closed", "", "image-default", "", "", "2022-02-14 22:37:30", "2022-02-14 19:07:30", "", "0", "https://wordpress.kingthemes.net/main/?p=791", "37", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("794", "1", "2022-02-14 22:37:30", "2020-06-20 18:23:38", "", "تصویر نسخه شماره یک", "", "publish", "closed", "closed", "", "image-v1", "", "", "2022-02-14 22:37:30", "2022-02-14 19:07:30", "", "0", "https://wordpress.kingthemes.net/main/?p=794", "38", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("795", "1", "2017-01-17 18:21:00", "2017-01-17 18:21:00", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "کوهستان کهکشان راه شیری", "", "publish", "open", "open", "", "milky-way-mountain-image", "", "", "2022-02-14 22:21:32", "2022-02-14 18:51:32", "", "0", "https://wordpress.kingthemes.net/main/?p=795", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("796", "1", "2020-06-20 18:22:15", "2020-06-20 18:22:15", "", "milky_way_mountain_by_yakub_nihat-wallpaper-1280x720", "", "inherit", "open", "closed", "", "milky_way_mountain_by_yakub_nihat-wallpaper-1280x720", "", "", "2022-02-14 22:21:27", "2022-02-14 18:51:27", "", "795", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/06/milky_way_mountain_by_yakub_nihat-wallpaper-1280x720-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("799", "1", "2022-02-14 22:37:30", "2020-06-20 18:23:38", "", "تصویر نسخه شماره دو", "", "publish", "closed", "closed", "", "image-v1-2", "", "", "2022-02-14 22:37:30", "2022-02-14 19:07:30", "", "0", "https://wordpress.kingthemes.net/main/?p=799", "39", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("801", "1", "2020-06-29 14:21:28", "2020-06-29 14:21:28", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "آلبوم اعتماد به نفس", "", "publish", "open", "open", "", "spotify-confidence-boost", "", "", "2022-02-14 22:02:54", "2022-02-14 18:32:54", "", "0", "https://wordpress.kingthemes.net/main/spotify-confidence-boost/", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("802", "1", "2020-06-29 14:21:28", "2020-06-29 14:21:28", "", "ab67706f000000027e368901f39aae9d510c8fda.jpg", "", "inherit", "open", "closed", "", "ab67706f000000027e368901f39aae9d510c8fda-jpg", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "801", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/06/httpsi.scdn_.coimageab67706f000000027e368901f39aae9d510c8fda.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("803", "1", "2017-06-29 21:52:00", "2017-06-29 21:52:00", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "موزیک شکستن قلب من", "", "publish", "open", "open", "", "breaking-me", "", "", "2022-02-14 22:06:55", "2022-02-14 18:36:55", "", "0", "https://wordpress.kingthemes.net/main/?p=803", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("804", "1", "2020-06-29 21:54:38", "2020-06-29 21:54:38", "", "ab67616d0000b273ca801dab96017456b9847ac2", "", "inherit", "open", "closed", "", "ab67616d0000b273ca801dab96017456b9847ac2", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "803", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/06/ab67616d0000b273ca801dab96017456b9847ac2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("807", "1", "2020-06-29 22:31:40", "2020-06-29 22:31:40", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "پلی لیست ویدیو", "", "publish", "open", "open", "", "video-playlist", "", "", "2022-02-14 21:59:59", "2022-02-14 18:29:59", "", "0", "https://wordpress.kingthemes.net/main/?p=807", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("809", "1", "2020-06-29 22:27:54", "2020-06-29 22:27:54", "", "maxresdefault (1)", "", "inherit", "open", "closed", "", "maxresdefault-1", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "807", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/06/maxresdefault-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("810", "1", "2020-06-29 22:28:06", "2020-06-29 22:28:06", "", "overlay", "", "inherit", "open", "closed", "", "overlay", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "807", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/06/overlay.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("811", "1", "2020-06-29 22:29:35", "2020-06-29 22:29:35", "", "overlay (1)", "", "inherit", "open", "closed", "", "overlay-1", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "807", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/06/overlay-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("816", "1", "2020-06-29 22:37:28", "2020-06-29 22:37:28", "", "the-little-prince-characters-the-conceited-man", "", "inherit", "open", "closed", "", "the-little-prince-characters-the-conceited-man", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "807", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/06/the-little-prince-characters-the-conceited-man.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("819", "1", "2020-06-29 22:44:37", "2020-06-29 22:44:37", "", "491616871", "", "inherit", "open", "closed", "", "491616871", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "807", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/06/491616871.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("821", "1", "2020-06-29 22:52:32", "2020-06-29 22:52:32", "", "maxresdefault (2)", "", "inherit", "open", "closed", "", "maxresdefault-2", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "823", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/06/maxresdefault-2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("822", "1", "2020-06-29 22:58:41", "2020-06-29 22:58:41", "\"Barns Courtney - Fire-[AudioTrimmer.com]\".", "Barns Courtney - Fire-[AudioTrimmer.com]", "", "inherit", "open", "closed", "", "barns-courtney-fire-audiotrimmer-com", "", "", "2022-02-14 22:00:22", "2022-02-14 18:30:22", "", "823", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/06/Barns-Courtney-Fire-AudioTrimmer.com_.mp3", "0", "attachment", "audio/mpeg", "0");
INSERT INTO `wp_posts` VALUES("823", "1", "2020-06-29 21:00:00", "2020-06-29 21:00:00", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "پلی لیست موزیک", "", "publish", "open", "open", "", "music-playlist", "", "", "2022-02-14 22:02:36", "2022-02-14 18:32:36", "", "0", "https://wordpress.kingthemes.net/main/music-playlist/", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("825", "1", "2020-06-29 23:01:46", "2020-06-29 23:01:46", "", "516770578", "", "inherit", "open", "closed", "", "516770578", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "823", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/06/516770578.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("826", "1", "2020-06-29 23:01:57", "2020-06-29 23:01:57", "", "522fe3f2331081c1cd83dfa313755019", "", "inherit", "open", "closed", "", "522fe3f2331081c1cd83dfa313755019", "", "", "2022-02-13 16:22:25", "2022-02-13 12:52:25", "", "823", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/06/522fe3f2331081c1cd83dfa313755019.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("829", "1", "2022-02-14 22:37:29", "2020-06-29 23:05:11", "", "پلی لیست ویدیویی", "", "publish", "closed", "closed", "", "video-playlist", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/?p=829", "15", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("830", "1", "2022-02-14 22:37:29", "2020-06-29 23:05:11", "", "پست موزیک", "", "publish", "closed", "closed", "", "music-post", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/?p=830", "21", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("831", "1", "2022-02-14 22:37:29", "2020-06-29 23:05:11", "", "پلی لیست موزیک", "", "publish", "closed", "closed", "", "music-playlist", "", "", "2022-02-14 22:37:29", "2022-02-14 19:07:29", "", "0", "https://wordpress.kingthemes.net/main/?p=831", "22", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("835", "1", "2020-10-04 21:29:55", "2020-10-04 21:29:55", "", "E9C0707A-630B-4585-8B29-938828E587C2", "", "inherit", "open", "closed", "", "e9c0707a-630b-4585-8b29-938828e587c2", "", "", "2020-10-04 21:29:55", "2020-10-04 21:29:55", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/10/E9C0707A-630B-4585-8B29-938828E587C2.jpeg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("845", "1", "2020-10-18 11:51:53", "2020-10-18 11:51:53", "", "Screenshot 2020-10-18 145042", "", "inherit", "open", "closed", "", "screenshot-2020-10-18-145042", "", "", "2020-10-18 11:51:53", "2020-10-18 11:51:53", "", "0", "https://wordpress.kingthemes.net/main/wp-content/uploads/2020/10/Screenshot-2020-10-18-145042.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("851", "1", "2022-02-13 16:28:14", "2022-02-13 12:58:14", "", "v7logo2", "", "inherit", "open", "closed", "", "v7logo2", "", "", "2022-02-13 16:28:14", "2022-02-13 12:58:14", "", "0", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2022/02/v7logo2.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("855", "1", "2022-02-13 16:34:28", "2022-02-13 13:04:28", " ", "", "", "publish", "closed", "closed", "", "855", "", "", "2022-02-13 16:34:28", "2022-02-13 13:04:28", "", "0", "https://themes.wpnovin.com/King/Main/?p=855", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("856", "1", "2022-02-13 16:34:28", "2022-02-13 13:04:28", " ", "", "", "publish", "closed", "closed", "", "856", "", "", "2022-02-13 16:34:28", "2022-02-13 13:04:28", "", "0", "https://themes.wpnovin.com/King/Main/?p=856", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("857", "1", "2022-02-13 16:34:28", "2022-02-13 13:04:28", " ", "", "", "publish", "closed", "closed", "", "857", "", "", "2022-02-13 16:34:28", "2022-02-13 13:04:28", "", "0", "https://themes.wpnovin.com/King/Main/?p=857", "3", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("858", "1", "2022-02-13 16:34:28", "2022-02-13 13:04:28", " ", "", "", "publish", "closed", "closed", "", "858", "", "", "2022-02-13 16:34:28", "2022-02-13 13:04:28", "", "0", "https://themes.wpnovin.com/King/Main/?p=858", "4", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("859", "1", "2022-02-13 16:34:28", "2022-02-13 13:04:28", " ", "", "", "publish", "closed", "closed", "", "859", "", "", "2022-02-13 16:34:28", "2022-02-13 13:04:28", "", "0", "https://themes.wpnovin.com/King/Main/?p=859", "5", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("860", "1", "2022-02-13 16:34:28", "2022-02-13 13:04:28", " ", "", "", "publish", "closed", "closed", "", "860", "", "", "2022-02-13 16:34:28", "2022-02-13 13:04:28", "", "0", "https://themes.wpnovin.com/King/Main/?p=860", "6", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("861", "1", "2022-02-13 16:34:51", "0000-00-00 00:00:00", " ", "", "", "draft", "closed", "closed", "", "", "", "", "2022-02-13 16:34:51", "0000-00-00 00:00:00", "", "0", "https://themes.wpnovin.com/King/Main/?p=861", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("862", "1", "2022-02-13 16:34:51", "0000-00-00 00:00:00", " ", "", "", "draft", "closed", "closed", "", "", "", "", "2022-02-13 16:34:51", "0000-00-00 00:00:00", "", "0", "https://themes.wpnovin.com/King/Main/?p=862", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("863", "1", "2022-02-13 16:39:13", "2022-02-13 13:09:13", "", "قالب جدید", "", "publish", "closed", "closed", "", "%d9%82%d8%a7%d9%84%d8%a8-%d8%ac%d8%af%db%8c%d8%af", "", "", "2022-02-15 01:12:27", "2022-02-14 21:42:27", "", "0", "https://themes.wpnovin.com/King/Main/?post_type=stories&#038;p=863", "0", "stories", "", "0");
INSERT INTO `wp_posts` VALUES("865", "1", "2022-02-13 16:55:21", "2022-02-13 13:25:21", ".owl-carousel .owl-stage-outer {\n    display: revert;\n    direction: ltr;\n    text-align: right;\n}\n.mfp-content {\n    text-align: center;\n}\n.mfp-content .king-related .related-title {\n    text-align: center;\n}\n.login-rl a {\n    padding-left: 30px;\n}\nmain#main .king-lists {\n    display: none !important;\n}", "king", "", "publish", "closed", "closed", "", "king", "", "", "2022-02-16 02:03:21", "2022-02-15 22:33:21", "", "0", "https://themes.wpnovin.com/King/Main/2022/02/13/king/", "0", "custom_css", "", "0");
INSERT INTO `wp_posts` VALUES("866", "1", "2022-02-13 16:55:21", "2022-02-13 13:25:21", ".owl-carousel .owl-stage-outer {\n    display: revert;\n    direction: ltr;\n    text-align: right;\n}", "king", "", "inherit", "closed", "closed", "", "865-revision-v1", "", "", "2022-02-13 16:55:21", "2022-02-13 13:25:21", "", "865", "https://themes.wpnovin.com/King/Main/?p=866", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("867", "1", "2022-02-14 19:52:48", "2022-02-14 16:22:48", "", "نشان ها", "", "inherit", "closed", "closed", "", "493-revision-v1", "", "", "2022-02-14 19:52:48", "2022-02-14 16:22:48", "", "493", "https://themes.wpnovin.com/King/Main/?p=867", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("868", "1", "2022-02-14 19:52:55", "2022-02-14 16:22:55", "", "دسته بندی ها", "", "inherit", "closed", "closed", "", "95-revision-v1", "", "", "2022-02-14 19:52:55", "2022-02-14 16:22:55", "", "95", "https://themes.wpnovin.com/King/Main/?p=868", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("869", "1", "2022-02-14 19:53:04", "2022-02-14 16:23:04", "", "دسته بندی های ورژن شماره دو", "", "inherit", "closed", "closed", "", "522-revision-v1", "", "", "2022-02-14 19:53:04", "2022-02-14 16:23:04", "", "522", "https://themes.wpnovin.com/King/Main/?p=869", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("870", "1", "2022-02-14 19:53:10", "2022-02-14 16:23:10", "", "داغ", "", "inherit", "closed", "closed", "", "22-revision-v1", "", "", "2022-02-14 19:53:10", "2022-02-14 16:23:10", "", "22", "https://themes.wpnovin.com/King/Main/?p=870", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("871", "1", "2022-02-14 19:53:17", "2022-02-14 16:23:17", "", "حفاظت محتوا", "", "inherit", "closed", "closed", "", "98-revision-v1", "", "", "2022-02-14 19:53:17", "2022-02-14 16:23:17", "", "98", "https://themes.wpnovin.com/King/Main/?p=871", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("872", "1", "2022-02-14 19:53:39", "2022-02-14 16:23:39", "", "واکنش ها", "", "inherit", "closed", "closed", "", "469-revision-v1", "", "", "2022-02-14 19:53:39", "2022-02-14 16:23:39", "", "469", "https://themes.wpnovin.com/King/Main/?p=872", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("873", "1", "2022-02-14 19:53:59", "2022-02-14 16:23:59", "<p style=\"text-align: justify;\"><strong>لورم ایپسوم متن ساختگی</strong></p>\r\n<p style=\"text-align: justify;\">با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</p>\r\n<p style=\"text-align: justify;\"><strong>لورم ایپسوم متن ساختگی</strong></p>\r\n<p style=\"text-align: justify;\">با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</p>", "برگه نمونه", "", "inherit", "closed", "closed", "", "105-revision-v1", "", "", "2022-02-14 19:53:59", "2022-02-14 16:23:59", "", "105", "https://themes.wpnovin.com/King/Main/?p=873", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("874", "1", "2022-02-14 19:54:13", "2022-02-14 16:24:13", "", "ترند", "", "inherit", "closed", "closed", "", "25-revision-v1", "", "", "2022-02-14 19:54:13", "2022-02-14 16:24:13", "", "25", "https://themes.wpnovin.com/King/Main/?p=874", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("875", "1", "2022-02-14 19:54:19", "2022-02-14 16:24:19", "", "کاربران", "", "inherit", "closed", "closed", "", "28-revision-v1", "", "", "2022-02-14 19:54:19", "2022-02-14 16:24:19", "", "28", "https://themes.wpnovin.com/King/Main/?p=875", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("876", "1", "2022-02-14 19:54:27", "2022-02-14 16:24:27", "", "کاربران ورژن شماره دو", "", "inherit", "closed", "closed", "", "617-revision-v1", "", "", "2022-02-14 19:54:27", "2022-02-14 16:24:27", "", "617", "https://themes.wpnovin.com/King/Main/?p=876", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("877", "1", "2022-02-14 21:55:28", "2022-02-14 18:25:28", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "پلی لیست ویدیو", "", "inherit", "closed", "closed", "", "807-autosave-v1", "", "", "2022-02-14 21:55:28", "2022-02-14 18:25:28", "", "807", "https://themes.wpnovin.com/King/Main/?p=877", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("878", "1", "2022-02-14 22:01:01", "2022-02-14 18:31:01", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "پلی لیست موزیک", "", "inherit", "closed", "closed", "", "823-autosave-v1", "", "", "2022-02-14 22:01:01", "2022-02-14 18:31:01", "", "823", "https://themes.wpnovin.com/King/Main/?p=878", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("881", "1", "2022-02-14 21:55:36", "2022-02-14 18:25:36", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "Multiple images with lightbox gallery", "", "inherit", "closed", "closed", "", "734-autosave-v1", "", "", "2022-02-14 21:55:36", "2022-02-14 18:25:36", "", "734", "https://themes.wpnovin.com/King/Main/?p=881", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("882", "1", "2022-02-14 21:56:25", "2022-02-14 18:26:25", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "پلی لیست ویدیو", "", "inherit", "closed", "closed", "", "807-revision-v1", "", "", "2022-02-14 21:56:25", "2022-02-14 18:26:25", "", "807", "https://themes.wpnovin.com/King/Main/?p=882", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("883", "1", "2022-02-14 21:56:29", "2022-02-14 18:26:29", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "Music Playlist", "", "inherit", "closed", "closed", "", "823-revision-v1", "", "", "2022-02-14 21:56:29", "2022-02-14 18:26:29", "", "823", "https://themes.wpnovin.com/King/Main/?p=883", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("884", "1", "2022-02-14 21:56:31", "2022-02-14 18:26:31", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "Spotify Confidence Boost", "", "inherit", "closed", "closed", "", "801-revision-v1", "", "", "2022-02-14 21:56:31", "2022-02-14 18:26:31", "", "801", "https://themes.wpnovin.com/King/Main/?p=884", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("885", "1", "2022-02-14 21:56:33", "2022-02-14 18:26:33", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "6 Awe-inspiring natural wonders for your bucket list", "", "inherit", "closed", "closed", "", "775-revision-v1", "", "", "2022-02-14 21:56:33", "2022-02-14 18:26:33", "", "775", "https://themes.wpnovin.com/King/Main/?p=885", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("886", "1", "2022-02-14 21:56:49", "2022-02-14 18:26:49", "", "Alireza Talischi (2)", "", "inherit", "open", "closed", "", "alireza-talischi-2", "", "", "2022-02-14 21:56:49", "2022-02-14 18:26:49", "", "807", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2020/06/Alireza-Talischi-2.mp4", "0", "attachment", "video/mp4", "0");
INSERT INTO `wp_posts` VALUES("887", "1", "2022-02-14 21:56:59", "2022-02-14 18:26:59", "", "Alireza Talischi 2", "", "inherit", "open", "closed", "", "alireza-talischi-2-2", "", "", "2022-02-14 21:56:59", "2022-02-14 18:26:59", "", "807", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2020/06/Alireza-Talischi-2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("888", "1", "2022-02-14 21:57:20", "2022-02-14 18:27:20", "", "Alireza Talischi", "", "inherit", "open", "closed", "", "alireza-talischi", "", "", "2022-02-14 21:57:20", "2022-02-14 18:27:20", "", "807", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2020/06/Alireza-Talischi.mp4", "0", "attachment", "video/mp4", "0");
INSERT INTO `wp_posts` VALUES("889", "1", "2022-02-14 21:57:58", "2022-02-14 18:27:58", "", "Behnam Bani", "", "inherit", "open", "closed", "", "behnam-bani", "", "", "2022-02-14 21:57:58", "2022-02-14 18:27:58", "", "807", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2020/06/Behnam-Bani.mp4", "0", "attachment", "video/mp4", "0");
INSERT INTO `wp_posts` VALUES("890", "1", "2022-02-14 21:58:08", "2022-02-14 18:28:08", "", "Behnam-Bani-Dota-Dele-Ashegh", "", "inherit", "open", "closed", "", "behnam-bani-dota-dele-ashegh", "", "", "2022-02-14 21:58:08", "2022-02-14 18:28:08", "", "807", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2020/06/Behnam-Bani-Dota-Dele-Ashegh.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("891", "1", "2022-02-14 21:58:43", "2022-02-14 18:28:43", "", "Meysam Ebrahimi", "", "inherit", "open", "closed", "", "meysam-ebrahimi", "", "", "2022-02-14 21:58:43", "2022-02-14 18:28:43", "", "807", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2020/06/Meysam-Ebrahimi.mp4", "0", "attachment", "video/mp4", "0");
INSERT INTO `wp_posts` VALUES("892", "1", "2022-02-14 21:58:57", "2022-02-14 18:28:57", "", "Meysam-Ebrahimi-Halish-Nemishe", "", "inherit", "open", "closed", "", "meysam-ebrahimi-halish-nemishe", "", "", "2022-02-14 21:58:57", "2022-02-14 18:28:57", "", "807", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2020/06/Meysam-Ebrahimi-Halish-Nemishe.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("893", "1", "2022-02-14 21:59:31", "2022-02-14 18:29:31", "", "Majid Razavi", "", "inherit", "open", "closed", "", "majid-razavi", "", "", "2022-02-14 21:59:31", "2022-02-14 18:29:31", "", "807", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2020/06/Majid-Razavi.mp4", "0", "attachment", "video/mp4", "0");
INSERT INTO `wp_posts` VALUES("894", "1", "2022-02-14 21:59:41", "2022-02-14 18:29:41", "", "Majid-Razavi-Remix-5e-Sobh-Music-fa.com_", "", "inherit", "open", "closed", "", "majid-razavi-remix-5e-sobh-music-fa-com_", "", "", "2022-02-14 21:59:41", "2022-02-14 18:29:41", "", "807", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2020/06/Majid-Razavi-Remix-5e-Sobh-Music-fa.com_.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("895", "1", "2022-02-14 21:59:59", "2022-02-14 18:29:59", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "پلی لیست ویدیو", "", "inherit", "closed", "closed", "", "807-revision-v1", "", "", "2022-02-14 21:59:59", "2022-02-14 18:29:59", "", "807", "https://themes.wpnovin.com/King/Main/?p=895", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("896", "1", "2022-02-14 22:01:07", "2022-02-14 18:31:07", "\"Hiss ~ UpMusic\" از Hiss (Single) توسط Asef Aria  ~ UpMusic. منتشرشده: 2020. سبک: 2020.", "Hiss ~ UpMusic", "", "inherit", "open", "closed", "", "hiss-upmusic", "", "", "2022-02-14 22:01:09", "2022-02-14 18:31:09", "", "823", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2020/06/Asef-Aria-Hiss-320.mp3", "0", "attachment", "audio/mpeg", "0");
INSERT INTO `wp_posts` VALUES("897", "1", "2022-02-14 22:01:07", "2022-02-14 18:31:07", "", "", "", "inherit", "open", "closed", "", "897", "", "", "2022-02-14 22:01:07", "2022-02-14 18:31:07", "", "0", "https://themes.wpnovin.com/King/Main/897/", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("898", "1", "2022-02-14 22:01:35", "2022-02-14 18:31:35", "\"Zade Baroon~ UpMusic\" از Zade Baroon(Single) توسط Masoud Sadeghlo ~ UpMusic. منتشرشده: 2020. سبک: 2020.", "Zade Baroon~ UpMusic", "", "inherit", "open", "closed", "", "zade-baroon-upmusic", "", "", "2022-02-14 22:01:36", "2022-02-14 18:31:36", "", "823", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2020/06/Masoud-Sadeghlo-Zade-Baroon320.mp3", "0", "attachment", "audio/mpeg", "0");
INSERT INTO `wp_posts` VALUES("899", "1", "2022-02-14 22:01:35", "2022-02-14 18:31:35", "", "", "", "inherit", "open", "closed", "", "899", "", "", "2022-02-14 22:01:35", "2022-02-14 18:31:35", "", "0", "https://themes.wpnovin.com/King/Main/899/", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("900", "1", "2022-02-14 22:02:11", "2022-02-14 18:32:11", "", "Masoud-Sadeghloo-Zade-Baroon", "", "inherit", "open", "closed", "", "masoud-sadeghloo-zade-baroon", "", "", "2022-02-14 22:02:11", "2022-02-14 18:32:11", "", "823", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2020/06/Masoud-Sadeghloo-Zade-Baroon.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("901", "1", "2022-02-14 22:02:22", "2022-02-14 18:32:22", "", "Asef-Aria-Hiss-Remix", "", "inherit", "open", "closed", "", "asef-aria-hiss-remix", "", "", "2022-02-14 22:02:22", "2022-02-14 18:32:22", "", "823", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2020/06/Asef-Aria-Hiss-Remix.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("902", "1", "2022-02-14 22:02:36", "2022-02-14 18:32:36", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "پلی لیست موزیک", "", "inherit", "closed", "closed", "", "823-revision-v1", "", "", "2022-02-14 22:02:36", "2022-02-14 18:32:36", "", "823", "https://themes.wpnovin.com/King/Main/?p=902", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("903", "1", "2022-02-14 22:02:54", "2022-02-14 18:32:54", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "آلبوم اعتماد به نفس", "", "inherit", "closed", "closed", "", "801-revision-v1", "", "", "2022-02-14 22:02:54", "2022-02-14 18:32:54", "", "801", "https://themes.wpnovin.com/King/Main/?p=903", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("904", "1", "2022-02-14 22:03:34", "2022-02-14 18:33:34", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "شش شگفتی ساز طبیعی برای لیست شما", "", "inherit", "closed", "closed", "", "775-revision-v1", "", "", "2022-02-14 22:03:34", "2022-02-14 18:33:34", "", "775", "https://themes.wpnovin.com/King/Main/?p=904", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("905", "1", "2022-02-14 22:04:17", "2022-02-14 18:34:17", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "تصاویر متعدد با گالری لایت باکس", "", "inherit", "closed", "closed", "", "734-revision-v1", "", "", "2022-02-14 22:04:17", "2022-02-14 18:34:17", "", "734", "https://themes.wpnovin.com/King/Main/?p=905", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("906", "1", "2022-02-14 22:05:31", "2022-02-14 18:35:31", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "انیمیشن جدید 2022", "", "inherit", "closed", "closed", "", "693-autosave-v1", "", "", "2022-02-14 22:05:31", "2022-02-14 18:35:31", "", "693", "https://themes.wpnovin.com/King/Main/?p=906", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("907", "1", "2022-02-14 22:05:32", "2022-02-14 18:35:32", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "Breaking Me", "", "inherit", "closed", "closed", "", "803-autosave-v1", "", "", "2022-02-14 22:05:32", "2022-02-14 18:35:32", "", "803", "https://themes.wpnovin.com/King/Main/?p=907", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("909", "1", "2022-02-14 22:05:35", "2022-02-14 18:35:35", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "A rather lovely thing", "", "inherit", "closed", "closed", "", "643-autosave-v1", "", "", "2022-02-14 22:05:35", "2022-02-14 18:35:35", "", "643", "https://themes.wpnovin.com/King/Main/?p=909", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("910", "1", "2022-02-14 22:05:40", "2022-02-14 18:35:40", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "Buy Funny Toy", "", "inherit", "closed", "closed", "", "485-autosave-v1", "", "", "2022-02-14 22:05:40", "2022-02-14 18:35:40", "", "485", "https://themes.wpnovin.com/King/Main/?p=910", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("911", "1", "2022-02-14 22:05:43", "2022-02-14 18:35:43", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "Simple news post", "", "inherit", "closed", "closed", "", "75-autosave-v1", "", "", "2022-02-14 22:05:43", "2022-02-14 18:35:43", "", "75", "https://themes.wpnovin.com/King/Main/?p=911", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("912", "1", "2022-02-14 22:05:45", "2022-02-14 18:35:45", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>\n<p style=\"text-align: justify;\"><em> </em></p>", "Mp3 music demo post - Barton Springs", "", "inherit", "closed", "closed", "", "418-autosave-v1", "", "", "2022-02-14 22:05:45", "2022-02-14 18:35:45", "", "418", "https://themes.wpnovin.com/King/Main/?p=912", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("913", "1", "2022-02-14 22:11:47", "2022-02-14 18:41:47", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "دموی ویدیو", "", "inherit", "closed", "closed", "", "445-autosave-v1", "", "", "2022-02-14 22:11:47", "2022-02-14 18:41:47", "", "445", "https://themes.wpnovin.com/King/Main/?p=913", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("914", "1", "2022-02-14 22:06:21", "2022-02-14 18:36:21", "", "Lost in Space _ Official Trailer _ Netflix", "", "inherit", "open", "closed", "", "lost-in-space-_-official-trailer-_-netflix", "", "", "2022-02-14 22:06:21", "2022-02-14 18:36:21", "", "693", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2020/05/Lost-in-Space-_-Official-Trailer-_-Netflix.mp4", "0", "attachment", "video/mp4", "0");
INSERT INTO `wp_posts` VALUES("915", "1", "2022-02-14 22:06:21", "2022-02-14 18:36:21", "", "", "", "inherit", "open", "closed", "", "915", "", "", "2022-02-14 22:06:21", "2022-02-14 18:36:21", "", "0", "https://themes.wpnovin.com/King/Main/915/", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("916", "1", "2022-02-14 22:06:34", "2022-02-14 18:36:34", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "انیمیشن جدید 2022", "", "inherit", "closed", "closed", "", "693-revision-v1", "", "", "2022-02-14 22:06:34", "2022-02-14 18:36:34", "", "693", "https://themes.wpnovin.com/King/Main/?p=916", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("917", "1", "2022-02-14 22:06:55", "2022-02-14 18:36:55", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "موزیک شکستن قلب من", "", "inherit", "closed", "closed", "", "803-revision-v1", "", "", "2022-02-14 22:06:55", "2022-02-14 18:36:55", "", "803", "https://themes.wpnovin.com/King/Main/?p=917", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("918", "1", "2022-02-14 22:07:28", "2022-02-14 18:37:28", "", "The Dark Crystal - Age of Resistance _ Trailer _ Netflix", "", "inherit", "open", "closed", "", "the-dark-crystal-age-of-resistance-_-trailer-_-netflix", "", "", "2022-02-14 22:07:28", "2022-02-14 18:37:28", "", "70", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2017/05/The-Dark-Crystal-Age-of-Resistance-_-Trailer-_-Netflix.mp4", "0", "attachment", "video/mp4", "0");
INSERT INTO `wp_posts` VALUES("919", "1", "2022-02-14 22:07:28", "2022-02-14 18:37:28", "", "", "", "inherit", "open", "closed", "", "919", "", "", "2022-02-14 22:07:28", "2022-02-14 18:37:28", "", "0", "https://themes.wpnovin.com/King/Main/919/", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("920", "1", "2022-02-14 22:08:25", "2022-02-14 18:38:25", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "انیمیشن کریستال تاریک", "", "inherit", "closed", "closed", "", "70-revision-v1", "", "", "2022-02-14 22:08:25", "2022-02-14 18:38:25", "", "70", "https://themes.wpnovin.com/King/Main/?p=920", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("921", "1", "2022-02-14 22:09:16", "2022-02-14 18:39:16", "", "Stranger Things _ Official Final Trailer _ Netflix", "", "inherit", "open", "closed", "", "stranger-things-_-official-final-trailer-_-netflix", "", "", "2022-02-14 22:09:16", "2022-02-14 18:39:16", "", "643", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2017/05/Stranger-Things-_-Official-Final-Trailer-_-Netflix.mp4", "0", "attachment", "video/mp4", "0");
INSERT INTO `wp_posts` VALUES("922", "1", "2022-02-14 22:09:16", "2022-02-14 18:39:16", "", "", "", "inherit", "open", "closed", "", "922", "", "", "2022-02-14 22:09:16", "2022-02-14 18:39:16", "", "0", "https://themes.wpnovin.com/King/Main/922/", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("923", "1", "2022-02-14 22:09:29", "2022-02-14 18:39:29", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "اتفاقات عاشقانه ای که افتاد", "", "inherit", "closed", "closed", "", "643-revision-v1", "", "", "2022-02-14 22:09:29", "2022-02-14 18:39:29", "", "643", "https://themes.wpnovin.com/King/Main/?p=923", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("924", "1", "2022-02-14 22:10:34", "2022-02-14 18:40:34", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "خرید عروسک دلقک", "", "inherit", "closed", "closed", "", "485-revision-v1", "", "", "2022-02-14 22:10:34", "2022-02-14 18:40:34", "", "485", "https://themes.wpnovin.com/King/Main/?p=924", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("925", "1", "2022-02-14 22:11:09", "2022-02-14 18:41:09", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "پست جدید ساده", "", "inherit", "closed", "closed", "", "75-revision-v1", "", "", "2022-02-14 22:11:09", "2022-02-14 18:41:09", "", "75", "https://themes.wpnovin.com/King/Main/?p=925", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("926", "1", "2022-02-14 22:11:36", "2022-02-14 18:41:36", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>\r\n<p style=\"text-align: justify;\"><em> </em></p>", "پست دموی موزیک - بارتون اسپرینگ", "", "inherit", "closed", "closed", "", "418-revision-v1", "", "", "2022-02-14 22:11:36", "2022-02-14 18:41:36", "", "418", "https://themes.wpnovin.com/King/Main/?p=926", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("927", "1", "2022-02-14 22:11:57", "2022-02-14 18:41:57", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "دموی ویدیویی انیمیشن", "", "inherit", "closed", "closed", "", "445-revision-v1", "", "", "2022-02-14 22:11:57", "2022-02-14 18:41:57", "", "445", "https://themes.wpnovin.com/King/Main/?p=927", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("928", "1", "2022-02-14 22:15:15", "2022-02-14 18:45:15", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "انیمیشن آلما", "", "inherit", "closed", "closed", "", "88-autosave-v1", "", "", "2022-02-14 22:15:15", "2022-02-14 18:45:15", "", "88", "https://themes.wpnovin.com/King/Main/?p=928", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("929", "1", "2022-02-14 22:15:17", "2022-02-14 18:45:17", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "موزیک ویدیوی دنیای تاریک", "", "inherit", "closed", "closed", "", "82-autosave-v1", "", "", "2022-02-14 22:15:17", "2022-02-14 18:45:17", "", "82", "https://themes.wpnovin.com/King/Main/?p=929", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("930", "1", "2022-02-14 22:16:20", "2022-02-14 18:46:20", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "تریلر فیلم سینمایی وضعیت قرمز", "", "inherit", "closed", "closed", "", "68-autosave-v1", "", "", "2022-02-14 22:16:20", "2022-02-14 18:46:20", "", "68", "https://themes.wpnovin.com/King/Main/?p=930", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("931", "1", "2022-02-14 22:15:45", "2022-02-14 18:45:45", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "پست تصویری تکی", "", "inherit", "closed", "closed", "", "74-autosave-v1", "", "", "2022-02-14 22:15:45", "2022-02-14 18:45:45", "", "74", "https://themes.wpnovin.com/King/Main/?p=931", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("933", "1", "2022-02-14 22:13:24", "2022-02-14 18:43:24", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "5 Dating Tips People Wish They Knew In Their Twenties", "", "inherit", "closed", "closed", "", "57-autosave-v1", "", "", "2022-02-14 22:13:24", "2022-02-14 18:43:24", "", "57", "https://themes.wpnovin.com/King/Main/?p=933", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("934", "1", "2022-02-14 22:19:26", "2022-02-14 18:49:26", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "من هستم یک...", "", "inherit", "closed", "closed", "", "48-autosave-v1", "", "", "2022-02-14 22:19:26", "2022-02-14 18:49:26", "", "48", "https://themes.wpnovin.com/King/Main/?p=934", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("935", "1", "2022-02-14 22:15:23", "2022-02-14 18:45:23", "", "Beauty shop 16", "", "inherit", "open", "closed", "", "beauty-shop-16", "", "", "2022-02-14 22:15:55", "2022-02-14 18:45:55", "", "74", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2017/01/Beauty-shop-16.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("936", "1", "2022-02-14 22:15:27", "2022-02-14 18:45:27", "", "Beauty shop 17", "", "inherit", "open", "closed", "", "beauty-shop-17", "", "", "2022-02-14 22:15:27", "2022-02-14 18:45:27", "", "74", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2017/01/Beauty-shop-17.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("937", "1", "2022-02-14 22:15:33", "2022-02-14 18:45:33", "", "Beauty shop 18", "", "inherit", "open", "closed", "", "beauty-shop-18", "", "", "2022-02-14 22:15:33", "2022-02-14 18:45:33", "", "74", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2017/01/Beauty-shop-18.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("938", "1", "2022-02-14 22:15:39", "2022-02-14 18:45:39", "", "Beauty shop 19", "", "inherit", "open", "closed", "", "beauty-shop-19", "", "", "2022-02-14 22:15:39", "2022-02-14 18:45:39", "", "74", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2017/01/Beauty-shop-19.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("939", "1", "2022-02-14 22:15:39", "2022-02-14 18:45:39", "", "Turning Red", "", "inherit", "open", "closed", "", "turning-red", "", "", "2022-02-14 22:15:39", "2022-02-14 18:45:39", "", "88", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2017/01/Turning-Red.mp4", "0", "attachment", "video/mp4", "0");
INSERT INTO `wp_posts` VALUES("940", "1", "2022-02-14 22:15:42", "2022-02-14 18:45:42", "", "Beauty shop 32", "", "inherit", "open", "closed", "", "beauty-shop-32", "", "", "2022-02-14 22:15:42", "2022-02-14 18:45:42", "", "74", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2017/01/Beauty-shop-32.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("941", "1", "2022-02-14 22:15:51", "2022-02-14 18:45:51", "<div id=\"text\" style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "انیمیشن آلما", "", "inherit", "closed", "closed", "", "88-revision-v1", "", "", "2022-02-14 22:15:51", "2022-02-14 18:45:51", "", "88", "https://themes.wpnovin.com/King/Main/?p=941", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("942", "1", "2022-02-14 22:16:01", "2022-02-14 18:46:01", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "پست تصویری تکی", "", "inherit", "closed", "closed", "", "74-revision-v1", "", "", "2022-02-14 22:16:01", "2022-02-14 18:46:01", "", "74", "https://themes.wpnovin.com/King/Main/?p=942", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("943", "1", "2022-02-14 22:16:31", "2022-02-14 18:46:31", "", "Lost in Space _ Official Trailer _ Netflix", "", "inherit", "open", "closed", "", "lost-in-space-_-official-trailer-_-netflix-2", "", "", "2022-02-14 22:16:31", "2022-02-14 18:46:31", "", "82", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2017/01/Lost-in-Space-_-Official-Trailer-_-Netflix.mp4", "0", "attachment", "video/mp4", "0");
INSERT INTO `wp_posts` VALUES("944", "1", "2022-02-14 22:17:04", "2022-02-14 18:47:04", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "موزیک ویدیوی دنیای تاریک", "", "inherit", "closed", "closed", "", "82-revision-v1", "", "", "2022-02-14 22:17:04", "2022-02-14 18:47:04", "", "82", "https://themes.wpnovin.com/King/Main/?p=944", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("945", "1", "2022-02-14 22:17:30", "2022-02-14 18:47:30", "", "Vaziat Ghermez", "", "inherit", "open", "closed", "", "vaziat-ghermez", "", "", "2022-02-14 22:17:30", "2022-02-14 18:47:30", "", "68", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2017/01/Vaziat-Ghermez.mp4", "0", "attachment", "video/mp4", "0");
INSERT INTO `wp_posts` VALUES("946", "1", "2022-02-14 22:17:39", "2022-02-14 18:47:39", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "5 نکته در مورد دوست یابی که کاش مردم در بیست سالگی می دانستند", "", "inherit", "closed", "closed", "", "57-revision-v1", "", "", "2022-02-14 22:17:39", "2022-02-14 18:47:39", "", "57", "https://themes.wpnovin.com/King/Main/?p=946", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("947", "1", "2022-02-14 22:18:06", "2022-02-14 18:48:06", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "موزیک نووا آمور با نام از جنس طلا", "", "inherit", "closed", "closed", "", "50-revision-v1", "", "", "2022-02-14 22:18:06", "2022-02-14 18:48:06", "", "50", "https://themes.wpnovin.com/King/Main/?p=947", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("948", "1", "2022-02-14 22:18:22", "2022-02-14 18:48:22", "", "Vaziat Ghermez", "", "inherit", "open", "closed", "", "vaziat-ghermez-2", "", "", "2022-02-14 22:18:22", "2022-02-14 18:48:22", "", "68", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2017/01/Vaziat-Ghermez.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("949", "1", "2022-02-14 22:18:33", "2022-02-14 18:48:33", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "تریلر فیلم سینمایی وضعیت قرمز", "", "inherit", "closed", "closed", "", "68-revision-v1", "", "", "2022-02-14 22:18:33", "2022-02-14 18:48:33", "", "68", "https://themes.wpnovin.com/King/Main/?p=949", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("950", "1", "2022-02-14 22:19:15", "2022-02-14 18:49:15", "", "Joker", "", "inherit", "open", "closed", "", "joker", "", "", "2022-02-14 22:19:15", "2022-02-14 18:49:15", "", "48", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2017/01/Joker.mp4", "0", "attachment", "video/mp4", "0");
INSERT INTO `wp_posts` VALUES("951", "1", "2022-02-14 22:19:27", "2022-02-14 18:49:27", "", "Joker", "", "inherit", "open", "closed", "", "joker-2", "", "", "2022-02-14 22:19:27", "2022-02-14 18:49:27", "", "48", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2017/01/Joker.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("952", "1", "2022-02-14 22:19:42", "2022-02-14 18:49:42", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "من هستم یک...", "", "inherit", "closed", "closed", "", "48-revision-v1", "", "", "2022-02-14 22:19:42", "2022-02-14 18:49:42", "", "48", "https://themes.wpnovin.com/King/Main/?p=952", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("953", "1", "2022-02-14 22:21:03", "2022-02-14 18:51:03", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "کوهستان کهکشان راه شیری", "", "inherit", "closed", "closed", "", "795-autosave-v1", "", "", "2022-02-14 22:21:03", "2022-02-14 18:51:03", "", "795", "https://themes.wpnovin.com/King/Main/?p=953", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("954", "1", "2022-02-14 22:23:06", "2022-02-14 18:53:06", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "ساوند کلاد - سینا درخشنده ای و", "", "inherit", "closed", "closed", "", "37-autosave-v1", "", "", "2022-02-14 22:23:06", "2022-02-14 18:53:06", "", "37", "https://themes.wpnovin.com/King/Main/?p=954", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("955", "1", "2022-02-14 22:24:07", "2022-02-14 18:54:07", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "تریلر فیلم سینمایی آرواره های کوسه", "", "inherit", "closed", "closed", "", "20-autosave-v1", "", "", "2022-02-14 22:24:07", "2022-02-14 18:54:07", "", "20", "https://themes.wpnovin.com/King/Main/?p=955", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("956", "1", "2022-02-14 22:21:18", "2022-02-14 18:51:18", "", "Moshaver Amlak 5", "", "inherit", "open", "closed", "", "moshaver-amlak-5", "", "", "2022-02-14 22:21:18", "2022-02-14 18:51:18", "", "795", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2017/01/Moshaver-Amlak-5.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("957", "1", "2022-02-14 22:21:20", "2022-02-14 18:51:20", "", "Moshaver Amlak 6", "", "inherit", "open", "closed", "", "moshaver-amlak-6", "", "", "2022-02-14 22:21:20", "2022-02-14 18:51:20", "", "795", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2017/01/Moshaver-Amlak-6.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("958", "1", "2022-02-14 22:21:21", "2022-02-14 18:51:21", "", "Moshaver Amlak 8", "", "inherit", "open", "closed", "", "moshaver-amlak-8", "", "", "2022-02-14 22:21:21", "2022-02-14 18:51:21", "", "795", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2017/01/Moshaver-Amlak-8.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("959", "1", "2022-02-14 22:21:24", "2022-02-14 18:51:24", "", "Moshaver Amlak carosel 2", "", "inherit", "open", "closed", "", "moshaver-amlak-carosel-2", "", "", "2022-02-14 22:21:24", "2022-02-14 18:51:24", "", "795", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2017/01/Moshaver-Amlak-carosel-2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("960", "1", "2022-02-14 22:21:32", "2022-02-14 18:51:32", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "کوهستان کهکشان راه شیری", "", "inherit", "closed", "closed", "", "795-revision-v1", "", "", "2022-02-14 22:21:32", "2022-02-14 18:51:32", "", "795", "https://themes.wpnovin.com/King/Main/?p=960", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("961", "1", "2022-02-14 22:21:55", "2022-02-14 18:51:55", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "گالری تصویر چند منظوره", "", "inherit", "closed", "closed", "", "44-revision-v1", "", "", "2022-02-14 22:21:55", "2022-02-14 18:51:55", "", "44", "https://themes.wpnovin.com/King/Main/?p=961", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("962", "1", "2022-02-14 22:22:54", "2022-02-14 18:52:54", "\"Engar Na Engar - [Nex1.ir]\" از Single Album توسط Sina Derakhshande. منتشرشده: 2020. سبک: 2020.", "Engar Na Engar - [Nex1.ir]", "", "inherit", "open", "closed", "", "engar-na-engar-nex1-ir", "", "", "2022-02-14 22:22:56", "2022-02-14 18:52:56", "", "37", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2017/01/Sina-Derakhshande_Engar-Na-Engar.mp3", "0", "attachment", "audio/mpeg", "0");
INSERT INTO `wp_posts` VALUES("963", "1", "2022-02-14 22:23:12", "2022-02-14 18:53:12", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "ساوند کلاد - سینا درخشنده ای وای به دلم", "", "inherit", "closed", "closed", "", "37-revision-v1", "", "", "2022-02-14 22:23:12", "2022-02-14 18:53:12", "", "37", "https://themes.wpnovin.com/King/Main/?p=963", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("964", "1", "2022-02-14 22:23:58", "2022-02-14 18:53:58", "", "Jaws Official Trailer #1 - Richard Dreyfuss, Steven Spielberg Movie (1975) HD", "", "inherit", "open", "closed", "", "jaws-official-trailer-1-richard-dreyfuss-steven-spielberg-movie-1975-hd", "", "", "2022-02-14 22:23:58", "2022-02-14 18:53:58", "", "20", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2017/01/Jaws-Official-Trailer-1-Richard-Dreyfuss-Steven-Spielberg-Movie-1975-HD.mp4", "0", "attachment", "video/mp4", "0");
INSERT INTO `wp_posts` VALUES("965", "1", "2022-02-14 22:23:58", "2022-02-14 18:53:58", "", "", "", "inherit", "open", "closed", "", "965", "", "", "2022-02-14 22:23:58", "2022-02-14 18:53:58", "", "0", "https://themes.wpnovin.com/King/Main/965/", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("966", "1", "2022-02-14 22:24:41", "2022-02-14 18:54:41", "", "Ejdehaye Chini", "", "inherit", "open", "closed", "", "ejdehaye-chini", "", "", "2022-02-14 22:24:41", "2022-02-14 18:54:41", "", "20", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2017/01/Ejdehaye-Chini.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("967", "1", "2022-02-14 22:24:55", "2022-02-14 18:54:55", "<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</div>", "تریلر فیلم سینمایی آرواره های کوسه", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2022-02-14 22:24:55", "2022-02-14 18:54:55", "", "20", "https://themes.wpnovin.com/King/Main/?p=967", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("968", "1", "2022-02-15 01:14:12", "2022-02-14 21:44:12", "", "وردپرس", "", "publish", "closed", "closed", "", "%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3", "", "", "2022-02-15 01:14:12", "2022-02-14 21:44:12", "", "0", "https://themes.wpnovin.com/King/Main/?post_type=stories&#038;p=968", "0", "stories", "", "0");
INSERT INTO `wp_posts` VALUES("969", "1", "2022-02-15 01:14:16", "2022-02-14 21:44:16", "", "قالب وردپرس", "", "publish", "closed", "closed", "", "%d9%82%d8%a7%d9%84%d8%a8-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3", "", "", "2022-02-15 01:14:16", "2022-02-14 21:44:16", "", "0", "https://themes.wpnovin.com/King/Main/?post_type=stories&#038;p=969", "0", "stories", "", "0");
INSERT INTO `wp_posts` VALUES("970", "1", "2022-02-15 01:14:20", "2022-02-14 21:44:20", "", "قالب کینگ", "", "publish", "closed", "closed", "", "%d9%82%d8%a7%d9%84%d8%a8-%da%a9%db%8c%d9%86%da%af", "", "", "2022-02-15 01:14:20", "2022-02-14 21:44:20", "", "0", "https://themes.wpnovin.com/King/Main/?post_type=stories&#038;p=970", "0", "stories", "", "0");
INSERT INTO `wp_posts` VALUES("971", "1", "2022-02-15 01:14:23", "2022-02-14 21:44:23", "", "پادشاه وردپرس", "", "publish", "closed", "closed", "", "%d9%be%d8%a7%d8%af%d8%b4%d8%a7%d9%87-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3", "", "", "2022-02-15 01:14:23", "2022-02-14 21:44:23", "", "0", "https://themes.wpnovin.com/King/Main/?post_type=stories&#038;p=971", "0", "stories", "", "0");
INSERT INTO `wp_posts` VALUES("972", "1", "2022-02-15 01:14:27", "2022-02-14 21:44:27", "", "بسته نصبی", "", "publish", "closed", "closed", "", "%d8%a8%d8%b3%d8%aa%d9%87-%d9%86%d8%b5%d8%a8%db%8c", "", "", "2022-02-15 01:14:27", "2022-02-14 21:44:27", "", "0", "https://themes.wpnovin.com/King/Main/?post_type=stories&#038;p=972", "0", "stories", "", "0");
INSERT INTO `wp_posts` VALUES("973", "1", "2022-02-15 01:14:30", "2022-02-14 21:44:30", "", "نوین وردپرس", "", "publish", "closed", "closed", "", "%d9%86%d9%88%db%8c%d9%86-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3", "", "", "2022-02-15 01:14:30", "2022-02-14 21:44:30", "", "0", "https://themes.wpnovin.com/King/Main/?post_type=stories&#038;p=973", "0", "stories", "", "0");
INSERT INTO `wp_posts` VALUES("974", "1", "2022-02-15 01:14:34", "2022-02-14 21:44:34", "", "فارسی ساز", "", "publish", "closed", "closed", "", "%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d8%b3%d8%a7%d8%b2", "", "", "2022-02-15 01:14:34", "2022-02-14 21:44:34", "", "0", "https://themes.wpnovin.com/King/Main/?post_type=stories&#038;p=974", "0", "stories", "", "0");
INSERT INTO `wp_posts` VALUES("975", "1", "2022-02-15 01:14:46", "2022-02-14 21:44:46", "", "راست چین", "", "publish", "closed", "closed", "", "%d8%b1%d8%a7%d8%b3%d8%aa-%da%86%db%8c%d9%86", "", "", "2022-02-15 01:14:46", "2022-02-14 21:44:46", "", "0", "https://themes.wpnovin.com/King/Main/?post_type=stories&#038;p=975", "0", "stories", "", "0");
INSERT INTO `wp_posts` VALUES("976", "1", "2022-02-15 01:14:44", "2022-02-14 21:44:44", "", "فیلمیو", "", "publish", "closed", "closed", "", "%d9%81%db%8c%d9%84%d9%85%db%8c%d9%88", "", "", "2022-02-15 01:14:44", "2022-02-14 21:44:44", "", "0", "https://themes.wpnovin.com/King/Main/?post_type=stories&#038;p=976", "0", "stories", "", "0");
INSERT INTO `wp_posts` VALUES("977", "1", "2022-02-15 01:14:07", "2022-02-14 21:44:07", "", "", "", "publish", "closed", "closed", "", "977", "", "", "2022-02-15 01:14:07", "2022-02-14 21:44:07", "", "0", "https://themes.wpnovin.com/King/Main/?post_type=stories&#038;p=977", "0", "stories", "", "0");
INSERT INTO `wp_posts` VALUES("979", "1", "2022-02-15 01:57:45", "2022-02-14 22:27:45", ".owl-carousel .owl-stage-outer {\n    display: revert;\n    direction: ltr;\n    text-align: right;\n}\n.mfp-content {\n    text-align: center;\n}", "king", "", "inherit", "closed", "closed", "", "865-revision-v1", "", "", "2022-02-15 01:57:45", "2022-02-14 22:27:45", "", "865", "https://themes.wpnovin.com/King/Main/?p=979", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("981", "1", "2022-02-15 01:58:01", "2022-02-14 22:28:01", ".owl-carousel .owl-stage-outer {\n    display: revert;\n    direction: ltr;\n    text-align: right;\n}\n.mfp-content {\n    text-align: center;\n}\n.mfp-content .king-related .related-title {\n    text-align: center;\n}", "king", "", "inherit", "closed", "closed", "", "865-revision-v1", "", "", "2022-02-15 01:58:01", "2022-02-14 22:28:01", "", "865", "https://themes.wpnovin.com/King/Main/?p=981", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("983", "1", "2022-02-15 02:00:11", "2022-02-14 22:30:11", ".owl-carousel .owl-stage-outer {\n    display: revert;\n    direction: ltr;\n    text-align: right;\n}\n.mfp-content {\n    text-align: center;\n}\n.mfp-content .king-related .related-title {\n    text-align: center;\n}\n.login-rl a {\n    padding-left: 30px;\n}", "king", "", "inherit", "closed", "closed", "", "865-revision-v1", "", "", "2022-02-15 02:00:11", "2022-02-14 22:30:11", "", "865", "https://themes.wpnovin.com/King/Main/?p=983", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("984", "1", "2022-02-15 18:35:07", "2022-02-15 15:05:07", "{\"version\": 2, \"isGlobalStylesUserThemeJSON\": true }", "Custom Styles", "", "publish", "closed", "closed", "", "wp-global-styles-king", "", "", "2022-02-15 18:35:07", "2022-02-15 15:05:07", "", "0", "https://themes.wpnovin.com/King/Main/wp-global-styles-king/", "0", "wp_global_styles", "", "0");
INSERT INTO `wp_posts` VALUES("986", "1", "2022-02-16 02:03:21", "2022-02-15 22:33:21", ".owl-carousel .owl-stage-outer {\n    display: revert;\n    direction: ltr;\n    text-align: right;\n}\n.mfp-content {\n    text-align: center;\n}\n.mfp-content .king-related .related-title {\n    text-align: center;\n}\n.login-rl a {\n    padding-left: 30px;\n}\nmain#main .king-lists {\n    display: none !important;\n}", "king", "", "inherit", "closed", "closed", "", "865-revision-v1", "", "", "2022-02-16 02:03:21", "2022-02-15 22:33:21", "", "865", "https://themes.wpnovin.com/King/Main/?p=986", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("992", "2", "2023-07-02 11:10:19", "2023-07-02 07:40:19", "", "ب-کینگ-14.jpg", "", "inherit", "open", "closed", "", "%d8%a8-%da%a9%db%8c%d9%86%da%af-14-jpg", "", "", "2023-07-02 11:10:22", "2023-07-02 07:40:22", "", "0", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2023/07/ب-کینگ-14.jpg.webp", "0", "attachment", "image/webp", "0");
INSERT INTO `wp_posts` VALUES("993", "4", "2023-08-31 18:01:04", "2023-08-31 14:31:04", "", "1", "", "inherit", "open", "closed", "", "1-3", "", "", "2023-08-31 18:01:06", "2023-08-31 14:31:06", "", "0", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2023/08/1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("994", "4", "2023-08-31 18:01:31", "0000-00-00 00:00:00", "<p>تست</p>", "اپلیکیشن های جدید(تست)", "", "pending", "open", "open", "", "", "", "", "2023-08-31 18:01:31", "0000-00-00 00:00:00", "", "0", "https://themes.wpnovin.com/King/Main/?p=994", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("995", "4", "2023-08-31 18:03:35", "0000-00-00 00:00:00", "", "اپلیکیشن های جدید(تست)", "", "pending", "closed", "closed", "", "", "", "", "2023-08-31 18:03:35", "0000-00-00 00:00:00", "", "0", "https://themes.wpnovin.com/King/Main/?post_type=stories&p=995", "0", "stories", "", "0");
INSERT INTO `wp_posts` VALUES("997", "5", "2023-11-06 02:28:48", "2023-11-05 22:58:48", "", "mygila-tea", "", "inherit", "open", "closed", "", "mygila-tea", "", "", "2023-11-06 02:28:48", "2023-11-05 22:58:48", "", "0", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2023/11/mygila-tea.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("998", "5", "2023-11-06 02:30:17", "0000-00-00 00:00:00", "", "تست", "", "pending", "closed", "closed", "", "", "", "", "2023-11-06 02:30:17", "0000-00-00 00:00:00", "", "0", "https://themes.wpnovin.com/King/Main/?post_type=stories&p=998", "0", "stories", "", "0");
INSERT INTO `wp_posts` VALUES("999", "5", "2023-11-06 02:31:14", "0000-00-00 00:00:00", "", "تست", "", "pending", "closed", "closed", "", "", "", "", "2023-11-06 02:31:14", "0000-00-00 00:00:00", "", "0", "https://themes.wpnovin.com/King/Main/?post_type=stories&p=999", "0", "stories", "", "0");
INSERT INTO `wp_posts` VALUES("1000", "5", "2023-11-06 02:32:53", "0000-00-00 00:00:00", "", "تست", "", "pending", "closed", "closed", "", "", "", "", "2023-11-06 02:32:53", "0000-00-00 00:00:00", "", "0", "https://themes.wpnovin.com/King/Main/?post_type=stories&p=1000", "0", "stories", "", "0");
INSERT INTO `wp_posts` VALUES("1001", "5", "2023-11-08 18:32:40", "0000-00-00 00:00:00", "", "تست", "", "pending", "closed", "closed", "", "", "", "", "2023-11-08 18:32:40", "0000-00-00 00:00:00", "", "0", "https://themes.wpnovin.com/King/Main/?post_type=stories&p=1001", "0", "stories", "", "0");
INSERT INTO `wp_posts` VALUES("1002", "6", "2023-11-10 10:47:39", "2023-11-10 07:17:39", "{{unknown}}", "", "", "publish", "closed", "closed", "", "c3be5d74690760927ad36c4227beaf13", "", "", "2023-11-10 10:47:39", "2023-11-10 07:17:39", "", "0", "https://themes.wpnovin.com/King/Main/c3be5d74690760927ad36c4227beaf13/", "0", "oembed_cache", "", "0");
INSERT INTO `wp_posts` VALUES("1003", "6", "2023-11-10 10:47:59", "0000-00-00 00:00:00", "<p>ثثصثصثصث</p>", "sdsdsdsd", "", "pending", "open", "open", "", "", "", "", "2023-11-10 10:47:59", "0000-00-00 00:00:00", "", "0", "https://themes.wpnovin.com/King/Main/?p=1003", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("1004", "6", "2023-11-10 10:48:01", "2023-11-10 07:18:01", "", "1689660262-_DSC1842", "", "inherit", "open", "closed", "", "1689660262-_dsc1842", "", "", "2023-11-10 10:48:01", "2023-11-10 07:18:01", "", "1003", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2023/11/1689660262-_DSC1842.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("1005", "6", "2023-11-10 10:49:49", "2023-11-10 07:19:49", "{{unknown}}", "", "", "publish", "closed", "closed", "", "3fdbd1396497c5fae4c93c6b7b350b41", "", "", "2023-11-10 10:49:49", "2023-11-10 07:19:49", "", "0", "https://themes.wpnovin.com/King/Main/3fdbd1396497c5fae4c93c6b7b350b41/", "0", "oembed_cache", "", "0");
INSERT INTO `wp_posts` VALUES("1006", "6", "2023-11-10 10:50:43", "2023-11-10 07:20:43", "{{unknown}}", "", "", "publish", "closed", "closed", "", "fa82a8855bb7388963d6a29179ef98fa", "", "", "2023-11-10 10:50:43", "2023-11-10 07:20:43", "", "0", "https://themes.wpnovin.com/King/Main/fa82a8855bb7388963d6a29179ef98fa/", "0", "oembed_cache", "", "0");
INSERT INTO `wp_posts` VALUES("1007", "6", "2023-11-10 10:51:04", "0000-00-00 00:00:00", "<p>ewewewe</p>", "ewewwewew", "", "pending", "open", "open", "", "", "", "", "2023-11-10 10:51:04", "0000-00-00 00:00:00", "", "0", "https://themes.wpnovin.com/King/Main/?p=1007", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("1008", "8", "2023-12-25 15:59:19", "2023-12-25 12:29:19", "", "download (1)", "", "inherit", "open", "closed", "", "download-1", "", "", "2023-12-25 15:59:19", "2023-12-25 12:29:19", "", "0", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2023/12/download-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("1009", "8", "2023-12-25 15:59:29", "2023-12-25 12:29:29", "", "Israel_flag_fire", "", "inherit", "open", "closed", "", "israel_flag_fire", "", "", "2023-12-25 15:59:29", "2023-12-25 12:29:29", "", "0", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2023/12/Israel_flag_fire.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("1010", "8", "2023-12-25 16:01:22", "0000-00-00 00:00:00", "", "داستان 1", "", "pending", "closed", "closed", "", "", "", "", "2023-12-25 16:01:22", "0000-00-00 00:00:00", "", "0", "https://themes.wpnovin.com/King/Main/?post_type=stories&p=1010", "0", "stories", "", "0");
INSERT INTO `wp_posts` VALUES("1011", "10", "2024-03-13 09:45:36", "2024-03-13 06:15:36", "{{unknown}}", "", "", "publish", "closed", "closed", "", "4938d5900c6c952b77738825e09434ce", "", "", "2024-03-13 09:45:36", "2024-03-13 06:15:36", "", "0", "https://themes.wpnovin.com/King/Main/4938d5900c6c952b77738825e09434ce/", "0", "oembed_cache", "", "0");
INSERT INTO `wp_posts` VALUES("1012", "10", "2024-03-13 09:45:36", "2024-03-13 06:15:36", "", "crown-5-Top", "", "inherit", "open", "closed", "", "crown-5-top", "", "", "2024-03-13 09:45:36", "2024-03-13 06:15:36", "", "0", "https://themes.wpnovin.com/King/Main/wp-content/uploads/2024/03/crown-5-Top.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("1013", "11", "2024-03-28 18:59:48", "0000-00-00 00:00:00", "<table style=\"width: 610px;height: 102px\">\r\n<tbody>\r\n<tr>\r\n<td>&nbsp;</td>\r\n<td>&nbsp;</td>\r\n</tr>\r\n<tr>\r\n<td>&nbsp;</td>\r\n<td>&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<blockquote>\r\n<p>عععغبب</p>\r\n</blockquote>\r\n<p>اایاا</p>\r\n<blockquote>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>االالال</p>\r\n</blockquote>", "التااتاائ", "", "draft", "open", "open", "", "", "", "", "2024-03-28 18:59:48", "0000-00-00 00:00:00", "", "0", "https://themes.wpnovin.com/King/Main/?p=1013", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("1014", "8", "2024-04-01 09:41:21", "0000-00-00 00:00:00", "", "سلام", "", "pending", "closed", "closed", "", "", "", "", "2024-04-01 09:41:21", "0000-00-00 00:00:00", "", "0", "https://themes.wpnovin.com/King/Main/?post_type=stories&p=1014", "0", "stories", "", "0");
INSERT INTO `wp_posts` VALUES("1015", "1", "2024-09-26 13:47:05", "0000-00-00 00:00:00", "", "پیش‌نویس خودکار", "", "auto-draft", "open", "open", "", "", "", "", "2024-09-26 13:47:05", "0000-00-00 00:00:00", "", "0", "https://themes.wpnovin.com/King/Main/?p=1015", "0", "post", "", "0");

/* INSERT TABLE DATA: wp_term_relationships */
INSERT INTO `wp_term_relationships` VALUES("20", "3", "0");
INSERT INTO `wp_term_relationships` VALUES("20", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("20", "12", "0");
INSERT INTO `wp_term_relationships` VALUES("20", "15", "0");
INSERT INTO `wp_term_relationships` VALUES("20", "117", "0");
INSERT INTO `wp_term_relationships` VALUES("20", "123", "0");
INSERT INTO `wp_term_relationships` VALUES("20", "128", "0");
INSERT INTO `wp_term_relationships` VALUES("20", "144", "0");
INSERT INTO `wp_term_relationships` VALUES("37", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("37", "9", "0");
INSERT INTO `wp_term_relationships` VALUES("37", "23", "0");
INSERT INTO `wp_term_relationships` VALUES("37", "80", "0");
INSERT INTO `wp_term_relationships` VALUES("37", "106", "0");
INSERT INTO `wp_term_relationships` VALUES("37", "144", "0");
INSERT INTO `wp_term_relationships` VALUES("44", "3", "0");
INSERT INTO `wp_term_relationships` VALUES("44", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("44", "23", "0");
INSERT INTO `wp_term_relationships` VALUES("44", "55", "0");
INSERT INTO `wp_term_relationships` VALUES("44", "60", "0");
INSERT INTO `wp_term_relationships` VALUES("44", "139", "0");
INSERT INTO `wp_term_relationships` VALUES("48", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("48", "15", "0");
INSERT INTO `wp_term_relationships` VALUES("48", "123", "0");
INSERT INTO `wp_term_relationships` VALUES("48", "124", "0");
INSERT INTO `wp_term_relationships` VALUES("48", "144", "0");
INSERT INTO `wp_term_relationships` VALUES("50", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("50", "9", "0");
INSERT INTO `wp_term_relationships` VALUES("50", "62", "0");
INSERT INTO `wp_term_relationships` VALUES("50", "80", "0");
INSERT INTO `wp_term_relationships` VALUES("50", "106", "0");
INSERT INTO `wp_term_relationships` VALUES("50", "144", "0");
INSERT INTO `wp_term_relationships` VALUES("57", "7", "0");
INSERT INTO `wp_term_relationships` VALUES("57", "38", "0");
INSERT INTO `wp_term_relationships` VALUES("57", "67", "0");
INSERT INTO `wp_term_relationships` VALUES("57", "82", "0");
INSERT INTO `wp_term_relationships` VALUES("57", "116", "0");
INSERT INTO `wp_term_relationships` VALUES("57", "142", "0");
INSERT INTO `wp_term_relationships` VALUES("68", "3", "0");
INSERT INTO `wp_term_relationships` VALUES("68", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("68", "15", "0");
INSERT INTO `wp_term_relationships` VALUES("68", "18", "0");
INSERT INTO `wp_term_relationships` VALUES("68", "21", "0");
INSERT INTO `wp_term_relationships` VALUES("68", "123", "0");
INSERT INTO `wp_term_relationships` VALUES("68", "124", "0");
INSERT INTO `wp_term_relationships` VALUES("68", "144", "0");
INSERT INTO `wp_term_relationships` VALUES("70", "14", "0");
INSERT INTO `wp_term_relationships` VALUES("70", "21", "0");
INSERT INTO `wp_term_relationships` VALUES("70", "33", "0");
INSERT INTO `wp_term_relationships` VALUES("70", "123", "0");
INSERT INTO `wp_term_relationships` VALUES("70", "124", "0");
INSERT INTO `wp_term_relationships` VALUES("70", "144", "0");
INSERT INTO `wp_term_relationships` VALUES("74", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("74", "5", "0");
INSERT INTO `wp_term_relationships` VALUES("74", "10", "0");
INSERT INTO `wp_term_relationships` VALUES("74", "57", "0");
INSERT INTO `wp_term_relationships` VALUES("74", "60", "0");
INSERT INTO `wp_term_relationships` VALUES("74", "104", "0");
INSERT INTO `wp_term_relationships` VALUES("74", "125", "0");
INSERT INTO `wp_term_relationships` VALUES("74", "139", "0");
INSERT INTO `wp_term_relationships` VALUES("75", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("75", "12", "0");
INSERT INTO `wp_term_relationships` VALUES("75", "22", "0");
INSERT INTO `wp_term_relationships` VALUES("75", "82", "0");
INSERT INTO `wp_term_relationships` VALUES("75", "127", "0");
INSERT INTO `wp_term_relationships` VALUES("75", "142", "0");
INSERT INTO `wp_term_relationships` VALUES("82", "14", "0");
INSERT INTO `wp_term_relationships` VALUES("82", "80", "0");
INSERT INTO `wp_term_relationships` VALUES("82", "123", "0");
INSERT INTO `wp_term_relationships` VALUES("82", "128", "0");
INSERT INTO `wp_term_relationships` VALUES("82", "144", "0");
INSERT INTO `wp_term_relationships` VALUES("88", "15", "0");
INSERT INTO `wp_term_relationships` VALUES("88", "123", "0");
INSERT INTO `wp_term_relationships` VALUES("88", "124", "0");
INSERT INTO `wp_term_relationships` VALUES("88", "144", "0");
INSERT INTO `wp_term_relationships` VALUES("418", "9", "0");
INSERT INTO `wp_term_relationships` VALUES("418", "144", "0");
INSERT INTO `wp_term_relationships` VALUES("445", "14", "0");
INSERT INTO `wp_term_relationships` VALUES("445", "40", "0");
INSERT INTO `wp_term_relationships` VALUES("445", "76", "0");
INSERT INTO `wp_term_relationships` VALUES("445", "123", "0");
INSERT INTO `wp_term_relationships` VALUES("445", "144", "0");
INSERT INTO `wp_term_relationships` VALUES("485", "14", "0");
INSERT INTO `wp_term_relationships` VALUES("485", "140", "0");
INSERT INTO `wp_term_relationships` VALUES("541", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("621", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("622", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("623", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("624", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("625", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("626", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("627", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("628", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("629", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("630", "138", "0");
INSERT INTO `wp_term_relationships` VALUES("641", "138", "0");
INSERT INTO `wp_term_relationships` VALUES("643", "14", "0");
INSERT INTO `wp_term_relationships` VALUES("643", "23", "0");
INSERT INTO `wp_term_relationships` VALUES("643", "123", "0");
INSERT INTO `wp_term_relationships` VALUES("643", "124", "0");
INSERT INTO `wp_term_relationships` VALUES("643", "144", "0");
INSERT INTO `wp_term_relationships` VALUES("644", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("645", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("646", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("647", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("648", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("649", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("650", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("651", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("652", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("653", "138", "0");
INSERT INTO `wp_term_relationships` VALUES("663", "138", "0");
INSERT INTO `wp_term_relationships` VALUES("664", "138", "0");
INSERT INTO `wp_term_relationships` VALUES("665", "138", "0");
INSERT INTO `wp_term_relationships` VALUES("666", "138", "0");
INSERT INTO `wp_term_relationships` VALUES("668", "138", "0");
INSERT INTO `wp_term_relationships` VALUES("669", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("670", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("693", "14", "0");
INSERT INTO `wp_term_relationships` VALUES("693", "144", "0");
INSERT INTO `wp_term_relationships` VALUES("734", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("734", "3", "0");
INSERT INTO `wp_term_relationships` VALUES("734", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("734", "10", "0");
INSERT INTO `wp_term_relationships` VALUES("734", "54", "0");
INSERT INTO `wp_term_relationships` VALUES("734", "60", "0");
INSERT INTO `wp_term_relationships` VALUES("734", "66", "0");
INSERT INTO `wp_term_relationships` VALUES("734", "79", "0");
INSERT INTO `wp_term_relationships` VALUES("734", "139", "0");
INSERT INTO `wp_term_relationships` VALUES("762", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("763", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("764", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("765", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("766", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("773", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("774", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("775", "10", "0");
INSERT INTO `wp_term_relationships` VALUES("775", "81", "0");
INSERT INTO `wp_term_relationships` VALUES("775", "123", "0");
INSERT INTO `wp_term_relationships` VALUES("775", "142", "0");
INSERT INTO `wp_term_relationships` VALUES("779", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("780", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("783", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("786", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("789", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("790", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("791", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("794", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("795", "14", "0");
INSERT INTO `wp_term_relationships` VALUES("795", "139", "0");
INSERT INTO `wp_term_relationships` VALUES("799", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("801", "9", "0");
INSERT INTO `wp_term_relationships` VALUES("801", "80", "0");
INSERT INTO `wp_term_relationships` VALUES("801", "107", "0");
INSERT INTO `wp_term_relationships` VALUES("801", "143", "0");
INSERT INTO `wp_term_relationships` VALUES("803", "14", "0");
INSERT INTO `wp_term_relationships` VALUES("803", "80", "0");
INSERT INTO `wp_term_relationships` VALUES("803", "107", "0");
INSERT INTO `wp_term_relationships` VALUES("803", "143", "0");
INSERT INTO `wp_term_relationships` VALUES("807", "14", "0");
INSERT INTO `wp_term_relationships` VALUES("807", "144", "0");
INSERT INTO `wp_term_relationships` VALUES("823", "9", "0");
INSERT INTO `wp_term_relationships` VALUES("823", "75", "0");
INSERT INTO `wp_term_relationships` VALUES("823", "80", "0");
INSERT INTO `wp_term_relationships` VALUES("823", "89", "0");
INSERT INTO `wp_term_relationships` VALUES("823", "143", "0");
INSERT INTO `wp_term_relationships` VALUES("829", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("830", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("831", "141", "0");
INSERT INTO `wp_term_relationships` VALUES("855", "145", "0");
INSERT INTO `wp_term_relationships` VALUES("856", "145", "0");
INSERT INTO `wp_term_relationships` VALUES("857", "145", "0");
INSERT INTO `wp_term_relationships` VALUES("858", "145", "0");
INSERT INTO `wp_term_relationships` VALUES("859", "145", "0");
INSERT INTO `wp_term_relationships` VALUES("860", "145", "0");
INSERT INTO `wp_term_relationships` VALUES("984", "146", "0");
INSERT INTO `wp_term_relationships` VALUES("994", "12", "0");
INSERT INTO `wp_term_relationships` VALUES("994", "113", "0");
INSERT INTO `wp_term_relationships` VALUES("994", "139", "0");
INSERT INTO `wp_term_relationships` VALUES("994", "147", "0");
INSERT INTO `wp_term_relationships` VALUES("1003", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("1003", "3", "0");
INSERT INTO `wp_term_relationships` VALUES("1003", "6", "0");
INSERT INTO `wp_term_relationships` VALUES("1003", "11", "0");
INSERT INTO `wp_term_relationships` VALUES("1003", "13", "0");
INSERT INTO `wp_term_relationships` VALUES("1003", "144", "0");
INSERT INTO `wp_term_relationships` VALUES("1003", "148", "0");
INSERT INTO `wp_term_relationships` VALUES("1007", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("1007", "3", "0");
INSERT INTO `wp_term_relationships` VALUES("1007", "11", "0");
INSERT INTO `wp_term_relationships` VALUES("1007", "144", "0");
INSERT INTO `wp_term_relationships` VALUES("1013", "4", "0");
INSERT INTO `wp_term_relationships` VALUES("1013", "142", "0");

/* INSERT TABLE DATA: wp_term_taxonomy */
INSERT INTO `wp_term_taxonomy` VALUES("1", "1", "category", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("2", "2", "category", "", "0", "3");
INSERT INTO `wp_term_taxonomy` VALUES("3", "3", "category", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است ", "0", "4");
INSERT INTO `wp_term_taxonomy` VALUES("4", "4", "category", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("5", "5", "category", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("6", "6", "category", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("7", "7", "category", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("8", "8", "category", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است ", "0", "7");
INSERT INTO `wp_term_taxonomy` VALUES("9", "9", "category", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است ", "0", "5");
INSERT INTO `wp_term_taxonomy` VALUES("10", "10", "category", "", "0", "3");
INSERT INTO `wp_term_taxonomy` VALUES("11", "11", "category", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("12", "12", "category", "", "0", "2");
INSERT INTO `wp_term_taxonomy` VALUES("13", "13", "category", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("14", "14", "category", "", "0", "9");
INSERT INTO `wp_term_taxonomy` VALUES("15", "15", "category", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است ", "0", "4");
INSERT INTO `wp_term_taxonomy` VALUES("16", "16", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("18", "18", "post_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("19", "19", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("20", "20", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("21", "21", "post_tag", "", "0", "2");
INSERT INTO `wp_term_taxonomy` VALUES("22", "22", "post_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("23", "23", "post_tag", "", "0", "3");
INSERT INTO `wp_term_taxonomy` VALUES("33", "33", "post_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("34", "34", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("35", "35", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("38", "38", "post_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("40", "40", "post_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("44", "44", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("46", "46", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("47", "47", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("54", "54", "post_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("55", "55", "post_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("57", "57", "post_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("60", "60", "post_tag", "", "0", "3");
INSERT INTO `wp_term_taxonomy` VALUES("62", "62", "post_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("63", "63", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("64", "64", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("66", "66", "post_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("67", "67", "post_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("71", "71", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("72", "72", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("75", "75", "post_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("76", "76", "post_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("79", "79", "post_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("80", "80", "post_tag", "", "0", "6");
INSERT INTO `wp_term_taxonomy` VALUES("81", "81", "post_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("82", "82", "post_tag", "", "0", "2");
INSERT INTO `wp_term_taxonomy` VALUES("83", "83", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("84", "84", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("87", "87", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("89", "89", "post_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("90", "90", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("91", "91", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("92", "92", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("103", "103", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("104", "104", "post_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("105", "105", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("106", "106", "post_tag", "", "0", "2");
INSERT INTO `wp_term_taxonomy` VALUES("107", "107", "post_tag", "", "0", "2");
INSERT INTO `wp_term_taxonomy` VALUES("112", "112", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("113", "113", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("115", "115", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("116", "116", "post_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("117", "117", "post_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("118", "118", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("123", "123", "post_tag", "", "0", "9");
INSERT INTO `wp_term_taxonomy` VALUES("124", "124", "post_tag", "", "0", "5");
INSERT INTO `wp_term_taxonomy` VALUES("125", "125", "post_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("126", "126", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("127", "127", "post_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("128", "128", "post_tag", "", "0", "2");
INSERT INTO `wp_term_taxonomy` VALUES("136", "136", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("138", "138", "nav_menu", "", "0", "8");
INSERT INTO `wp_term_taxonomy` VALUES("139", "139", "post_format", "", "0", "4");
INSERT INTO `wp_term_taxonomy` VALUES("140", "140", "post_format", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("141", "141", "nav_menu", "", "0", "40");
INSERT INTO `wp_term_taxonomy` VALUES("142", "142", "post_format", "", "0", "3");
INSERT INTO `wp_term_taxonomy` VALUES("143", "143", "post_format", "", "0", "3");
INSERT INTO `wp_term_taxonomy` VALUES("144", "144", "post_format", "", "0", "13");
INSERT INTO `wp_term_taxonomy` VALUES("145", "145", "nav_menu", "", "0", "6");
INSERT INTO `wp_term_taxonomy` VALUES("146", "146", "wp_theme", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("147", "147", "post_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("148", "148", "post_tag", "", "0", "0");

/* INSERT TABLE DATA: wp_termmeta */
INSERT INTO `wp_termmeta` VALUES("1", "2", "category_colors", "#00b1d0");
INSERT INTO `wp_termmeta` VALUES("2", "2", "_category_colors", "field_5aaadfed91603");
INSERT INTO `wp_termmeta` VALUES("3", "2", "category_logo", "533");
INSERT INTO `wp_termmeta` VALUES("4", "2", "_category_logo", "field_5af35938f0413");
INSERT INTO `wp_termmeta` VALUES("5", "2", "category_background_image", "");
INSERT INTO `wp_termmeta` VALUES("6", "2", "_category_background_image", "field_5af35834f0412");
INSERT INTO `wp_termmeta` VALUES("7", "3", "category_colors", "#ffd13d");
INSERT INTO `wp_termmeta` VALUES("8", "3", "_category_colors", "field_5aaadfed91603");
INSERT INTO `wp_termmeta` VALUES("9", "3", "category_logo", "532");
INSERT INTO `wp_termmeta` VALUES("10", "3", "_category_logo", "field_5af35938f0413");
INSERT INTO `wp_termmeta` VALUES("11", "3", "category_background_image", "");
INSERT INTO `wp_termmeta` VALUES("12", "3", "_category_background_image", "field_5af35834f0412");
INSERT INTO `wp_termmeta` VALUES("13", "4", "category_colors", "#eb4620");
INSERT INTO `wp_termmeta` VALUES("14", "4", "_category_colors", "field_5aaadfed91603");
INSERT INTO `wp_termmeta` VALUES("15", "4", "category_logo", "538");
INSERT INTO `wp_termmeta` VALUES("16", "4", "_category_logo", "field_5af35938f0413");
INSERT INTO `wp_termmeta` VALUES("17", "4", "category_background_image", "");
INSERT INTO `wp_termmeta` VALUES("18", "4", "_category_background_image", "field_5af35834f0412");
INSERT INTO `wp_termmeta` VALUES("19", "5", "category_colors", "#1f1f21");
INSERT INTO `wp_termmeta` VALUES("20", "5", "_category_colors", "field_5aaadfed91603");
INSERT INTO `wp_termmeta` VALUES("21", "5", "category_logo", "534");
INSERT INTO `wp_termmeta` VALUES("22", "5", "_category_logo", "field_5af35938f0413");
INSERT INTO `wp_termmeta` VALUES("23", "5", "category_background_image", "");
INSERT INTO `wp_termmeta` VALUES("24", "5", "_category_background_image", "field_5af35834f0412");
INSERT INTO `wp_termmeta` VALUES("25", "6", "category_colors", "#fbdf03");
INSERT INTO `wp_termmeta` VALUES("26", "6", "_category_colors", "field_5aaadfed91603");
INSERT INTO `wp_termmeta` VALUES("27", "6", "category_logo", "526");
INSERT INTO `wp_termmeta` VALUES("28", "6", "_category_logo", "field_5af35938f0413");
INSERT INTO `wp_termmeta` VALUES("29", "6", "category_background_image", "");
INSERT INTO `wp_termmeta` VALUES("30", "6", "_category_background_image", "field_5af35834f0412");
INSERT INTO `wp_termmeta` VALUES("31", "7", "category_colors", "#6f8baa");
INSERT INTO `wp_termmeta` VALUES("32", "7", "_category_colors", "field_5aaadfed91603");
INSERT INTO `wp_termmeta` VALUES("33", "7", "category_logo", "536");
INSERT INTO `wp_termmeta` VALUES("34", "7", "_category_logo", "field_5af35938f0413");
INSERT INTO `wp_termmeta` VALUES("35", "7", "category_background_image", "");
INSERT INTO `wp_termmeta` VALUES("36", "7", "_category_background_image", "field_5af35834f0412");
INSERT INTO `wp_termmeta` VALUES("37", "8", "category_colors", "");
INSERT INTO `wp_termmeta` VALUES("38", "8", "_category_colors", "field_5aaadfed91603");
INSERT INTO `wp_termmeta` VALUES("39", "8", "category_logo", "535");
INSERT INTO `wp_termmeta` VALUES("40", "8", "_category_logo", "field_5af35938f0413");
INSERT INTO `wp_termmeta` VALUES("41", "8", "category_background_image", "528");
INSERT INTO `wp_termmeta` VALUES("42", "8", "_category_background_image", "field_5af35834f0412");
INSERT INTO `wp_termmeta` VALUES("43", "9", "category_colors", "#bde567");
INSERT INTO `wp_termmeta` VALUES("44", "9", "_category_colors", "field_5aaadfed91603");
INSERT INTO `wp_termmeta` VALUES("45", "9", "category_logo", "531");
INSERT INTO `wp_termmeta` VALUES("46", "9", "_category_logo", "field_5af35938f0413");
INSERT INTO `wp_termmeta` VALUES("47", "9", "category_background_image", "");
INSERT INTO `wp_termmeta` VALUES("48", "9", "_category_background_image", "field_5af35834f0412");
INSERT INTO `wp_termmeta` VALUES("49", "10", "category_colors", "#97d66b");
INSERT INTO `wp_termmeta` VALUES("50", "10", "_category_colors", "field_5aaadfed91603");
INSERT INTO `wp_termmeta` VALUES("51", "10", "category_logo", "537");
INSERT INTO `wp_termmeta` VALUES("52", "10", "_category_logo", "field_5af35938f0413");
INSERT INTO `wp_termmeta` VALUES("53", "10", "category_background_image", "");
INSERT INTO `wp_termmeta` VALUES("54", "10", "_category_background_image", "field_5af35834f0412");
INSERT INTO `wp_termmeta` VALUES("55", "11", "category_colors", "#044351");
INSERT INTO `wp_termmeta` VALUES("56", "11", "_category_colors", "field_5aaadfed91603");
INSERT INTO `wp_termmeta` VALUES("57", "11", "category_logo", "540");
INSERT INTO `wp_termmeta` VALUES("58", "11", "_category_logo", "field_5af35938f0413");
INSERT INTO `wp_termmeta` VALUES("59", "11", "category_background_image", "");
INSERT INTO `wp_termmeta` VALUES("60", "11", "_category_background_image", "field_5af35834f0412");
INSERT INTO `wp_termmeta` VALUES("61", "12", "category_colors", "#b079ea");
INSERT INTO `wp_termmeta` VALUES("62", "12", "_category_colors", "field_5aaadfed91603");
INSERT INTO `wp_termmeta` VALUES("63", "12", "category_logo", "527");
INSERT INTO `wp_termmeta` VALUES("64", "12", "_category_logo", "field_5af35938f0413");
INSERT INTO `wp_termmeta` VALUES("65", "12", "category_background_image", "");
INSERT INTO `wp_termmeta` VALUES("66", "12", "_category_background_image", "field_5af35834f0412");
INSERT INTO `wp_termmeta` VALUES("67", "13", "category_colors", "#73c2d6");
INSERT INTO `wp_termmeta` VALUES("68", "13", "_category_colors", "field_5aaadfed91603");
INSERT INTO `wp_termmeta` VALUES("69", "13", "category_logo", "542");
INSERT INTO `wp_termmeta` VALUES("70", "13", "_category_logo", "field_5af35938f0413");
INSERT INTO `wp_termmeta` VALUES("71", "13", "category_background_image", "");
INSERT INTO `wp_termmeta` VALUES("72", "13", "_category_background_image", "field_5af35834f0412");
INSERT INTO `wp_termmeta` VALUES("73", "14", "category_colors", "");
INSERT INTO `wp_termmeta` VALUES("74", "14", "_category_colors", "field_5aaadfed91603");
INSERT INTO `wp_termmeta` VALUES("75", "14", "category_logo", "");
INSERT INTO `wp_termmeta` VALUES("76", "14", "_category_logo", "field_5af35938f0413");
INSERT INTO `wp_termmeta` VALUES("77", "14", "category_background_image", "");
INSERT INTO `wp_termmeta` VALUES("78", "14", "_category_background_image", "field_5af35834f0412");
INSERT INTO `wp_termmeta` VALUES("79", "14", "category_for_news", "0");
INSERT INTO `wp_termmeta` VALUES("80", "14", "_category_for_news", "field_5ec929c889938");
INSERT INTO `wp_termmeta` VALUES("81", "14", "category_for_video", "0");
INSERT INTO `wp_termmeta` VALUES("82", "14", "_category_for_video", "field_5ec92a4a89939");
INSERT INTO `wp_termmeta` VALUES("83", "14", "category_for_image", "0");
INSERT INTO `wp_termmeta` VALUES("84", "14", "_category_for_image", "field_5ec92a5b8993a");
INSERT INTO `wp_termmeta` VALUES("85", "15", "category_colors", "#c8e690");
INSERT INTO `wp_termmeta` VALUES("86", "15", "_category_colors", "field_5aaadfed91603");
INSERT INTO `wp_termmeta` VALUES("87", "15", "category_logo", "530");
INSERT INTO `wp_termmeta` VALUES("88", "15", "_category_logo", "field_5af35938f0413");
INSERT INTO `wp_termmeta` VALUES("89", "15", "category_background_image", "");
INSERT INTO `wp_termmeta` VALUES("90", "15", "_category_background_image", "field_5af35834f0412");
INSERT INTO `wp_termmeta` VALUES("91", "8", "category_for", "");
INSERT INTO `wp_termmeta` VALUES("92", "8", "_category_for", "field_6096ce9cb70e1");
INSERT INTO `wp_termmeta` VALUES("93", "8", "category_for_free", "0");
INSERT INTO `wp_termmeta` VALUES("94", "8", "_category_for_free", "field_5fe71d5564615");
INSERT INTO `wp_termmeta` VALUES("95", "9", "category_for", "");
INSERT INTO `wp_termmeta` VALUES("96", "9", "_category_for", "field_6096ce9cb70e1");
INSERT INTO `wp_termmeta` VALUES("97", "9", "category_for_free", "0");
INSERT INTO `wp_termmeta` VALUES("98", "9", "_category_for_free", "field_5fe71d5564615");
INSERT INTO `wp_termmeta` VALUES("99", "15", "category_for", "");
INSERT INTO `wp_termmeta` VALUES("100", "15", "_category_for", "field_6096ce9cb70e1");
INSERT INTO `wp_termmeta` VALUES("101", "15", "category_for_free", "0");
INSERT INTO `wp_termmeta` VALUES("102", "15", "_category_for_free", "field_5fe71d5564615");
INSERT INTO `wp_termmeta` VALUES("103", "3", "category_for", "");
INSERT INTO `wp_termmeta` VALUES("104", "3", "_category_for", "field_6096ce9cb70e1");
INSERT INTO `wp_termmeta` VALUES("105", "3", "category_for_free", "0");
INSERT INTO `wp_termmeta` VALUES("106", "3", "_category_for_free", "field_5fe71d5564615");

/* INSERT TABLE DATA: wp_terms */
INSERT INTO `wp_terms` VALUES("1", "دسته‌بندی نشده", "%d8%af%d8%b3%d8%aa%d9%87%e2%80%8c%d8%a8%d9%86%d8%af%db%8c-%d9%86%d8%b4%d8%af%d9%87", "0");
INSERT INTO `wp_terms` VALUES("2", "هنر", "art", "0");
INSERT INTO `wp_terms` VALUES("3", "سرگرمی", "entertainment", "0");
INSERT INTO `wp_terms` VALUES("4", "غذا و نوشیدنی", "food-drink", "0");
INSERT INTO `wp_terms` VALUES("5", "بازی", "games", "0");
INSERT INTO `wp_terms` VALUES("6", "تاریخی", "history", "0");
INSERT INTO `wp_terms` VALUES("7", "چطور", "how-to", "0");
INSERT INTO `wp_terms` VALUES("8", "اینترنت", "internet", "0");
INSERT INTO `wp_terms` VALUES("9", "موزیک", "music", "0");
INSERT INTO `wp_terms` VALUES("10", "طبیعت", "nature", "0");
INSERT INTO `wp_terms` VALUES("11", "ورزش", "sports", "0");
INSERT INTO `wp_terms` VALUES("12", "تکنولوژی", "technology", "0");
INSERT INTO `wp_terms` VALUES("13", "سفر", "travel", "0");
INSERT INTO `wp_terms` VALUES("14", "دسته بندی نشده", "uncategorized", "0");
INSERT INTO `wp_terms` VALUES("15", "ویدیو", "video", "0");
INSERT INTO `wp_terms` VALUES("16", "بازی", "gaming", "0");
INSERT INTO `wp_terms` VALUES("18", "سه بعدی", "3d", "0");
INSERT INTO `wp_terms` VALUES("19", "آمازون", "amazon", "0");
INSERT INTO `wp_terms` VALUES("20", "پرندگان خشمگین", "angry-birds", "0");
INSERT INTO `wp_terms` VALUES("21", "انیمیشن", "animation", "0");
INSERT INTO `wp_terms` VALUES("22", "اپل", "apple", "0");
INSERT INTO `wp_terms` VALUES("23", "هنر", "art", "0");
INSERT INTO `wp_terms` VALUES("33", "ترسناک", "beer", "0");
INSERT INTO `wp_terms` VALUES("34", "چت", "chat", "0");
INSERT INTO `wp_terms` VALUES("35", "مستند", "commentary", "0");
INSERT INTO `wp_terms` VALUES("38", "تاریخ", "dating", "0");
INSERT INTO `wp_terms` VALUES("40", "دمو", "demo", "0");
INSERT INTO `wp_terms` VALUES("44", "تحصیلات", "education", "0");
INSERT INTO `wp_terms` VALUES("46", "فیسبوک", "facebook", "0");
INSERT INTO `wp_terms` VALUES("47", "فرهاد دریا", "farhad-darya", "0");
INSERT INTO `wp_terms` VALUES("54", "گالری", "gallery", "0");
INSERT INTO `wp_terms` VALUES("55", "گالری تصویر", "galley", "0");
INSERT INTO `wp_terms` VALUES("57", "اچ دی", "hd", "0");
INSERT INTO `wp_terms` VALUES("60", "تصویر", "image", "0");
INSERT INTO `wp_terms` VALUES("62", "اینترنت", "internet", "0");
INSERT INTO `wp_terms` VALUES("63", "جمشید هاشم پور", "jake-paul-2", "0");
INSERT INTO `wp_terms` VALUES("64", "جان ویک", "james-brown", "0");
INSERT INTO `wp_terms` VALUES("66", "لایت باکس", "lightbox", "0");
INSERT INTO `wp_terms` VALUES("67", "فهرست", "list", "0");
INSERT INTO `wp_terms` VALUES("71", "ماتریکس", "matrax", "0");
INSERT INTO `wp_terms` VALUES("72", "مه", "may", "0");
INSERT INTO `wp_terms` VALUES("75", "mp3", "mp3", "0");
INSERT INTO `wp_terms` VALUES("76", "mp4", "mp4", "0");
INSERT INTO `wp_terms` VALUES("79", "چند منظوره", "multiple", "0");
INSERT INTO `wp_terms` VALUES("80", "موزیک", "music", "0");
INSERT INTO `wp_terms` VALUES("81", "طبیعت", "nature", "0");
INSERT INTO `wp_terms` VALUES("82", "اخبار", "news", "0");
INSERT INTO `wp_terms` VALUES("83", "نیمار", "neymar", "0");
INSERT INTO `wp_terms` VALUES("84", "نوکیا", "nokia", "0");
INSERT INTO `wp_terms` VALUES("87", "خدای من", "omg", "0");
INSERT INTO `wp_terms` VALUES("89", "پلی لیست", "playlist", "0");
INSERT INTO `wp_terms` VALUES("90", "سیاسی", "politics", "0");
INSERT INTO `wp_terms` VALUES("91", "پست", "post", "0");
INSERT INTO `wp_terms` VALUES("92", "حرفه ای", "pro", "0");
INSERT INTO `wp_terms` VALUES("103", "سریال", "serie", "0");
INSERT INTO `wp_terms` VALUES("104", "تکی", "single", "0");
INSERT INTO `wp_terms` VALUES("105", "آهنگ", "sonegar", "0");
INSERT INTO `wp_terms` VALUES("106", "ساوند کلاد", "soundcloud", "0");
INSERT INTO `wp_terms` VALUES("107", "اسپورت", "spotify", "0");
INSERT INTO `wp_terms` VALUES("112", "برچسب", "tag", "0");
INSERT INTO `wp_terms` VALUES("113", "تست", "test", "0");
INSERT INTO `wp_terms` VALUES("115", "سریال 100", "the-100", "0");
INSERT INTO `wp_terms` VALUES("116", "نکته", "tips", "0");
INSERT INTO `wp_terms` VALUES("117", "تریلر", "trailer", "0");
INSERT INTO `wp_terms` VALUES("118", "ترکی", "turk", "0");
INSERT INTO `wp_terms` VALUES("123", "ویدیو", "video", "0");
INSERT INTO `wp_terms` VALUES("124", "ویمئو", "vimeo", "0");
INSERT INTO `wp_terms` VALUES("125", "کاغذ دیواری", "wallpaper", "0");
INSERT INTO `wp_terms` VALUES("126", "ویلیام گپیبسون", "william-gibson", "0");
INSERT INTO `wp_terms` VALUES("127", "کار", "workplace", "0");
INSERT INTO `wp_terms` VALUES("128", "یوتیوب", "youtube", "0");
INSERT INTO `wp_terms` VALUES("136", "قسمت آخر", "%d8%a7%d9%84%d8%ad%d9%84%d9%82%d8%a9-%d8%a7%d9%84%d8%a7%d8%ae%d9%8a%d8%b1%d8%a9", "0");
INSERT INTO `wp_terms` VALUES("138", "header", "header", "0");
INSERT INTO `wp_terms` VALUES("139", "Image", "post-format-image", "0");
INSERT INTO `wp_terms` VALUES("140", "Link", "post-format-link", "0");
INSERT INTO `wp_terms` VALUES("141", "Menu", "menu", "0");
INSERT INTO `wp_terms` VALUES("142", "News", "post-format-quote", "0");
INSERT INTO `wp_terms` VALUES("143", "Audio", "post-format-audio", "0");
INSERT INTO `wp_terms` VALUES("144", "Video", "post-format-video", "0");
INSERT INTO `wp_terms` VALUES("145", "Footer", "footer", "0");
INSERT INTO `wp_terms` VALUES("146", "king", "king", "0");
INSERT INTO `wp_terms` VALUES("147", "تست ها", "%d8%aa%d8%b3%d8%aa-%d9%87%d8%a7", "0");
INSERT INTO `wp_terms` VALUES("148", "صثصثص", "%d8%b5%d8%ab%d8%b5%d8%ab%d8%b5", "0");

/* INSERT TABLE DATA: wp_usermeta */
INSERT INTO `wp_usermeta` VALUES("1", "1", "nickname", "King");
INSERT INTO `wp_usermeta` VALUES("2", "1", "first_name", "");
INSERT INTO `wp_usermeta` VALUES("3", "1", "last_name", "");
INSERT INTO `wp_usermeta` VALUES("4", "1", "description", "نوین وردپرس تداعی خلاقیت و نوآوری در دنیای وردپرس فارسی است ، کیفیت محصولات ، پشتیبانی ویژه و منحصربه فرد از ویژگی های برجسته نوین وردپرس میباشد. تمامی محصولات تجاری مجموعه بصورت اورجینال از مراجع مربوطه خریداری شده و با بهترین کیفیت در اختیار شما عزیزان قرار میگیرد. نوین وردپرس از سال 1393 در پی کسب یک رضایت همگانی ایجاد شده است...");
INSERT INTO `wp_usermeta` VALUES("5", "1", "rich_editing", "true");
INSERT INTO `wp_usermeta` VALUES("6", "1", "syntax_highlighting", "true");
INSERT INTO `wp_usermeta` VALUES("7", "1", "comment_shortcuts", "false");
INSERT INTO `wp_usermeta` VALUES("8", "1", "admin_color", "fresh");
INSERT INTO `wp_usermeta` VALUES("9", "1", "use_ssl", "0");
INSERT INTO `wp_usermeta` VALUES("10", "1", "show_admin_bar_front", "true");
INSERT INTO `wp_usermeta` VALUES("11", "1", "locale", "");
INSERT INTO `wp_usermeta` VALUES("12", "1", "wp_capabilities", "a:1:{s:13:\"administrator\";b:1;}");
INSERT INTO `wp_usermeta` VALUES("13", "1", "wp_user_level", "10");
INSERT INTO `wp_usermeta` VALUES("14", "1", "dismissed_wp_pointers", "");
INSERT INTO `wp_usermeta` VALUES("15", "1", "show_welcome_panel", "0");
INSERT INTO `wp_usermeta` VALUES("17", "1", "wp_dashboard_quick_press_last_post_id", "1015");
INSERT INTO `wp_usermeta` VALUES("18", "1", "community-events-location", "a:1:{s:2:\"ip\";s:9:\"2.179.8.0\";}");
INSERT INTO `wp_usermeta` VALUES("19", "1", "wp_user-settings", "libraryContent=browse&ampeditor=tinymce&ampeditor_expand=on&ampposts_list_mode=list");
INSERT INTO `wp_usermeta` VALUES("20", "1", "wp_user-settings-time", "1645712605");
INSERT INTO `wp_usermeta` VALUES("21", "1", "nav_menu_recently_edited", "141");
INSERT INTO `wp_usermeta` VALUES("22", "1", "managenav-menuscolumnshidden", "a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}");
INSERT INTO `wp_usermeta` VALUES("23", "1", "metaboxhidden_nav-menus", "a:6:{i:0;s:18:\"add-post-type-list\";i:1;s:18:\"add-post-type-poll\";i:2;s:20:\"add-post-type-trivia\";i:3;s:21:\"add-post-type-stories\";i:4;s:12:\"add-post_tag\";i:5;s:15:\"add-post_format\";}");
INSERT INTO `wp_usermeta` VALUES("24", "1", "king_user_points", "10027");
INSERT INTO `wp_usermeta` VALUES("25", "1", "king_user_badges", "a:2:{i:0;s:32:\"حسابهای_دنبال_شده\";i:1;s:32:\"نشان_نویسنده_سطح_1\";}");
INSERT INTO `wp_usermeta` VALUES("26", "1", "session_tokens", "a:3:{s:64:\"fc7a7923bcfe6f2a48aad2c0d111e623e4b41940b4632a56ffecc66323efb8bd\";a:4:{s:10:\"expiration\";i:1728555416;s:2:\"ip\";s:14:\"151.234.65.246\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36\";s:5:\"login\";i:1727345816;}s:64:\"107ac1c447ed6d804ef70b13b0f6da6547ed2a1eeaf113ddcf0dae6578d989f2\";a:4:{s:10:\"expiration\";i:1727768978;s:2:\"ip\";s:11:\"2.179.8.217\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36\";s:5:\"login\";i:1727596178;}s:64:\"64c95b21512d6173409a6ff60ef9baeb00342eb09438c784050cd3f40a34ea51\";a:4:{s:10:\"expiration\";i:1728805778;s:2:\"ip\";s:11:\"2.179.8.217\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36\";s:5:\"login\";i:1727596178;}}");
INSERT INTO `wp_usermeta` VALUES("27", "1", "closedpostboxes_stories", "a:0:{}");
INSERT INTO `wp_usermeta` VALUES("28", "1", "metaboxhidden_stories", "a:1:{i:0;s:7:\"slugdiv\";}");
INSERT INTO `wp_usermeta` VALUES("29", "1", "author_image", "605");
INSERT INTO `wp_usermeta` VALUES("30", "1", "_author_image", "field_587be48552f9f");
INSERT INTO `wp_usermeta` VALUES("31", "1", "cover_image", "729");
INSERT INTO `wp_usermeta` VALUES("32", "1", "_cover_image", "field_587be575569ec");
INSERT INTO `wp_usermeta` VALUES("33", "1", "profile_facebook", "#");
INSERT INTO `wp_usermeta` VALUES("34", "1", "_profile_facebook", "field_587be5f411824");
INSERT INTO `wp_usermeta` VALUES("35", "1", "profile_twitter", "#");
INSERT INTO `wp_usermeta` VALUES("36", "1", "_profile_twitter", "field_587be62b11825");
INSERT INTO `wp_usermeta` VALUES("37", "1", "profile_linkedin", "#");
INSERT INTO `wp_usermeta` VALUES("38", "1", "_profile_linkedin", "field_587be65111826");
INSERT INTO `wp_usermeta` VALUES("39", "1", "profile_instagram", "#");
INSERT INTO `wp_usermeta` VALUES("40", "1", "_profile_instagram", "field_5b5f73a37030e");
INSERT INTO `wp_usermeta` VALUES("41", "1", "profile_pinterest", "#");
INSERT INTO `wp_usermeta` VALUES("42", "1", "_profile_pinterest", "field_5b5f73c17030f");
INSERT INTO `wp_usermeta` VALUES("43", "1", "profile_add_url", "");
INSERT INTO `wp_usermeta` VALUES("44", "1", "_profile_add_url", "field_5a132d05c424b");
INSERT INTO `wp_usermeta` VALUES("45", "1", "verified_account", "1");
INSERT INTO `wp_usermeta` VALUES("46", "1", "_verified_account", "field_587be6cb63209");
INSERT INTO `wp_usermeta` VALUES("47", "1", "bonus_points", "10000");
INSERT INTO `wp_usermeta` VALUES("48", "1", "_bonus_points", "field_59430297b0d37");
INSERT INTO `wp_usermeta` VALUES("49", "1", "closedpostboxes_dashboard", "a:0:{}");
INSERT INTO `wp_usermeta` VALUES("50", "1", "metaboxhidden_dashboard", "a:6:{i:0;s:21:\"dashboard_site_health\";i:1;s:19:\"dashboard_right_now\";i:2;s:18:\"dashboard_activity\";i:3;s:27:\"duplicator_dashboard_widget\";i:4;s:21:\"dashboard_quick_press\";i:5;s:17:\"dashboard_primary\";}");
INSERT INTO `wp_usermeta` VALUES("51", "1", "closedpostboxes_post", "a:0:{}");
INSERT INTO `wp_usermeta` VALUES("52", "1", "metaboxhidden_post", "a:1:{i:0;s:9:\"authordiv\";}");
INSERT INTO `wp_usermeta` VALUES("53", "1", "meta-box-order_post", "a:4:{s:15:\"acf_after_title\";s:0:\"\";s:4:\"side\";s:61:\"submitdiv,formatdiv,categorydiv,tagsdiv-post_tag,postimagediv\";s:6:\"normal\";s:125:\"acf-group_58bc8b2c6ed68,acf-group_5b5b94e54f971,revisionsdiv,trackbacksdiv,postexcerpt,commentstatusdiv,commentsdiv,authordiv\";s:8:\"advanced\";s:7:\"slugdiv\";}");
INSERT INTO `wp_usermeta` VALUES("54", "1", "screen_layout_post", "2");
INSERT INTO `wp_usermeta` VALUES("55", "1", "king_notify", "a:3:{s:4:\"type\";s:7:\"dislike\";s:6:\"postid\";s:3:\"775\";s:3:\"who\";i:1;}");
INSERT INTO `wp_usermeta` VALUES("56", "1", "king_notify_count", "7");
INSERT INTO `wp_usermeta` VALUES("57", "1", "king_notify", "a:3:{s:4:\"type\";s:4:\"like\";s:6:\"postid\";s:3:\"775\";s:3:\"who\";i:1;}");
INSERT INTO `wp_usermeta` VALUES("58", "1", "wp__user_follow_count", "0");
INSERT INTO `wp_usermeta` VALUES("59", "1", "duplicator_notice_bar_dismissed", "1");
INSERT INTO `wp_usermeta` VALUES("60", "2", "nickname", "sayedsalehbadri");
INSERT INTO `wp_usermeta` VALUES("61", "2", "first_name", "");
INSERT INTO `wp_usermeta` VALUES("62", "2", "last_name", "");
INSERT INTO `wp_usermeta` VALUES("63", "2", "description", "");
INSERT INTO `wp_usermeta` VALUES("64", "2", "rich_editing", "true");
INSERT INTO `wp_usermeta` VALUES("65", "2", "syntax_highlighting", "true");
INSERT INTO `wp_usermeta` VALUES("66", "2", "comment_shortcuts", "false");
INSERT INTO `wp_usermeta` VALUES("67", "2", "admin_color", "fresh");
INSERT INTO `wp_usermeta` VALUES("68", "2", "use_ssl", "0");
INSERT INTO `wp_usermeta` VALUES("69", "2", "show_admin_bar_front", "false");
INSERT INTO `wp_usermeta` VALUES("70", "2", "locale", "");
INSERT INTO `wp_usermeta` VALUES("71", "2", "wp_capabilities", "a:1:{s:6:\"author\";b:1;}");
INSERT INTO `wp_usermeta` VALUES("72", "2", "wp_user_level", "2");
INSERT INTO `wp_usermeta` VALUES("73", "2", "show_admin_bar_admin", "false");
INSERT INTO `wp_usermeta` VALUES("74", "2", "agree", "1");
INSERT INTO `wp_usermeta` VALUES("75", "2", "user_activation_key", "qYJ27ykvhYuUzow5SRNc");
INSERT INTO `wp_usermeta` VALUES("76", "2", "session_tokens", "a:1:{s:64:\"f53e6ec1d30a6e30b2c97401355790e369c53bc4bb12a50d3c1020591798f400\";a:4:{s:10:\"expiration\";i:1689493081;s:2:\"ip\";s:13:\"85.185.132.37\";s:2:\"ua\";s:124:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36 OPR/99.0.0.0\";s:5:\"login\";i:1688283481;}}");
INSERT INTO `wp_usermeta` VALUES("77", "2", "king_user_points", "0");
INSERT INTO `wp_usermeta` VALUES("78", "2", "king_user_badges", NULL);
INSERT INTO `wp_usermeta` VALUES("79", "3", "nickname", "ihhhsh809");
INSERT INTO `wp_usermeta` VALUES("80", "3", "first_name", "");
INSERT INTO `wp_usermeta` VALUES("81", "3", "last_name", "");
INSERT INTO `wp_usermeta` VALUES("82", "3", "description", "");
INSERT INTO `wp_usermeta` VALUES("83", "3", "rich_editing", "true");
INSERT INTO `wp_usermeta` VALUES("84", "3", "syntax_highlighting", "true");
INSERT INTO `wp_usermeta` VALUES("85", "3", "comment_shortcuts", "false");
INSERT INTO `wp_usermeta` VALUES("86", "3", "admin_color", "fresh");
INSERT INTO `wp_usermeta` VALUES("87", "3", "use_ssl", "0");
INSERT INTO `wp_usermeta` VALUES("88", "3", "show_admin_bar_front", "false");
INSERT INTO `wp_usermeta` VALUES("89", "3", "locale", "");
INSERT INTO `wp_usermeta` VALUES("90", "3", "wp_capabilities", "a:1:{s:6:\"author\";b:1;}");
INSERT INTO `wp_usermeta` VALUES("91", "3", "wp_user_level", "2");
INSERT INTO `wp_usermeta` VALUES("92", "3", "show_admin_bar_admin", "false");
INSERT INTO `wp_usermeta` VALUES("93", "3", "agree", "1");
INSERT INTO `wp_usermeta` VALUES("94", "3", "user_activation_key", "IJkYU326tYK1lBPd3kEZ");
INSERT INTO `wp_usermeta` VALUES("95", "3", "session_tokens", "a:1:{s:64:\"e260811b6089e9bd8d567cea15a491dc9854790e7d8388304b875c06c33f8bb0\";a:4:{s:10:\"expiration\";i:1693657332;s:2:\"ip\";s:13:\"2.147.153.182\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/116.0.0.0 Safari/537.36\";s:5:\"login\";i:1692447732;}}");
INSERT INTO `wp_usermeta` VALUES("96", "3", "king_user_points", "0");
INSERT INTO `wp_usermeta` VALUES("97", "3", "king_user_badges", NULL);
INSERT INTO `wp_usermeta` VALUES("98", "3", "wp__user_follow_count", "0");
INSERT INTO `wp_usermeta` VALUES("99", "4", "nickname", "hessam");
INSERT INTO `wp_usermeta` VALUES("100", "4", "first_name", "");
INSERT INTO `wp_usermeta` VALUES("101", "4", "last_name", "");
INSERT INTO `wp_usermeta` VALUES("102", "4", "description", "");
INSERT INTO `wp_usermeta` VALUES("103", "4", "rich_editing", "true");
INSERT INTO `wp_usermeta` VALUES("104", "4", "syntax_highlighting", "true");
INSERT INTO `wp_usermeta` VALUES("105", "4", "comment_shortcuts", "false");
INSERT INTO `wp_usermeta` VALUES("106", "4", "admin_color", "fresh");
INSERT INTO `wp_usermeta` VALUES("107", "4", "use_ssl", "0");
INSERT INTO `wp_usermeta` VALUES("108", "4", "show_admin_bar_front", "false");
INSERT INTO `wp_usermeta` VALUES("109", "4", "locale", "");
INSERT INTO `wp_usermeta` VALUES("110", "4", "wp_capabilities", "a:1:{s:6:\"author\";b:1;}");
INSERT INTO `wp_usermeta` VALUES("111", "4", "wp_user_level", "2");
INSERT INTO `wp_usermeta` VALUES("112", "4", "show_admin_bar_admin", "false");
INSERT INTO `wp_usermeta` VALUES("113", "4", "agree", "1");
INSERT INTO `wp_usermeta` VALUES("114", "4", "user_activation_key", "Zyp0GNyPbImiwhOeAv1Q");
INSERT INTO `wp_usermeta` VALUES("115", "4", "session_tokens", "a:1:{s:64:\"195d0d5bf96c7e88dd54722a008a8cf31fdc5b42235fbe78b2ae8cc6aa7bf702\";a:4:{s:10:\"expiration\";i:1693753221;s:2:\"ip\";s:13:\"159.146.28.56\";s:2:\"ua\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/115.0.0.0 Safari/537.36\";s:5:\"login\";i:1692543621;}}");
INSERT INTO `wp_usermeta` VALUES("116", "4", "wp__user_follow_count", "1");
INSERT INTO `wp_usermeta` VALUES("117", "1", "wp__user_followd", "a:3:{s:6:\"user-4\";i:4;s:6:\"user-5\";i:5;s:6:\"user-8\";i:8;}");
INSERT INTO `wp_usermeta` VALUES("118", "1", "king_notify", "a:3:{s:4:\"type\";s:6:\"follow\";s:6:\"postid\";s:1:\"1\";s:3:\"who\";i:4;}");
INSERT INTO `wp_usermeta` VALUES("119", "1", "wp__post_follow_count", "3");
INSERT INTO `wp_usermeta` VALUES("120", "1", "_post_follow_modified", "2024-04-01 06:20:20");
INSERT INTO `wp_usermeta` VALUES("121", "4", "king_user_points", "0");
INSERT INTO `wp_usermeta` VALUES("122", "4", "king_user_badges", NULL);
INSERT INTO `wp_usermeta` VALUES("123", "5", "nickname", "Tes688t");
INSERT INTO `wp_usermeta` VALUES("124", "5", "first_name", "");
INSERT INTO `wp_usermeta` VALUES("125", "5", "last_name", "");
INSERT INTO `wp_usermeta` VALUES("126", "5", "description", "");
INSERT INTO `wp_usermeta` VALUES("127", "5", "rich_editing", "true");
INSERT INTO `wp_usermeta` VALUES("128", "5", "syntax_highlighting", "true");
INSERT INTO `wp_usermeta` VALUES("129", "5", "comment_shortcuts", "false");
INSERT INTO `wp_usermeta` VALUES("130", "5", "admin_color", "fresh");
INSERT INTO `wp_usermeta` VALUES("131", "5", "use_ssl", "0");
INSERT INTO `wp_usermeta` VALUES("132", "5", "show_admin_bar_front", "false");
INSERT INTO `wp_usermeta` VALUES("133", "5", "locale", "");
INSERT INTO `wp_usermeta` VALUES("134", "5", "wp_capabilities", "a:1:{s:6:\"author\";b:1;}");
INSERT INTO `wp_usermeta` VALUES("135", "5", "wp_user_level", "2");
INSERT INTO `wp_usermeta` VALUES("136", "5", "show_admin_bar_admin", "false");
INSERT INTO `wp_usermeta` VALUES("137", "5", "agree", "1");
INSERT INTO `wp_usermeta` VALUES("138", "5", "user_activation_key", "PIKsaAuQA1Pp7vbz3lbL");
INSERT INTO `wp_usermeta` VALUES("139", "5", "session_tokens", "a:3:{s:64:\"62df746f6fb5fea90e3b87ab17f0311f093701ade30a0f9cdaa760a2129d2d22\";a:4:{s:10:\"expiration\";i:1700345242;s:2:\"ip\";s:14:\"151.246.218.93\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Mobile Safari/537.36\";s:5:\"login\";i:1699135642;}s:64:\"f91c5a7856e278de90abbeb12fb03db1f6aa4fa9cd97daf7dcf9d983cfced56f\";a:4:{s:10:\"expiration\";i:1699455015;s:2:\"ip\";s:14:\"151.246.219.59\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/118.0.0.0 Safari/537.36\";s:5:\"login\";i:1699282215;}s:64:\"537ad3d2b3597d46dcf7f286c17fa915d5ecc7439e1494822aa3db8956b24294\";a:4:{s:10:\"expiration\";i:1700491815;s:2:\"ip\";s:14:\"151.246.219.59\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/118.0.0.0 Safari/537.36\";s:5:\"login\";i:1699282215;}}");
INSERT INTO `wp_usermeta` VALUES("140", "1", "king_notify", "a:3:{s:4:\"type\";s:4:\"like\";s:6:\"postid\";s:2:\"48\";s:3:\"who\";i:5;}");
INSERT INTO `wp_usermeta` VALUES("141", "5", "king_readlater", "a:2:{i:0;s:2:\"48\";i:1;s:3:\"807\";}");
INSERT INTO `wp_usermeta` VALUES("142", "1", "king_notify", "a:3:{s:4:\"type\";s:4:\"like\";s:6:\"postid\";s:2:\"70\";s:3:\"who\";i:5;}");
INSERT INTO `wp_usermeta` VALUES("143", "5", "wp__user_follow_count", "1");
INSERT INTO `wp_usermeta` VALUES("144", "1", "king_notify", "a:3:{s:4:\"type\";s:6:\"follow\";s:6:\"postid\";s:1:\"1\";s:3:\"who\";i:5;}");
INSERT INTO `wp_usermeta` VALUES("145", "5", "king_user_reactions", "a:1:{i:807;s:3:\"wow\";}");
INSERT INTO `wp_usermeta` VALUES("146", "5", "king_user_points", "0");
INSERT INTO `wp_usermeta` VALUES("147", "6", "nickname", "aliali");
INSERT INTO `wp_usermeta` VALUES("148", "6", "first_name", "");
INSERT INTO `wp_usermeta` VALUES("149", "6", "last_name", "");
INSERT INTO `wp_usermeta` VALUES("150", "6", "description", "");
INSERT INTO `wp_usermeta` VALUES("151", "6", "rich_editing", "true");
INSERT INTO `wp_usermeta` VALUES("152", "6", "syntax_highlighting", "true");
INSERT INTO `wp_usermeta` VALUES("153", "6", "comment_shortcuts", "false");
INSERT INTO `wp_usermeta` VALUES("154", "6", "admin_color", "fresh");
INSERT INTO `wp_usermeta` VALUES("155", "6", "use_ssl", "0");
INSERT INTO `wp_usermeta` VALUES("156", "6", "show_admin_bar_front", "false");
INSERT INTO `wp_usermeta` VALUES("157", "6", "locale", "");
INSERT INTO `wp_usermeta` VALUES("158", "6", "wp_capabilities", "a:1:{s:6:\"author\";b:1;}");
INSERT INTO `wp_usermeta` VALUES("159", "6", "wp_user_level", "2");
INSERT INTO `wp_usermeta` VALUES("160", "6", "show_admin_bar_admin", "false");
INSERT INTO `wp_usermeta` VALUES("161", "6", "agree", "1");
INSERT INTO `wp_usermeta` VALUES("162", "6", "user_activation_key", "39Ds4NqrsO5ZFE1OOQeu");
INSERT INTO `wp_usermeta` VALUES("163", "6", "session_tokens", "a:1:{s:64:\"8502a12124d2d161002dc3e0eeb402f65e7c308fe6eac535be4c6fe1a29e4959\";a:4:{s:10:\"expiration\";i:1700810108;s:2:\"ip\";s:11:\"5.116.16.44\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36\";s:5:\"login\";i:1699600508;}}");
INSERT INTO `wp_usermeta` VALUES("164", "6", "king_user_points", "0");
INSERT INTO `wp_usermeta` VALUES("165", "6", "king_user_reactions", "a:1:{i:801;s:3:\"sad\";}");
INSERT INTO `wp_usermeta` VALUES("166", "7", "nickname", "amirfarhadian");
INSERT INTO `wp_usermeta` VALUES("167", "7", "first_name", "");
INSERT INTO `wp_usermeta` VALUES("168", "7", "last_name", "");
INSERT INTO `wp_usermeta` VALUES("169", "7", "description", "");
INSERT INTO `wp_usermeta` VALUES("170", "7", "rich_editing", "true");
INSERT INTO `wp_usermeta` VALUES("171", "7", "syntax_highlighting", "true");
INSERT INTO `wp_usermeta` VALUES("172", "7", "comment_shortcuts", "false");
INSERT INTO `wp_usermeta` VALUES("173", "7", "admin_color", "fresh");
INSERT INTO `wp_usermeta` VALUES("174", "7", "use_ssl", "0");
INSERT INTO `wp_usermeta` VALUES("175", "7", "show_admin_bar_front", "false");
INSERT INTO `wp_usermeta` VALUES("176", "7", "locale", "");
INSERT INTO `wp_usermeta` VALUES("177", "7", "wp_capabilities", "a:1:{s:6:\"author\";b:1;}");
INSERT INTO `wp_usermeta` VALUES("178", "7", "wp_user_level", "2");
INSERT INTO `wp_usermeta` VALUES("179", "7", "show_admin_bar_admin", "false");
INSERT INTO `wp_usermeta` VALUES("180", "7", "agree", "1");
INSERT INTO `wp_usermeta` VALUES("181", "7", "user_activation_key", "j4MOZ0cTAdPUGEuA02P7");
INSERT INTO `wp_usermeta` VALUES("182", "7", "session_tokens", "a:2:{s:64:\"8f1949c2081dc038ad0e73339f18a34b09e70a799c9b565f21bf4d57b4c21782\";a:4:{s:10:\"expiration\";i:1701256159;s:2:\"ip\";s:12:\"5.210.148.49\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36\";s:5:\"login\";i:1700046559;}s:64:\"d2892687286d4778421a6b1c975f481636c1afd98295856e777df98ef19d88a6\";a:4:{s:10:\"expiration\";i:1701275831;s:2:\"ip\";s:11:\"86.55.53.87\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36\";s:5:\"login\";i:1700066231;}}");
INSERT INTO `wp_usermeta` VALUES("183", "7", "king_user_points", "0");
INSERT INTO `wp_usermeta` VALUES("184", "7", "king_user_badges", NULL);
INSERT INTO `wp_usermeta` VALUES("185", "7", "_profile_facebook", "field_587be5f411824");
INSERT INTO `wp_usermeta` VALUES("186", "7", "profile_facebook", "");
INSERT INTO `wp_usermeta` VALUES("187", "7", "_profile_twitter", "field_587be62b11825");
INSERT INTO `wp_usermeta` VALUES("188", "7", "profile_twitter", "");
INSERT INTO `wp_usermeta` VALUES("189", "7", "_profile_pinterest", "field_5b5f73c17030f");
INSERT INTO `wp_usermeta` VALUES("190", "7", "profile_pinterest", "");
INSERT INTO `wp_usermeta` VALUES("191", "7", "_profile_instagram", "field_5b5f73a37030e");
INSERT INTO `wp_usermeta` VALUES("192", "7", "profile_instagram", "");
INSERT INTO `wp_usermeta` VALUES("193", "7", "_profile_linkedin", "field_587be65111826");
INSERT INTO `wp_usermeta` VALUES("194", "7", "profile_linkedin", "");
INSERT INTO `wp_usermeta` VALUES("195", "7", "_profile_add_url", "field_5a132d05c424b");
INSERT INTO `wp_usermeta` VALUES("196", "7", "profile_add_url", "");
INSERT INTO `wp_usermeta` VALUES("197", "7", "author_image", "");
INSERT INTO `wp_usermeta` VALUES("198", "7", "_author_image", "field_587be48552f9f");
INSERT INTO `wp_usermeta` VALUES("199", "7", "cover_image", "");
INSERT INTO `wp_usermeta` VALUES("200", "7", "_cover_image", "field_587be575569ec");
INSERT INTO `wp_usermeta` VALUES("201", "5", "king_user_badges", NULL);
INSERT INTO `wp_usermeta` VALUES("202", "6", "king_user_badges", NULL);
INSERT INTO `wp_usermeta` VALUES("203", "8", "nickname", "akbari963");
INSERT INTO `wp_usermeta` VALUES("204", "8", "first_name", "");
INSERT INTO `wp_usermeta` VALUES("205", "8", "last_name", "");
INSERT INTO `wp_usermeta` VALUES("206", "8", "description", "");
INSERT INTO `wp_usermeta` VALUES("207", "8", "rich_editing", "true");
INSERT INTO `wp_usermeta` VALUES("208", "8", "syntax_highlighting", "true");
INSERT INTO `wp_usermeta` VALUES("209", "8", "comment_shortcuts", "false");
INSERT INTO `wp_usermeta` VALUES("210", "8", "admin_color", "fresh");
INSERT INTO `wp_usermeta` VALUES("211", "8", "use_ssl", "0");
INSERT INTO `wp_usermeta` VALUES("212", "8", "show_admin_bar_front", "false");
INSERT INTO `wp_usermeta` VALUES("213", "8", "locale", "");
INSERT INTO `wp_usermeta` VALUES("214", "8", "wp_capabilities", "a:1:{s:6:\"author\";b:1;}");
INSERT INTO `wp_usermeta` VALUES("215", "8", "wp_user_level", "2");
INSERT INTO `wp_usermeta` VALUES("216", "8", "show_admin_bar_admin", "false");
INSERT INTO `wp_usermeta` VALUES("217", "8", "agree", "1");
INSERT INTO `wp_usermeta` VALUES("218", "8", "user_activation_key", "5PyjWKwn1diLfcgk1vqs");
INSERT INTO `wp_usermeta` VALUES("219", "8", "session_tokens", "a:4:{s:64:\"15fb5cb1ea3bac2a0c9546c966bef090212c21f5677cff75c15398a5c8306543\";a:4:{s:10:\"expiration\";i:1712124489;s:2:\"ip\";s:14:\"37.254.124.150\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/123.0.0.0 Safari/537.36\";s:5:\"login\";i:1711951689;}s:64:\"2d2bf3bb86ed04d1d43fd6925a5778cbfb22d099c895ad1e383ffc5b1f243703\";a:4:{s:10:\"expiration\";i:1713161289;s:2:\"ip\";s:14:\"37.254.124.150\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/123.0.0.0 Safari/537.36\";s:5:\"login\";i:1711951689;}s:64:\"c4d763b27c9cf706d68070c95997441b58ff6fbfe2ca8d17061ef0ef0c2b233a\";a:4:{s:10:\"expiration\";i:1712124580;s:2:\"ip\";s:14:\"37.254.124.150\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/122.0.0.0 Mobile Safari/537.36\";s:5:\"login\";i:1711951780;}s:64:\"4c7c41ab622ab285a9bddc51d14110d425299be9545e97683dadc29c3f9558a5\";a:4:{s:10:\"expiration\";i:1713161380;s:2:\"ip\";s:14:\"37.254.124.150\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/122.0.0.0 Mobile Safari/537.36\";s:5:\"login\";i:1711951780;}}");
INSERT INTO `wp_usermeta` VALUES("220", "9", "nickname", "dvsdgaef");
INSERT INTO `wp_usermeta` VALUES("221", "9", "first_name", "");
INSERT INTO `wp_usermeta` VALUES("222", "9", "last_name", "");
INSERT INTO `wp_usermeta` VALUES("223", "9", "description", "");
INSERT INTO `wp_usermeta` VALUES("224", "9", "rich_editing", "true");
INSERT INTO `wp_usermeta` VALUES("225", "9", "syntax_highlighting", "true");
INSERT INTO `wp_usermeta` VALUES("226", "9", "comment_shortcuts", "false");
INSERT INTO `wp_usermeta` VALUES("227", "9", "admin_color", "fresh");
INSERT INTO `wp_usermeta` VALUES("228", "9", "use_ssl", "0");
INSERT INTO `wp_usermeta` VALUES("229", "9", "show_admin_bar_front", "false");
INSERT INTO `wp_usermeta` VALUES("230", "9", "locale", "");
INSERT INTO `wp_usermeta` VALUES("231", "9", "wp_capabilities", "a:1:{s:6:\"author\";b:1;}");
INSERT INTO `wp_usermeta` VALUES("232", "9", "wp_user_level", "2");
INSERT INTO `wp_usermeta` VALUES("233", "9", "show_admin_bar_admin", "false");
INSERT INTO `wp_usermeta` VALUES("234", "9", "agree", "1");
INSERT INTO `wp_usermeta` VALUES("235", "9", "user_activation_key", "ZsZuAlMp74NO65blcIFr");
INSERT INTO `wp_usermeta` VALUES("236", "9", "session_tokens", "a:1:{s:64:\"56bb8659614e0f4c4dc9a8e46e7be493c8ba91076fc27f5db48fc2b71e2a6e47\";a:4:{s:10:\"expiration\";i:1708378604;s:2:\"ip\";s:12:\"89.196.65.58\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/121.0.0.0 Safari/537.36\";s:5:\"login\";i:1707169004;}}");
INSERT INTO `wp_usermeta` VALUES("237", "9", "king_user_points", "0");
INSERT INTO `wp_usermeta` VALUES("238", "9", "king_user_badges", NULL);
INSERT INTO `wp_usermeta` VALUES("239", "9", "wp__user_follow_count", "0");
INSERT INTO `wp_usermeta` VALUES("240", "9", "king_readlater", "a:0:{}");
INSERT INTO `wp_usermeta` VALUES("241", "9", "king_favorites", "a:1:{i:0;s:2:\"48\";}");
INSERT INTO `wp_usermeta` VALUES("243", "10", "nickname", "abolfazl");
INSERT INTO `wp_usermeta` VALUES("244", "10", "first_name", "");
INSERT INTO `wp_usermeta` VALUES("245", "10", "last_name", "");
INSERT INTO `wp_usermeta` VALUES("246", "10", "description", "");
INSERT INTO `wp_usermeta` VALUES("247", "10", "rich_editing", "true");
INSERT INTO `wp_usermeta` VALUES("248", "10", "syntax_highlighting", "true");
INSERT INTO `wp_usermeta` VALUES("249", "10", "comment_shortcuts", "false");
INSERT INTO `wp_usermeta` VALUES("250", "10", "admin_color", "fresh");
INSERT INTO `wp_usermeta` VALUES("251", "10", "use_ssl", "0");
INSERT INTO `wp_usermeta` VALUES("252", "10", "show_admin_bar_front", "false");
INSERT INTO `wp_usermeta` VALUES("253", "10", "locale", "");
INSERT INTO `wp_usermeta` VALUES("254", "10", "wp_capabilities", "a:1:{s:6:\"author\";b:1;}");
INSERT INTO `wp_usermeta` VALUES("255", "10", "wp_user_level", "2");
INSERT INTO `wp_usermeta` VALUES("256", "10", "show_admin_bar_admin", "false");
INSERT INTO `wp_usermeta` VALUES("257", "10", "agree", "1");
INSERT INTO `wp_usermeta` VALUES("258", "10", "user_activation_key", "2Nkql0y2NpLMlHxmJBNm");
INSERT INTO `wp_usermeta` VALUES("259", "10", "session_tokens", "a:1:{s:64:\"a7ef96920ec4a42b7b2afd136cd20afaab3cb7a5db9d6f3636160978c96df327\";a:4:{s:10:\"expiration\";i:1711519912;s:2:\"ip\";s:12:\"5.125.11.119\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/122.0.0.0 Mobile Safari/537.36\";s:5:\"login\";i:1710310312;}}");
INSERT INTO `wp_usermeta` VALUES("260", "10", "king_user_points", "0");
INSERT INTO `wp_usermeta` VALUES("261", "10", "king_user_badges", NULL);
INSERT INTO `wp_usermeta` VALUES("262", "10", "wp__user_follow_count", "0");
INSERT INTO `wp_usermeta` VALUES("263", "11", "nickname", "sohamin");
INSERT INTO `wp_usermeta` VALUES("264", "11", "first_name", "");
INSERT INTO `wp_usermeta` VALUES("265", "11", "last_name", "");
INSERT INTO `wp_usermeta` VALUES("266", "11", "description", "");
INSERT INTO `wp_usermeta` VALUES("267", "11", "rich_editing", "true");
INSERT INTO `wp_usermeta` VALUES("268", "11", "syntax_highlighting", "true");
INSERT INTO `wp_usermeta` VALUES("269", "11", "comment_shortcuts", "false");
INSERT INTO `wp_usermeta` VALUES("270", "11", "admin_color", "fresh");
INSERT INTO `wp_usermeta` VALUES("271", "11", "use_ssl", "0");
INSERT INTO `wp_usermeta` VALUES("272", "11", "show_admin_bar_front", "false");
INSERT INTO `wp_usermeta` VALUES("273", "11", "locale", "");
INSERT INTO `wp_usermeta` VALUES("274", "11", "wp_capabilities", "a:1:{s:6:\"author\";b:1;}");
INSERT INTO `wp_usermeta` VALUES("275", "11", "wp_user_level", "2");
INSERT INTO `wp_usermeta` VALUES("276", "11", "show_admin_bar_admin", "false");
INSERT INTO `wp_usermeta` VALUES("277", "11", "agree", "1");
INSERT INTO `wp_usermeta` VALUES("278", "11", "user_activation_key", "Wvm65dAd1RK3XATZEdZE");
INSERT INTO `wp_usermeta` VALUES("279", "11", "session_tokens", "a:2:{s:64:\"661966a0a30cd07c9f6df20ffaac358d39aa265a5c4d8f0bbd8ccc00388bc14e\";a:4:{s:10:\"expiration\";i:1713504822;s:2:\"ip\";s:11:\"37.255.0.92\";s:2:\"ua\";s:80:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:125.0) Gecko/20100101 Firefox/125.0\";s:5:\"login\";i:1713332022;}s:64:\"2876af70476ff7de2a17815daaa249005c432f1b762e633ba10ce8da97bd03e1\";a:4:{s:10:\"expiration\";i:1714541622;s:2:\"ip\";s:11:\"37.255.0.92\";s:2:\"ua\";s:80:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:125.0) Gecko/20100101 Firefox/125.0\";s:5:\"login\";i:1713332022;}}");
INSERT INTO `wp_usermeta` VALUES("280", "11", "king_user_points", "0");
INSERT INTO `wp_usermeta` VALUES("281", "8", "king_user_points", "0");
INSERT INTO `wp_usermeta` VALUES("282", "8", "king_user_badges", NULL);
INSERT INTO `wp_usermeta` VALUES("283", "8", "wp__user_follow_count", "1");
INSERT INTO `wp_usermeta` VALUES("284", "1", "king_notify", "a:3:{s:4:\"type\";s:6:\"follow\";s:6:\"postid\";s:1:\"1\";s:3:\"who\";i:8;}");
INSERT INTO `wp_usermeta` VALUES("285", "6", "wp__user_follow_count", "0");
INSERT INTO `wp_usermeta` VALUES("286", "12", "nickname", "adminadmin");
INSERT INTO `wp_usermeta` VALUES("287", "12", "first_name", "");
INSERT INTO `wp_usermeta` VALUES("288", "12", "last_name", "");
INSERT INTO `wp_usermeta` VALUES("289", "12", "description", "");
INSERT INTO `wp_usermeta` VALUES("290", "12", "rich_editing", "true");
INSERT INTO `wp_usermeta` VALUES("291", "12", "syntax_highlighting", "true");
INSERT INTO `wp_usermeta` VALUES("292", "12", "comment_shortcuts", "false");
INSERT INTO `wp_usermeta` VALUES("293", "12", "admin_color", "fresh");
INSERT INTO `wp_usermeta` VALUES("294", "12", "use_ssl", "0");
INSERT INTO `wp_usermeta` VALUES("295", "12", "show_admin_bar_front", "false");
INSERT INTO `wp_usermeta` VALUES("296", "12", "locale", "");
INSERT INTO `wp_usermeta` VALUES("297", "12", "wp_capabilities", "a:1:{s:6:\"author\";b:1;}");
INSERT INTO `wp_usermeta` VALUES("298", "12", "wp_user_level", "2");
INSERT INTO `wp_usermeta` VALUES("299", "12", "show_admin_bar_admin", "false");
INSERT INTO `wp_usermeta` VALUES("300", "12", "agree", "1");
INSERT INTO `wp_usermeta` VALUES("301", "12", "user_activation_key", "OxrEh7eKjgcUxGS5yvyh");
INSERT INTO `wp_usermeta` VALUES("302", "12", "session_tokens", "a:1:{s:64:\"813fec574ec34191510bb52726308d24568aaa5863905af04e88a6c650e0540a\";a:4:{s:10:\"expiration\";i:1720089941;s:2:\"ip\";s:11:\"5.124.26.48\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36\";s:5:\"login\";i:1718880341;}}");
INSERT INTO `wp_usermeta` VALUES("303", "12", "king_user_points", "0");
INSERT INTO `wp_usermeta` VALUES("304", "12", "king_user_badges", NULL);
INSERT INTO `wp_usermeta` VALUES("305", "7", "wp__user_follow_count", "0");
INSERT INTO `wp_usermeta` VALUES("306", "12", "wp__user_follow_count", "0");

/* INSERT TABLE DATA: wp_users */
INSERT INTO `wp_users` VALUES("1", "King", "$P$BI4n0K7P6tGq4aW10ly0uxLujGVw1B0", "king", "wpnovin.ir@gmail.com", "https://themes.wpnovin.com/King/Main", "2022-01-14 22:58:09", "", "0", "King");

SET FOREIGN_KEY_CHECKS = 1; 

/* Duplicator WordPress Timestamp: 2024-09-29 07:54:01*/
/* DUPLICATOR_MYSQLDUMP_EOF */
