<?php

defined( 'ABSPATH' ) || exit;
// texts
function play_get_text( $str, $echo = false ) {
    $texts = array(
        'following'              => esc_html__( 'Following', 'play-block' ),
        'follow'                 => esc_html__( 'Follow', 'play-block' ),
        'follower'               => esc_html__( 'Follower', 'play-block' ),
        'followers'              => esc_html__( 'Followers', 'play-block' ),
        'like'                   => esc_html__( 'Like', 'play-block' ),
        'likes'                  => esc_html__( 'Likes', 'play-block' ),
        'share'                  => esc_html__( 'Share', 'play-block' ),
        'single'                 => esc_html__( 'Single', 'play-block' ),
        'singles'                => esc_html__( 'Singles', 'play-block' ),
        'track'                  => esc_html__( 'Track', 'play-block' ),
        'tracks'                 => esc_html__( 'Tracks', 'play-block' ),
        'album'                  => esc_html__( 'Album', 'play-block' ),
        'albums'                 => esc_html__( 'Albums', 'play-block' ),
        'playlist'               => esc_html__( 'Playlist', 'play-block' ),
        'playlist-type'          => esc_html__( 'Playlist type', 'play-block' ),
        'playlists'              => esc_html__( 'Playlists', 'play-block' ),
        'playlist-placeholder'   => esc_attr__( 'Playlist title', 'play-block' ),
        'add-to-playlist'        => esc_html__( 'Add to playlist', 'play-block' ),
        'added-to-playlist'      => esc_html__( 'Added to playlist', 'play-block' ),
        'station'                => esc_html__( 'Station', 'play-block' ),
        'stations'               => esc_html__( 'Stations', 'play-block' ),
        'profile'                => esc_html__( 'Profile', 'play-block' ),
        'upload'                 => esc_html__( 'Upload', 'play-block' ),
        'uploading'              => esc_html__( 'Uploading', 'play-block' ),
        'download'               => esc_html__( 'Download', 'play-block' ),
        'downloads'              => esc_html__( 'Downloads', 'play-block' ),
        'logout'                 => esc_html__( 'Log out', 'play-block' ),
        'more-from'              => esc_html__( 'More from', 'play-block' ),
        'similar'                => esc_html__( 'Similar', 'play-block' ),
        'stream'                 => esc_html__( 'Stream', 'play-block' ),
        'recently-played'        => esc_html__( 'Recently played', 'play-block' ),
        'add'                    => esc_html__( 'Add', 'play-block' ),
        'save'                   => esc_html__( 'Save', 'play-block' ),
        'saved'                  => esc_html__( 'Changes saved', 'play-block' ),
        'update'                 => esc_attr__( 'Update', 'play-block' ),
        'edit'                   => esc_html__( 'Edit', 'play-block' ),
        'remove'                 => esc_html__( 'Remove', 'play-block' ),
        'clear'                  => esc_html__( 'Clear', 'play-block' ),
        'new'                    => esc_html__( 'New', 'play-block' ),
        'error-mail'             => esc_html__( 'Please enter a valid email address.', 'play-block' ),
        'error-mail-exist'       => esc_html__( 'Sorry, that email address is already used!', 'play-block' ),
        'error-pwd'              => esc_html__( 'Your current password is incorrect.', 'play-block' ),
        'error-pwd-mismatch'     => esc_html__( 'The passwords do not match.', 'play-block' ),
        'play'                   => esc_html__( 'Play', 'play-block' ),
        'next-to-play'           => esc_html__( 'Next to play', 'play-block' ),
        'add-to-queue'           => esc_html__( 'Add to queue', 'play-block' ),
        'this-week'              => esc_html__( 'This week', 'play-block' ),
        'this-month'             => esc_html__( 'This month', 'play-block' ),
        'this-year'              => esc_html__( 'This year', 'play-block' ),
        'all-time'               => esc_html__( 'All time', 'play-block' ),
        'verified'               => esc_attr__( 'Verified', 'play-block' ),
        'queue-title'            => esc_attr__( 'Next up', 'play-block' ),
        'queue-empty'            => esc_html__( 'Your queue is empty, Click the play button on an album, song, or playlist to add it to your queue', 'play-block' ),
        'no-follower'            => esc_html__( 'You do not have any followers yet', 'play-block' ),
        'no-follower-alt'        => esc_html__( 'This user has no follower', 'play-block' ),
        'no-following'           => esc_html__( 'You have not followed anyone yet', 'play-block' ),
        'no-following-alt'       => esc_html__( 'This user is not following anyone.', 'play-block' ),
        'no-like'                => esc_html__( 'You do not have any likes yet', 'play-block' ),
        'no-like-alt'            => esc_html__( 'This user hasn\'t liked anything yet.', 'play-block' ),
        'no-playlist'            => esc_html__( 'You do not have any playlists yet', 'play-block' ),
        'no-playlist-alt'        => esc_html__( 'This user hasn\'t created any playlists yet.', 'play-block' ),
        'no-album'               => esc_html__( 'You do not have any albums yet', 'play-block' ),
        'no-album-alt'           => esc_html__( 'This user hasn\'t created any albums yet.', 'play-block' ),
        'no-upload'              => esc_html__( 'You do not have any upload yet', 'play-block' ),
        'no-upload-alt'          => esc_html__( 'This user hasn\'t upload anything yet.', 'play-block' ),
        'no-download'            => esc_html__( 'You do not have any downloads yet', 'play-block' ),
        'no-download-alt'        => esc_html__( 'This user hasn\'t download anything yet.', 'play-block' ),
        'title-required'         => esc_html__( 'Title is a required field.', 'play-block' ),
        'poster-required'        => esc_html__( 'Poster is required.', 'play-block' ),
        'stream-required'        => esc_html__( 'Stream is a required field.', 'play-block' ),
        'first-name'             => esc_html__( 'First Name', 'play-block' ),
        'last-name'              => esc_html__( 'Last Name', 'play-block' ),
        'display-name'           => esc_html__( 'Display Name', 'play-block' ),
        'email'                  => esc_html__( 'Email', 'play-block' ),
        'website'                => esc_html__( 'Website', 'play-block' ),
        'description'            => esc_html__( 'Description', 'play-block' ),
        'social-networks'        => esc_html__( 'Social networks', 'play-block' ),
        'facebook'               => esc_html__( 'Facebook', 'play-block' ),
        'twitter'                => esc_html__( 'Twitter', 'play-block' ),
        'youtube'                => esc_html__( 'YouTube', 'play-block' ),
        'snapchat'               => esc_html__( 'Snapchat', 'play-block' ),
        'instagram'              => esc_html__( 'Instagram', 'play-block' ),
        'whatsapp'               => esc_html__( 'WhatsApp', 'play-block' ),
        'current-password'       => esc_html__( 'Current password', 'play-block' ),
        'new-password'           => esc_html__( 'New password', 'play-block' ),
        'comfirm-new-password'   => esc_html__( 'Comfirm new password', 'play-block' ),
        'poster'                 => esc_html__( 'Poster', 'play-block' ),
        'title'                  => esc_html__( 'Title', 'play-block' ),
        'content'                => esc_html__( 'Content', 'play-block' ),
        'regular-price'          => esc_html__( 'Regular price', 'play-block' ),
        'sale-price'             => esc_html__( 'Sale price', 'play-block' ),
        'complete'               => esc_html__( 'Complete', 'play-block' ),
        'duration'               => esc_html__( 'Duration', 'play-block' ),
        'release-date'           => esc_html__( 'Release Date', 'play-block' ),
        'genre'                  => esc_html__( 'Genre', 'play-block' ),
        'tags'                   => esc_html__( 'Tags', 'play-block' ),
        'tags-tip'               => esc_html__( '(Separate with commas)', 'play-block' ),
        'artists'                => esc_html__( 'Artists', 'play-block' ),
        'artists-tip'            => esc_html__( '(Separate with commas)', 'play-block' ),
        'downloadable'           => esc_html__( 'Downloadable', 'play-block' ),
        'purchase-title'         => esc_html__( 'Purchase title', 'play-block' ),
        'purchase-url'           => esc_html__( 'Purchase url', 'play-block' ),
        'url'                    => esc_html__( 'Url', 'play-block' ),
        'public'                 => esc_html__( 'Public', 'play-block' ),
        'private'                => esc_html__( 'Private', 'play-block' ),
        'password-change'        => esc_html__( 'Password change', 'play-block' ),
        'activate-email'         => esc_html__( 'Please check email to get activate first.', 'play-block' ),
        'activate-email-subject' => esc_html__( 'Email activation', 'play-block' ),
        'activate-email-content' => esc_html__( 'Please click the following link %s', 'play-block' ),
        'activated'              => esc_html__( 'Your account has been activated!', 'play-block' ),
        'not-activated'          => esc_html__( 'Your account is not activated!', 'play-block' ),
        'register-complete'      => esc_html__( 'Registration complete.', 'play-block' ),
        'editor-note'            => esc_html__( 'Editor\'s Notes', 'play-block' ),
        'show-more'              => esc_html__( 'Show more', 'play-block' ),
        'cancel'                 => esc_html__( 'Cancel', 'play-block' ),
        'remove-alert'           => esc_html__( 'Are you sure you want to delete? This action cannot be undone.', 'play-block' ),
        'public-tip'             => esc_html__( 'Anyone will be able to listen.', 'play-block' ),
        'private-tip'            => esc_html__( 'Only you will be able to listen.', 'play-block' ),
        'dragdrop-upload-title'  => esc_html__( 'Drag and drop your tracks &amp; albums here', 'play-block' ),
        'dragdrop-upload-button' => esc_html__( 'or choose files to upload', 'play-block' ),
        'dragdrop-playlist'      => esc_html__( 'A playlist will made when multiple files are selected', 'play-block' ),
        'dragdrop-copyright'     => esc_html__( 'By uploading, you confirm that your sounds comply with our Terms of Use and you don\'t infringe anyone else\'s rights.', 'play-block' ),
        'online-upload-title'    => esc_html__( 'Copy and paste online stream url here', 'play-block' ),
        'online-upload-tip'      => esc_html__( 'Support audio, video, Youtube, Youtube Music, Shoutcast, Icecast and any other online stream URL.', 'play-block' ),
        'featured'               => esc_html__( 'Featured on', 'play-block' ),
        'copyright'              => esc_html__( 'Copyright', 'play-block' ),
        'embed'                  => esc_html__( 'Embed', 'play-block' ),
        'time-ago'               => esc_html__( '%1$s ago', 'play-block' ),
        'popular'                => esc_html__( 'Popular', 'play-block' ),
        'notifications'          => esc_html__( 'Notifications', 'play-block' ),
        'no-notification'        => esc_html__( 'You do not have any notifications', 'play-block' ),
        'all-notifications'      => esc_html__( 'View all notifications', 'play-block' ),
        'notification-like'      => esc_html__( '%1$s liked %2$s', 'play-block' ),
        'notification-follow'    => esc_html__( '%1$s followed you', 'play-block' ),
        'notification-comment'   => esc_html__( '%1$s commented on %2$s', 'play-block' ),
        'notification-upload'    => esc_html__( '%1$s uploaded %2$s', 'play-block' ),
        'notification-download'  => esc_html__( '%1$s downloaded %2$s', 'play-block' ),
        'notification-playlist'  => esc_html__( '%1$s added %2$s to %3$s', 'play-block' ),
        'twitter-username'       => esc_html__( 'Twitter Username', 'play-block' ),
        'delete-account'         => esc_html__( 'Delete account', 'play-block' ),
        'delete-my-account'      => esc_html__( 'Delete my account', 'play-block' ),
        'delete-account-alert'   => esc_html__( 'Yes, I want to delete my account.', 'play-block' ),
        'uploading-files'        => esc_html__( 'Uploading files, Please wait.', 'play-block' ),
        'files uploaded'         => esc_html__( 'Files uploaded.', 'play-block' ),
        'bpm'                    => esc_html__( 'BPM', 'play-block' ),
        'yes'                    => esc_html__( 'Yes', 'play-block' ),
        'no'                     => esc_html__( 'No', 'play-block' ),
        'activate'               => esc_html__( 'Activate', 'play-block' ),
        'login'                  => esc_html__( 'Log In', 'play-block' ),
        'register'               => esc_html__( 'Register', 'play-block' ),
        'lost-password'          => esc_html__( 'Lost your password?', 'play-block' ),
    );
    $texts = apply_filters( 'play_block_texts', $texts );
    $text  = isset( $texts[ $str ] ) ? $texts[ $str ] : str_replace( '-', ' ', ucfirst( $str ) );
    if ( $echo ) {
        echo $text;
    } else {
        return $text;
    }
}
